/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.util;

import java.util.function.Supplier;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;

public class WatchLoggerUtil {
    public static void debug(WatchLogger log, String msg) {
        if (WatchLoggerUtil.isDebug()) {
            log.info(msg);
        }
    }

    public static void debugEnd(WatchLogger log, String msg) {
        if (WatchLoggerUtil.isDebug()) {
            log.infoEnd(msg);
        }
    }

    public static void logTime(WatchLogger log, Runnable runnable, String msg) {
        log.startWatch();
        runnable.run();
        log.infoEnd(msg);
    }

    public static <T> T logTime(WatchLogger log, Supplier<T> supplier, String msg) {
        log.startWatch();
        T result = supplier.get();
        log.infoEnd(msg);
        return result;
    }

    public static boolean isDebug() {
        return DebugServiceHelper.isDebugModel();
    }
}

