/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.vo;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.formula.enums.DataSourceTypeEnum;
import kd.fi.bcm.business.formula.enums.VDataTypeEnum;
import kd.fi.bcm.business.formula.util.VDataFormulaUtils;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataEBVo;
import kd.fi.bcm.business.vo.VDataPropertyVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.business.vo.VDataVoucherVo;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class VDataFormulaVo {
    private boolean isSingleFormula;
    private VDataTypeEnum type;
    private String modelNum;
    private String extNum;
    private String defaultCon;
    private List<VDataRowVo> columnVos;
    private List<String> returnFields;
    private List<String> txtFields;
    private boolean isAgg;
    public static final String V_DATA = "V_DATA";
    public static final String VS_DATA = "VS_DATA";
    public static final String LEFT_BRACKET = "{";
    public static final String RIGHT_BRACKET = "}";
    public static final String MIN_LEFT_BRACKET = "(";
    public static final String MIN_RIGHT_BRACKET = ")";
    public static final String C_LEFT_BRACKET = "[";
    public static final String C_RIGHT_BRACKET = "]";
    public static final String NO_CONDITION = "*";
    public static final String MUTI = "_MUTI";

    public VDataFormulaVo(boolean isSingleFormula, VDataTypeEnum type, String modelNum, String extNum, String defaultCon, List<VDataRowVo> columnVos, List<String> returnFields, List<String> txtFields, boolean isAgg) {
        this.isSingleFormula = isSingleFormula;
        this.type = type;
        this.modelNum = modelNum;
        this.extNum = extNum;
        this.defaultCon = defaultCon;
        this.columnVos = columnVos;
        this.returnFields = returnFields;
        this.txtFields = txtFields;
        this.isAgg = isAgg;
    }

    public boolean isSingleFormula() {
        return this.isSingleFormula;
    }

    public void setSingleFormula(boolean singleFormula) {
        this.isSingleFormula = singleFormula;
    }

    public VDataTypeEnum getType() {
        return this.type;
    }

    public void setType(VDataTypeEnum type) {
        this.type = type;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public void setModelNum(String modelNum) {
        this.modelNum = modelNum;
    }

    public String getExtNum() {
        return this.extNum;
    }

    public void setExtNum(String extNum) {
        this.extNum = extNum;
    }

    public String getDefaultCon() {
        return this.defaultCon;
    }

    public void setDefaultCon(String defaultCon) {
        this.defaultCon = defaultCon;
    }

    public List<VDataRowVo> getColumnVos() {
        return this.columnVos;
    }

    public void setColumnVos(List<VDataRowVo> columnVos) {
        this.columnVos = columnVos;
    }

    public List<String> getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(List<String> returnFields) {
        this.returnFields = returnFields;
    }

    public List<String> getTxtFields() {
        return this.txtFields;
    }

    public void setTxtFields(List<String> txtFields) {
        this.txtFields = txtFields;
    }

    public boolean isAgg() {
        return this.isAgg;
    }

    public void setAgg(boolean agg) {
        this.isAgg = agg;
    }

    public String toExcelFormula() {
        StringBuilder formula = new StringBuilder();
        String sourceModel = "";
        sourceModel = StringUtils.isBlank((CharSequence)this.extNum) ? this.modelNum : this.modelNum + "," + this.extNum;
        formula.append(this.isSingleFormula ? V_DATA : VS_DATA).append(MIN_LEFT_BRACKET);
        formula.append("\"").append(this.type.getType()).append("\",\"").append(sourceModel);
        if (this.isSingleFormula) {
            formula.append("\",\"").append(this.defaultCon);
        }
        String condition = this.getConditionStr(true);
        formula.append("\",\"").append(condition);
        formula.append("\",\"").append(CollectionUtil.isEmpty(this.returnFields) ? "" : String.join((CharSequence)",", this.returnFields)).append("\"");
        if (!this.isSingleFormula) {
            formula.append(",\"").append(CollectionUtil.isEmpty(this.txtFields) ? "" : String.join((CharSequence)",", this.txtFields));
            formula.append("\",\"").append(this.isAgg).append("\"");
        }
        formula.append(MIN_RIGHT_BRACKET);
        return formula.toString();
    }

    public String toFetchDataString() {
        boolean isExist;
        StringBuilder formula = new StringBuilder();
        String app = this.isSingleFormula ? this.type.getType() : this.type.getType() + MUTI;
        formula.append("\"").append(app);
        if (VDataTypeEnum.EPM == this.type) {
            formula.append("\"");
        } else {
            formula.append("\",\"").append(this.modelNum).append("\"");
        }
        if (VDataTypeEnum.CM_ETX == this.type || VDataTypeEnum.EB == this.type || VDataTypeEnum.ISC == this.type) {
            formula.append(",\"").append(this.extNum).append("\"");
        } else if (VDataTypeEnum.EPM == this.type && this.extNum.split(",").length == 2) {
            String[] splits = this.extNum.split(",");
            QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)splits[0]);
            qfBuilder.add("catalog.number", "=", (Object)splits[1]);
            DynamicObject one = QueryServiceHelper.queryOne((String)DataSourceTypeEnum.EPM_DATAMANAGE.getFormId(), (String)"id,number", (QFilter[])qfBuilder.toArray());
            formula.append(",\"").append(one.getString("id")).append("\"");
        }
        if ((VDataTypeEnum.CM == this.type || VDataTypeEnum.RPT == this.type || VDataTypeEnum.CM_ETX == this.type || VDataTypeEnum.EB == this.type) && this.isSingleFormula) {
            formula.append(",\"").append(this.defaultCon).append("\"");
        }
        String condition = this.getConditionStr(false);
        if (VDataTypeEnum.ISC == this.type && this.isSingleFormula && !(isExist = this.columnVos.stream().map(VDataRowVo::getNumber).anyMatch(e -> e.equals(this.returnFields.get(0))))) {
            condition = condition + "," + C_LEFT_BRACKET + this.returnFields.get(0) + C_RIGHT_BRACKET + '.' + NO_CONDITION;
        }
        formula.append(",\"").append(condition).append("\"");
        ArrayList<String> newReturnFields = new ArrayList<String>(this.returnFields);
        if (!this.isSingleFormula && VDataTypeEnum.CM_ETX == this.type) {
            ExtendsModel extendsModel;
            String selectFields = "id";
            QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)this.extNum).add("model", "=", (Object)MemberReader.findModelIdByShowNum((String)this.modelNum));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)selectFields, (QFilter[])qfBuilder.toArray());
            ExtendsModel extendsModel2 = extendsModel = query.isEmpty() ? null : new ExtendsModel(((DynamicObject)query.get(0)).getLong("id"));
            if (extendsModel != null) {
                Set extFields = extendsModel.getExtFieldEntry().stream().map(ext -> ext.getExtField().getNumber()).collect(Collectors.toSet());
                this.columnVos.forEach(vo -> {
                    if (extFields.contains(vo.getNumber()) && !this.returnFields.contains(vo.getNumber())) {
                        newReturnFields.add(vo.getNumber());
                    }
                });
            }
        }
        formula.append(",\"").append(CollectionUtil.isEmpty(newReturnFields) ? "" : String.join((CharSequence)",", newReturnFields)).append("\"");
        if (!this.isSingleFormula && this.isAgg) {
            formula.append(",\"").append(CollectionUtil.isEmpty(this.txtFields) ? "" : String.join((CharSequence)",", this.txtFields)).append("\"");
        }
        return formula.toString();
    }

    private String getConditionStr(boolean isExcel) {
        return this.columnVos.stream().map(e -> {
            StringBuilder colStr = new StringBuilder();
            String number = e.getNumber();
            if (e instanceof VDataDimNodeVo) {
                colStr.append(number).append(".");
            } else if (e instanceof VDataPropertyVo) {
                colStr.append(C_LEFT_BRACKET).append(number).append(".").append(((VDataPropertyVo)e).getProperty()).append(C_RIGHT_BRACKET).append(".");
            } else if (e instanceof VDataEBVo) {
                if (((VDataEBVo)e).getProperty() == null) {
                    colStr.append(number).append(".");
                } else {
                    colStr.append(C_LEFT_BRACKET).append(e.getDimNum()).append(".").append(((VDataEBVo)e).getProperty()).append(C_RIGHT_BRACKET).append(".");
                }
            } else if (e instanceof VDataVoucherVo) {
                colStr.append(number).append(".");
            } else if (number.contains(".")) {
                colStr.append(C_LEFT_BRACKET).append(number).append(C_RIGHT_BRACKET).append(".");
            } else {
                colStr.append(number).append(".");
            }
            if (e.isFloat) {
                colStr.append("@").append(e.getFloatMapping());
            } else if (StringUtils.isBlank((CharSequence)e.getCondition())) {
                colStr.append(NO_CONDITION);
            } else {
                boolean needBracket = true;
                String con = e.getCondition();
                if (con.contains("\"")) {
                    con = isExcel ? con.replace("\"", "\"\"") : con.replace("\"", "\\\"");
                }
                if (e instanceof VDataDimNodeVo) {
                    MultiF7Results f7Results = ((VDataDimNodeVo)e).getMultiF7Results();
                    if (f7Results != null) {
                        if (f7Results.getList() != null && f7Results.getList().size() == 1 && f7Results.getList().get(0).getScope() == 10) {
                            needBracket = false;
                        }
                        StringJoiner f7s = new StringJoiner(",");
                        if (!StringUtils.isEmpty((CharSequence)f7Results.getShowText())) {
                            for (MultiF7Result multiF7Result : f7Results.getList()) {
                                if (multiF7Result.getScope() == 10) {
                                    f7s.add(multiF7Result.getNumber());
                                    continue;
                                }
                                f7s.add(multiF7Result.getNumber() + "." + RangeEnum.getRangeByVal((int)multiF7Result.getScope()).getNumber());
                            }
                            con = f7s.toString();
                        }
                    }
                } else if (e instanceof VDataEBVo && StringUtils.isEmpty((CharSequence)((VDataEBVo)e).getProperty()) && !e.getCondition().contains(",") && !e.getCondition().contains(".")) {
                    needBracket = false;
                }
                if (!isExcel && needBracket) {
                    con = VDataFormulaUtils.dealSourceSuffix(LEFT_BRACKET + con + RIGHT_BRACKET);
                    con = con.substring(1, con.length() - 1);
                }
                if (needBracket) {
                    colStr.append(LEFT_BRACKET);
                }
                colStr.append(con);
                if (needBracket) {
                    colStr.append(RIGHT_BRACKET);
                }
            }
            return colStr.toString();
        }).collect(Collectors.joining(","));
    }
}

