/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.websocket;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dlock.DLock;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.session.SessionDAOFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.fi.bcm.business.websocket.BcmWebSocketCommand;
import kd.fi.bcm.fel.common.StringUtils;

public class BcmWebSocketManger {
    private static final Log logger = LogFactory.getLog(BcmWebSocketManger.class);
    public static final String CONSOLE_SIGN = "CONSOLE";
    public static final String GUIDE_SIGN = "GUIDE";
    private static final String GLOBALPARAM_SIGN = "gp";
    public static final String REGISTRYLIST_SIGN = "ws_refisterList";
    private static final int DEFAULT_CACHE_TIME = 86400;
    private static final DistributeSessionlessCache sharedBufferCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(BcmWebSocketManger.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWebSocket(String identifyType) {
        block17: {
            try (DLock dl = DLock.create((String)REGISTRYLIST_SIGN);){
                if (!dl.tryLock(1000L)) break block17;
                try {
                    sharedBufferCache.addList(REGISTRYLIST_SIGN, new String[]{identifyType}, 86400, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    try {
                        logger.error(t);
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        dl.unlock();
                    }
                }
                dl.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unRegisterWebSocket(String identifyType) {
        block18: {
            try (DLock dl = DLock.create((String)REGISTRYLIST_SIGN);){
                block19: {
                    if (!dl.tryLock(1000L)) break block18;
                    try {
                        int deleteIndex = -1;
                        String[] refisterList = BcmWebSocketManger.getRefisterList();
                        for (int i = 0; i < refisterList.length; ++i) {
                            if (!StringUtils.equals((CharSequence)identifyType, (CharSequence)refisterList[i])) continue;
                            deleteIndex = i;
                            break;
                        }
                        if (deleteIndex < 0) break block19;
                        sharedBufferCache.removeListObject(REGISTRYLIST_SIGN, deleteIndex);
                    }
                    catch (Throwable t) {
                        try {
                            logger.error(t);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            dl.unlock();
                        }
                    }
                }
                dl.unlock();
            }
        }
    }

    public static String[] getRefisterList() {
        return sharedBufferCache.getList(REGISTRYLIST_SIGN);
    }

    public static boolean isWSAlive(String identifyType) {
        if (StringUtils.isEmpty((CharSequence)identifyType)) {
            return false;
        }
        String config = System.getProperty("websocket.listener.config");
        boolean isRegListener = config != null && config.contains("kd.fi.bcm.business.websocket.BcmWebSocketPageHandler");
        return !isRegListener || Arrays.stream(BcmWebSocketManger.getRefisterList()).anyMatch(p -> StringUtils.equals((CharSequence)p, (CharSequence)identifyType));
    }

    public static void setGlobalParam(String key, String value, int expiretime) {
        BcmWebSocketManger.setParam(GLOBALPARAM_SIGN, key, value, expiretime);
    }

    public static void getGlobalParam(String key) {
        BcmWebSocketManger.getParam(GLOBALPARAM_SIGN, key);
    }

    public static void setParam(String areaSign, String key, String value, int expiretime) {
        sharedBufferCache.put(areaSign + "." + key, (Object)value, expiretime, TimeUnit.SECONDS);
    }

    public static String getParam(String areaSign, String key) {
        return (String)sharedBufferCache.get(areaSign + "." + key);
    }

    public static String buildWSIdentifytype(String applymenu, String accountId, String tenantId, String userId, String userSpceKey) {
        return applymenu + "_" + accountId + "_" + tenantId + "_" + userId + "_" + userSpceKey;
    }

    public static void sendMsg(BcmWebSocketCommand bcmWebSocketOrder) {
        BcmWebSocketManger.sendMsg(Collections.singletonList(RequestContext.getOrCreate().getUserId()), bcmWebSocketOrder);
    }

    public static void sendMsg(List<String> receiverList, BcmWebSocketCommand bcmWebSocketOrder) {
        try {
            for (String receiver : receiverList) {
                bcmWebSocketOrder.getConsumer().setReceiver(receiver);
                String identifyType = BcmWebSocketManger.buildWSIdentifytype(bcmWebSocketOrder.getWsMsgType(), bcmWebSocketOrder.getConsumer().getAccountId(), bcmWebSocketOrder.getConsumer().getTenantId(), bcmWebSocketOrder.getConsumer().getReceiver(), bcmWebSocketOrder.getConsumer().getUserSpceKey());
                bcmWebSocketOrder.setIdentifyType(identifyType);
                MsgSendFactory.getSender().send(identifyType, bcmWebSocketOrder.toByteSerialized());
            }
        }
        catch (Throwable t) {
            logger.error(t);
            throw t;
        }
    }

    public static void createForWS(String sessionId) {
        Map<String, String> sessionInfo = BcmWebSocketManger.getSessionInfoBySessionId(sessionId);
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setUserAgent("WS");
        rc.setClient("WS");
        rc.setTraceId(TraceIdUtil.createTraceIdString());
        rc.setTenantId(sessionInfo.get("tenantId"));
        rc.setAccountId(sessionInfo.get("accountId"));
        rc.setUserId(sessionInfo.get("userId"));
        rc.setLang(Lang.defaultLang());
        rc.setGlobalSessionId(sessionId);
        RequestContextThreadBinder.bind((RequestContext)rc);
    }

    public static Map<String, String> getSessionInfoBySessionId(String globalSessionId) {
        return SessionDAOFactory.getSessionDAO((String)globalSessionId).getAttributesAsMap(new String[]{"tenantId", "userId", "userName", "userOpenId", "orgId", "accountId"});
    }
}

