/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.enumvalue.EnumAndMembModel;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.HeadObject;
import kd.fi.bcm.spread.model.IDimMember;

public class CellDataTypeUtil {
    private static final String dimDataTypeCache = "dimCacheInfo";
    public static final String USER_DEFINED_DIM = "userdefineddim";
    public static final String ALL_FILTER_DIM_MEMBER = "getSpreadModelAllFilterDimNumbers";

    public static List<String> getUserDefined(long modelId, IPageCache pageCache) {
        return (List)ThreadCache.get((Object)(USER_DEFINED_DIM + modelId), () -> {
            ArrayList<String> userDefined = null;
            boolean realodFromDb = false;
            String jsonStr = pageCache.get(USER_DEFINED_DIM + modelId);
            try {
                if (StringUtils.isNotEmpty((String)jsonStr)) {
                    userDefined = SerializationUtils.fromJsonStringToList((String)jsonStr, String.class);
                } else {
                    realodFromDb = true;
                }
            }
            catch (Exception ex) {
                realodFromDb = true;
            }
            if (realodFromDb) {
                userDefined = new ArrayList<String>(10);
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                Collection col = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq").values();
                for (DynamicObject dot : col) {
                    if (!CellDataTypeUtil.isUserDefinedDim(dot.getString("number"))) continue;
                    userDefined.add(dot.getString("number"));
                }
                pageCache.put(USER_DEFINED_DIM + modelId, SerializationUtils.toJsonString(userDefined));
            }
            return userDefined;
        });
    }

    public static List<String> getUserDefinedThreadCache(long modelId) {
        return (List)ThreadCache.get((Object)(USER_DEFINED_DIM + modelId), () -> {
            ArrayList<String> userDefined = null;
            boolean realodFromDb = false;
            Object jsonStr = ThreadCache.get((Object)(USER_DEFINED_DIM + modelId));
            try {
                if (jsonStr != null) {
                    userDefined = (ArrayList<String>)jsonStr;
                } else {
                    realodFromDb = true;
                }
            }
            catch (Exception ex) {
                realodFromDb = true;
            }
            if (realodFromDb) {
                userDefined = new ArrayList<String>(10);
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                Collection col = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq").values();
                for (DynamicObject dot : col) {
                    if (!CellDataTypeUtil.isUserDefinedDim(dot.getString("number"))) continue;
                    userDefined.add(dot.getString("number"));
                }
                ThreadCache.put((Object)(USER_DEFINED_DIM + modelId), userDefined);
            }
            return userDefined;
        });
    }

    public static DataTypeEnum getCellDataType(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager) {
        return CellDataTypeUtil.getCellDataType(modelId, cell, pageCache, spreadManager, null);
    }

    public static DataTypeEnum getCellDataType(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        return CellDataTypeUtil.getCellDataType(modelId, cell, pageCache, spreadManager, cachemap, false);
    }

    public static DataTypeEnum getCellDataType(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap, boolean isDetail) {
        return CellDataTypeUtil.getCellDataType(modelId, cell, pageCache, spreadManager, cachemap, isDetail, false);
    }

    public static Map<String, String> getRCDimMemberMapForHeaderMode(int r, int c, Sheet sheet) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (r < sheet.getMaxRowHeaderSize() && c < sheet.getMaxColHeaderSize()) {
            Header rowHeader = sheet.getRowHeader();
            Header colHeader = sheet.getColHeader();
            List rowDims = rowHeader.getDimNums();
            List colDims = colHeader.getDimNums();
            HeadObject headObject = rowHeader.get(r, false);
            if (headObject == null) {
                return map;
            }
            map.putAll(headObject.getCombineMap(rowDims));
            HeadObject object = colHeader.get(c, false);
            if (object != null) {
                map.putAll(object.getCombineMap(colDims));
            } else {
                map.clear();
            }
            if (map.size() != rowDims.size() + colDims.size()) {
                map.clear();
            }
        }
        return map;
    }

    public static Map<String, String> getRCDimMemberMap(Cell cell, Sheet sheet, boolean isHeader) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (isHeader) {
            map.putAll(CellDataTypeUtil.getRCDimMemberMapForHeaderMode(cell.getRow(), cell.getCol(), sheet));
        } else {
            map.putAll(cell.getMemberFromUserObjectDimNumbers());
        }
        return map;
    }

    public static DataTypeEnum getCellDataType(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap, boolean isDetail, boolean isHeaderMode) {
        DataTypeEnum defaultDataType = DataTypeEnum.DEFAULT;
        if (cell.isMdDataDomain() || isHeaderMode) {
            Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(spreadManager);
            Map<String, String> rcDimMemberMap = CellDataTypeUtil.getRCDimMemberMap(cell, spreadManager.getBook().getSheet(0), isHeaderMode);
            DataTypeEnum returnDataType = CellDataTypeUtil.getDataTypeEnum(modelId, CellDataTypeUtil.getPreSetDimensions(modelId), rcDimMemberMap, pageCache, allFilterDimNumbers, cachemap, isDetail);
            if (returnDataType != defaultDataType) {
                return returnDataType;
            }
            List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId, pageCache);
            return CellDataTypeUtil.getDataTypeEnum(modelId, userDefined, rcDimMemberMap, pageCache, allFilterDimNumbers, cachemap, isDetail);
        }
        if (isHeaderMode) {
            return DataTypeEnum.TXT;
        }
        PositionInfo ps = spreadManager.getInAreaPositionByRow(cell.getRow(), cell.getCol());
        if (ps != null && ps.getExtendInfo() != null) {
            Map index2DimNums = spreadManager.getExtHeadInfo(ps);
            String extNum = (String)index2DimNums.get(cell.getCol());
            DataTypeEnum dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, "Extends", extNum, cachemap);
            return dataTypeEnum;
        }
        return DataTypeEnum.TXT;
    }

    public static DataTypeEnum getCellDataTypeThreadCache(long modelId, Cell cell, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultDataType = DataTypeEnum.DEFAULT;
        if (cell.isMdDataDomain()) {
            Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(spreadManager);
            DataTypeEnum returnDataType = CellDataTypeUtil.getDataTypeEnumThreadCache(modelId, CellDataTypeUtil.getPreSetDimensions(modelId), cell, allFilterDimNumbers, cachemap);
            if (returnDataType != defaultDataType) {
                return returnDataType;
            }
            List<String> userDefined = CellDataTypeUtil.getUserDefinedThreadCache(modelId);
            return CellDataTypeUtil.getDataTypeEnumThreadCache(modelId, userDefined, cell, allFilterDimNumbers, cachemap);
        }
        PositionInfo ps = spreadManager.getInAreaPositionByRow(cell.getRow(), cell.getCol());
        if (ps != null) {
            Map index2DimNums = spreadManager.getExtHeadInfo(ps);
            String extNum = (String)index2DimNums.get(cell.getCol());
            DataTypeEnum dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, "Extends", extNum, cachemap);
            return dataTypeEnum;
        }
        return DataTypeEnum.TXT;
    }

    public static List<String> getPreSetDimensions(long modelId) {
        return DataTypeEnum.getDataTypePerSetDims((Object)modelId);
    }

    public static DataTypeEnum getCellDataTypeThreadCache(long modelId, Map<String, String> dim2Members, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            cachemap = CellDataTypeUtil.getDataTypeThreadCache();
        }
        ArrayList<String> dimNumbers = new ArrayList<String>();
        dimNumbers.addAll(CellDataTypeUtil.getPreSetDimensions(modelId));
        dimNumbers.addAll(CellDataTypeUtil.getUserDefinedThreadCache(modelId));
        Map.Entry[] resultMap = new Map.Entry[dimNumbers.size()];
        int index = 0;
        for (String dimNumber : dimNumbers) {
            resultMap[index++] = new AbstractMap.SimpleEntry<String, String>(dimNumber, dim2Members.get(dimNumber));
        }
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < resultMap.length; ++i) {
            String memberNumber;
            String dim = (String)resultMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = (String)resultMap[i].getValue(), cachemap);
            if (dataTypeEnum == DataTypeEnum.ENUMTP) {
                dataTypeEnum = cachemap.get(dim).getMemberDataTypeEnum(dim, memberNumber + "_item");
            }
            if (dataTypeEnum == defaultType) continue;
            return dataTypeEnum;
        }
        if (isCache) {
            CellDataTypeUtil.cacheDataTypeInfo2Thread(cachemap);
        }
        return defaultType;
    }

    public static EnumAndMembModel getCellDataType4EnumStyle(long modelId, Cell cell, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultDataType = DataTypeEnum.DEFAULT;
        if (cell.isMdDataDomain()) {
            EnumAndMembModel returnDataType = CellDataTypeUtil.getDataTypeEnum4Enumvalue(modelId, CellDataTypeUtil.getPreSetDimensions(modelId), cell, pageCache, allFilterDimNumbers, cachemap);
            if (!returnDataType.getDataTypeEnum().index.equals(defaultDataType.index)) {
                return returnDataType;
            }
            List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId, pageCache);
            return CellDataTypeUtil.getDataTypeEnum4Enumvalue(modelId, userDefined, cell, pageCache, allFilterDimNumbers, cachemap);
        }
        return new EnumAndMembModel(defaultDataType);
    }

    public static EnumAndMembModel getCellDataType4EnumStyle(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(spreadManager);
        return CellDataTypeUtil.getCellDataType4EnumStyle(modelId, cell, pageCache, allFilterDimNumbers, cachemap);
    }

    private static DataTypeEnum getDataTypeEnum(long modelId, List<String> dims, Map<String, String> checkDimNumbers, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap, boolean isDetail) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            if (cachemap == null) {
                cachemap = new HashMap(16);
            }
            cachemap.putAll(CellDataTypeUtil.getDataTypeCache(pageCache));
        }
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(checkDimNumbers, dims, allFilterDimNumbers);
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            if (isDetail && DataTypeEnum.ENUMTP == dataTypeEnum) {
                dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber, cachemap, true);
            }
            return dataTypeEnum;
        }
        if (isCache) {
            CellDataTypeUtil.cacheDataTypeInfo(pageCache, cachemap);
        }
        return defaultType;
    }

    private static DataTypeEnum getDataTypeEnumThreadCache(long modelId, List<String> dims, Cell cell, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            cachemap = CellDataTypeUtil.getDataTypeThreadCache();
        }
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(cell, dims, allFilterDimNumbers);
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            if (DataTypeEnum.ENUMTP == dataTypeEnum) {
                dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber, cachemap, true);
            }
            return dataTypeEnum;
        }
        if (isCache) {
            CellDataTypeUtil.cacheDataTypeInfo2Thread(cachemap);
        }
        return defaultType;
    }

    public static void cacheDataTypeInfo(IPageCache pageCache, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        pageCache.put(dimDataTypeCache, ObjectSerialUtil.toByteSerialized(cachemap));
    }

    public static void cacheDataTypeInfo2Thread(HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        ThreadCache.put((Object)dimDataTypeCache, cachemap);
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getDataTypeCache(IPageCache pageCache) {
        return (HashMap)ThreadCache.get((Object)(pageCache.getPageId() + "dt"), () -> {
            String dimCacheInfo = pageCache.get(dimDataTypeCache);
            HashMap cachemap = new HashMap(16);
            if (dimCacheInfo != null) {
                cachemap = (HashMap)ObjectSerialUtil.deSerializedBytes((String)dimCacheInfo);
            }
            return cachemap;
        });
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getDataTypeThreadCache() {
        Object dimCacheInfo = ThreadCache.get((Object)dimDataTypeCache);
        HashMap<String, DataTypeAcctCacheInfo> cachemap = new HashMap<String, DataTypeAcctCacheInfo>(16);
        if (dimCacheInfo != null) {
            return (HashMap)dimCacheInfo;
        }
        return cachemap;
    }

    private static EnumAndMembModel getDataTypeEnum4Enumvalue(long modelId, List<String> dims, Cell cell, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(cell, dims, allFilterDimNumbers);
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            return new EnumAndMembModel(dim, memberNumber, dataTypeEnum);
        }
        return new EnumAndMembModel(defaultType);
    }

    private static Map.Entry<String, String>[] getCurrencyMemberName(Cell cell, Collection<String> dimNumbers, Map<String, String> allFilterDimNumbers) {
        return CellDataTypeUtil.getCurrencyMemberName(cell.getMemberFromUserObjectDimNumbers(), dimNumbers, allFilterDimNumbers);
    }

    private static Map.Entry<String, String>[] getCurrencyMemberName(Map<String, String> checkDimNumbers, Collection<String> dimNumbers, Map<String, String> allFilterDimNumbers) {
        Map.Entry[] resultMap = new Map.Entry[dimNumbers.size()];
        int i = 0;
        for (String dimNumber : dimNumbers) {
            String number = checkDimNumbers.get(dimNumber);
            if (number == null && (number = allFilterDimNumbers.get(dimNumber)) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u5143\u683c\u5185\u67d0\u4e00\u7ef4\u5ea6\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff1a%s\u3002", (String)"CellDataTypeUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), dimNumber));
            }
            resultMap[i++] = new AbstractMap.SimpleEntry<String, String>(dimNumber, number);
        }
        return resultMap;
    }

    public static Map<String, String> getSpreadModelAllFilterDimNumbers(SpreadManager spreadModel) {
        return (Map)ThreadCache.get((Object)ALL_FILTER_DIM_MEMBER, () -> {
            HashMap<String, String> resultMap = new HashMap<String, String>(16);
            if (spreadModel != null && spreadModel.getFilter() != null) {
                List listMemmber;
                if (spreadModel.getFilter().getPageDomain() != null && (listMemmber = spreadModel.getFilter().getPageDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        resultMap.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
                if (spreadModel.getFilter().getViewPointDomain() != null && (listMemmber = spreadModel.getFilter().getViewPointDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        resultMap.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
            }
            return resultMap;
        });
    }

    public static DataTypeEnum getDimensionDataType(long modelId, String dimNumber, String memberNumber, HashMap<String, DataTypeAcctCacheInfo> cachemap, boolean isDetail) {
        if (cachemap.get(dimNumber) == null) {
            DataTypeAcctCacheInfo acctCacheInfo = new DataTypeAcctCacheInfo(modelId, ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNumber), dimNumber);
            cachemap.put(dimNumber, acctCacheInfo);
        }
        return cachemap.get(dimNumber).getMemberDataTypeEnum(dimNumber, memberNumber, isDetail);
    }

    public static DataTypeEnum getDimensionDataType(long modelId, String dimNumber, String memberNumber, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        return CellDataTypeUtil.getDimensionDataType(modelId, dimNumber, memberNumber, cachemap, false);
    }

    public static DataTypeEnum getCellDataType(Long modelId, IPageCache pageCache, Map<String, String> dimMap, Map<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum returnDataType = CellDataTypeUtil.getDataTypeEnum(modelId, CellDataTypeUtil.getPreSetDimensions(modelId), pageCache, dimMap, cachemap);
        if (returnDataType != DataTypeEnum.DEFAULT) {
            return returnDataType;
        }
        List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId, pageCache);
        return CellDataTypeUtil.getDataTypeEnum(modelId, userDefined, pageCache, dimMap, cachemap);
    }

    private static DataTypeEnum getDataTypeEnum(Long modelId, List<String> dims, IPageCache pageCache, Map<String, String> dimMap, Map<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            if (cachemap == null) {
                cachemap = new HashMap<String, DataTypeAcctCacheInfo>(16);
            }
            cachemap.putAll(CellDataTypeUtil.getDataTypeCache(pageCache));
        }
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(dimMap, dims);
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            String tempIndex = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (tempIndex == null || tempIndex.equals(defaultType.index)) continue;
            return DataTypeEnum.valueOfBy((String)tempIndex);
        }
        if (isCache) {
            pageCache.put(dimDataTypeCache, ObjectSerialUtil.toByteSerialized(cachemap));
        }
        return defaultType;
    }

    private static Map.Entry<String, String>[] getCurrencyMemberName(Map<String, String> dimMap, Collection<String> dimNumbers) {
        Map.Entry[] resultMap = new Map.Entry[dimNumbers.size()];
        int i = 0;
        for (String dimNumber : dimNumbers) {
            String number = dimMap.get(dimNumber);
            if (StringUtils.isEmpty((String)number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6210\u5458\u4e3a\u7a7a\u3002", (String)"CellDataTypeUtil_2", (String)"fi-bcm-business", (Object[])new Object[0]), dimNumber) + "\ndimMap: " + dimMap);
            }
            resultMap[i++] = new AbstractMap.SimpleEntry<String, String>(dimNumber, number);
        }
        return resultMap;
    }

    private static String getDimensionDataType(Long modelId, String dimNumber, String memberNumber, Map<String, DataTypeAcctCacheInfo> cachemap) {
        if (cachemap.get(dimNumber) == null) {
            DataTypeAcctCacheInfo acctCacheInfo = new DataTypeAcctCacheInfo(modelId, ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNumber), dimNumber);
            cachemap.put(dimNumber, acctCacheInfo);
        }
        return cachemap.get(dimNumber).getMemberDataType(dimNumber, memberNumber);
    }

    public static boolean isUserDefinedDim(String dimNum) {
        return CellDataTypeUtil.getDimMembEntityNumByDimNum(dimNum).equals("bcm_userdefinedmembertree");
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        return ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNum);
    }

    public static DataTypeEnum getCellDataType(Long modelId, Map<String, String> dimMap, Map<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum returnDataType = CellDataTypeUtil.getDataTypeEnum(modelId, CellDataTypeUtil.getPreSetDimensions(modelId), dimMap, cachemap);
        if (returnDataType != DataTypeEnum.DEFAULT) {
            return returnDataType;
        }
        List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId);
        return CellDataTypeUtil.getDataTypeEnum(modelId, userDefined, dimMap, cachemap);
    }

    public static List<String> getUserDefined(long modelId) {
        return (List)ThreadCache.get((Object)(USER_DEFINED_DIM + modelId), () -> {
            ArrayList<String> userDefined = new ArrayList<String>(10);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            Collection col = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq").values();
            for (DynamicObject dot : col) {
                if (!CellDataTypeUtil.isUserDefinedDim(dot.getString("number"))) continue;
                userDefined.add(dot.getString("number"));
            }
            return userDefined;
        });
    }

    private static DataTypeEnum getDataTypeEnum(Long modelId, List<String> dims, Map<String, String> dimMap, Map<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(dimMap, dims);
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            String tempIndex = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (tempIndex == null || tempIndex.equals(defaultType.index)) continue;
            return DataTypeEnum.valueOfBy((String)tempIndex);
        }
        return defaultType;
    }
}

