/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.datacollect.DCContext;
import kd.fi.bcm.spread.datacollect.DataCollectServiceHelper;
import kd.fi.bcm.spread.datacollect.OrgDCContext;
import kd.fi.bcm.spread.datacollect.OrgDataCollectService;

public class DataCollectService {
    private DCContext _ctx;

    public DataCollectService(DCContext _ctx) {
        this._ctx = _ctx;
    }

    public void excute() {
        this.setStatusREADY();
        int excsise = 0;
        ArrayList<Long> orgs = new ArrayList<Long>();
        Iterator iterator = this._ctx.getMap().keySet().iterator();
        while (iterator.hasNext()) {
            long org = (Long)iterator.next();
            if (ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPENMQCAL.getNumber())) {
                int tmpsize = this._ctx.getMap().get((Object)org).size();
                if ((excsise += tmpsize) > 5) {
                    if (!orgs.isEmpty()) {
                        MQCommonPublisher.publishDataCollect(orgs, (String)ObjectSerialUtil.toByteSerialized((Object)this._ctx));
                    }
                    orgs.clear();
                    excsise = tmpsize;
                }
                orgs.add(org);
                continue;
            }
            ThreadPoolService.runDataCollectThread(() -> new OrgDataCollectService(DataCollectService.getOrgDCContext(org, this._ctx)).excute());
        }
        if (!orgs.isEmpty()) {
            MQCommonPublisher.publishDataCollect(orgs, (String)ObjectSerialUtil.toByteSerialized((Object)this._ctx));
        }
    }

    public static void excuteFromMQ(List<Long> orgIds, String _ctxs) {
        WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DataCollectService.class);
        DCContext _ctx = (DCContext)ObjectSerialUtil.deSerializedBytes((String)_ctxs);
        try {
            CountDownLatch latch = new CountDownLatch(orgIds.size());
            for (long org : orgIds) {
                ThreadPoolService.runDataCollect4OrgThread(() -> {
                    try {
                        OrgDCContext dct = DataCollectService.getOrgDCContext(org, _ctx);
                        new OrgDataCollectService(dct).excute();
                    }
                    catch (Exception e) {
                        logger.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            latch.await();
        }
        catch (Exception e) {
            logger.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
        }
    }

    private static OrgDCContext getOrgDCContext(long org, DCContext _ctx) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)_ctx.getModelNum(), (Long)org);
        OrgDCContext dct = new OrgDCContext(SimpleItem.newOne(_ctx.getModelId(), _ctx.getModelNum()), SimpleItem.newOne(_ctx.getScenarioId(), _ctx.getScenariodNum()), SimpleItem.newOne(_ctx.getFyId(), _ctx.getFyNum()), SimpleItem.newOne(_ctx.getPeriodId(), _ctx.getPeriodNum()), SimpleItem.newOne(orgNode.getId(), orgNode.getNumber()));
        dct.setBaseOrgId(TreeStructureServiceHelper.getEntityBaseMemberId(orgNode.getId()));
        if (_ctx.getMap().get((Object)org) == null) {
            dct.setWithoutTmp(true);
        }
        dct.setSort(_ctx.isSort());
        dct.setReCollect(_ctx.isReCollect());
        dct.setHasDim(_ctx.isHasDim());
        ArrayList<Long> allTempIds = new ArrayList<Long>(_ctx.getMap().get((Object)org));
        dct.setAllExcuteTempIds(allTempIds);
        if (!_ctx.isReCollect() && _ctx.getRealSelectRow() != null && _ctx.getRealSelectRow().containsKey((Object)org)) {
            dct.setRealselectTmp(_ctx.getRealSelectRow().get((Object)org));
        }
        dct.setGroup(_ctx.getGroup());
        dct.setNoPermOrgs(_ctx.getNoPermOrgs());
        dct.setRateOgrs(_ctx.getRateOrgs());
        return dct;
    }

    private void setStatusREADY() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this._ctx.getModelId());
        qfBuilder.add("scenario", "=", (Object)this._ctx.getScenarioId());
        qfBuilder.add("fy", "=", (Object)this._ctx.getFyId());
        qfBuilder.add("period", "=", (Object)this._ctx.getPeriodId());
        qfBuilder.add("org.id", "in", (Object)this._ctx.getMap().keySet());
        qfBuilder.add("template.id", "in", (Object)this._ctx.getMap().values());
        String selectFields = "id,org.id,template.id";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_datacollect", (String)selectFields, (QFilter[])qfBuilder.toArray());
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>();
        HashBasedTable colres = HashBasedTable.create();
        if (!dys.isEmpty()) {
            for (DynamicObject obj : dys) {
                colres.put((Object)obj.getLong("org.id"), (Object)obj.getLong("template.id"), (Object)obj);
            }
        }
        for (Long org : this._ctx.getMap().keySet()) {
            for (Long tmp : this._ctx.getMap().get((Object)org)) {
                if (colres.contains((Object)org, (Object)tmp)) {
                    deleteIds.add(((DynamicObject)colres.get((Object)org, (Object)tmp)).getLong("id"));
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollect");
                dynamicObject.set("org", (Object)org);
                dynamicObject.set("template", (Object)tmp);
                DataCollectServiceHelper.fixStatusComMsg(dynamicObject, this._ctx);
                dynamicObject.set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.READY.index));
                dynamicObject.set("group", (Object)this._ctx.getGroup());
                saves.add(dynamicObject);
            }
        }
        DeleteServiceHelper.delete((String)"bcm_datacollect", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
        if (!saves.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)saves.get(0)).getDataEntityType(), (Object[])saves.toArray());
            this.createRecord(saves);
        }
    }

    private void createRecord(List<DynamicObject> saves) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bcm_collectrecord");
        record.set("model", (Object)this._ctx.getModelId());
        record.set("group", (Object)this._ctx.getGroup());
        record.set("count", (Object)saves.size());
        record.set("remainder", (Object)saves.size());
        record.set("scenario", (Object)this._ctx.getScenarioId());
        record.set("year", (Object)this._ctx.getFyId());
        record.set("period", (Object)this._ctx.getPeriodId());
        record.set("creator", (Object)RequestContext.get().getUserId());
        BusinessDataWriter.save((IDataEntityType)record.getDataEntityType(), (Object[])new Object[]{record});
    }
}

