/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.model.DataCollectModel;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.spread.datacollect.OrgDCContext;

public class DataCollectServiceHelper {
    private static final String NUMBER = "number";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DataCollectServiceHelper.class);

    public static void saveSpreadData(long temId, String[] rowCol, String[] rowcolMemNum, Object value, String orgNum, DataCollectModel dataCollectModel, int dcsize) {
        Map<String, CellSet> temCellSets;
        if (dataCollectModel.getTemCmdInfos().get(temId + "!" + orgNum) == null) {
            SaveCommandInfo info = new SaveCommandInfo();
            dataCollectModel.getIdMaps().get(temId + "||" + orgNum).put("Entity", orgNum);
            List<String> rowcolMemNumList = Arrays.asList(rowCol);
            for (String key : dataCollectModel.getIdMaps().get(temId + "||" + orgNum).keySet()) {
                if (rowcolMemNumList.contains(key)) continue;
                info.addfixedDimension(new String[]{key, dataCollectModel.getIdMaps().get(temId + "||" + orgNum).get(key)});
            }
            info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            OlapCommandUtil.addSourceMeasure((String)dataCollectModel.getModelDy(), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.F1);
            info.setDimensions(rowCol);
            dataCollectModel.getTemCmdInfos().put(temId + "!" + orgNum, info);
        }
        if ((temCellSets = dataCollectModel.getTemCellSets()).get(temId + "!" + orgNum) == null) {
            CellSet cellSets = new CellSet(rowCol, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            cellSets.set(rowcolMemNum, FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
            temCellSets.put(temId + "!" + orgNum, cellSets);
        } else {
            rowcolMemNum = DataCollectServiceHelper.checkMems(dataCollectModel.getTemCmdInfos().get(temId + "!" + orgNum).getDimensions(), rowCol, rowcolMemNum);
            temCellSets.get(temId + "!" + orgNum).set(rowcolMemNum, FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
        }
        int count = temCellSets.get(temId + "!" + orgNum).getCount();
        if (count == dcsize) {
            Long baseOrgId = MemberReader.findEntityMemberByNum((String)dataCollectModel.getModelDy(), (String)orgNum).getBaseTreeNode().getId();
            DataCollectServiceHelper.saveOlap(dataCollectModel.getTemCmdInfos().get(temId + "!" + orgNum), temCellSets.remove(temId + "!" + orgNum), dataCollectModel.getModelDy(), baseOrgId, dataCollectModel.getFyid(), dataCollectModel.getPeriodid());
        }
    }

    public static void saveSpreadData(long temId, String[] rowCol, String[] rowcolMemNum, Object value, String orgNum, OrgDCContext ctx, int dcsize) {
        ArrayList<String> rowcolLists = new ArrayList<String>(10);
        if (ctx.getTemCmdInfos().get(temId) == null) {
            SaveCommandInfo info = new SaveCommandInfo();
            ctx.getComMemMaps().get(temId).put("Entity", orgNum);
            Collections.addAll(rowcolLists, rowCol);
            for (String key : ctx.getComMemMaps().get(temId).keySet()) {
                String currency = ctx.getComMemMaps().get(temId).get(DimTypesEnum.CURRENCY.getNumber());
                if (rowcolLists.contains(key)) continue;
                if (DimTypesEnum.CURRENCY.getNumber().equals(key) && ("DC".equals(currency) || "EC".equals(currency))) {
                    rowcolLists.add(DimTypesEnum.CURRENCY.getNumber());
                    continue;
                }
                info.addfixedDimension(new String[]{key, ctx.getComMemMaps().get(temId).get(key)});
            }
            info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            OlapCommandUtil.addSourceMeasure((String)ctx.getModelNum(), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.F1);
            info.setDimensions(rowcolLists.toArray(new String[0]));
            ctx.getTemCmdInfos().put(temId, info);
            rowcolLists.clear();
        }
        ArrayList<String> numberLists = new ArrayList<String>(10);
        Collections.addAll(rowcolLists, rowCol);
        Collections.addAll(numberLists, rowcolMemNum);
        String currency = rowcolLists.indexOf(DimTypesEnum.CURRENCY.getNumber()) == -1 ? ctx.getComMemMaps().get(temId).get(DimTypesEnum.CURRENCY.getNumber()) : (String)numberLists.get(rowcolLists.indexOf(DimTypesEnum.CURRENCY.getNumber()));
        String process = rowcolLists.indexOf(DimTypesEnum.PROCESS.getNumber()) == -1 ? ctx.getComMemMaps().get(temId).get(DimTypesEnum.PROCESS.getNumber()) : (String)numberLists.get(rowcolLists.indexOf(DimTypesEnum.PROCESS.getNumber()));
        String org = rowcolLists.indexOf(DimTypesEnum.ENTITY.getNumber()) == -1 ? ctx.getComMemMaps().get(temId).get(DimTypesEnum.ENTITY.getNumber()) : (String)numberLists.get(rowcolLists.indexOf(DimTypesEnum.ENTITY.getNumber()));
        Object msg = null;
        Map<Long, CellSet> temCellSets = ctx.getTemCellSets();
        if (temCellSets.get(temId) == null) {
            DataCollectServiceHelper.collectDims(temId, rowCol, rowcolMemNum, ctx, rowcolLists, numberLists, currency, process, org);
            CellSet cellSets = new CellSet(ctx.getTemCmdInfos().get(temId).getDimensions().toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            cellSets.set(numberLists.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
            temCellSets.put(temId, cellSets);
        } else {
            DataCollectServiceHelper.collectDims(temId, rowCol, rowcolMemNum, ctx, rowcolLists, numberLists, currency, process, org);
            temCellSets.get(temId).set(numberLists.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
        }
        int count = temCellSets.get(temId).getCount();
        if (count == dcsize) {
            DataCollectServiceHelper.saveOlap(ctx.getTemCmdInfos().get(temId), temCellSets.remove(temId), ctx.getModelNum(), ctx.getBaseOrgId(), ctx.getFyId(), ctx.getPeriodId());
        }
    }

    private static void collectDims(long temId, String[] rowCol, String[] rowcolMemNum, OrgDCContext ctx, List<String> rowcolLists, List<String> numberLists, String currency, String process, String org) {
        rowcolMemNum = DataCollectServiceHelper.checkMems(ctx.getTemCmdInfos().get(temId).getDimensions(), rowCol, rowcolMemNum);
        numberLists.clear();
        Collections.addAll(numberLists, rowcolMemNum);
        DataCollectServiceHelper.changeCurrencyForCell(ctx, rowcolLists, numberLists, currency, process, org);
    }

    private static void saveOlap(SaveCommandInfo info, CellSet cellSet, String cube, long orgId, long yearId, long periodId) {
        logger.startWatch();
        String bpNum = null;
        String crNum = null;
        for (FixedDimension ff : info.getFixedDimensions()) {
            if (DimTypesEnum.PROCESS.getNumber().equals(ff.getName())) {
                bpNum = ff.getValue();
            }
            if (!DimTypesEnum.CURRENCY.getNumber().equals(ff.getName())) continue;
            crNum = ff.getValue();
        }
        if (bpNum != null && "DC".equals(crNum)) {
            for (int i = 0; i < info.getFixedDimensions().size(); ++i) {
                FixedDimension ff;
                ff = (FixedDimension)info.getFixedDimensions().get(i);
                if (!DimTypesEnum.CURRENCY.getNumber().equals(ff.getName()) || !"DC".equals(ff.getValue())) continue;
                info.getFixedDimensions().remove(ff);
                Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(cube, orgId, bpNum, "DC", yearId, periodId);
                info.addfixedDimension(new String[]{DimTypesEnum.CURRENCY.getNumber(), (String)msg.p2});
            }
        }
        logger.info("bcm_olapSave_calculateByTemplate: begin olapSave");
        OlapServiceHelper.saveData(info, cellSet, cube);
        logger.infoEnd("bcm_olapSave_calculateByTemplate: end olapSave");
    }

    private static void changeCurrencyForCell(OrgDCContext ctx, List<String> rowcolLists, List<String> numberLists, String currency, String process, String org) {
        if ("DC".equals(currency) || "EC".equals(currency)) {
            long orgid = MemberReader.findEntityMemberByNum((String)ctx.getModelNum(), (String)org).getId();
            Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getModelNum(), orgid, process, currency, 0L, 0L);
            if (numberLists.contains(currency)) {
                Collections.replaceAll(numberLists, currency, msg.p2);
            } else {
                rowcolLists.add(DimTypesEnum.CURRENCY.getNumber());
                numberLists.add((String)msg.p2);
            }
        }
    }

    private static String[] checkMems(List<String> dims, String[] rowCol, String[] rowcolMemNum) {
        String[] newMems = new String[rowcolMemNum.length];
        for (int i = 0; i < rowCol.length; ++i) {
            newMems[dims.indexOf((Object)rowCol[i])] = rowcolMemNum[i];
        }
        return newMems;
    }

    public static void excuteDataCollect(StringBuffer msg, DataCollectModel dataCollectModel) {
        DataCollectServiceHelper.excuteDataCollect(msg, dataCollectModel, false);
    }

    public static void excuteDataCollect(StringBuffer msg, DataCollectModel dataCollectModel, boolean excuteBizRules) {
        throw new KDBizException("Please use a new interface : DataCollectUtil.easyBatchExecuteDC");
    }

    public static void saveDataCollectsComplete(List<DynamicObject> list) {
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXECUTED.index));
            }
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>();
            updateList.add(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                if (list.get(0).getDynamicObjectType() != list.get(i).getDynamicObjectType()) {
                    newList.add(list.get(i));
                    continue;
                }
                updateList.add(list.get(i));
            }
            if (!newList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)newList.get(0)).getDataEntityType(), (Object[])newList.toArray());
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray());
            }
        }
    }

    public static void saveDataCollecting(List<DynamicObject> list) {
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXCUTING.index));
            }
            SaveServiceHelper.save((IDataEntityType)list.get(0).getDataEntityType(), (Object[])list.toArray());
        }
    }

    public static DynamicObject getLog(OrgDCContext msg, String error) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectlog");
        log.set("model", (Object)msg.getModelId());
        log.set("collecttime", (Object)TimeServiceHelper.now());
        log.set("collector", (Object)msg.getUserId());
        log.set("fy", (Object)msg.getFyId());
        log.set("period", (Object)msg.getPeriodId());
        log.set("scenario", (Object)msg.getScenarioId());
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        log.set("logtype", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType());
        DataCollectServiceHelper.subLog(error, log);
        return log;
    }

    public static DynamicObject getLog(String formula, Long tmpId, Long orgId, Integer cellId, Long modelId, Long periodId, Long scenarioId, Long yearId, String error, String dims) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectlog");
        log.set("model", (Object)modelId);
        log.set("collecttime", (Object)TimeServiceHelper.now());
        log.set("period", (Object)periodId);
        log.set("scenario", (Object)scenarioId);
        log.set("collector", (Object)RequestContext.get().getUserId());
        log.set("fy", (Object)yearId);
        DataCollectServiceHelper.subLog(error, log);
        log.set("datafrom", (Object)formula);
        log.set("template", (Object)tmpId);
        log.set("org", (Object)orgId);
        log.set("cellid", (Object)cellId);
        log.set("dims", (Object)dims);
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        log.set("logtype", (Object)"0");
        return log;
    }

    private static void subLog(String error, DynamicObject log) {
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            if (error.contains("java") || error.contains("kd")) {
                log.set("error", (Object)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u201c%1$s\u201d\u5185\u90e8\u5f02\u5e38\uff1a%2$s\u3002", (String)"DataCollectServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), "traceId:" + RequestContext.get().getTraceId(), error.length() > 500 ? error.substring(0, 500) : error));
            } else {
                log.set("error", (Object)(error.length() > 500 ? "traceId:" + RequestContext.get().getTraceId() + error.substring(0, 500) : error));
            }
        }
    }

    public static DynamicObject getLog(DataCollectModel msg, String error) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectlog");
        log.set("model", (Object)msg.getModelid());
        log.set("collecttime", (Object)TimeServiceHelper.now());
        log.set("collector", (Object)msg.getUserId());
        log.set("fy", (Object)msg.getFyid());
        log.set("period", (Object)msg.getPeriodid());
        log.set("scenario", (Object)msg.getScenarioid());
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        log.set("logtype", (Object)"0");
        DataCollectServiceHelper.subLog(error, log);
        return log;
    }

    public static Map<Long, DynamicObject> getReports(DataCollectModel dataCollectModel, long orgId, String orgNum, List<Long> tmpids) {
        QFilter qf = QFilter.of((String)"fyear=? and period=? and scene=? and entity=?", (Object[])new Object[]{dataCollectModel.getFyid(), dataCollectModel.getPeriodid(), dataCollectModel.getScenarioid(), orgId});
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"template.id,currency,spreadjson,data,reportstatus,modifier,modifytime,reporttype", (QFilter[])qf.toArray());
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (doc != null) {
            for (DynamicObject d : doc) {
                long tempId = d.getLong("template.id");
                String currency = null;
                if (dataCollectModel.getIdMaps().get(tempId + "||" + orgNum) != null) {
                    currency = dataCollectModel.getIdMaps().get(tempId + "||" + orgNum).get("Currency");
                }
                if (StringUtils.isEmpty(currency)) {
                    currency = MemberReader.findEntityMemberByNum((String)dataCollectModel.getModelDy(), (String)orgNum).getCurrency();
                }
                if (d.getDynamicObject("currency") == null || currency == null || !currency.equals(d.getDynamicObject("currency").getString(NUMBER))) continue;
                map.put(d.getLong("template.id"), d);
            }
        }
        return map;
    }

    public static Map<Long, DynamicObject> getReports(OrgDCContext ctx, long orgId, String orgNum, List<Long> tmpids) {
        QFilter qf = QFilter.of((String)"fyear=? and period=? and scene=? and entity=?", (Object[])new Object[]{ctx.getFyId(), ctx.getPeriodId(), ctx.getScenarioId(), orgId});
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"template.id,currency,spreadjson,data,reportstatus,modifytime,modifier, reporttype", (QFilter[])qf.toArray());
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        if (doc != null) {
            for (DynamicObject d : doc) {
                long tempId = d.getLong("template.id");
                String currency = null;
                if (ctx.getComMemMaps().get(tempId) != null) {
                    currency = ctx.getCurrency(tempId);
                }
                if (StringUtils.isEmpty(currency)) {
                    currency = MemberReader.findEntityMemberByNum((String)ctx.getModelNum(), (String)orgNum).getCurrency();
                }
                if (d.getDynamicObject("currency") == null || currency == null || !currency.equals(d.getDynamicObject("currency").getString(NUMBER))) continue;
                map.put(d.getLong("template.id"), d);
            }
        }
        return map;
    }

    public static void fixStatusComMsg(DynamicObject status, AbstractContext _ctx) {
        status.set("scenario", (Object)_ctx.getScenarioId());
        status.set("fy", (Object)_ctx.getFyId());
        status.set("period", (Object)_ctx.getPeriodId());
        status.set("model", (Object)_ctx.getModelId());
        status.set("modifydate", (Object)TimeServiceHelper.now());
        status.set("modifier", (Object)RequestContext.get().getUserId());
    }
}

