/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.datacollect.ReportCalculateHelper;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.CalculateInfo;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.lang3.StringUtils;

public class EDFormulaUtil {
    private static final Log LOGGER = LogFactory.getLog(EDFormulaUtil.class);
    public static String EDC = "EDC";
    public static String CURRYEAR = "currYear";
    public static String CURRPERIOD = "currPeriod";
    public static String SUMDATA = "sumdata";

    public static void calExtFormula(String modelNum, SpreadManager sm) {
        HashMap<String, String> dimNumMap = new HashMap<String, String>();
        HashMap<String, String> dim2Number = new HashMap<String, String>();
        Sheet sheet = sm.getBook().getSheet(0);
        for (PositionInfo po : sm.getAreaManager().getPostionInfoSet()) {
            ICalContext ctx = EDFormulaUtil.getCalCtx(modelNum, sm);
            if (po.getExtendInfo() != null && po.getExtendInfo().getCalculateInfos() != null) {
                List calculateInfos = po.getExtendInfo().getCalculateInfos();
                RangeModel rm = new RangeModel(po.getAreaRange());
                EDFormulaUtil.packFormula(calculateInfos, rm, sheet);
                ctx.setProperty(ReportCalculateHelper.RANGE, rm);
                if (dimNumMap.isEmpty()) {
                    QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber,dseq,issysdimension", (QFilter[])new QFBuilder().add("model.number", "=", (Object)modelNum).toArray()).forEach(e -> dimNumMap.put(e.getString("shortnumber"), e.getString("number")));
                }
                if (dim2Number.isEmpty()) {
                    sm.getFilter().getPageDomain().getDimensions().forEach(d -> dim2Number.put(d.getNumber().toLowerCase(), ((IDimMember)d.getMembers().get(0)).getNumber()));
                    sm.getFilter().getViewPointDomain().getDimensions().forEach(d -> dim2Number.put(d.getNumber().toLowerCase(), ((IDimMember)d.getMembers().get(0)).getNumber()));
                }
                SpecialCalLogic.fixVFormulaHandle(ctx, dimNumMap, dim2Number);
            }
            if (sheet.getChangedRows() == null) continue;
            RangeModel rm = new RangeModel(po.getAreaRange());
            List<String> cals = ReportCalculateHelper.calculateSheet(sheet, ctx, cell -> rm.getY_start() <= cell.getRow() && rm.getY_end() >= cell.getRow() && sheet.getChangedRows().contains(cell.getRow()));
            for (String cal : cals) {
                Cell cell2 = sheet.getCell(ExcelUtils.pos2Y((String)cal), ExcelUtils.pos2X((String)cal));
                if (!(cell2.getValue() instanceof Exception)) continue;
                cell2.setValue(null);
            }
        }
    }

    private static void packFormula(List<CalculateInfo> calculateInfos, RangeModel rm, Sheet sheet) {
        String formula;
        CalculateInfo cal;
        Map<String, Integer> map = EDFormulaUtil.getColMap(rm, sheet);
        FormulaChecker formulaChecker = new FormulaChecker();
        boolean isHasVFormula = false;
        Iterator<CalculateInfo> iterator = calculateInfos.iterator();
        while (!(!iterator.hasNext() || map.containsKey((cal = iterator.next()).getCalcol().toLowerCase()) && (isHasVFormula = StringUtils.isNotEmpty((CharSequence)(formula = EDFormulaUtil.paserFormula(cal.getFormula(), colnum -> {
            ReferenceExpr r = new ReferenceExpr();
            r.setRow(rm.getY_start());
            r.setCol(((Integer)map.get(colnum.toLowerCase())).intValue());
            return r;
        }))) && !formulaChecker.checkIsOnlyExcel(formula)))) {
        }
        for (int row = rm.getY_start(); row <= rm.getY_end(); ++row) {
            boolean isChangeRow = false;
            for (Cell cell : sheet.getRow(row)) {
                if (cell.getCol() < rm.getX_start() || cell.getCol() > rm.getX_end() || !cell.isChangeVal() && cell.getUserObject("extrowSpkid") != null && !isHasVFormula) continue;
                isChangeRow = true;
                break;
            }
            if (!isChangeRow) continue;
            sheet.addChangeRow(Integer.valueOf(row));
            for (CalculateInfo cal2 : calculateInfos) {
                if (!map.containsKey(cal2.getCalcol().toLowerCase())) continue;
                int col = map.get(cal2.getCalcol().toLowerCase());
                if (EDFormulaUtil.checkRowNeedCal(sheet, row, col, map)) {
                    int finalRow = row;
                    String formula2 = EDFormulaUtil.paserFormula(cal2.getFormula(), colnum -> {
                        ReferenceExpr r = new ReferenceExpr();
                        r.setRow(finalRow);
                        r.setCol(((Integer)map.get(colnum.toLowerCase())).intValue());
                        return r;
                    });
                    sheet.getCell(row, col).setFormula(formula2);
                    continue;
                }
                sheet.getCell(row, col).setFormula(null);
            }
        }
    }

    private static boolean checkRowNeedCal(Sheet sheet, int row, int curCol, Map<String, Integer> colNum2Cols) {
        for (int col : colNum2Cols.values()) {
            Object value;
            if (col == curCol || colNum2Cols.get("entity") != null && col == colNum2Cols.get("entity") || (value = sheet.getCell(row, col).getValue()) == null || !kd.bos.util.StringUtils.isNotEmpty((String)value.toString())) continue;
            return true;
        }
        return false;
    }

    private static ICalContext getCalCtx(String modelNum, SpreadManager sm) {
        return new CalContext(modelNum, SpreadMemberUtil.getDimNumberBySm(sm, DimTypesEnum.ENTITY), SpreadMemberUtil.getDimNumberBySm(sm, DimTypesEnum.YEAR), SpreadMemberUtil.getDimNumberBySm(sm, DimTypesEnum.PERIOD), SpreadMemberUtil.getDimNumberBySm(sm, DimTypesEnum.SCENARIO), SpreadMemberUtil.getDimNumberBySm(sm, DimTypesEnum.CURRENCY));
    }

    private static Map<String, Integer> getColMap(RangeModel rm, Sheet sheet) {
        int startRowIndex = rm.getY_start();
        int headerCol = startRowIndex - 1;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int col = rm.getX_start(); col <= rm.getX_end(); ++col) {
            Cell cell = sheet.getCell(headerCol, col);
            if (cell.getEXTColNumber() == null) continue;
            map.put(cell.getEXTColNumber().toLowerCase(), col);
        }
        return map;
    }

    private static String paserFormula(String formula, Function<String, Expression> custom) {
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            LOGGER.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)10));
            return null;
        }
        expression = ExcelFormulaPaserHelper.walk((Expression)expression, expr -> {
            if (expr instanceof FunctionExpr && ((FunctionExpr)expr).getFuncionName().equalsIgnoreCase(EDC)) {
                return (Expression)custom.apply(((StringExpr)((FunctionExpr)expr).getParameters().get(0)).getValue());
            }
            return expr;
        });
        return expression.toString();
    }

    public static void checkSumFormula(SpreadManager sm) {
        HashMap sumdata = new HashMap();
        HashMap headtoModel = new HashMap();
        HashMap map = new HashMap(16);
        sm.getAreaManager().getPostionInfoSet().forEach(p -> {
            if (p.getExtendInfo() != null) {
                RangeModel rm = new RangeModel(p.getAreaRange());
                int startrow = rm.getY_start();
                headtoModel.put(startrow - 1, p.getExtendInfo().getExtModelNumber());
                map.put(startrow - 1, p.getAreaRange());
            }
        });
        Sheet sheet = sm.getBook().getSheet(0);
        sheet.iteratorCells(c -> {
            if (c.hasFormula() && c.getFormula().startsWith("XSUMBYAREA")) {
                String extCol;
                int row;
                if (c.getFormula().equalsIgnoreCase("XSUMBYAREA(\"up\")")) {
                    for (row = c.getRow() - 1; row >= 0; --row) {
                        extCol = sheet.getCell(row, c.getCol()).getEXTColNumber();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)extCol)) continue;
                        sumdata.put(ExcelUtils.xy2Pos((int)c.getCol(), (int)c.getRow()), (String)headtoModel.get(row) + "|" + extCol + "|" + (String)map.get(row));
                        break;
                    }
                }
                if (c.getFormula().equalsIgnoreCase("XSUMBYAREA(\"down\")")) {
                    for (row = c.getRow(); row < sheet.getMaxRowCount(); ++row) {
                        extCol = sheet.getCell(row, c.getCol()).getEXTColNumber();
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)extCol)) continue;
                        sumdata.put(ExcelUtils.xy2Pos((int)c.getCol(), (int)c.getRow()), (String)headtoModel.get(row) + "|" + extCol + "|" + (String)map.get(row));
                        break;
                    }
                }
            }
        });
        if (!sumdata.isEmpty()) {
            sheet.putUserObject(SUMDATA, sumdata);
        } else {
            sheet.getUserObject().remove(SUMDATA);
        }
    }

    public static Cell getXSumCellUnitCell(SpreadManager sm, Cell c) {
        Variant value = c.getVariant();
        Sheet sheet = sm.getBook().getSheet(0);
        if (value != null && value.isNumeric() && c.hasFormula() && c.getFormula().startsWith("XSUMBYAREA")) {
            String extCol;
            int row;
            if (c.getFormula().equalsIgnoreCase("XSUMBYAREA(\"up\")")) {
                for (row = c.getRow() - 1; row >= 0; --row) {
                    extCol = sheet.getCell(row, c.getCol()).getEXTColNumber();
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)extCol)) continue;
                    return sheet.getCell(row + 1, c.getCol());
                }
            }
            if (c.getFormula().equalsIgnoreCase("XSUMBYAREA(\"down\")")) {
                for (row = c.getRow(); row < sheet.getMaxRowCount(); ++row) {
                    extCol = sheet.getCell(row, c.getCol()).getEXTColNumber();
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)extCol)) continue;
                    return sheet.getCell(row + 1, c.getCol());
                }
            }
            return null;
        }
        return null;
    }

    public static boolean checkHasSumCal(SpreadManager sm) {
        return sm.getBook().getSheet(0).getUserObject().containsKey(SUMDATA);
    }

    public static Set<String> getSumColByModel(Map<String, String> sumdata, String datamodelNum) {
        HashSet<String> cols = new HashSet<String>();
        sumdata.values().forEach(sd -> {
            String[] s = sd.split("\\|");
            if (s[0].equals(datamodelNum)) {
                cols.add(s[1]);
            }
        });
        return cols;
    }

    public static Map<String, BigDecimal> getSumValue(EdQueryComInfo edQueryComInfo) {
        HashMap<String, BigDecimal> sumvalues = new HashMap<String, BigDecimal>();
        if (edQueryComInfo.getSumValue() != null) {
            String datamodel = edQueryComInfo.getDatamodel();
            edQueryComInfo.getSumValue().forEach((k, v) -> sumvalues.put(datamodel + "|" + k, (BigDecimal)v));
        }
        return sumvalues;
    }

    public static void fixSumValueToSm(SpreadManager sm, Map<String, String> sumdata, Map<String, BigDecimal> sumvalues) {
        if (!sumvalues.isEmpty()) {
            sumdata.forEach((k, v) -> {
                Cell c = sm.getBook().getSheet(0).getCell(ExcelUtils.pos2Y((String)k), ExcelUtils.pos2X((String)k));
                c.setValue(sumvalues.get(v));
            });
        }
    }
}

