/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.spread.datacollect.EDFormulaUtil;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.IBreakableExpressionHandler;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;

public class FormulaCheckModel
implements IBreakableExpressionHandler {
    private boolean pass;
    private boolean hasfunction;
    private boolean onlyExcel = true;
    private List<String> formulaList;

    public FormulaCheckModel() {
        this.formulaList = FormulaRegister.getRegistFormula();
    }

    public FormulaCheckModel(List<String> formulaList) {
        this.formulaList = formulaList;
    }

    public boolean isPass(String formula) {
        try {
            Expression e = ExcelFormulaPaserHelper.parse((String)formula);
            ExcelFormulaPaserHelper.walk((Expression)e, (IBreakableExpressionHandler)this);
        }
        catch (Exception ex) {
            return false;
        }
        return this.pass || !this.hasfunction;
    }

    public boolean isOnlyExcel(String formula) {
        try {
            Expression e = ExcelFormulaPaserHelper.parse((String)formula);
            ExcelFormulaPaserHelper.walk((Expression)e, expr -> {
                if (expr instanceof FunctionExpr) {
                    String funmame = ((FunctionExpr)expr).getFuncionName();
                    if (FormulaRegister.getExcelNotSupportFormulas().contains(funmame.toLowerCase(Locale.ENGLISH))) {
                        this.onlyExcel = false;
                        return false;
                    }
                }
                return true;
            });
        }
        catch (Exception ex) {
            return false;
        }
        return this.onlyExcel;
    }

    public boolean isHaveColsField(String formula, List<String> cols) {
        AtomicBoolean flag = new AtomicBoolean(false);
        try {
            Expression e = ExcelFormulaPaserHelper.parse((String)formula);
            ExcelFormulaPaserHelper.walk((Expression)e, expr -> {
                FunctionExpr functionExpr;
                String funmame;
                if (expr instanceof FunctionExpr && EDFormulaUtil.EDC.equalsIgnoreCase(funmame = (functionExpr = (FunctionExpr)expr).getFuncionName()) && cols.contains(functionExpr.getParameters().get(0).toString().replaceAll("\"", ""))) {
                    flag.set(true);
                    return false;
                }
                return true;
            });
        }
        catch (Exception ex) {
            return false;
        }
        return flag.get();
    }

    public List<String> getNoDataCols(String formula, List<String> cols) {
        ArrayList<String> list = new ArrayList<String>(16);
        if (!cols.isEmpty()) {
            try {
                Expression e = ExcelFormulaPaserHelper.parse((String)formula);
                ExcelFormulaPaserHelper.walk((Expression)e, expr -> {
                    String number;
                    FunctionExpr functionExpr;
                    String funmame;
                    if (expr instanceof FunctionExpr && EDFormulaUtil.EDC.equalsIgnoreCase(funmame = (functionExpr = (FunctionExpr)expr).getFuncionName()) && !cols.contains(number = functionExpr.getParameters().get(0).toString().replaceAll("\"", ""))) {
                        list.add(number);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean isHaveColField(String formula, String colNumber) {
        return this.isHaveColsField(formula, Collections.singletonList(colNumber));
    }

    public boolean handle(Expression expr) {
        if (this.pass) {
            return false;
        }
        if (expr instanceof FunctionExpr) {
            this.hasfunction = true;
            String funmame = ((FunctionExpr)expr).getFuncionName();
            if (this.formulaList.contains(funmame.toLowerCase(Locale.ENGLISH))) {
                this.pass = true;
                return false;
            }
        }
        return true;
    }
}

