/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.AbstractContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class OrgDCContext
extends AbstractContext {
    private Map<Long, SimpleItem> calCurrencys;
    private String ec;
    private String pc;
    private long orgId;
    private long baseOrgId;
    private String org;
    private Set<String> noPermOrgs;
    private Set<String> rateOgrs;
    private SpreadManager spreadManager;
    private boolean withoutTmp;
    private Map<Long, Map<String, String>> comMemMaps;
    private boolean isSort = false;
    private boolean isReCollect = true;
    private String userId;
    private Map<String, Object> result;
    private List<Long> allExcuteTempIds;
    private int failacctSum = 0;
    private int successacctSum = 0;
    private int tipLogSum = 0;
    private Collection<Long> realselectTmp;
    private McStatus mc;
    private transient Map<Long, SaveCommandInfo> temCmdInfos = new HashMap<Long, SaveCommandInfo>();
    private transient Map<Long, CellSet> temCellSets = new HashMap<Long, CellSet>();
    private boolean hasDim = true;
    private boolean ignoreError = false;
    private Long group = 0L;
    private Map<String, DataTypeAcctCacheInfo> cachemap = new HashMap<String, DataTypeAcctCacheInfo>(16);
    private static final List<String> EFFECT_CURRENCY_DIM = Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber());
    private static final List<String> TRANS_CURRENCY = Arrays.asList("DC", "PC");

    public OrgDCContext(SimpleItem model, SimpleItem scenario, SimpleItem fy, SimpleItem period, SimpleItem org) {
        super(model, scenario, fy, period);
        this.org = org.number;
        this.orgId = Long.parseLong(org.id.toString());
        this.userId = RequestContext.get().getUserId();
        this.init();
    }

    private void init() {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)this.getModelNum(), (Long)this.getOrgId());
        this.ec = orgNode.getCurrency();
        this.pc = orgNode.getParent().getCurrency();
        this.mc = McStatus.getMcStatus(this.getModelId(), this.getOrgId(), this.getScenarioId(), this.getFyId(), this.getPeriodId());
    }

    public SimpleItem getCalCurrency(long tmpId) {
        if (this.calCurrencys == null) {
            this.calCurrencys = new HashMap<Long, SimpleItem>(16);
            for (long tmp : this.getAllExcuteTempIds()) {
                String curnumber = this.ec;
                if (this.getComMemMaps().get(tmp).containsKey(DimTypesEnum.CURRENCY.getNumber()) && !"EC".equals(this.getComMemMaps().get(tmp).get(DimTypesEnum.CURRENCY.getNumber()))) {
                    curnumber = this.getComMemMaps().get(tmp).get(DimTypesEnum.CURRENCY.getNumber());
                }
                if ("DC".equals(curnumber)) {
                    String pbNum = this.getComMemMaps().get(tmp).get(DimTypesEnum.PROCESS.getNumber());
                    if (StringUtils.isEmpty((String)pbNum)) {
                        curnumber = this.ec;
                    } else {
                        Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(this.getModelNum(), this.getOrgId(), pbNum, "DC", this.getFyId(), this.getPeriodId());
                        curnumber = (String)msg.p2;
                    }
                } else if ("PC".equals(curnumber)) {
                    QFilter filter1 = new QFilter("number", "=", (Object)this.getOrg());
                    QFilter filter2 = new QFilter("model.number", "=", (Object)this.getModelId());
                    QFilter filter3 = new QFilter("storagetype", "!=", (Object)"3");
                    DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"parent.currency", (QFilter[])new QFilter[]{filter1, filter2, filter3});
                    filter1 = new QFilter("id", "=", (Object)dy.getLong("parent.id"));
                    dy = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"currency.number", (QFilter[])new QFilter[]{filter1});
                    curnumber = dy.getString("currency.number");
                }
                this.calCurrencys.put(tmp, SimpleItem.newOne(MemberReader.findCurrencyMemberByNum((String)this.getModelNum(), (String)curnumber).getId(), curnumber));
            }
        }
        return this.calCurrencys.get(tmpId);
    }

    public Map<Long, Map<String, String>> getComMemMaps() {
        if (this.comMemMaps == null) {
            this.comMemMaps = DataCollectUtil.collectPageSelect(this.getModelNum(), this.getOrg(), this.getAllExcuteTempIds());
            for (Map.Entry<Long, Map<String, String>> entry : this.comMemMaps.entrySet()) {
                Map<String, String> dims2memnum = entry.getValue();
                String currencyNum = DimTypesEnum.CURRENCY.getNumber();
                if (!dims2memnum.keySet().containsAll(EFFECT_CURRENCY_DIM) || !TRANS_CURRENCY.contains(dims2memnum.get(currencyNum))) continue;
                Pair<String, String> pair = TransMemberUtil.transOrgAndCurbyOrgId(this.getModelId(), this.getBaseOrgId(), dims2memnum.get(DimTypesEnum.PROCESS.getNumber()), dims2memnum.get(currencyNum), 0L, 0L);
                dims2memnum.put(currencyNum, (String)pair.p2);
            }
            for (Map map : this.comMemMaps.values()) {
                if (map.get(DimTypesEnum.YEAR.getNumber()) == null) {
                    map.put(DimTypesEnum.YEAR.getNumber(), this.getFyNum());
                }
                if (map.get(DimTypesEnum.PERIOD.getNumber()) == null) {
                    map.put(DimTypesEnum.PERIOD.getNumber(), this.getPeriodNum());
                }
                if (map.get(DimTypesEnum.SCENARIO.getNumber()) == null) {
                    map.put(DimTypesEnum.SCENARIO.getNumber(), this.getScenariodNum());
                }
                if (map.get(DimTypesEnum.ENTITY.getNumber()) == null) {
                    map.put(DimTypesEnum.ENTITY.getNumber(), this.getOrg());
                }
                if (map.get(DimTypesEnum.CURRENCY.getNumber()) == null || "EC".equals(map.get(DimTypesEnum.CURRENCY.getNumber()))) {
                    map.put(DimTypesEnum.CURRENCY.getNumber(), this.getEc());
                }
                Optional specificFy = PeriodUtils.trans2SpecificFy((String)this.getModelNum(), (String)this.getFyNum(), (String)((String)map.get(DimTypesEnum.YEAR.getNumber())));
                Optional trans2SpecificPeriod = PeriodUtils.trans2SpecificPeriod((String)this.getModelNum(), (String)this.getPeriodNum(), (String)((String)map.get(DimTypesEnum.PERIOD.getNumber())), (boolean)true);
                map.put(DimTypesEnum.YEAR.getNumber(), specificFy.get());
                map.put(DimTypesEnum.PERIOD.getNumber(), trans2SpecificPeriod.get());
            }
        }
        return this.comMemMaps;
    }

    public String getPc() {
        return this.pc;
    }

    public void setComMemMaps(Map<Long, Map<String, String>> comMemMaps) {
        this.comMemMaps = comMemMaps;
    }

    public long getCurrencyId(long tmpId) {
        return (Long)this.getCalCurrency((long)tmpId).id;
    }

    public String getCurrency(long tmpId) {
        return this.getCalCurrency((long)tmpId).number;
    }

    public String getEc() {
        return this.ec;
    }

    public SpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public void setSpreadManager(SpreadManager spreadManager) {
        this.spreadManager = spreadManager;
    }

    public void setWithoutTmp(boolean withoutTmp) {
        this.withoutTmp = withoutTmp;
    }

    public boolean isWithoutTmp() {
        return this.withoutTmp;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public String getOrg() {
        return this.org;
    }

    public Set<String> getNoPermOrgs() {
        return this.noPermOrgs;
    }

    public void setNoPermOrgs(Set<String> noPermOrgs) {
        this.noPermOrgs = noPermOrgs;
    }

    public Set<String> getRateOgrs() {
        return this.rateOgrs;
    }

    public void setRateOgrs(Set<String> rateOgrs) {
        this.rateOgrs = rateOgrs;
    }

    public boolean isReCollect() {
        return this.isReCollect;
    }

    public boolean isSort() {
        return this.isSort;
    }

    public void setReCollect(boolean reCollect) {
        this.isReCollect = reCollect;
    }

    public void setSort(boolean sort) {
        this.isSort = sort;
    }

    public Map<Long, SaveCommandInfo> getTemCmdInfos() {
        return this.temCmdInfos;
    }

    public void setTemCmdInfos(Map<Long, SaveCommandInfo> temCmdInfos) {
        this.temCmdInfos = temCmdInfos;
    }

    public Map<Long, CellSet> getTemCellSets() {
        return this.temCellSets;
    }

    public void setTemCellSets(Map<Long, CellSet> temCellSets) {
        this.temCellSets = temCellSets;
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, Object> getResult() {
        if (this.result == null) {
            this.result = new HashMap<String, Object>();
        }
        return this.result;
    }

    public boolean isHasDim() {
        return this.hasDim;
    }

    public void setHasDim(boolean hasDim) {
        this.hasDim = hasDim;
    }

    public List<Long> getAllExcuteTempIds() {
        return this.allExcuteTempIds;
    }

    public void setAllExcuteTempIds(List<Long> allExcuteTempIds) {
        this.allExcuteTempIds = allExcuteTempIds;
    }

    public int getFailacctSum() {
        return this.failacctSum;
    }

    public void setFailacctSum(int failacctSum) {
        this.failacctSum = failacctSum;
    }

    public int getTipLogSum() {
        return this.tipLogSum;
    }

    public void setTipLogSum(int tipLogSum) {
        this.tipLogSum = tipLogSum;
    }

    public int getSuccessacctSum() {
        return this.successacctSum;
    }

    public void setSuccessacctSum(int successacctSum) {
        this.successacctSum = successacctSum;
    }

    public Collection<Long> getRealselectTmp() {
        return this.realselectTmp;
    }

    public void setRealselectTmp(Collection<Long> realselectTmp) {
        this.realselectTmp = realselectTmp;
    }

    public McStatus getMc() {
        return this.mc;
    }

    public long getBaseOrgId() {
        return this.baseOrgId;
    }

    public void setBaseOrgId(long baseOrgId) {
        this.baseOrgId = baseOrgId;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public Long getGroup() {
        return this.group;
    }

    public void setGroup(Long group) {
        this.group = group;
    }

    public Map<String, DataTypeAcctCacheInfo> getCachemap() {
        return this.cachemap;
    }

    public void setCachemap(Map<String, DataTypeAcctCacheInfo> cachemap) {
        this.cachemap = cachemap;
    }
}

