/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.datacollet.DimensionMapModel;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.CollectCalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.key.IPackKey;
import kd.fi.bcm.business.formula.model.key.PackKey;
import kd.fi.bcm.business.formula.model.value.ICollectResultHandle;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.model.excel.ApiResponseModel;
import kd.fi.bcm.business.model.excel.DimsReq;
import kd.fi.bcm.business.model.formula.AccountCheckParser;
import kd.fi.bcm.business.model.formula.AcctJudgeFormula;
import kd.fi.bcm.business.model.formula.ParseFormula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.FormarResultServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.BcmDLockUtil;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.business.util.DefaultPageDimSettingUtil;
import kd.fi.bcm.business.util.MyTemplateUtil;
import kd.fi.bcm.business.util.SpreadMemUtil;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.FormulaMessage;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AcctCollectConfigTypeEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DChangeTypeEnum;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.report.ReportType;
import kd.fi.bcm.common.exception.NotificationException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.parser.AntlrParser;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.fi.bcm.formplugin.util.CellDataTypeUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.datacollect.DataCollectServiceHelper;
import kd.fi.bcm.spread.datacollect.ErrorMsg;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.datacollect.OrgDCContext;
import kd.fi.bcm.spread.datacollect.ReportCalculateHelper;
import kd.fi.bcm.spread.datacollect.SheetDataProvider;
import kd.fi.bcm.spread.datacollect.SpecialCalLogic;
import kd.fi.bcm.spread.datacollect.model.RefParamResult;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import kd.fi.bcm.spread.util.CollectCalculateHelp;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public class OrgDataCollectService {
    private OrgDCContext _ctx;
    private List<Long> sortTempids;
    private Map<Long, DynamicObject> reportMap;
    private Map<String, String> shortNumbers;
    private List<Long> unCollectTmp;
    private static final String SCENARIO = "scenario";
    private static final String MODIFIER = "modifier";
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String DATA_FROM = "datafrom";
    private static final String TEMPLATE = "template";
    private static final String MODEL = "model";
    private static final String PERIOD = "period";
    private static final String ERROR = "error";
    private static final String SPREAD_JSON = "spreadjson";
    private static final String MEMBKEY = "membkey";
    private static final String DCHANGE_TYPE = "dchangetype";
    private List<AbstractFormula> formulas = new ArrayList<AbstractFormula>();
    private Date collectTime;
    private int failacctSum = 0;
    private int tipLogSum = 0;
    private AtomicInteger successacctSum = new AtomicInteger(0);
    private Map<String, String> dimNumMap;
    public static final String[] notCollectFormula = new String[]{"rptinfo", "rptdate"};
    private FormulaChecker formulaChecker;
    private DataTrace2FromService dtfs;
    boolean isOpenTrace;
    private int dcsize = 10000;
    private int batchlogsize = 1;
    private Sheet sheet;
    private SpreadManager spreadManager;
    private static WatchLogger LOGGER = BcmLogFactory.getWatchLogInstance((boolean)true, OrgDataCollectService.class);
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, OrgDataCollectService.class);
    private long tmpId;
    private boolean leaf = false;
    private boolean isCalStaging = false;
    private static final List<String> CELLDIMS = Arrays.asList(DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber());
    boolean isStringCheck = true;
    boolean errorLogLevel = false;
    boolean openBatchCal = false;
    boolean iSDistZeroAndNull = false;
    boolean isAutoConventMyCompany = false;
    int INIT_TEN = 10;
    private static DimTypesEnum[] CHECKDIMTYPES = new DimTypesEnum[]{DimTypesEnum.CHANGETYPE, DimTypesEnum.INTERCOMPANY, DimTypesEnum.DATASORT, DimTypesEnum.MYCOMPANY, DimTypesEnum.MULTIGAAP};

    private boolean isFromRpt() {
        return this._ctx.getSpreadManager() != null;
    }

    public OrgDataCollectService(OrgDCContext _ctx) {
        this._ctx = _ctx;
        this.spreadManager = _ctx.getSpreadManager();
        if (this.spreadManager != null) {
            this.sheet = this.spreadManager.getBook().getSheet(0);
        }
        this.collectTime = TimeServiceHelper.now();
        this.shortNumbers = new HashMap<String, String>();
        this.dimNumMap = new HashMap<String, String>();
        QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber,dseq,issysdimension", (QFilter[])new QFBuilder().add("model.number", "=", (Object)_ctx.getModelNum()).toArray()).forEach(e -> this.dimNumMap.put(e.getString("shortnumber"), e.getString(NUMBER)));
        this.formulaChecker = new FormulaChecker();
        this.dtfs = new DataTrace2FromService(_ctx.getModelId(), GlobalIdUtil.genGlobalLongId());
        this.isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
        String bcm_dcsize = ConfigServiceHelper.getStringParamNoModel("dcsize");
        if (!StringUtils.isEmpty((String)bcm_dcsize)) {
            this.dcsize = Integer.parseInt(bcm_dcsize);
        }
        if (this.isFromRpt() && _ctx.getAllExcuteTempIds() != null) {
            this.tmpId = _ctx.getAllExcuteTempIds().get(0);
        }
        this.isCalStaging = ConfigServiceHelper.getBoolParam(_ctx.getModelId(), "isCalStaging") && this.isFromRpt();
        this.isStringCheck = ConfigServiceHelper.getBoolChildParam(_ctx.getModelId(), "CM014", AcctCollectConfigTypeEnum.ISSTRINGCHECK.getNumber());
        this.errorLogLevel = ConfigServiceHelper.getBoolParam(_ctx.getModelNum(), "calErrorLogLevel");
        this.openBatchCal = ConfigServiceHelper.getBoolParam(_ctx.getModelId(), ConfigEnum.IS_OPEN_BATCH_CAL.getNumber());
        this.iSDistZeroAndNull = ConfigServiceHelper.getBoolParam(_ctx.getModelId(), "isDistinguish0AndNull");
        this.isAutoConventMyCompany = ConfigServiceHelper.getBoolParam(_ctx.getModelId(), "CM043");
    }

    public List<Long> getUnCollectTmp() {
        if (this.unCollectTmp == null) {
            this.unCollectTmp = this.checkCurrencyMcstatus();
        }
        return this.unCollectTmp;
    }

    public void add(AbstractFormula model) {
        this.formulas.add(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excute() {
        try {
            this._ctx.setIgnoreError(this.isStringCheck);
            Set<String> notPermEntityNums = DataCollectUtil.getNotPermNumsCache(this._ctx.getModelId(), "Entity");
            this._ctx.setNoPermOrgs(notPermEntityNums);
            this._ctx.setRateOgrs(MemberReader.getAllNodeByDimNum((String)"Entity", (String)this._ctx.getModelNum()).stream().map(e -> {
                if (e.getLongNumber().contains("RateEntity")) {
                    return e.getNumber();
                }
                return null;
            }).collect(Collectors.toSet()));
            this.calculateGroupByOrg();
            this._ctx.setFailacctSum(this.failacctSum);
            this._ctx.setTipLogSum(this.tipLogSum);
            this._ctx.setSuccessacctSum(this.successacctSum.get());
        }
        catch (Exception e2) {
            try {
                DynamicObject dy = DataCollectServiceHelper.getLog(this._ctx, String.format(ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6570\u5931\u8d25\uff1a%s\u3002", (String)"OrgDataCollectService_0", (String)"fi-bcm-business", (Object[])new Object[0]), DataCollectUtil.getErrorMsg(e2)));
                dy.set("org", (Object)this._ctx.getBaseOrgId());
                dy.set(TEMPLATE, (Object)this.tmpId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
                this._ctx.setFailacctSum(1);
            }
            catch (Throwable throwable) {
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add(MODEL, "=", (Object)this._ctx.getModelId());
                qfBuilder.add(SCENARIO, "=", (Object)this._ctx.getScenarioId());
                qfBuilder.add("fy", "=", (Object)this._ctx.getFyId());
                qfBuilder.add(PERIOD, "=", (Object)this._ctx.getPeriodId());
                qfBuilder.add("org", "=", (Object)this._ctx.getBaseOrgId());
                qfBuilder.add("template.id", "in", this._ctx.getAllExcuteTempIds());
                qfBuilder.add("collectstatus", "in", (Object)new char[]{DataCollectRecordEnum.EXCUTING.index, DataCollectRecordEnum.READY.index});
                DynamicObject[] cols = BusinessDataServiceHelper.load((String)"bcm_datacollect", (String)"collectstatus,modifydate,modifier", (QFilter[])qfBuilder.toArray());
                if (cols != null && cols.length > 0) {
                    for (DynamicObject dynamicObject : cols) {
                        dynamicObject.set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXECUTED.index));
                        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                        dynamicObject.set(MODIFIER, (Object)RequestContext.get().getUserId());
                    }
                    SaveServiceHelper.save((DynamicObject[])cols);
                }
                if (this._ctx.getGroup() != 0L) {
                    QFilter qFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId()).and("group", "=", (Object)this._ctx.getGroup());
                    Object[] record = BusinessDataServiceHelper.load((String)"bcm_collectrecord", (String)"model, count, remainder, createtime, endtime, group, creator.name", (QFilter[])qFilter.toArray());
                    if (record.length > 0) {
                        for (DynamicObject dynamicObject : record) {
                            dynamicObject.set("endtime", (Object)new Date());
                        }
                        BusinessDataWriter.update((IDataEntityType)record[0].getDataEntityType(), (Object[])record);
                    }
                    if (record.length != 1) {
                        logger.error(String.format("bcm_datacollect group error groupid %d count %d", this._ctx.getGroup(), record.length));
                    }
                }
                throw throwable;
            }
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(MODEL, "=", (Object)this._ctx.getModelId());
            qfBuilder.add(SCENARIO, "=", (Object)this._ctx.getScenarioId());
            qfBuilder.add("fy", "=", (Object)this._ctx.getFyId());
            qfBuilder.add(PERIOD, "=", (Object)this._ctx.getPeriodId());
            qfBuilder.add("org", "=", (Object)this._ctx.getBaseOrgId());
            qfBuilder.add("template.id", "in", this._ctx.getAllExcuteTempIds());
            qfBuilder.add("collectstatus", "in", (Object)new char[]{DataCollectRecordEnum.EXCUTING.index, DataCollectRecordEnum.READY.index});
            QFilter cols = BusinessDataServiceHelper.load((String)"bcm_datacollect", (String)"collectstatus,modifydate,modifier", (QFilter[])qfBuilder.toArray());
            if (cols != null && ((DynamicObject[])cols).length > 0) {
                for (DynamicObject dynamicObject : cols) {
                    dynamicObject.set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXECUTED.index));
                    dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                    dynamicObject.set(MODIFIER, (Object)RequestContext.get().getUserId());
                }
                SaveServiceHelper.save((DynamicObject[])cols);
            }
            if (this._ctx.getGroup() != 0L) {
                QFilter qFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId()).and("group", "=", (Object)this._ctx.getGroup());
                Object[] record = BusinessDataServiceHelper.load((String)"bcm_collectrecord", (String)"model, count, remainder, createtime, endtime, group, creator.name", (QFilter[])qFilter.toArray());
                if (record.length > 0) {
                    for (DynamicObject dynamicObject : record) {
                        dynamicObject.set("endtime", (Object)new Date());
                    }
                    BusinessDataWriter.update((IDataEntityType)record[0].getDataEntityType(), (Object[])record);
                }
                if (record.length != 1) {
                    logger.error(String.format("bcm_datacollect group error groupid %d count %d", this._ctx.getGroup(), record.length));
                }
            }
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)this._ctx.getModelId());
        qfBuilder.add(SCENARIO, "=", (Object)this._ctx.getScenarioId());
        qfBuilder.add("fy", "=", (Object)this._ctx.getFyId());
        qfBuilder.add(PERIOD, "=", (Object)this._ctx.getPeriodId());
        qfBuilder.add("org", "=", (Object)this._ctx.getBaseOrgId());
        qfBuilder.add("template.id", "in", this._ctx.getAllExcuteTempIds());
        qfBuilder.add("collectstatus", "in", (Object)new char[]{DataCollectRecordEnum.EXCUTING.index, DataCollectRecordEnum.READY.index});
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)"bcm_datacollect", (String)"collectstatus,modifydate,modifier", (QFilter[])qfBuilder.toArray());
        if (cols != null && cols.length > 0) {
            for (DynamicObject dynamicObject : cols) {
                dynamicObject.set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXECUTED.index));
                dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                dynamicObject.set(MODIFIER, (Object)RequestContext.get().getUserId());
            }
            SaveServiceHelper.save((DynamicObject[])cols);
        }
        if (this._ctx.getGroup() != 0L) {
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId()).and("group", "=", (Object)this._ctx.getGroup());
            Object[] record = BusinessDataServiceHelper.load((String)"bcm_collectrecord", (String)"model, count, remainder, createtime, endtime, group, creator.name", (QFilter[])qFilter.toArray());
            if (record.length > 0) {
                for (DynamicObject dynamicObject : record) {
                    dynamicObject.set("endtime", (Object)new Date());
                }
                BusinessDataWriter.update((IDataEntityType)record[0].getDataEntityType(), (Object[])record);
            }
            if (record.length != 1) {
                logger.error(String.format("bcm_datacollect group error groupid %d count %d", this._ctx.getGroup(), record.length));
            }
        }
    }

    private void markComplete(long tmpId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)this._ctx.getModelId());
        qfBuilder.add(SCENARIO, "=", (Object)this._ctx.getScenarioId());
        qfBuilder.add("fy", "=", (Object)this._ctx.getFyId());
        qfBuilder.add(PERIOD, "=", (Object)this._ctx.getPeriodId());
        qfBuilder.add("org", "=", (Object)this._ctx.getBaseOrgId());
        qfBuilder.add("template.id", "=", (Object)tmpId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_datacollect", (String)"collectstatus,modifydate,modifier,startdate", (QFilter[])qfBuilder.toArray());
        dynamicObject.set("collectstatus", (Object)Character.valueOf(DataCollectRecordEnum.EXECUTED.index));
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void calculateOtherFormula(long tmpId, int accountreclass, List<AbstractFormula> allformulas, String currency, Sheet sheet) {
        ICalContext ctx = this.getCalCtx(accountreclass, tmpId, currency);
        ctx.setExternalDataProvider(new SheetDataProvider(sheet));
        ctx.setProperty("isDistinguish0AndNull", this.iSDistZeroAndNull);
        CalculateService service = new CalculateService(ctx);
        service.setOpenTrace(this.isOpenTrace);
        HashMap<String, String> dim2Number = new HashMap<String, String>();
        SpecialCalLogic.fixVFormulaHandle(ctx, this.dimNumMap, dim2Number);
        Map<Long, Map<String, String>> ctxmap = this.getTmpMemberMap();
        AtomicInteger success = new AtomicInteger();
        IDNumberTreeNode truePeriod = MemberReader.findPeriodMemberById((String)ctx.getCubeNumber(), (Long)this._ctx.getPeriodId());
        service.setIgnoreError(this.isStringCheck);
        List<Object> logs = new ArrayList(this.INIT_TEN);
        List<Object> tipLogs = new ArrayList(this.INIT_TEN);
        for (AbstractFormula f : allformulas) {
            f.setMsg(null);
            if (!(f instanceof AcctJudgeFormula)) continue;
            String forstr = f.getFormulaStr();
            if (this.isStringCheck) {
                f.setMsg(null);
            }
            if (!StringUtils.isEmpty((String)f.getMsg())) continue;
            Map<String, String> c = ctxmap.get(f.getTempleId());
            dim2Number.clear();
            if (c != null && f.getRowcolMemNum().length == f.getRowcols().length) {
                for (int i = 0; i < f.getRowcols().length; ++i) {
                    c.put(f.getRowcols()[i].toLowerCase(Locale.ENGLISH), f.getRowcolMemNum()[i]);
                }
                dim2Number.putAll(c);
            }
            ((AcctJudgeFormula)f).setResultStatus(service.addCalculateExpress(forstr));
            this._ctx.getComMemMaps().get(f.getTempleId()).put("Period", truePeriod.getNumber());
        }
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: begin batchCalculate", ctx.getOrg(), tmpId));
        service.batchCalculate();
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: end batchCalculate", ctx.getOrg(), tmpId));
        AntlrParser formalParser = new AntlrParser(service.getCalculateEngine().getBigfel());
        Map<String, String> comMemMap = this._ctx.getComMemMaps().get(tmpId);
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers(ctx.getCubeNumber()));
        boolean myCompanyInPage = false;
        boolean isMyCompanyInPage = false;
        if (this.isAutoConventMyCompany && comMemMap.containsKey(DimTypesEnum.MYCOMPANY.getNumber())) {
            myCompanyInPage = true;
            isMyCompanyInPage = "MyCompany".equals(comMemMap.get(DimTypesEnum.MYCOMPANY.getNumber()));
        }
        Map<String, DataTypeAcctCacheInfo> cachemap = this._ctx.getCachemap();
        Map<String, String> logMsgMap = service.getLogMsg();
        List<Object> logMsgs = new ArrayList(this.INIT_TEN);
        boolean logLevel = !logMsgMap.isEmpty() && this.errorLogLevel;
        for (AbstractFormula f : allformulas) {
            if (!(f instanceof AcctJudgeFormula) || !StringUtils.isEmpty((String)f.getMsg())) continue;
            ExpressStatus resultStatus = ((AcctJudgeFormula)f).getResultStatus();
            FelNode accts = formalParser.parse(resultStatus.getParseExpr());
            if (logLevel) {
                String logStr = logMsgMap.get(accts.toString());
                if (StringUtils.isNotEmpty((String)logStr)) {
                    logMsgs.add(this.getLog(f.getFormulaStr(), logStr, f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), f.getCellID()));
                } else if (CollectionUtils.isNotEmpty(resultStatus.getChildParseExpr()) && resultStatus.getChildParseExpr().size() > 1) {
                    for (String childExpr : ((AcctJudgeFormula)f).getResultStatus().getChildParseExpr()) {
                        String childLog = logMsgMap.get(childExpr);
                        if (!StringUtils.isNotEmpty((String)childLog)) continue;
                        logMsgs.add(this.getLog(f.getFormulaStr(), childLog, f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), f.getCellID()));
                        break;
                    }
                }
            }
            Object result = f.getResult();
            f.setMsg(null);
            if (this.isStringCheck) {
                StringBuffer sb = new StringBuffer();
                ExpressStatus ex = ((AcctJudgeFormula)f).getResultStatus();
                if (ex.getException() == null) {
                    try {
                        FormarResultServiceHelper.weakCheckFormar(accts, service, sb);
                        f.setMsg(sb.toString());
                        sb.setLength(0);
                    }
                    catch (Exception e) {
                        f.setMsg(e.getMessage());
                        logger.error("parse formal error:\n" + e);
                    }
                }
            }
            Object res = service.evalExpress(((AcctJudgeFormula)f).getResultStatus());
            DataTraceFrom dc = service.getFormulaForTrace(((AcctJudgeFormula)f).getResultStatus());
            if ((!myCompanyInPage || this.isAutoConventMyCompany && myCompanyInPage) && !(res instanceof Exception)) {
                OrgDataCollectService.dealFormulaMyCompany((Table<String, String, String>)assoMembs, myCompanyInPage, isMyCompanyInPage, f, this._ctx.getOrg());
            }
            if (res instanceof Number) {
                double value = ((Number)service.evalExpress(((AcctJudgeFormula)f).getResultStatus())).doubleValue();
                if (!this.iSDistZeroAndNull && value == 0.0) {
                    f.setResult(null);
                } else {
                    f.setResult(value);
                }
                result = value;
                if (StringUtils.isNotEmpty((String)f.getMsg())) {
                    logs.add(this.getLog(f));
                } else {
                    success.getAndIncrement();
                }
                f.setMsg(null);
                this.saveOneSpread(f);
                this.traceFormula(f, tmpId, dc);
            } else if (res instanceof Exception) {
                String msg = DataCollectUtil.getErrorMsg((Exception)res);
                f.setMsg(msg);
                this.collectExceptionLogs(logs, tipLogs, f, res);
            } else if (res == null) {
                if (this.iSDistZeroAndNull) {
                    f.setMsg(null);
                    f.setResult(null);
                    this.saveOneSpread(f);
                    this.traceFormula(f, tmpId, dc);
                } else {
                    f.setMsg(ResManager.loadKDString((String)"\u53d6\u503c\u4e3a\u7a7a\u3002", (String)"OrgDataCollectService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    logs.add(this.getLog(f));
                }
            } else {
                String value = service.evalExpress(((AcctJudgeFormula)f).getResultStatus()).toString();
                if (this._ctx.isHasDim()) {
                    HashMap<String, String> rowColMems = new HashMap<String, String>(this.INIT_TEN);
                    rowColMems.putAll(comMemMap);
                    for (int i = 0; i < f.getRowcols().length; ++i) {
                        rowColMems.put(f.getRowcols()[i], f.getRowcolMemNum()[i]);
                    }
                    DataTypeEnum typeEnum = CellDataTypeUtil.getCellDataType(this._ctx.getModelId(), rowColMems, cachemap);
                    if (DataTypeEnum.DEFAULT == typeEnum || DataTypeEnum.UNCURRENCY == typeEnum || DataTypeEnum.CURRENCY == typeEnum) {
                        logs.add(this.getLog(f.getFormulaStr(), String.format(ResManager.loadKDString((String)"%s\u7684\u53d6\u503c\u4e0e\u5355\u5143\u683c\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"OrgDataCollectService_10", (String)"fi-bcm-business", (Object[])new Object[0]), value), f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), f.getCellID()));
                        continue;
                    }
                }
                result = value;
                f.setMsg(null);
                DataCollectServiceHelper.saveSpreadData(f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), (Object)value, f.getOrgMemberNum(), this._ctx, this.dcsize);
                this.traceFormula(f, tmpId, dc);
                success.getAndIncrement();
            }
            if (this._ctx.isHasDim()) continue;
            this._ctx.getResult().put(f.getFormulaStr(), result);
        }
        this._ctx.setCachemap(cachemap);
        if (!logs.isEmpty()) {
            this.failacctSum += logs.size();
            logs = logs.stream().limit(this.batchlogsize).collect(Collectors.toList());
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logs.get(0)).getDynamicObjectType(), (Object[])logs.toArray());
        }
        if (!tipLogs.isEmpty()) {
            this.tipLogSum += tipLogs.size();
            tipLogs = tipLogs.stream().limit(this.batchlogsize).collect(Collectors.toList());
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)tipLogs.get(0)).getDynamicObjectType(), (Object[])tipLogs.toArray());
        }
        if (!logMsgs.isEmpty()) {
            logMsgs = logMsgs.stream().limit(this.batchlogsize).collect(Collectors.toList());
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logMsgs.get(0)).getDynamicObjectType(), (Object[])logMsgs.toArray());
        }
        this.successacctSum.set(this.successacctSum.get() + success.get());
    }

    private static String getRedirectMyCompany(Table<String, String, String> assoMembs, AbstractFormula f, String orgNum) {
        String redirectMyCompany = "MyCompany";
        if (PositionInfo.MyCompanyAutoConvent.NO.getIndex() == f.getAutoConvent()) {
            redirectMyCompany = assoMembs.contains((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") ? (String)assoMembs.get((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") : "MyCompany";
        } else if (PositionInfo.MyCompanyAutoConvent.MCNONE.getIndex() == f.getAutoConvent()) {
            redirectMyCompany = "MCNone";
        } else if (PositionInfo.MyCompanyAutoConvent.ECUR.getIndex() == f.getAutoConvent()) {
            redirectMyCompany = orgNum;
        }
        if ("$Cur".equals(redirectMyCompany)) {
            redirectMyCompany = "MyCompany";
        }
        return redirectMyCompany;
    }

    private ICalContext getCalCtx(int accountreclass, long tmpId, String currency) {
        if (tmpId != 0L) {
            currency = this._ctx.getCurrency(tmpId);
        }
        CalContext ctx = new CalContext(this._ctx.getModelNum(), this._ctx.getOrg(), this._ctx.getFyNum(), this._ctx.getPeriodNum(), this._ctx.getScenariodNum(), currency);
        ctx.setProperty("accountreclass", accountreclass);
        ctx.setProperty("orgpnumber", MemberReader.findEntityMemberById((String)this._ctx.getModelNum(), (Long)this._ctx.getOrgId()).getParent().getNumber());
        if (this._ctx.isIgnoreError()) {
            ctx.setProperty("rptignorerror", true);
        }
        ctx.setProperty("orgId", LongUtil.toLong((Object)this._ctx.getOrgId()));
        ctx.setProperty("dcsize", this.dcsize);
        ctx.setProperty("cellCal", !ConfigServiceHelper.getBoolParam(this._ctx.getModelNum(), "cellCal"));
        ctx.setProperty("calErrorLogLevel", this.errorLogLevel);
        if (tmpId != 1L) {
            TemplateModel template = TemplateServiceHelper.getTemplateModelById(tmpId);
            ctx.setProperty(TEMPLATE, template.getNumber());
            ctx.setProperty("templateId", tmpId);
            ctx.setProperty(DimTypesEnum.PROCESS.getShortNumber(), this._ctx.getComMemMaps().get(tmpId).get("Process"));
        }
        ctx.setProperty(DimTypesEnum.PROCESS.getShortNumber(), this._ctx.getComMemMaps().get(tmpId).get("Process"));
        ctx.setProperty("noPermOrgs", this._ctx.getNoPermOrgs());
        ctx.setProperty("rateOrgs", this._ctx.getRateOgrs());
        return ctx;
    }

    private void traceFormula(AbstractFormula f, long temId, DataTraceFrom dc) {
        if (!this.isOpenTrace || dc == null) {
            return;
        }
        SaveCommandInfo info = this._ctx.getTemCmdInfos().get(temId);
        HashMap<String, String> mems = new HashMap<String, String>(f.getRowcols().length);
        info.getFixedDimensions().forEach(fix -> mems.put(fix.getName(), fix.getValue()));
        String originalOrg = null;
        for (int i = 0; i < f.getRowcols().length; ++i) {
            mems.put(f.getRowcols()[i], f.getRowcolMemNum()[i]);
            if (!f.getRowcols()[i].equals(DimTypesEnum.ENTITY.getNumber())) continue;
            originalOrg = f.getRowcolMemNum()[i];
        }
        if (CurrencyTool.isTransCurrency((String)mems.get(DimTypesEnum.CURRENCY.getNumber()))) {
            Pair<String, String> p = TransMemberUtil.transOrgAndCurbyOrgId(this._ctx.getModelId(), this._ctx.getOrgId(), (String)mems.get(DimTypesEnum.PROCESS.getNumber()), (String)mems.get(DimTypesEnum.CURRENCY.getNumber()), 0L, 0L);
            mems.put(DimTypesEnum.ENTITY.getNumber(), (String)p.p1);
            mems.put(DimTypesEnum.CURRENCY.getNumber(), (String)p.p2);
        }
        if (originalOrg != null) {
            mems.put(DimTypesEnum.ENTITY.getNumber(), originalOrg);
        }
        this.dtfs.saveCellDataTemp(mems, dc, 1);
    }

    private Map<Long, Map<String, String>> getTmpMemberMap() {
        HashMap<Long, Map<String, String>> allmap = new HashMap<Long, Map<String, String>>(this._ctx.getComMemMaps().size());
        for (Map.Entry<Long, Map<String, String>> mp : this._ctx.getComMemMaps().entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(mp.getValue().size());
            for (Map.Entry<String, String> m : mp.getValue().entrySet()) {
                map.put(m.getKey().toLowerCase(Locale.ENGLISH), m.getValue());
            }
            allmap.put(mp.getKey(), map);
        }
        return allmap;
    }

    private void calculateGroupByOrg() {
        if (this._ctx.isWithoutTmp()) {
            this.caculateWithoutTmp();
        } else {
            Pair<List<DynamicObject>, List<DynamicObject>> logPair;
            boolean openMq = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPENMQCAL.getNumber());
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)this._ctx.getModelNum(), (String)this._ctx.getOrg());
            ArrayList<Long> tmpids = new ArrayList<Long>(this._ctx.getComMemMaps().keySet());
            this.checkModel(orgNode, tmpids);
            ArrayList logs = new ArrayList(this.INIT_TEN);
            ArrayList tipLogs = new ArrayList(this.INIT_TEN);
            for (int i = 0; i < this.getSortTempids().size(); ++i) {
                long tmp = this.getSortTempids().get(i);
                if (!this._ctx.getAllExcuteTempIds().contains(tmp)) continue;
                logPair = this.caculateByTemplate(tmp);
                logs.addAll((Collection)logPair.p1);
                tipLogs.addAll((Collection)logPair.p2);
                if (this.getSortTempids().lastIndexOf(tmp) > i) continue;
                this.markComplete(tmp);
            }
            ArrayList<Long> openThreadTmps = new ArrayList<Long>();
            for (Long tmp : this._ctx.getAllExcuteTempIds()) {
                if (!this._ctx.isReCollect() && this._ctx.getRealselectTmp() != null && !this._ctx.getRealselectTmp().contains(tmp) || this.getSortTempids().contains(tmp)) continue;
                if (!openMq || this.isFromRpt() || this.tmpId != 0L) {
                    logPair = this.caculateByTemplate(tmp);
                    logs.addAll((Collection)logPair.p1);
                    tipLogs.addAll((Collection)logPair.p2);
                    this.markComplete(tmp);
                    continue;
                }
                openThreadTmps.add(tmp);
            }
            if (!logs.isEmpty()) {
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)logs.get(0)).getDynamicObjectType(), (Object[])logs.toArray());
                this.failacctSum += logs.size();
            }
            if (!tipLogs.isEmpty()) {
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)tipLogs.get(0)).getDynamicObjectType(), (Object[])tipLogs.toArray());
                this.tipLogSum += tipLogs.size();
            }
            if (!openThreadTmps.isEmpty()) {
                try {
                    CountDownLatch latch = new CountDownLatch(openThreadTmps.size());
                    for (Long tmp : openThreadTmps) {
                        ThreadPoolService.runDataCollectThread(() -> {
                            try {
                                OrgDataCollectService ocs = new OrgDataCollectService(this.getTmpCtx(tmp));
                                ocs.setTmpId(tmp);
                                ocs.excute();
                            }
                            catch (Exception e) {
                                throw new KDBizException(tmp + "datacollect error");
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                    }
                    latch.await();
                }
                catch (Exception e) {
                    throw new KDBizException("datacollect error");
                }
            }
        }
    }

    private OrgDCContext getTmpCtx(long tmpId) {
        OrgDCContext dct = new OrgDCContext(SimpleItem.newOne(this._ctx.getModelId(), this._ctx.getModelNum()), SimpleItem.newOne(this._ctx.getScenarioId(), this._ctx.getScenariodNum()), SimpleItem.newOne(this._ctx.getFyId(), this._ctx.getFyNum()), SimpleItem.newOne(this._ctx.getPeriodId(), this._ctx.getPeriodNum()), SimpleItem.newOne(this._ctx.getOrgId(), this._ctx.getOrg()));
        dct.setBaseOrgId(this._ctx.getBaseOrgId());
        dct.setWithoutTmp(false);
        dct.setSort(false);
        dct.setReCollect(true);
        dct.setHasDim(this._ctx.isHasDim());
        dct.setAllExcuteTempIds(Collections.singletonList(tmpId));
        dct.setRealselectTmp(Collections.singleton(tmpId));
        dct.setGroup(this._ctx.getGroup());
        dct.setCachemap(this._ctx.getCachemap());
        dct.setNoPermOrgs(this._ctx.getNoPermOrgs());
        dct.setRateOgrs(this._ctx.getRateOgrs());
        return dct;
    }

    private Pair<List<DynamicObject>, List<DynamicObject>> caculateByTemplate(Long tmp) {
        DynamicObject log;
        String json;
        boolean hasReport;
        DynamicObject orgTemplate;
        String currency;
        DynamicObject record;
        TemplateModel t;
        Pair<List<DynamicObject>, List<DynamicObject>> errorAndTip;
        ArrayList<DynamicObject> tips;
        ArrayList<DynamicObject> logs;
        block50: {
            LOGGER.startWatch();
            DataCollectUtil.setCaculateStatus(DataCollectRecordEnum.EXCUTING.index, this._ctx.getModelId(), this._ctx.getScenarioId(), this._ctx.getFyId(), this._ctx.getPeriodId(), this._ctx.getBaseOrgId(), tmp, this._ctx.getGroup());
            this.deleteDateCollectLog(tmp);
            logs = new ArrayList<DynamicObject>(this.INIT_TEN);
            tips = new ArrayList<DynamicObject>(this.INIT_TEN);
            errorAndTip = new Pair<List<DynamicObject>, List<DynamicObject>>(logs, tips);
            if (this.getUnCollectTmp().contains(tmp)) {
                DynamicObject log2 = DataCollectServiceHelper.getLog(this._ctx, ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25\uff1a\u9ed8\u8ba4\u5e01\u6216\u6298\u7b97\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u80fd\u91cd\u65b0\u6267\u884c\u53d6\u6570\u3002", (String)"OrgDataCollectService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
                log2.set("org", (Object)this._ctx.getBaseOrgId());
                logs.add(log2);
                ((List)errorAndTip.p1).addAll(logs);
                return errorAndTip;
            }
            t = TemplateServiceHelper.getTemplateModelById(tmp);
            record = this.reportMap.get(t.getId());
            currency = this.getCurrency(t);
            orgTemplate = MyTemplateUtil.getOwnOrgTemplate(t, this._ctx.getBaseOrgId());
            hasReport = true;
            if (record == null) {
                long curid = MemberReader.findCurrencyMemberByNum((String)this._ctx.getModelNum(), (String)currency).getId();
                String reportLock = BcmDLockUtil.getReportLockKey(this._ctx.getModelId(), this._ctx.getScenarioId(), this._ctx.getFyId(), this._ctx.getPeriodId(), curid, this._ctx.getBaseOrgId());
                try (DLock lock = DLock.create((String)reportLock).fastMode();){
                    if (!lock.tryLock(BcmDLockUtil.reportEntityWaitTime)) break block50;
                    try {
                        DynamicObject[] doc = this.queryRecord(tmp, currency);
                        if (doc.length == 0) {
                            hasReport = false;
                            record = this.getNewReport(this._ctx.getBaseOrgId(), t, orgTemplate);
                            if (record.getLong(CURRENCY) == 0L) {
                                record.set(CURRENCY, (Object)curid);
                            }
                            break block50;
                        }
                        if (doc.length == 1) {
                            record = doc[0];
                            break block50;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u8bb0\u5f55\u5b58\u5728\u591a\u6761\u3002", (String)"OrgDataCollectService_9", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
        String data = !hasReport && orgTemplate != null && !StringUtil.isEmptyString((String)orgTemplate.getString("data")) ? orgTemplate.getString("data") : this.getValue(record, t, "data");
        String string = json = !hasReport && orgTemplate != null && !StringUtil.isEmptyString((String)orgTemplate.getString(SPREAD_JSON)) ? orgTemplate.getString(SPREAD_JSON) : this.getValue(record, t, SPREAD_JSON);
        if (!this.isFromRpt()) {
            this.spreadManager = null;
            this.sheet = null;
        }
        if (this.spreadManager == null) {
            if (!hasReport && ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isSupportNewMytemplate") && (orgTemplate == null || StringUtils.isEmpty((String)orgTemplate.getString("data")))) {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)data);
                List<Cell> cells = SpecialCalLogic.loadMyTemplateFormulasAndLocks(this.spreadManager, this._ctx.getModelId(), t.getId(), this._ctx.getBaseOrgId(), true);
                this.sheet = this.spreadManager.getBook().getSheet(0);
                json = SpecialCalLogic.dealSpreadJson(cells, this.spreadManager.getBook().getSheet(0).getSheetName(), json);
            } else {
                this.spreadManager = JsonSerializerUtil.toSpreadManager((String)data);
                this.sheet = this.spreadManager.getBook().getSheet(0);
            }
        }
        HashMultimap tempformula = HashMultimap.create();
        IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)this._ctx.getModelNum(), (Long)this._ctx.getOrgId());
        this.leaf = entity.isLeaf();
        boolean isConInput = ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isConInput");
        boolean isConInputWithDim = ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isConInputWithOutDim");
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: begin collectFormulas", entity.getNumber(), t.getNumber()));
        if (t.isSaveByDim() && (this.leaf || isConInput && !isConInputWithDim)) {
            this.collectFormulas(t);
            for (AbstractFormula f : this.formulas) {
                tempformula.put((Object)f.getTempleId(), (Object)f);
            }
            this.formulas.clear();
        }
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: finish collectFormulas", entity.getNumber(), t.getNumber()));
        ICalContext ctx = this.getCalCtx(Integer.parseInt(t.getAccountreclass()), tmp, currency);
        DimensionMapModel dimensionMapModel = new DimensionMapModel(this._ctx.getModelId());
        String commonDimension = dimensionMapModel.getCommonDimen(this._ctx.getComMemMaps().get(tmp));
        ctx.setCommonDimension(commonDimension);
        List<ViewPointDimensionEntry> viewPointDimensionEntries = t.getViewPointDimensionEntries();
        List<PageDimensionEntry> pageDimensionEntries = t.getPageDimensionEntries();
        HashMultimap<String, String> dimMapKeyAsCommonAssist = dimensionMapModel.getDimMapKeyAsCommonAssist(viewPointDimensionEntries, pageDimensionEntries, this._ctx.getComMemMaps().get(tmp));
        if (dimMapKeyAsCommonAssist.size() > 0) {
            ctx.setProperty("commonAssistDim", dimMapKeyAsCommonAssist);
        }
        ctx.setProperty("deleteOrg", dimensionMapModel.isReplaceOrg());
        Map<String, String> dimmems = SpecialCalLogic.getDim2NumberLowCase(this._ctx, t.getId(), this._ctx.getOrg());
        HashMap<String, String> numbers = new HashMap<String, String>();
        SpecialCalLogic.fixVFormulaHandle(ctx, this.dimNumMap, numbers);
        SpecialCalLogic.replaceOrgFormula(tempformula.get((Object)tmp), this.sheet);
        ApiResponseModel checkResult = new ApiResponseModel();
        if (this.isFromRpt() && isConInputWithDim) {
            DimsReq dimsReq = this.genDimsReq(currency, this._ctx);
            checkResult = DataCollectUtils.checkCal(isConInputWithDim, t.isSaveByDim(), dimsReq);
        }
        boolean check = checkResult.isSuccess();
        ReportCalculateHelper.calculateSheet(this.sheet, ctx, cell -> this.checkCellCanCal(dimmems, (Map<String, String>)numbers, (Cell)cell, t.isSaveByDim(), isConInput, isConInputWithDim, check), errorMsg -> this.collectErrorLog(tmp, (List<DynamicObject>)logs, (List<DynamicObject>)tips, (ErrorMsg)errorMsg));
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: finish calculateSheet", entity.getNumber(), t.getNumber()));
        if (!checkResult.isSuccess()) {
            log = DataCollectServiceHelper.getLog(this._ctx, checkResult.getBackData().toString());
            log.set(TEMPLATE, (Object)tmp);
            log.set("org", (Object)this._ctx.getBaseOrgId());
            log.set("type", (Object)Character.valueOf(DataCollectLogEnum.TIP.index));
            tips.add(log);
        }
        errorAndTip = this.collectSheetToSave(tmp, t);
        ((List)errorAndTip.p1).addAll(logs);
        ((List)errorAndTip.p2).addAll(tips);
        this.collectDataTrace(tmp, this.sheet);
        if (record == null) {
            log = DataCollectServiceHelper.getLog(this._ctx, ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25\uff1a\u7f16\u5236\u8bb0\u5f55\u4e3a\u7a7a", (String)"OrgDataCollectService_19", (String)"fi-bcm-business", (Object[])new Object[0]));
            log.set("org", (Object)this._ctx.getBaseOrgId());
            ((List)errorAndTip.p1).add(log);
            return errorAndTip;
        }
        if (ReportStatusEnum.BACK.status().equals(record.getString("reportstatus"))) {
            record.set("reportstatus", (Object)"B");
        }
        FilterView filterView = this.spreadManager.getFilter();
        this.spreadManager.setFilter(null);
        record.set("data", (Object)JsonSerializerUtil.toJson((SpreadManager)this.spreadManager));
        this.spreadManager.setFilter(filterView);
        record.set(SPREAD_JSON, (Object)json);
        record.set(MODIFIER, (Object)this._ctx.getUserId());
        record.set("modifytime", (Object)TimeServiceHelper.now());
        record.set("reporttype", (Object)ReportType.NORMAL.index);
        this.reportMap.put(t.getId(), record);
        int beforeflostsus = this.successacctSum.get();
        if (this.isCalStaging && beforeflostsus > 0) {
            this.spreadManager.getBook().getSheet(0).putUserObject("cic", (Object)true);
        }
        if (tempformula.containsKey((Object)tmp) && checkResult.isSuccess()) {
            int tipSize;
            HashMap<String, Long> filterDimSetting = new HashMap(10);
            if (this.isFromRpt()) {
                for (IDimension dimension : this.spreadManager.getFilter().getFilterDomain().getDimensions()) {
                    List members = dimension.getMembers();
                    if (members.isEmpty()) continue;
                    filterDimSetting.put(dimension.getNumber(), ((IDimMember)members.get(0)).getId());
                }
            } else {
                filterDimSetting = DefaultPageDimSettingUtil.getFilterDimSetting(this._ctx.getModelId(), tmp, this._ctx.getBaseOrgId(), null);
            }
            Pair<List<AbstractFormula>, List<AbstractFormula>> errorAndTips = this.anayFloatAndCaculateFormula(tmp, Integer.parseInt(t.getAccountreclass()), tempformula.get((Object)tmp), currency, this.sheet, filterDimSetting);
            int errorSize = ((List)errorAndTips.p1).size();
            if (errorSize > 0) {
                this.saveLog((List)errorAndTips.p1);
            }
            if ((tipSize = ((List)errorAndTips.p2).size()) > 0) {
                this.saveTipLog((List)errorAndTips.p2);
            }
            if (this.successacctSum.get() == 0 && errorSize == 0 && tipSize == 0) {
                this.successacctSum.addAndGet(tempformula.get((Object)tmp).size());
            }
            LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: finish anayFloatAndCaculateFormula", entity.getNumber(), t.getNumber()));
        }
        if (!this.isCalStaging) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        } else if (this.successacctSum.get() > beforeflostsus) {
            record.set("data", null);
            record.set(SPREAD_JSON, null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            this.spreadManager.getBook().getSheet(0).putUserObject("cri", (Object)record.getLong("id"));
        }
        if (t.isSaveByDim() && checkResult.isSuccess() && this._ctx.getTemCmdInfos().containsKey(t.getId())) {
            SaveCommandInfo info = this._ctx.getTemCmdInfos().get(t.getId());
            String bpNum = null;
            for (FixedDimension ff : info.getFixedDimensions()) {
                if (!DimTypesEnum.PROCESS.getNumber().equals(ff.getName())) continue;
                bpNum = ff.getValue();
            }
            if (bpNum != null) {
                for (int i = 0; i < info.getFixedDimensions().size(); ++i) {
                    FixedDimension ff = (FixedDimension)info.getFixedDimensions().get(i);
                    if (!DimTypesEnum.CURRENCY.getNumber().equals(ff.getName()) || !"DC".equals(ff.getValue())) continue;
                    info.getFixedDimensions().remove(ff);
                    Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getCubeNumber(), this._ctx.getOrgId(), bpNum, "DC", this._ctx.getFyId(), this._ctx.getPeriodId());
                    info.addfixedDimension(new String[]{DimTypesEnum.CURRENCY.getNumber(), (String)msg.p2});
                }
            }
            if (this._ctx.getTemCellSets().get(t.getId()) != null) {
                OlapServiceHelper.saveData(info, this._ctx.getTemCellSets().remove(t.getId()), this._ctx.getModelNum());
            }
            this.dtfs.saveCellDataPremanent();
            if (!this.isFromRpt()) {
                this.excuteBizRules(currency, t.getId());
            }
        }
        LOGGER.infoEnd(String.format("bcm_calculateByTemplate %s entity's template %s: end calculateByTemplate", this._ctx.getOrg(), this.tmpId));
        return errorAndTip;
    }

    private void collectErrorLog(Long tmp, List<DynamicObject> logs, List<DynamicObject> tips, ErrorMsg errorMsg) {
        DynamicObject log = DataCollectServiceHelper.getLog(this._ctx, errorMsg.getError());
        log.set("dims", (Object)errorMsg.getDims());
        log.set(DATA_FROM, (Object)errorMsg.getFormula());
        log.set(TEMPLATE, (Object)tmp);
        log.set("org", (Object)this._ctx.getBaseOrgId());
        log.set("cellid", (Object)errorMsg.getCellid());
        if (errorMsg.getType() != '\u0000') {
            log.set("type", (Object)Character.valueOf(errorMsg.getType()));
            tips.add(log);
        } else {
            logs.add(log);
        }
    }

    private String getCurrency(TemplateModel t) {
        String currency = null;
        if (this._ctx.getComMemMaps().get(t.getId()) != null) {
            currency = this._ctx.getComMemMaps().get(t.getId()).get(DimTypesEnum.CURRENCY.getNumber());
        }
        if (StringUtils.isEmpty(currency) || "EC".equals(currency)) {
            currency = this._ctx.getEc();
        }
        if ("DC".equals(currency)) {
            Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(this._ctx.getModelNum(), this._ctx.getOrgId(), "EIRpt", "DC", this._ctx.getFyId(), this._ctx.getPeriodId());
            currency = (String)msg.p2;
        }
        return currency;
    }

    private DimsReq genDimsReq(String currency, OrgDCContext ctx) {
        String audit;
        if (this.spreadManager == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u578b\u6709\u95ee\u9898, \u8bf7\u91cd\u65b0\u53d6\u6570", (String)"OrgDataCollectService_18", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map userDefines = MemberReader.getUsetDefineDimNumberMapNameById((long)ctx.getModelId());
        HashMap<String, String> userDefinedDim2mem = new HashMap<String, String>(16);
        for (DimTypesEnum[] userDefineDim : userDefines.keySet()) {
            String userDefineMem = SpreadMemUtil.getMemFromFilter(this.spreadManager, (String)userDefineDim);
            if (!StringUtils.isNotEmpty((String)userDefineMem)) continue;
            userDefinedDim2mem.put((String)userDefineDim, userDefineMem);
        }
        HashMap<String, String> checkDim2mem = new HashMap<String, String>(16);
        for (DimTypesEnum checkdimtype : CHECKDIMTYPES) {
            String mem = SpreadMemUtil.getMemFromFilter(this.spreadManager, checkdimtype.getNumber());
            if (!StringUtils.isNotEmpty((String)mem)) continue;
            checkDim2mem.put(checkdimtype.getNumber(), mem);
        }
        DimsReq dimsReq = new DimsReq(ctx.getModelId(), ctx.getModelNum(), ctx.getOrgId(), ctx.getOrg(), ctx.getFyId(), ctx.getPeriodId(), ctx.getScenarioId(), currency, userDefinedDim2mem, checkDim2mem);
        String process = SpreadMemUtil.getMemFromFilter(this.spreadManager, DimTypesEnum.PROCESS.getNumber());
        if (StringUtils.isNotEmpty((String)process)) {
            dimsReq.setProcess(process);
        }
        if (StringUtils.isNotEmpty((String)(audit = SpreadMemUtil.getMemFromFilter(this.spreadManager, DimTypesEnum.AUDITTRIAL.getNumber())))) {
            dimsReq.setAudit(audit);
        }
        return dimsReq;
    }

    private DynamicObject[] queryRecord(Long tmp, String currency) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(MODEL, "=", (Object)this._ctx.getModelId());
        qfBuilder.add("scene", "=", (Object)this._ctx.getScenarioId());
        qfBuilder.add("fyear", "=", (Object)this._ctx.getFyId());
        qfBuilder.add(PERIOD, "=", (Object)this._ctx.getPeriodId());
        qfBuilder.add("currency.number", "=", (Object)currency);
        qfBuilder.add("entity", "=", (Object)this._ctx.getBaseOrgId());
        qfBuilder.add("template.id", "=", (Object)tmp);
        qfBuilder.add("reporttype", "=", (Object)ReportType.NORMAL.index);
        DynamicObject[] doc = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"template.id,currency,spreadjson,data,reportstatus,modifytime,modifier, reporttype", (QFilter[])qfBuilder.toArray());
        return doc;
    }

    private void deleteDateCollectLog(Long tmp) {
        QFilter deleteQf = new QFilter("org", "=", (Object)this._ctx.getBaseOrgId());
        deleteQf.and(TEMPLATE, "=", (Object)tmp);
        DeleteServiceHelper.delete((String)"bcm_datacollectlog", (QFilter[])deleteQf.toArray());
    }

    private void collectDataTrace(Long tmp, Sheet sheet) {
        if (this.isOpenTrace && !this.isCalStaging) {
            sheet.iteratorCells(cell -> {
                if (cell.getUserObject().containsKey((Object)"datatrace")) {
                    if (cell.isMdDataDomain()) {
                        if (cell.getUserObject("datatrace") instanceof DataTraceFrom) {
                            DataTraceFrom dc = (DataTraceFrom)cell.getUserObject("datatrace");
                            HashMap<String, String> map = new HashMap<String, String>(this._ctx.getComMemMaps().get(tmp));
                            Recorder originalOrg = new Recorder(null);
                            cell.getMemberFromUserObject().forEach(m -> {
                                map.put(m.getDimension().getNumber(), m.getNumber());
                                if (m.getDimension().getNumber().equals(DimTypesEnum.ENTITY.getNumber())) {
                                    originalOrg.setRecord((Object)m.getNumber());
                                }
                            });
                            Pair<String, String> p = TransMemberUtil.transOrgAndCurbyOrgId(this._ctx.getModelNum(), this._ctx.getOrgId(), (String)map.get(DimTypesEnum.PROCESS.getNumber()), (String)map.get(DimTypesEnum.CURRENCY.getNumber()), 0L, 0L);
                            map.put(DimTypesEnum.CURRENCY.getNumber(), (String)p.p2);
                            map.put(DimTypesEnum.ENTITY.getNumber(), (String)p.p1);
                            if (originalOrg.getRecord() != null) {
                                map.put(DimTypesEnum.ENTITY.getNumber(), (String)originalOrg.getRecord());
                            }
                            this.dtfs.saveCellDataTemp(map, dc, 1);
                        } else {
                            logger.info("OrgDataCollectService cell.get(datatrace) class: " + cell.getUserObject("datatrace").getClass() + " value: " + cell.getUserObject("datatrace").toString());
                        }
                    }
                    cell.getUserObject().remove((Object)"datatrace");
                }
            });
        }
    }

    public void collectFormulas(TemplateModel templateModel) {
        DynamicObject orgTemplate = MyTemplateUtil.getOwnOrgTemplate(templateModel, this._ctx.getBaseOrgId());
        if (orgTemplate != null) {
            SpreadManager spreadManager = null;
            if (ConfigServiceHelper.getBoolParam(this._ctx.getModelId(), "isSupportNewMytemplate") && StringUtil.isEmptyString((String)orgTemplate.getString("data"))) {
                spreadManager = JsonSerializerUtil.toSpreadManager((String)templateModel.getRptData());
                SpecialCalLogic.loadMyTemplateFormulasAndLocks(spreadManager, templateModel.getModelId(), templateModel.getId(), this._ctx.getBaseOrgId(), true);
            } else {
                String data = orgTemplate.getString("data");
                if (StringUtils.isEmpty((String)data)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u540e\u53f0\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\u3002", (String)"OrgDataCollectService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                spreadManager = JsonSerializerUtil.toSpreadManager((String)data);
            }
            this.packFormulas(AnalysisFormulaUtil.getFormulaDyo(spreadManager, templateModel.getId(), this._ctx.getCurrency(templateModel.getId()), true));
            return;
        }
        Set<String> formulaIds = IntergrationUtil.getAcctByTemplateAndOrg(Long.toString(templateModel.getId()), String.valueOf(this._ctx.getModelId()), String.valueOf(this._ctx.getBaseOrgId()));
        if (formulaIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", formulaIds);
            ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(formulaIds.size());
            String fields = "id,datafrom,template,dimkey,membkey,currency,cellid,floatarea";
            ruleList.addAll((Collection<DynamicObject>)QueryServiceHelper.query((String)"bcm_intergration_entity", (String)fields, (QFilter[])filter.toArray()));
            this.packFormulas(ruleList);
        }
        this.packFormulas(AnalysisFormulaUtil.getFormulaDyo(JsonSerializerUtil.toSpreadManager((String)templateModel.getRptData()), templateModel.getId(), this._ctx.getCurrency(templateModel.getId()), true));
    }

    public void packFormulas(List<DynamicObject> ruleList) {
        ArrayList<AbstractFormula> failformula = new ArrayList<AbstractFormula>(this.INIT_TEN);
        AccountCheckParser checkParser = new AccountCheckParser();
        Set<String> lossAndCashflowAccountSet = null;
        if (CollectionUtils.isNotEmpty(ruleList)) {
            lossAndCashflowAccountSet = OrgDataCollectService.getLossAndCashflowAccountType(this._ctx.getModelId());
            for (DynamicObject dy : ruleList) {
                String formulaStr = dy.getString(DATA_FROM);
                if (StringUtils.isEmpty((String)formulaStr)) continue;
                Long templeteId = dy.getLong(TEMPLATE);
                if (this.getUnCollectTmp() != null && this.getUnCollectTmp().contains(templeteId)) continue;
                Map<String, String> pageviewdimemberNum = this._ctx.getComMemMaps().get(templeteId);
                List<String> rowcols = Arrays.asList(dy.getString("dimkey").split("\\|"));
                List<String> rowcolMemNum = Arrays.asList(dy.getString(MEMBKEY).split("\\|"));
                String errormsg = this.checkDimMember(pageviewdimemberNum, rowcols, rowcolMemNum, lossAndCashflowAccountSet);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("fyear", this._ctx.getFyNum());
                params.put(PERIOD, this._ctx.getPeriodNum());
                params.put("orgNum", this._ctx.getOrg());
                params.put(CURRENCY, dy.getString(CURRENCY));
                this._ctx.getComMemMaps().get(templeteId).put("Year", this._ctx.getFyNum());
                this._ctx.getComMemMaps().get(templeteId).put("Period", this._ctx.getPeriodNum());
                this._ctx.getComMemMaps().get(templeteId).put("Scenario", this._ctx.getScenariodNum());
                String cyNumber = this._ctx.getCurrency(templeteId);
                if ((params.get(CURRENCY) == null || "0".equals(params.get(CURRENCY).toString())) && (cyNumber == null || cyNumber.isEmpty())) {
                    cyNumber = this._ctx.getEc();
                }
                this._ctx.getComMemMaps().get(templeteId).put("Currency", cyNumber);
                AbstractFormula formulaModel = ParseFormula.parse(formulaStr, params, checkParser);
                formulaModel.setTempleId(templeteId);
                formulaModel.setOrgMemberId(this._ctx.getBaseOrgId());
                formulaModel.setOrgMemberNum(this._ctx.getOrg());
                if (dy.get("cellid") != null) {
                    formulaModel.setCellID(dy.getInt("cellid"));
                }
                if (formulaStr.toLowerCase().startsWith("=v_data") && !formulaStr.contains(".@")) continue;
                if ("dimkey".equals(dy.getString("dimkey"))) {
                    formulaModel.setMsg(ResManager.loadKDString((String)"\u6570\u636e\u516c\u5f0f\u5b9a\u4e49\u6709\u8bef\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a\u975e\u6d6e\u52a8\u533a\u57df\u586b\u5199\u4e86\u7684\u5e26\u201c@\u201d\u7684\u516c\u5f0f\u3002", (String)"OrgDataCollectService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
                    formulaModel.setRowcols(rowcols.toArray(new String[0]));
                    formulaModel.setRowcolMemNum(rowcolMemNum.toArray(new String[0]));
                    failformula.add(formulaModel);
                    continue;
                }
                if (this._ctx.isHasDim() && StringUtils.isEmpty((String)dy.getString("dimkey"))) {
                    errormsg = ResManager.loadKDString((String)"\u53d6\u6570\u516c\u5f0f\u5b9a\u4e49\u6709\u8bef\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u53d6\u6570\u516c\u5f0f\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570\uff0c\u6d6e\u52a8\u884c\u53d6\u6570\u516c\u5f0f\u7f3a\u5c11\u6838\u7b97\u7ef4\u5ea6\u53ca\u201c@\u201d\u7b26\u53f7\u5b9a\u4e49\u3002", (String)"OrgDataCollectService_3", (String)"fi-bcm-business", (Object[])new Object[0]);
                    formulaModel.setMsg(errormsg);
                }
                if (dy.get(MEMBKEY) != null && dy.getString(MEMBKEY).contains("@")) {
                    if (!dy.getString(DATA_FROM).contains("@")) {
                        errormsg = ResManager.loadKDString((String)"\u53d6\u6570\u516c\u5f0f\u5b9a\u4e49\u6709\u8bef\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a\u6d6e\u52a8\u62a5\u8868\u586b\u5199\u4e86\u56fa\u5b9a\u516c\u5f0f\u3002", (String)"OrgDataCollectService_4", (String)"fi-bcm-business", (Object[])new Object[0]);
                        formulaModel.setMsg(errormsg);
                    } else {
                        formulaModel.setFloatarea(dy.getString("floatarea"));
                    }
                }
                formulaModel.setRowcols(rowcols.toArray(new String[0]));
                formulaModel.setRowcolMemNum(rowcolMemNum.toArray(new String[0]));
                if (StringUtils.isNotEmpty((String)errormsg)) {
                    formulaModel.setMsg(errormsg);
                    failformula.add(formulaModel);
                    continue;
                }
                this.add(formulaModel);
            }
        }
        this.saveLog(failformula);
    }

    private static Predicate startsWithAcct() {
        return e -> ((FunctionExpr)e).getFuncionName().startsWith("ACCT");
    }

    private static Predicate containParamFloatFormula() {
        List<String> canFloatFormulaNums = DataCollectUtil.getCanParamFloatFormulaNums();
        return e -> canFloatFormulaNums.contains(((FunctionExpr)e).getFuncionName().toLowerCase(Locale.ENGLISH));
    }

    private Boolean checkCellCanCal(Map<String, String> dimmems, Map<String, String> numbers, Cell cell, boolean saveByDim, boolean isConInput, boolean isConInputWithDim, boolean check) {
        if (cell.getUserObject("lockFormula") != null) {
            return false;
        }
        if (saveByDim && !this.leaf) {
            if (!isConInput && !isConInputWithDim) {
                return false;
            }
            if (isConInputWithDim && cell.isMdDataDomain()) {
                return false;
            }
        }
        if (cell.getFormula().toLowerCase().startsWith("v_data")) {
            if (this.formulaChecker.checkFormulaExits(cell.getFormula())) {
                numbers.clear();
                numbers.putAll(dimmems);
                if (cell.isMdDataDomain()) {
                    for (IDimMember mem : cell.getMemberFromUserObject()) {
                        numbers.put(mem.getDimension().getNumber().toLowerCase(Locale.ENGLISH), mem.getNumber());
                    }
                }
            }
            return !cell.getFormula().contains(".@");
        }
        if (cell.getFormula().contains("@")) {
            return false;
        }
        if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("get_dim_attr") || cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("getjlentry")) {
            return false;
        }
        for (String formula : notCollectFormula) {
            if (!cell.getFormula().trim().startsWith(formula)) continue;
            return false;
        }
        if (this.formulaChecker.checkFormulaExits(cell.getFormula())) {
            numbers.clear();
            numbers.putAll(dimmems);
            if (cell.isMdDataDomain()) {
                if (!check) {
                    return false;
                }
                for (IDimMember mem : cell.getMemberFromUserObject()) {
                    String dimNum = mem.getDimension().getNumber();
                    if (!(DimTypesEnum.YEAR.getNumber().equalsIgnoreCase(dimNum) && "CurrentYear".equalsIgnoreCase(mem.getNumber()) || !CELLDIMS.contains(dimNum) || mem.getNumber().equals(numbers.get(dimNum.toLowerCase(Locale.ENGLISH))))) {
                        return false;
                    }
                    numbers.put(mem.getDimension().getNumber().toLowerCase(Locale.ENGLISH), mem.getNumber());
                }
            }
            return true;
        }
        return false;
    }

    private Pair<List<DynamicObject>, List<DynamicObject>> collectSheetToSave(Long tmp, TemplateModel t) {
        Object pageDimension;
        ArrayList logs = new ArrayList(this.INIT_TEN);
        ArrayList tipLogs = new ArrayList(this.INIT_TEN);
        Set<String> lossAndCashflowAccountSet = OrgDataCollectService.getLossAndCashflowAccountType(this._ctx.getModelId());
        Map<String, String> comMemMap = this._ctx.getComMemMaps().get(tmp);
        Map<String, DataTypeAcctCacheInfo> cachemap = this._ctx.getCachemap();
        String cube = MemberReader.findModelNumberById((Object)t.getModelId());
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers(cube));
        boolean myCompanyInPage = false;
        String redirectMyCompany = "";
        boolean entityInPage = false;
        List<ViewPointDimensionEntry> viewDimension = t.getViewPointDimensionEntries();
        if (!viewDimension.isEmpty()) {
            for (ViewPointDimensionEntry viewPointDimensionEntry : viewDimension) {
                if (null == viewPointDimensionEntry.getDimension()) continue;
                String dimNum = viewPointDimensionEntry.getDimension().getNumber();
                if (!DimTypesEnum.ENTITY.getNumber().equals(dimNum)) continue;
                entityInPage = true;
            }
        }
        if (!entityInPage && !(pageDimension = t.getPageDimensionEntries()).isEmpty()) {
            Iterator iterator = pageDimension.iterator();
            while (iterator.hasNext()) {
                PageDimensionEntry dimEntry2 = (PageDimensionEntry)iterator.next();
                String dimNum = dimEntry2.getDimension().getNumber();
                if (!DimTypesEnum.ENTITY.getNumber().equals(dimNum)) continue;
                entityInPage = true;
            }
        }
        if (!entityInPage) {
            for (PageDimPropEntry pageDimPropEntry : t.getPagePropEntries()) {
                Dimension dimension = pageDimPropEntry.getDimension();
                if (dimension == null || !DimTypesEnum.ENTITY.getNumber().equals(dimension.getNumber())) continue;
                entityInPage = true;
            }
        }
        if (this.isAutoConventMyCompany && comMemMap.containsKey(DimTypesEnum.MYCOMPANY.getNumber())) {
            myCompanyInPage = true;
            if ("MyCompany".equals(comMemMap.get(DimTypesEnum.MYCOMPANY.getNumber()))) {
                String string = redirectMyCompany = assoMembs.contains((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") ? (String)assoMembs.get((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") : "MyCompany";
                if ("$ECur".equals(redirectMyCompany) && entityInPage) {
                    redirectMyCompany = this._ctx.getOrg();
                }
                if ("$Cur".equals(redirectMyCompany)) {
                    redirectMyCompany = "MyCompany";
                }
            }
        }
        boolean finalMyCompanyInPage = myCompanyInPage;
        String string = redirectMyCompany;
        boolean finalEntityInPage = entityInPage;
        this.sheet.iteratorCells(cell -> {
            if (cell.hasFormula()) {
                int cid = (Integer)cell.getUserObject("cid", (Object)0);
                if (cell.isMdDataDomain() && (!cell.getFormula().contains("@") || cell.getFormula().toLowerCase().startsWith("v_data") && !cell.getFormula().contains(".@")) && cell.isChangeVal()) {
                    ArrayList<String> rowcols = new ArrayList<String>();
                    ArrayList<String> rowcolMemNum = new ArrayList<String>();
                    cell.getMemberFromUserObject().forEach(m -> {
                        rowcols.add(m.getDimension().getNumber());
                        rowcolMemNum.add(m.getNumber());
                    });
                    String errormsg = this.checkDimMember(this._ctx.getComMemMaps().get(t.getId()), rowcols, rowcolMemNum, lossAndCashflowAccountSet);
                    if (StringUtils.isNotEmpty((String)errormsg)) {
                        logs.add(this.getLog(cell.getFormula(), errormsg, tmp, rowcols.toArray(new String[0]), rowcolMemNum.toArray(new String[0]), cid));
                    } else if (cell.getValue() instanceof Exception) {
                        DynamicObject log = this.getLog(cell.getFormula(), DataCollectUtil.getErrorMsg((Exception)cell.getValue()), tmp, rowcols.toArray(new String[0]), rowcolMemNum.toArray(new String[0]), cid);
                        OrgDataCollectService.collectExceptionLogs(logs, tipLogs, cell, log);
                    } else {
                        Object value = cell.getValue();
                        if (this.isAutoConventMyCompany) {
                            int myCompanyIndex;
                            if (finalMyCompanyInPage && StringUtils.isNotEmpty((String)finalRedirectMyCompany)) {
                                if (finalEntityInPage) {
                                    rowcolMemNum.add(finalRedirectMyCompany);
                                } else if ("$ECur".equals(finalRedirectMyCompany)) {
                                    int index = rowcols.indexOf(DimTypesEnum.ENTITY.getNumber());
                                    rowcolMemNum.add((String)rowcolMemNum.get(index));
                                } else {
                                    rowcolMemNum.add(finalRedirectMyCompany);
                                }
                                rowcols.add(DimTypesEnum.MYCOMPANY.getNumber());
                            }
                            if (!finalMyCompanyInPage && (myCompanyIndex = rowcols.indexOf(DimTypesEnum.MYCOMPANY.getNumber())) != -1 && "MyCompany".equals(rowcolMemNum.get(myCompanyIndex))) {
                                String rediectMyCompany;
                                String string = rediectMyCompany = assoMembs.contains((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") ? (String)assoMembs.get((Object)DimTypesEnum.MYCOMPANY.getNumber(), (Object)"MyCompany") : "MyCompany";
                                if ("$ECur".equals(rediectMyCompany)) {
                                    if (finalEntityInPage) {
                                        rediectMyCompany = this._ctx.getOrg();
                                    } else {
                                        int index = rowcols.indexOf(DimTypesEnum.ENTITY.getNumber());
                                        rediectMyCompany = (String)rowcolMemNum.get(index);
                                    }
                                }
                                if ("$Cur".equals(rediectMyCompany)) {
                                    rediectMyCompany = "MyCompany";
                                }
                                rowcolMemNum.set(myCompanyIndex, rediectMyCompany);
                            }
                        }
                        if (cell.getValue() == null || cell.getValue() instanceof Number) {
                            if (!this.iSDistZeroAndNull && cell.getValue() != null && ((Number)cell.getValue()).doubleValue() == 0.0) {
                                value = null;
                            }
                        } else {
                            DataTypeEnum typeEnum;
                            Map memberFromUserObjectDimNumbers = cell.getMemberFromUserObjectDimNumbers();
                            memberFromUserObjectDimNumbers.putAll(comMemMap);
                            int myCompanyIndex = rowcols.indexOf(DimTypesEnum.MYCOMPANY.getNumber());
                            if (myCompanyIndex != -1) {
                                memberFromUserObjectDimNumbers.put(DimTypesEnum.MYCOMPANY.getNumber(), rowcolMemNum.get(myCompanyIndex));
                            }
                            if (DataTypeEnum.DEFAULT == (typeEnum = CellDataTypeUtil.getCellDataType(t.getModelId(), memberFromUserObjectDimNumbers, cachemap)) || DataTypeEnum.UNCURRENCY == typeEnum || DataTypeEnum.CURRENCY == typeEnum) {
                                logs.add(this.getLog(cell.getFormula(), String.format(ResManager.loadKDString((String)"%s\u7684\u53d6\u503c\u4e0e\u5355\u5143\u683c\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"OrgDataCollectService_10", (String)"fi-bcm-business", (Object[])new Object[0]), cell.getValue()), tmp, ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), cid));
                                cell.setValue(null);
                                return;
                            }
                        }
                        if (!this.isCalStaging) {
                            DataCollectServiceHelper.saveSpreadData(t.getId(), rowcols.toArray(new String[0]), rowcolMemNum.toArray(new String[0]), value, this._ctx.getOrg(), this._ctx, this.dcsize);
                        } else {
                            cell.setUserObject("csv", (Object)true);
                        }
                        this.successacctSum.incrementAndGet();
                    }
                } else if (cell.getValue() instanceof Exception) {
                    DynamicObject log = this.getLog(cell.getFormula(), DataCollectUtil.getErrorMsg((Exception)cell.getValue()), tmp, ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), cid);
                    OrgDataCollectService.collectExceptionLogs(logs, tipLogs, cell, log);
                    cell.setValue(null);
                } else if (!cell.getFormula().contains("@")) {
                    this.successacctSum.incrementAndGet();
                }
                if (cell.getValue() instanceof Exception) {
                    cell.setValue(null);
                }
            }
        });
        this._ctx.setCachemap(cachemap);
        Pair errorAndtips = new Pair(logs, tipLogs);
        return errorAndtips;
    }

    private void collectExceptionLogs(List<DynamicObject> logs, List<DynamicObject> tipLogs, AbstractFormula f, Object res) {
        if (res instanceof NotificationException) {
            tipLogs.add(this.getTipLog(f));
        } else {
            logs.add(this.getLog(f));
        }
    }

    private static void collectExceptionLogs(List<DynamicObject> logs, List<DynamicObject> tipLogs, Cell cell, DynamicObject log) {
        if (cell.getValue() instanceof NotificationException) {
            log.set("type", (Object)Character.valueOf(DataCollectLogEnum.TIP.index));
            tipLogs.add(log);
        } else {
            log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
            logs.add(log);
        }
    }

    private void excuteBizRules(String cur, long tid) {
        BizRuleExecParam eiprtParam = this.getBizRuleExecParam(cur, "EIRpt");
        logger.info("Report_Refresh, EIRpt exec start");
        boolean bizRuleExcResult = BizRuleExecStarter.execBizRuleWhenSave(tid, eiprtParam, ApplicationTypeEnum.CM);
        logger.info("Report_Refresh, EIRpt exec end");
        if (bizRuleExcResult) {
            BizRuleExecParam eradjParam = this.getBizRuleExecParam(cur, "ERAdj");
            logger.info("Report_Refresh, ERAdj exec start");
            BizRuleExecStarter.execBizRuleWhenSave(tid, eradjParam, ApplicationTypeEnum.CM);
            logger.info("Report_Refresh, ERAdj exec start");
        }
    }

    private BizRuleExecParam getBizRuleExecParam(String cur, String process) {
        BizRuleExecParam p = new BizRuleExecParam(this._ctx.getModelNum());
        IDNumberTreeNode orgnode = MemberReader.findEntityMemberByNum((String)this._ctx.getModelNum(), (String)this._ctx.getOrg());
        IDNumberTreeNode curnode = MemberReader.findCurrencyMemberByNum((String)this._ctx.getModelNum(), (String)cur);
        p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, orgnode.getId(), this._ctx.getOrg());
        p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, Long.valueOf(this._ctx.getFyId()), this._ctx.getFyNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, Long.valueOf(this._ctx.getPeriodId()), this._ctx.getPeriodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, Long.valueOf(this._ctx.getScenarioId()), this._ctx.getScenariodNum());
        p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, curnode.getId(), curnode.getNumber());
        p.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findMemberByNumber((String)this._ctx.getModelNum(), (String)PresetConstant.PROCESS_DIM, (String)process).getId(), process);
        return p;
    }

    private String getValue(DynamicObject record, TemplateModel t, String field) {
        String value = record.getString(field);
        if (StringUtils.isEmpty((String)value)) {
            if (SPREAD_JSON.equals(field)) {
                value = t.getRptSpreadJson();
            } else if ("data".equals(field)) {
                value = t.getRptData();
            }
        }
        return value;
    }

    private void checkModel(IDNumberTreeNode orgNode, List<Long> tmpids) {
        if (this._ctx.getAllExcuteTempIds() == null) {
            this._ctx.setAllExcuteTempIds(tmpids);
        }
        if (this.reportMap == null) {
            this.reportMap = DataCollectServiceHelper.getReports(this._ctx, (long)orgNode.getId(), orgNode.getNumber(), this._ctx.getAllExcuteTempIds());
        }
    }

    private void caculateWithoutTmp() {
        HashMultimap orgformula = HashMultimap.create();
        for (AbstractFormula f : this.formulas) {
            orgformula.put((Object)f.getOrgMemberNum(), (Object)f);
        }
        for (String org : orgformula.keySet()) {
            String cur = null;
            if (this._ctx.getComMemMaps().containsKey(0L)) {
                cur = this._ctx.getComMemMaps().get(0L).get(DimTypesEnum.CURRENCY.getNumber());
            }
            this.calculateOtherFormula(1L, 0, Lists.newArrayList((Iterable)orgformula.get((Object)org)), cur, null);
        }
    }

    private DynamicObject getNewReport(long orgId, TemplateModel t, DynamicObject orgTemplate) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bcm_reportentity");
        record.set("fyear", (Object)this._ctx.getFyId());
        record.set(PERIOD, (Object)this._ctx.getPeriodId());
        record.set("scene", (Object)this._ctx.getScenarioId());
        record.set(CURRENCY, (Object)this._ctx.getCurrencyId(t.getId()));
        record.set("entity", (Object)orgId);
        record.set(MODEL, (Object)this._ctx.getModelId());
        record.set(TEMPLATE, (Object)t.getId());
        record.set(MODIFIER, (Object)RequestContext.get().getUserId());
        record.set("modifytime", (Object)TimeServiceHelper.now());
        record.set("creator", (Object)RequestContext.get().getUserId());
        record.set("createtime", (Object)TimeServiceHelper.now());
        record.set("reportstatus", (Object)ReportStatusEnum.WEAVING.status());
        String data = orgTemplate != null && !StringUtil.isEmptyString((String)orgTemplate.getString("data")) ? orgTemplate.getString("data") : this.getValue(record, t, "data");
        record.set("data", (Object)data);
        Object[] save = BusinessDataWriter.save((IDataEntityType)record.getDataEntityType(), (Object[])new Object[]{record});
        this.reportMap.put(t.getId(), (DynamicObject)save[0]);
        return (DynamicObject)save[0];
    }

    private DynamicObject getTipLog(AbstractFormula f) {
        DynamicObject log = this.getLog(f.getFormulaStr(), f.getMsg(), f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), f.getCellID());
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.TIP.index));
        return log;
    }

    private DynamicObject getLog(AbstractFormula f) {
        return this.getLog(f.getFormulaStr(), f.getMsg(), f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), f.getCellID());
    }

    private DynamicObject getLog(String formula, String error, long tmpId, String point, int cellid) {
        DynamicObject log = this.packLog(formula, error, tmpId, cellid);
        log.set("dims", (Object)point);
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        return log;
    }

    private DynamicObject getLog(String formula, String error, long tmpId, String[] rowcols, String[] rowcolMemNum, int cellid) {
        return this.getLog(formula, error, tmpId, rowcols, rowcolMemNum, cellid, DataCollectLogEnum.ERROR.index);
    }

    private DynamicObject getTipLog(String formula, String tip, long tmpId, String[] rowcols, String[] rowcolMemNum, int cellid) {
        return this.getLog(formula, tip, tmpId, rowcols, rowcolMemNum, cellid, DataCollectLogEnum.TIP.index);
    }

    private DynamicObject getLog(String formula, String error, long tmpId, String[] rowcols, String[] rowcolMemNum, int cellid, char type) {
        DynamicObject log = this.packLog(formula, error, tmpId, cellid);
        StringBuilder dims = new StringBuilder(this.getDimensionText(tmpId, this._ctx.getOrg()));
        if (rowcolMemNum.length != rowcols.length) {
            return log;
        }
        for (int i = 0; i < rowcols.length; ++i) {
            dims.append(',').append(DimTypesEnum.getShortNumberByNumber((String)rowcols[i])).append(':').append(rowcolMemNum[i]);
        }
        log.set("dims", (Object)dims.toString());
        log.set("type", (Object)Character.valueOf(type));
        return log;
    }

    private DynamicObject packLog(String formula, String error, long tmpId, int cellid) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectlog");
        log.set(MODEL, (Object)this._ctx.getModelId());
        log.set("collecttime", (Object)this.collectTime);
        log.set("collector", (Object)this._ctx.getUserId());
        log.set("fy", (Object)this._ctx.getFyId());
        log.set(PERIOD, (Object)this._ctx.getPeriodId());
        log.set(SCENARIO, (Object)this._ctx.getScenarioId());
        if (StringUtils.isNotEmpty((String)error)) {
            log.set(ERROR, (Object)(error.length() > 2000 ? error.substring(0, 2000) : error));
        }
        log.set(DATA_FROM, (Object)formula);
        log.set(TEMPLATE, (Object)tmpId);
        log.set("org", (Object)this._ctx.getBaseOrgId());
        log.set("cellid", (Object)cellid);
        log.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        log.set("logtype", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType());
        return log;
    }

    private void saveOneSpread(AbstractFormula f) {
        try {
            if (StringUtils.isEmpty((String)f.getMsg())) {
                DataCollectServiceHelper.saveSpreadData(f.getTempleId(), f.getRowcols(), f.getRowcolMemNum(), (Object)f.getResult(), f.getOrgMemberNum(), this._ctx, this.dcsize);
            }
        }
        catch (Exception e) {
            f.setMsg(ResManager.loadKDString((String)"\u5b58\u5165\u62a5\u8868\u5931\u8d25", (String)"OrgDataCollectService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public void saveLog(List<AbstractFormula> formulas) {
        ArrayList logs = new ArrayList();
        formulas.forEach(f -> logs.add(this.getLog((AbstractFormula)f)));
        if (!logs.isEmpty()) {
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logs.get(0)).getDynamicObjectType(), (Object[])logs.toArray());
        }
        this.failacctSum += formulas.size();
    }

    public int getFailacctSum() {
        return this.failacctSum;
    }

    public int getSuccessacctSum() {
        return this.successacctSum.get();
    }

    public List<AbstractFormula> getFormulas() {
        return this.formulas;
    }

    public static void analyNotAcctFormula(BatchFormulaList acctFloatList, AbstractFormula formula, Map<String, Set<String>> dimToMembs) {
        if (dimToMembs.size() == 1) {
            for (Map.Entry<String, Set<String>> entry : dimToMembs.entrySet()) {
                for (String floatMember : entry.getValue()) {
                    String datafrom = formula.getFormulaStr();
                    datafrom = datafrom.replaceAll("@", floatMember);
                    String membkey = Joiner.on((String)"|").join((Object[])formula.getRowcolMemNum());
                    membkey = membkey.replaceAll("@", floatMember);
                    AbstractFormula dy = OrgDataCollectService.getFloatFormula(formula, datafrom, membkey);
                    acctFloatList.add(dy);
                }
            }
        }
    }

    public static void analyParamFloatFormula(List<String> dims, Map<String, Set<String>> dim2mems, Map<String, List<String>> dim2params, AbstractFormula formula, int layer, BatchFormulaList resultFormulas, List<AbstractFormula> logs) {
        String dim;
        List<String> params;
        int dimSize = dims.size();
        if (layer == dimSize) {
            return;
        }
        String formulaStr = formula.getFormulaStr();
        int paramIndex = OrgDataCollectService.getParamIndex(formula, logs, formulaStr, params = dim2params.get(dim = dims.get(layer)));
        if (paramIndex == -1) {
            return;
        }
        String param = params.get(paramIndex);
        String regex = param + "\\|@";
        String[] rowcolMemNum = formula.getRowcolMemNum();
        List<String> rowcols = Arrays.asList(formula.getRowcols());
        int index = rowcols.indexOf(dim);
        int layerIndex = dimSize - 1;
        for (String mem : dim2mems.get(dim)) {
            String tmpFormula = formulaStr.replaceAll(regex, param + "|" + mem);
            String[] cloneRowColMem = (String[])rowcolMemNum.clone();
            cloneRowColMem[index] = mem;
            AbstractFormula newFormula = OrgDataCollectService.getFloatFormula(formula, tmpFormula, cloneRowColMem);
            if (layer == layerIndex) {
                resultFormulas.add(newFormula);
                continue;
            }
            OrgDataCollectService.analyParamFloatFormula(dims, dim2mems, dim2params, newFormula, layer + 1, resultFormulas, logs);
        }
    }

    private static int getParamIndex(AbstractFormula formula, List<AbstractFormula> logs, String formulaStr, List<String> params) {
        if (CollectionUtils.isEmpty(params)) {
            return OrgDataCollectService.returnErrorIndex(formula, logs, ResManager.loadKDString((String)"\u53c2\u6570\u7f3a\u5c11\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"OrgDataCollectService_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            if (!formulaStr.contains(param + "|@")) continue;
            return i;
        }
        if (formulaStr.contains("@")) {
            return OrgDataCollectService.returnErrorIndex(formula, logs, ResManager.loadKDString((String)"\u53c2\u6570\u7f3a\u5c11\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"OrgDataCollectService_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return OrgDataCollectService.returnErrorIndex(formula, logs, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f3a\u5c11\u53c2\u6570\u6620\u5c04\u3002", (String)"OrgDataCollectService_16", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static int returnErrorIndex(AbstractFormula formula, List<AbstractFormula> logs, String msg) {
        AbstractFormula logDy = OrgDataCollectService.genFormulaLog(formula, formula.getFormulaStr(), msg);
        logs.add(logDy);
        return -1;
    }

    private static void functionTypeCheck(String formula, AtomicBoolean isCheck, Predicate predicate) {
        Expression exp = null;
        try {
            exp = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        AnalysisFormulaUtil.functionTypeCheckByExpression(exp, isCheck, predicate);
    }

    public static AbstractFormula getFloatFormula(AbstractFormula baseFormula, String datafrom, String membkey) {
        AbstractFormula formulaModel = OrgDataCollectService.genFormula(baseFormula, datafrom);
        formulaModel.setRowcolMemNum(membkey.split("\\|"));
        return formulaModel;
    }

    public static AbstractFormula getFloatFormula(AbstractFormula baseFormula, String datafrom, String[] cloneRowColMem) {
        AbstractFormula formulaModel = OrgDataCollectService.genFormula(baseFormula, datafrom);
        formulaModel.setRowcolMemNum(cloneRowColMem);
        return formulaModel;
    }

    private static AbstractFormula genFormula(AbstractFormula baseFormula, String datafrom) {
        AbstractFormula formulaModel = ParseFormula.parse(datafrom, baseFormula.getParams(), new AccountCheckParser());
        formulaModel.setTempleId(baseFormula.getTempleId());
        formulaModel.setOrgMemberId(baseFormula.getOrgMemberId());
        formulaModel.setOrgMemberNum(baseFormula.getOrgMemberNum());
        formulaModel.setRowcols(baseFormula.getRowcols());
        formulaModel.setCellID(baseFormula.getCellID());
        formulaModel.setCellID(baseFormula.getCellID());
        formulaModel.setAutoConvent(baseFormula.getAutoConvent());
        return formulaModel;
    }

    private Pair<List<AbstractFormula>, List<AbstractFormula>> anayFloatAndCaculateFormula(long tmp, int accountreclass, Collection<AbstractFormula> allformulas, String currency, Sheet sheet, Map<String, Long> filterDimSetting) {
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: begin anayFloatAndCaculateFormula", this._ctx.getOrg(), tmp));
        ArrayList<AbstractFormula> allFloatFormulas = new ArrayList<AbstractFormula>(allformulas);
        ArrayList formulaByoldVersion = new ArrayList(16);
        ArrayList<AbstractFormula> formulaByNewBatchAcct = new ArrayList<AbstractFormula>(16);
        DimensionMapModel dimensionMapModel = new DimensionMapModel(this._ctx.getModelId());
        Map<String, String> glDimToBcmDim = dimensionMapModel.getDimMapKeyAsOther();
        HashMap formulaArea2AutoConvent = new HashMap(16);
        allformulas.forEach(f -> {
            String floatarea = f.getFloatarea();
            if (StringUtils.isNotEmpty((String)floatarea)) {
                BasePointInfo base = null;
                PositionInfo position = null;
                if (f.getFormulaStr().contains("@")) {
                    this.setMyCompanyAutoConvent2formula(formulaArea2AutoConvent, (AbstractFormula)f, floatarea, base, position);
                    this.groupFloatFormula(formulaByoldVersion, (List<AbstractFormula>)allFloatFormulas, (List<AbstractFormula>)formulaByNewBatchAcct, (AbstractFormula)f);
                }
            }
        });
        if (formulaByNewBatchAcct.size() > 0) {
            this.collectFloatCal(tmp, accountreclass, currency, formulaByNewBatchAcct, glDimToBcmDim, filterDimSetting);
        }
        BatchFormulaList acctFloatList = new BatchFormulaList(tmp, accountreclass, currency, sheet);
        ArrayList logs = new ArrayList(16);
        ArrayList tipLogs = new ArrayList(16);
        Map<String, List<AbstractFormula>> formulaByFloatArea = formulaByoldVersion.stream().collect(Collectors.groupingBy(formula -> formula.getFloatarea()));
        for (Map.Entry<String, List<AbstractFormula>> area2formulas : formulaByFloatArea.entrySet()) {
            String floatArea = area2formulas.getKey();
            Map<String, Set<String>> dimToMembs = AnalysisFormulaUtil.getFloatDimmembMap(tmp, floatArea, filterDimSetting);
            List<AbstractFormula> formulas = area2formulas.getValue();
            for (AbstractFormula formula2 : formulas) {
                Map<String, List<String>> floatDim2ParamMap = AnalysisFormulaUtil.getFloatDim2ParamMap(this._ctx.getModelId());
                ArrayList<List<String>> dimValue = new ArrayList<List<String>>();
                Pair<List<AbstractFormula>, List<AbstractFormula>> errorAndTips = OrgDataCollectService.generateFloatAcctDy(glDimToBcmDim, acctFloatList, formula2, dimToMembs, dimValue, floatDim2ParamMap);
                logs.addAll((Collection)errorAndTips.p1);
                tipLogs.addAll((Collection)errorAndTips.p2);
            }
        }
        acctFloatList.addAll(allFloatFormulas);
        acctFloatList.run();
        return new Pair(logs, tipLogs);
    }

    private void groupFloatFormula(List<AbstractFormula> floatAcctList, List<AbstractFormula> acctList, List<AbstractFormula> batchCalList, AbstractFormula f) {
        if (this.openBatchCal && CollectCalculateHelp.canBatchCal(f).booleanValue()) {
            batchCalList.add(f);
        } else {
            floatAcctList.add(f);
        }
        acctList.remove(f);
    }

    private void setMyCompanyAutoConvent2formula(HashMap<String, Integer> formulaArea2AutoConvent, AbstractFormula f, String floatarea, BasePointInfo base, PositionInfo position) {
        if (formulaArea2AutoConvent.containsKey(floatarea)) {
            f.setAutoConvent(formulaArea2AutoConvent.get(floatarea));
        } else {
            this.collectFormulaArea2MyCompanyConvent(formulaArea2AutoConvent, f, floatarea, base, position);
        }
    }

    private void collectFormulaArea2MyCompanyConvent(HashMap<String, Integer> formulaArea2AutoConvent, AbstractFormula f, String floatarea, BasePointInfo base, PositionInfo position) {
        for (PositionInfo positionInfo : this.spreadManager.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                String spreadArea = basePointInfo.getOriginalDynaRange();
                if (!SpreadAreaUtil.isInArea((String)floatarea, (String)spreadArea)) continue;
                base = basePointInfo;
                position = positionInfo;
                break;
            }
            if (base == null) continue;
            break;
        }
        if (base == null) {
            f.setMsg("Float area not exist");
        } else {
            boolean myCompanyInRowCol = Arrays.asList(f.getRowcols()).contains(DimTypesEnum.MYCOMPANY.getNumber());
            if (myCompanyInRowCol) {
                BasePointInnerLineInfo mcLine = base.getBasePointInnerLineInfo().stream().filter(l -> "MyCompany".equals(l.getDimension().getNumber())).findFirst().orElse(null);
                if (mcLine != null && mcLine.isFloated() && mcLine.isIshide() && "Entity".equals(mcLine.getNumberfrom())) {
                    f.setAutoConvent(PositionInfo.MyCompanyAutoConvent.ECUR.getIndex());
                    formulaArea2AutoConvent.put(floatarea, PositionInfo.MyCompanyAutoConvent.ECUR.getIndex());
                } else {
                    f.setAutoConvent(-1);
                    formulaArea2AutoConvent.put(floatarea, -1);
                }
            } else if (this.isAutoConventMyCompany) {
                int autoConvent = base.getMyCompanyAutoConvent(position).getIndex();
                f.setAutoConvent(autoConvent);
                formulaArea2AutoConvent.put(floatarea, autoConvent);
            } else {
                f.setAutoConvent(-1);
                formulaArea2AutoConvent.put(floatarea, -1);
            }
        }
    }

    private void collectFloatCal(long tmp, int accountreclass, String currency, List<AbstractFormula> batchCalList, Map<String, String> glDimToBcmDim, Map<String, Long> filterDimSetting) {
        Map<String, List<AbstractFormula>> formulaByArea = batchCalList.stream().collect(Collectors.groupingBy(formula -> formula.getFloatarea()));
        TemplateModel templateModel = TemplateServiceHelper.getTemplateModelById(tmp);
        Map<String, Map<String, List<DynaMembScopeInfo>>> area2scope = formulaByArea.keySet().stream().collect(Collectors.toMap(area -> area, area -> AnalysisFormulaUtil.getFloatDimmScope(templateModel, area)));
        Map<String, List<String>> sameScopeArea = OrgDataCollectService.groupAreaByFloatDim(area2scope);
        LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: finish groupAreaByFloatDim %d", this._ctx.getOrg(), tmp, sameScopeArea.size()));
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers(this._ctx.getModelNum()));
        boolean myCompanyInPage = false;
        boolean isMyCompanyInPage = false;
        Map<String, String> comMemMap = this._ctx.getComMemMaps().get(tmp);
        if (this.isAutoConventMyCompany && comMemMap.containsKey(DimTypesEnum.MYCOMPANY.getNumber())) {
            myCompanyInPage = true;
            isMyCompanyInPage = "MyCompany".equals(comMemMap.get(DimTypesEnum.MYCOMPANY.getNumber()));
        }
        ArrayList failFormula = Lists.newArrayList();
        ArrayList tipFormula = Lists.newArrayList();
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(this.INIT_TEN);
        ArrayList<DynamicObject> tips = new ArrayList<DynamicObject>(this.INIT_TEN);
        Table<String, String, String> param2BcmDim = AnalysisFormulaUtil.getParam2BcmDim(this._ctx.getModelId());
        for (List<String> areas : sameScopeArea.values()) {
            ArrayList<AbstractFormula> formulaList = new ArrayList<AbstractFormula>(this.INIT_TEN);
            for (String area2 : areas) {
                formulaList.addAll((Collection<AbstractFormula>)formulaByArea.get(area2));
            }
            RefParamResult refParamResult = CollectCalculateHelp.packRefParam(formulaList, glDimToBcmDim, param2BcmDim, filterDimSetting);
            refParamResult.setPageDims(this._ctx.getComMemMaps());
            if (MapUtils.isEmpty(refParamResult.getRefParam()) && MapUtils.isEmpty(refParamResult.getFloatParam())) {
                AbstractFormula abstractFormula = (AbstractFormula)formulaList.get(0);
                abstractFormula.setMsg(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u6d6e\u52a8\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u548c\u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e\u3002", (String)"OrgDataCollectService_17", (String)"fi-bcm-business", (Object[])new Object[0]));
                failFormula.add(abstractFormula);
                continue;
            }
            CollectCalculateService collectCalculateService = this.getCollectCalculateService(tmp, accountreclass, currency, refParamResult);
            List<Pair<List<ExpressStatus>, List<AbstractFormula>>> statusAndBatchFormuls = this.addBatchFormula(formulaByArea, failFormula, tipFormula, areas, collectCalculateService);
            collectCalculateService.calculateCollect();
            Map<String, Object> collectResultSet = collectCalculateService.getCollectResultSet();
            Map<String, Integer> formulaKey2ParamIndex = collectCalculateService.getFormulaKey2ParamIndex();
            ICollectResultHandle handle = this.getiCollectResultHandle(glDimToBcmDim, refParamResult, param2BcmDim);
            for (Pair<List<ExpressStatus>, List<AbstractFormula>> statusAndBatchFormul : statusAndBatchFormuls) {
                Map<String, Pair<String, String>> tipLogMsg;
                List statusList = (List)statusAndBatchFormul.p1;
                List<AbstractFormula> batchCalFromula = (List<AbstractFormula>)statusAndBatchFormul.p2;
                List<IPackKey> packKeys = CollectCalculateHelp.batchPackKeys(statusList, batchCalFromula, collectResultSet, this._ctx.getModelId(), refParamResult.getGlMem2BcmMems(), failFormula, formulaKey2ParamIndex, param2BcmDim);
                if ((batchCalFromula = this.checkCM014(batchCalFromula)).isEmpty()) continue;
                LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: finish batchCaculateFormula, statusListSize %d", this._ctx.getOrg(), tmp, batchCalFromula.size()));
                HashMap<String, String> protoComMems = new HashMap<String, String>(16);
                Map<String, String> comMems = this._ctx.getComMemMaps().get(tmp);
                for (Map.Entry<String, String> entry : comMems.entrySet()) {
                    String dim = entry.getKey();
                    if (ObjectUtils.equals((Object)dim, (Object)batchCalFromula.get(0).getRowcols())) continue;
                    protoComMems.put(dim, entry.getValue());
                }
                HashMap<Integer, Pair<Map<String, List<String>>, List<String>>> index2formulaGlDim = new HashMap<Integer, Pair<Map<String, List<String>>, List<String>>>(this.INIT_TEN);
                for (int i = 0; i < batchCalFromula.size(); ++i) {
                    Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(batchCalFromula.get(i).getFormulaStr());
                    index2formulaGlDim.put(i, pair);
                }
                boolean isEntityFloat = false;
                int entityIndex = -1;
                if (!batchCalFromula.isEmpty()) {
                    AbstractFormula f = batchCalFromula.get(0);
                    ArrayList rowcolList = new ArrayList(this.INIT_TEN);
                    Object[] rowcols = f.getRowcols();
                    CollectionUtils.addAll(rowcolList, (Object[])rowcols);
                    entityIndex = rowcolList.indexOf(DimTypesEnum.ENTITY.getNumber());
                    if (entityIndex != -1) {
                        ArrayList rowcoMemlList = new ArrayList(this.INIT_TEN);
                        Object[] rowcolMemNum = f.getRowcolMemNum();
                        CollectionUtils.addAll(rowcoMemlList, (Object[])rowcolMemNum);
                        String entityNum = (String)rowcoMemlList.get(entityIndex);
                        isEntityFloat = "@".equals(entityNum);
                    }
                }
                if (!isEntityFloat) {
                    for (AbstractFormula formula2 : batchCalFromula) {
                        if (myCompanyInPage && (!myCompanyInPage || !this.isAutoConventMyCompany)) continue;
                        OrgDataCollectService.dealFormulaMyCompany((Table<String, String, String>)assoMembs, myCompanyInPage, isMyCompanyInPage, formula2, this._ctx.getOrg());
                    }
                }
                if (!(tipLogMsg = collectCalculateService.getTipLogMsg()).isEmpty()) {
                    for (Map.Entry<String, Pair<String, String>> key2tip : tipLogMsg.entrySet()) {
                        Pair<String, String> formula2tip = key2tip.getValue();
                        tips.add(this.getTipLog((String)formula2tip.p1, (String)formula2tip.p2, tmp, new String[0], new String[0], 0));
                    }
                    this.saveTip(tips);
                }
                LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: packKyesSize : %d\u4e2a", this._ctx.getOrg(), tmp, packKeys.size()));
                for (IPackKey key : packKeys) {
                    statusList.clear();
                    collectCalculateService.reset();
                    collectCalculateService.get_cs().setOpenTrace(this.isOpenTrace);
                    for (AbstractFormula formula3 : batchCalFromula) {
                        statusList.add(collectCalculateService.addCollectCalculateExpress(formula3.getFormulaStr()));
                    }
                    String orgNum = this.getOrgNum(batchCalFromula, isEntityFloat, entityIndex, (PackKey)key);
                    for (int i = 0; i < statusList.size(); ++i) {
                        AbstractFormula formula4 = batchCalFromula.get(i);
                        String[] rowcols = formula4.getRowcols();
                        String[] rowcolMemNum = formula4.getRowcolMemNum();
                        String[] dimMems = this.fillDimMems(rowcolMemNum, (PackKey)key);
                        if ((!myCompanyInPage || myCompanyInPage && this.isAutoConventMyCompany) && isEntityFloat && StringUtils.isNotEmpty((String)orgNum)) {
                            Pair<List<String>, List<String>> pair = this.dealMycompanyByRowCol((Table<String, String, String>)assoMembs, myCompanyInPage, isMyCompanyInPage, orgNum, formula4, rowcols, dimMems);
                            rowcols = ((List)pair.p1).toArray(new String[0]);
                            dimMems = ((List)pair.p2).toArray(new String[0]);
                        }
                        String formulaStr = formula4.getFormulaStr();
                        Object value = collectCalculateService.evalExpress((ExpressStatus)statusList.get(i), key, handle);
                        if (value instanceof Exception) {
                            AbstractFormula abstractFormula = formula4;
                            abstractFormula.setMsg(((Exception)value).getMessage());
                            failFormula.add(abstractFormula);
                            continue;
                        }
                        this.collectValue2Olap(tmp, rowcols, logs, dimMems, formulaStr, value);
                        this.collectTraceData((ExpressStatus)statusList.get(i), collectCalculateService, protoComMems, rowcols, dimMems, (Pair<Map<String, List<String>>, List<String>>)((Pair)index2formulaGlDim.get(i)), glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), param2BcmDim);
                        this.collectErrorMesg(tmp, logs, tips, statusList, collectCalculateService, i, rowcols, dimMems, formulaStr);
                    }
                    if (this.successacctSum.get() != 0 || logs.size() != 0) continue;
                    this.successacctSum.addAndGet(formulaList.size());
                }
            }
            LOGGER.info(String.format("bcm_calculateByTemplate %s entity's %s template finish packKey calculate", this._ctx.getOrg(), tmp));
        }
        this.saveFailLog(failFormula, logs);
        this.saveTipLog(tipFormula, tips);
    }

    private List<Pair<List<ExpressStatus>, List<AbstractFormula>>> addBatchFormula(Map<String, List<AbstractFormula>> formulaByArea, List<AbstractFormula> failFormula, List<AbstractFormula> tipFormula, List<String> areas, CollectCalculateService collectCalculateService) {
        ArrayList<Pair<List<ExpressStatus>, List<AbstractFormula>>> statusAndBatchFormuls = new ArrayList<Pair<List<ExpressStatus>, List<AbstractFormula>>>(this.INIT_TEN);
        for (String area : areas) {
            ArrayList<ExpressStatus> statusList = new ArrayList<ExpressStatus>(this.INIT_TEN);
            ArrayList<AbstractFormula> batchCalFromula = new ArrayList<AbstractFormula>(this.INIT_TEN);
            this.collectCalFormula(formulaByArea.get(area), collectCalculateService, statusList, batchCalFromula, failFormula, tipFormula);
            Pair pair = new Pair(statusList, batchCalFromula);
            statusAndBatchFormuls.add((Pair<List<ExpressStatus>, List<AbstractFormula>>)pair);
        }
        return statusAndBatchFormuls;
    }

    private static Map<String, List<String>> groupAreaByFloatDim(Map<String, Map<String, List<DynaMembScopeInfo>>> area2scope) {
        HashMap<String, List<String>> sameScopeArea = new HashMap<String, List<String>>(16);
        ArrayList<String> sameArea = new ArrayList<String>();
        for (Map.Entry<String, Map<String, List<DynaMembScopeInfo>>> entity : area2scope.entrySet()) {
            Map<String, List<DynaMembScopeInfo>> scope = entity.getValue();
            Set<String> dims = scope.keySet();
            String area = entity.getKey();
            for (Map.Entry<String, Map<String, List<DynaMembScopeInfo>>> entityScope : area2scope.entrySet()) {
                String scopeArea = entityScope.getKey();
                if (sameArea.contains(scopeArea)) continue;
                if (ObjectUtils.equals((Object)area, (Object)scopeArea)) {
                    sameScopeArea.computeIfAbsent(area, e -> new ArrayList(10)).add(scopeArea);
                    sameArea.add(scopeArea);
                    continue;
                }
                Map<String, List<DynaMembScopeInfo>> scopeValue = entityScope.getValue();
                Set<String> scopeDims = scopeValue.keySet();
                if (dims.size() != scopeDims.size() || !dims.containsAll(scopeDims)) continue;
                boolean same = true;
                for (String dim : dims) {
                    if (!same) break;
                    List<DynaMembScopeInfo> scopeInfos = scope.get(dim);
                    List<DynaMembScopeInfo> dynaMembScopeInfos = scopeValue.get(dim);
                    if (scopeInfos.size() == dynaMembScopeInfos.size() && scopeInfos.containsAll(dynaMembScopeInfos)) continue;
                    same = false;
                }
                if (!same) continue;
                sameScopeArea.computeIfAbsent(area, e -> new ArrayList()).add(scopeArea);
                sameArea.add(scopeArea);
            }
        }
        return sameScopeArea;
    }

    private Pair<List<String>, List<String>> dealMycompanyByRowCol(Table<String, String, String> assoMembs, boolean myCompanyInPage, boolean isMyCompanyInPage, String orgNum, AbstractFormula formula, String[] rowcols, String[] dimMems) {
        int myCompanyIndex;
        ArrayList<String> rowcolList = new ArrayList<String>(this.INIT_TEN);
        ArrayList<String> rowcolMemNumlist = new ArrayList<String>(this.INIT_TEN);
        CollectionUtils.addAll(rowcolList, (Object[])rowcols);
        CollectionUtils.addAll(rowcolMemNumlist, (Object[])dimMems);
        if (isMyCompanyInPage) {
            rowcolList.add(DimTypesEnum.MYCOMPANY.getNumber());
            String redirectMyCompany = OrgDataCollectService.getRedirectMyCompany(assoMembs, formula, orgNum);
            rowcolMemNumlist.add(redirectMyCompany);
        } else if (!myCompanyInPage && formula.getAutoConvent() != -1 && (myCompanyIndex = rowcolList.indexOf(DimTypesEnum.MYCOMPANY.getNumber())) != -1) {
            rowcolMemNumlist.set(myCompanyIndex, orgNum);
        }
        return new Pair(rowcolList, rowcolMemNumlist);
    }

    private String getOrgNum(List<AbstractFormula> batchCalFromula, boolean isEntityFloat, int entityIndex, PackKey key) {
        String orgNum = "";
        if (isEntityFloat) {
            AbstractFormula formula = batchCalFromula.get(0);
            String[] rowcolMemNum = formula.getRowcolMemNum();
            String[] dimMems = this.fillDimMems(rowcolMemNum, key);
            orgNum = dimMems[entityIndex];
        }
        return orgNum;
    }

    private static void dealFormulaMyCompany(Table<String, String, String> assoMembs, boolean myCompanyInPage, boolean isMyCompanyInPage, AbstractFormula formula, String org) {
        int myCompanyIndex;
        String orgNum;
        ArrayList<String> rowcolList = new ArrayList<String>(10);
        Object[] rowcols = formula.getRowcols();
        CollectionUtils.addAll(rowcolList, (Object[])rowcols);
        if (myCompanyInPage && rowcolList.contains(DimTypesEnum.MYCOMPANY.getNumber())) {
            return;
        }
        boolean entityInPageView = true;
        if (rowcolList.contains(DimTypesEnum.ENTITY.getNumber())) {
            entityInPageView = false;
        }
        ArrayList<String> rowcolMemNumlist = new ArrayList<String>(10);
        Object[] rowcolMemNum = formula.getRowcolMemNum();
        CollectionUtils.addAll(rowcolMemNumlist, (Object[])rowcolMemNum);
        String string = orgNum = entityInPageView ? org : (String)rowcolMemNumlist.get(rowcolList.indexOf(DimTypesEnum.ENTITY.getNumber()));
        if (isMyCompanyInPage) {
            rowcolList.add(DimTypesEnum.MYCOMPANY.getNumber());
            String redirectMyCompany = OrgDataCollectService.getRedirectMyCompany(assoMembs, formula, orgNum);
            if ("$ECur".equals(redirectMyCompany)) {
                redirectMyCompany = orgNum;
            }
            rowcolMemNumlist.add(redirectMyCompany);
        } else if (!myCompanyInPage && formula.getAutoConvent() != -1 && (myCompanyIndex = rowcolList.indexOf(DimTypesEnum.MYCOMPANY.getNumber())) != -1) {
            rowcolMemNumlist.set(myCompanyIndex, orgNum);
        }
        formula.setRowcols(rowcolList.toArray(new String[0]));
        formula.setRowcolMemNum(rowcolMemNumlist.toArray(new String[0]));
    }

    private void collectTraceData(ExpressStatus status, CollectCalculateService collectCalculateService, HashMap<String, String> protoComMems, String[] rowcols, String[] rowcolMemNum, Pair<Map<String, List<String>>, List<String>> formulaGlDims, Map<String, String> glDimToBcmDim, HashMultimap<String, String> glDimBcmMem2GlMems, Table<String, String, String> param2BcmDim) {
        DataTraceFrom dc;
        HashMap mems = (HashMap)protoComMems.clone();
        if (this.isOpenTrace && (dc = collectCalculateService.get_cs().getCollectFormulaForTrace(status, Arrays.asList(rowcols), Arrays.asList(rowcolMemNum), formulaGlDims, glDimToBcmDim, glDimBcmMem2GlMems, false, param2BcmDim)) != null) {
            String originalOrg = null;
            for (int j = 0; j < rowcols.length; ++j) {
                mems.put(rowcols[j], rowcolMemNum[j]);
                if (!rowcols[j].equals(DimTypesEnum.ENTITY.getNumber())) continue;
                originalOrg = rowcolMemNum[j];
            }
            if (CurrencyTool.isTransCurrency((String)mems.get(DimTypesEnum.CURRENCY.getNumber()))) {
                Pair<String, String> p = TransMemberUtil.transOrgAndCurbyOrgId(this._ctx.getModelId(), this._ctx.getOrgId(), (String)mems.get(DimTypesEnum.PROCESS.getNumber()), (String)mems.get(DimTypesEnum.CURRENCY.getNumber()), 0L, 0L);
                mems.put(DimTypesEnum.ENTITY.getNumber(), p.p1);
                mems.put(DimTypesEnum.CURRENCY.getNumber(), p.p2);
            }
            if (originalOrg != null) {
                mems.put(DimTypesEnum.ENTITY.getNumber(), originalOrg);
            }
            this.dtfs.saveCellDataTemp(mems, dc, 1);
        }
    }

    private void collectErrorMesg(long tmp, List<DynamicObject> logs, List<DynamicObject> tips, List<ExpressStatus> statusList, CollectCalculateService collectCalculateService, int i, String[] rowcols, String[] dimMems, String formulaStr) {
        Map<String, String> errorMsg = collectCalculateService.get_cs().getErrorMsg();
        Map<String, String> tipLogs = collectCalculateService.get_cs().getTipLogMsg();
        if (errorMsg.size() != 0 || tipLogs.size() != 0) {
            for (String e : statusList.get(i).getChildParseExpr()) {
                if (errorMsg.get(e) != null) {
                    logs.add(this.getLog(formulaStr, errorMsg.get(e), tmp, rowcols, dimMems, 0));
                    break;
                }
                if (tipLogs.get(e) == null) continue;
                tips.add(this.getTipLog(formulaStr, tipLogs.get(e), tmp, rowcols, dimMems, 0));
                break;
            }
        }
    }

    private List<AbstractFormula> checkCM014(List<AbstractFormula> batchCalFromula) {
        return batchCalFromula.stream().filter(formula -> this.isStringCheck || formula.getMsg() == null).collect(Collectors.toList());
    }

    private void saveFailLog(List<AbstractFormula> failFormula, List<DynamicObject> logs) {
        if (!logs.isEmpty()) {
            this.failacctSum += logs.size();
            logs = logs.stream().limit(this.batchlogsize).collect(Collectors.toList());
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logs.get(0)).getDynamicObjectType(), (Object[])logs.toArray());
        }
        this.saveLog(failFormula);
    }

    private void saveTipLog(List<AbstractFormula> tipFormula, List<DynamicObject> tips) {
        if (!tips.isEmpty()) {
            this.tipLogSum += tips.size();
            tips = tips.stream().limit(this.batchlogsize).collect(Collectors.toList());
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)tips.get(0)).getDynamicObjectType(), (Object[])tips.toArray());
        }
        this.saveTipLog(tipFormula);
    }

    private void saveTip(List<DynamicObject> tips) {
        if (!tips.isEmpty()) {
            this.tipLogSum += tips.size();
            BusinessDataWriter.save((IDataEntityType)tips.get(0).getDynamicObjectType(), (Object[])tips.toArray());
            tips.clear();
        }
    }

    private void saveTipLog(List<AbstractFormula> tipFormula) {
        ArrayList tipLogs = new ArrayList(this.INIT_TEN);
        tipFormula.forEach(f -> tipLogs.add(this.getTipLog((AbstractFormula)f)));
        if (!tipLogs.isEmpty()) {
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)tipLogs.get(0)).getDynamicObjectType(), (Object[])tipLogs.toArray());
        }
        this.tipLogSum += tipLogs.size();
    }

    private void collectCalFormula(List<AbstractFormula> batchCalList, CollectCalculateService collectCalculateService, List<ExpressStatus> statusList, List<AbstractFormula> batchCalFromula, List<AbstractFormula> failFormula, List<AbstractFormula> tipFormula) {
        for (AbstractFormula formula : batchCalList) {
            if (StringUtils.isNotEmpty((String)formula.getMsg())) {
                failFormula.add(formula);
                continue;
            }
            ExpressStatus expressStatus = collectCalculateService.addCollectCalculateExpress(formula.getFormulaStr());
            if (expressStatus.hasException()) {
                formula.setMsg(expressStatus.getException().getMessage());
                if (expressStatus.getException() instanceof NotificationException) {
                    tipFormula.add(formula);
                    continue;
                }
                failFormula.add(formula);
                continue;
            }
            statusList.add(expressStatus);
            batchCalFromula.add(formula);
        }
    }

    private String[] fillDimMems(String[] rowcolMemNum, PackKey key) {
        String[] cloneMems = (String[])rowcolMemNum.clone();
        block0: for (String bcmMem : key.getBcmMems()) {
            if (StringUtil.isEmptyString((String)bcmMem)) continue;
            for (int j = 0; j < cloneMems.length; ++j) {
                if (!"@".equals(cloneMems[j])) continue;
                cloneMems[j] = bcmMem;
                continue block0;
            }
        }
        return cloneMems;
    }

    private void collectValue2Olap(long tmp, String[] rowcols, List<DynamicObject> logs, String[] cloneMems, String formulaStr, Object value) {
        if (value instanceof Exception) {
            logs.add(this.getLog(formulaStr, DataCollectUtil.getErrorMsg((Exception)value), tmp, rowcols, cloneMems, 0));
        } else if (value instanceof Number && ((Number)value).doubleValue() == 0.0) {
            DataCollectServiceHelper.saveSpreadData(tmp, rowcols, cloneMems, null, this._ctx.getOrg(), this._ctx, this.dcsize);
            this.successacctSum.getAndIncrement();
        } else {
            DataCollectServiceHelper.saveSpreadData(tmp, rowcols, cloneMems, value, this._ctx.getOrg(), this._ctx, this.dcsize);
            this.successacctSum.getAndIncrement();
        }
    }

    private ICollectResultHandle getiCollectResultHandle(final Map<String, String> glDimToBcmDim, final RefParamResult refParamResult, final Table<String, String, String> param2BcmDim) {
        ICollectResultHandle handle = new ICollectResultHandle(){

            @Override
            public void handle(Object collects, IPackKey dynaKey, IFormula formula, ICalContext ctx) {
                if (collects instanceof Map) {
                    if (CollectCalculateHelp.batchSupportFormulas4bcm.contains(formula.getName().toLowerCase(Locale.ENGLISH))) {
                        String key = JSONArray.toJSONString(((PackKey)dynaKey).getBcmMems());
                        formula.setValue(((Map)collects).get(key));
                        return;
                    }
                    List<String> keys = dynaKey.getKey(formula, glDimToBcmDim, refParamResult.getGlDimBcmMem2GlMems(), (Table<String, String, String>)param2BcmDim);
                    BigDecimal value = BigDecimal.ZERO;
                    if (keys.size() > 1) {
                        String msg = String.format(ResManager.loadKDString((String)"%1s \u6620\u5c04\u591a\u4e2a\u6838\u7b97\u7ef4\u5ea6\u6210\u5458 %2s\u3002", (String)"OrgDataCollectService_12", (String)"fi-bcm-business", (Object[])new Object[0]), ((PackKey)dynaKey).getBcmMems(), String.join((CharSequence)",", keys));
                        formula.setTipLogMsg(msg);
                        for (String key : keys) {
                            try {
                                Object v = ((Map)collects).get(key);
                                if (v == null) continue;
                                BigDecimal bigDecimal = NumberUtil.toBigDecimal(v);
                                value = value.add(bigDecimal);
                            }
                            catch (Exception e) {
                                formula.setException(e);
                            }
                        }
                        formula.setValue(value);
                    } else {
                        formula.setValue(((Map)collects).get(keys.get(0)));
                    }
                }
            }
        };
        return handle;
    }

    private CollectCalculateService getCollectCalculateService(long tmp, int accountreclass, String currency, RefParamResult refParamResult) {
        ICalContext ctx = this.getCalCtx(accountreclass, tmp, currency);
        ctx.setExternalDataProvider(new SheetDataProvider(this.sheet));
        ctx.setProperty("is_calc_collect_ref_param", refParamResult.getRefParam());
        ctx.setProperty("is_calc_collect_float_param", refParamResult.getFloatParam());
        ctx.setProperty("v_data_return_dims", refParamResult.getVDataDims());
        ctx.setProperty("v_data_variable_dims", refParamResult.getInParams());
        ctx.setProperty("v_data_page_dims", refParamResult.getPageDims());
        ctx.setFormulaHandle(f -> SpecialCalLogic.dealAccountForAcct(ctx, f));
        CollectCalculateService collectCalculateService = new CollectCalculateService(ctx);
        return collectCalculateService;
    }

    private static Pair<List<AbstractFormula>, List<AbstractFormula>> generateFloatAcctDy(Map<String, String> glDimToBcmDim, BatchFormulaList acctFloatList, AbstractFormula formula, Map<String, Set<String>> dimToMembs, List<List<String>> dimValue, Map<String, List<String>> floatDim2ParamMap) {
        ArrayList<AbstractFormula> logs = new ArrayList<AbstractFormula>(10);
        ArrayList<AbstractFormula> tipLogs = new ArrayList<AbstractFormula>(10);
        Pair errorAndTip = new Pair(logs, tipLogs);
        String acct = formula.getFormulaStr();
        AtomicBoolean isAcct = new AtomicBoolean(false);
        OrgDataCollectService.functionTypeCheck(acct, isAcct, OrgDataCollectService.startsWithAcct());
        if (!isAcct.get()) {
            if (dimToMembs.size() == 1) {
                OrgDataCollectService.analyNotAcctFormula(acctFloatList, formula, dimToMembs);
                return errorAndTip;
            }
            AtomicBoolean isParamFloatFormula = new AtomicBoolean(false);
            OrgDataCollectService.functionTypeCheck(acct, isParamFloatFormula, OrgDataCollectService.containParamFloatFormula());
            if (!isParamFloatFormula.get()) {
                AbstractFormula logDy = OrgDataCollectService.genFormulaLog(formula, acct, ResManager.loadKDString((String)"\u516c\u5f0f\u53ea\u652f\u6301\u5355\u4e2a\u6d6e\u52a8\u3002", (String)"OrgDataCollectService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
                logs.add(logDy);
            }
            return errorAndTip;
        }
        Pair pair = Pair.onePair((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        AnalysisFormulaUtil.generateFloatAcctDy(acct, (Pair<List<String>, List<String>>)pair);
        ArrayList<String> bcmDimSeq = new ArrayList<String>();
        HashMap gldim2DimIndex = Maps.newHashMap();
        for (String key : (List)pair.p2) {
            if (dimToMembs.get(glDimToBcmDim.get(key)) == null) continue;
            ArrayList floatMembs = new ArrayList(dimToMembs.get(glDimToBcmDim.get(key)));
            if (!bcmDimSeq.contains(glDimToBcmDim.get(key))) {
                bcmDimSeq.add(glDimToBcmDim.get(key));
                dimValue.add(floatMembs);
                continue;
            }
            gldim2DimIndex.put(key, bcmDimSeq.indexOf(glDimToBcmDim.get(key)));
        }
        if (dimValue.isEmpty()) {
            return errorAndTip;
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        AnalysisFormulaUtil.descartes(dimValue, result, 0, new ArrayList<String>());
        ArrayList replaces = Lists.newArrayListWithExpectedSize((int)10);
        HashMap<String, Set<String>> assgrpToDimvalueMap = new HashMap<String, Set<String>>();
        for (List list : result) {
            for (int i = 0; i < list.size(); ++i) {
                assgrpToDimvalueMap.computeIfAbsent((String)((List)pair.p2).get(i), (Function<String, Set<String>>)((Function<String, Set>)k -> new HashSet())).add(list.get(i));
            }
            for (Map.Entry entry : gldim2DimIndex.entrySet()) {
                for (int i = 0; i < ((List)pair.p2).size(); ++i) {
                    if (!((String)((List)pair.p2).get(i)).equals(entry.getKey())) continue;
                    assgrpToDimvalueMap.computeIfAbsent((String)((List)pair.p2).get(i), (Function<String, Set<String>>)((Function<String, Set>)k -> new HashSet())).add(list.get((Integer)entry.getValue()));
                }
            }
        }
        HashMultimap<String, String> orgToAssgrpMap = AnalysisFormulaUtil.getAssgrpMapValue(assgrpToDimvalueMap, null);
        HashSet hashSet = new HashSet();
        for (List list : result) {
            HashMultimap group = HashMultimap.create();
            int dimMemListSize = list.size();
            for (int i = 0; i < dimMemListSize; ++i) {
                String key = String.join((CharSequence)"_-", (CharSequence)((List)pair.p2).get(i), (CharSequence)list.get(i));
                Set vals = orgToAssgrpMap.get((Object)key);
                for (String val : vals) {
                    group.put(((List)pair.p1).get(i), (Object)String.join((CharSequence)"|", (CharSequence)((List)pair.p2).get(i), val, (CharSequence)list.get(i)));
                    hashSet.add(((List)pair.p1).get(i));
                }
            }
            for (Map.Entry entry : gldim2DimIndex.entrySet()) {
                for (int i = 0; i < ((List)pair.p2).size(); ++i) {
                    if (!((String)((List)pair.p2).get(i)).equals(entry.getKey())) continue;
                    String s = (String)list.get((Integer)entry.getValue());
                    String key = String.join((CharSequence)"_-", (CharSequence)((List)pair.p2).get(i), s);
                    Set vals = orgToAssgrpMap.get((Object)key);
                    Iterator iterator = vals.iterator();
                    while (iterator.hasNext()) {
                        String val = (String)iterator.next();
                        group.put(((List)pair.p1).get(i), (Object)String.join((CharSequence)"|", (CharSequence)((List)pair.p2).get(i), val, s));
                        hashSet.add(((List)pair.p1).get(i));
                    }
                }
            }
            int groupSize = group.size();
            if (groupSize <= 0 || groupSize < dimMemListSize) continue;
            replaces.add(group);
        }
        if (((List)pair.p1).size() == hashSet.size()) {
            for (String string : (List)pair.p1) {
                if (hashSet.contains(string)) continue;
                return errorAndTip;
            }
        } else {
            return errorAndTip;
        }
        String dimkey = Joiner.on((String)"|").join((Object[])formula.getRowcols());
        String string = Joiner.on((String)"|").join((Object[])formula.getRowcolMemNum());
        for (HashMultimap replace : replaces) {
            AbstractFormula dy;
            String memberkey;
            String tipMsg = "";
            String[] dims = dimkey.split("\\|");
            CharSequence[] mems = string.split("\\|");
            String datafrom = formula.getFormulaStr();
            String notAcctFloatMem = " ";
            for (Map.Entry entry : replace.entries()) {
                String[] params = ((String)entry.getValue()).split("\\|");
                for (int i = 0; i < mems.length; ++i) {
                    if (!"@".equals(mems[i])) continue;
                    for (Map.Entry<String, String> dimentry : glDimToBcmDim.entrySet()) {
                        if (!dimentry.getKey().equals(params[0]) || !dims[i].equals(dimentry.getValue())) continue;
                        String param = params[2];
                        notAcctFloatMem = params[2];
                        mems[i] = param;
                    }
                }
                StringBuilder astMembStr = new StringBuilder(String.join((CharSequence)"|", params[0], params[1]));
                ArrayList<String> glMems = new ArrayList<String>(5);
                for (String v : replace.get(entry.getKey())) {
                    String[] subparams = v.split("\\|");
                    if (!params[0].equals(subparams[0]) || params[1].equals(subparams[1])) continue;
                    astMembStr.append(",");
                    astMembStr.append(subparams[1]);
                    glMems.add(params[1]);
                }
                if (!glMems.isEmpty()) {
                    glMems.add(params[2]);
                    tipMsg = String.format(ResManager.loadKDString((String)"%1s \u6620\u5c04\u591a\u4e2a\u6838\u7b97\u7ef4\u5ea6\u6210\u5458 %2s\u3002", (String)"OrgDataCollectService_12", (String)"fi-bcm-business", (Object[])new Object[0]), params[2], String.join((CharSequence)",", glMems));
                }
                datafrom = datafrom.replace("|" + (String)entry.getKey(), "|" + astMembStr);
            }
            if (datafrom.contains("@")) {
                datafrom = datafrom.replace("@", notAcctFloatMem);
            }
            if (StringUtils.isNotEmpty((String)(memberkey = String.join((CharSequence)"|", mems)))) {
                memberkey = memberkey + "|";
            }
            if (StringUtils.isNotEmpty((String)tipMsg)) {
                AbstractFormula logDy = OrgDataCollectService.getFloatFormula(formula, datafrom, memberkey);
                logDy.setMsg(tipMsg);
                tipLogs.add(logDy);
            }
            if ((dy = OrgDataCollectService.getFloatFormula(formula, datafrom, memberkey)).getFormulaStr().contains("@")) continue;
            acctFloatList.add(dy);
        }
        return errorAndTip;
    }

    private static AbstractFormula genFormulaLog(AbstractFormula formula, String acct, String msg) {
        AbstractFormula logDy = OrgDataCollectService.getFloatFormula(formula, acct, "");
        logDy.setMsg(msg);
        return logDy;
    }

    private List<Long> getSortTempids() {
        if (this.sortTempids == null) {
            this.sortTmp();
        }
        return this.sortTempids;
    }

    private void sortTmp() {
        if (this._ctx.isSort()) {
            Set<Long> groupIds = this.getGroupIds();
            int maxNum = this.getMaxNum(groupIds);
            DynamicObjectCollection allSortGroups = this.getAllSortGroups(maxNum);
            Map<String, Long> map = this.getMap();
            ArrayList<Long> isReCollectTempIds = new ArrayList<Long>(this.INIT_TEN);
            ArrayList<Long> isNotReCollectTempIds = new ArrayList<Long>(this.INIT_TEN);
            ArrayList<Long> isWeavingTempIds = new ArrayList<Long>(this.INIT_TEN);
            for (DynamicObject sortGroup : allSortGroups) {
                String group = sortGroup.getString("group");
                Long templateid = map.get(group);
                if (templateid == null) continue;
                isReCollectTempIds.add(templateid);
                isNotReCollectTempIds.add(templateid);
                String reportStatus = ReportStatusEnum.UNWEAVE.status();
                if (this.reportMap.get(templateid) != null) {
                    reportStatus = this.reportMap.get(templateid).getString("reportstatus");
                }
                if (this._ctx.getRealselectTmp() != null && this._ctx.getRealselectTmp().contains(templateid) || StringUtils.isEmpty((String)reportStatus) || !reportStatus.equals(ReportStatusEnum.WEAVING.status())) continue;
                isWeavingTempIds.add(templateid);
            }
            isNotReCollectTempIds.removeAll(isWeavingTempIds);
            if (this._ctx.isSort()) {
                this.sortTempids = this._ctx.isReCollect() ? isReCollectTempIds : isNotReCollectTempIds;
            }
        }
        if (this.sortTempids == null) {
            this.sortTempids = new ArrayList<Long>();
        }
    }

    private Set<Long> getGroupIds() {
        QFilter modelQFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId());
        QFilter idQFilters = new QFilter("id", "in", this._ctx.getAllExcuteTempIds());
        String selectFields = "id,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, idQFilters}, null);
        HashSet groupIds = Sets.newHashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            groupIds.add(groupId);
        });
        return groupIds;
    }

    private int getMaxNum(Set<Long> groupIds) {
        QFilter modelQFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId());
        QFilter groupQFilter = new QFilter("group", "in", groupIds);
        String selectFields = "id,setorder";
        DynamicObjectCollection allGroupTemp = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, groupQFilter}, (String)"setorder asc");
        int maxNum = 1;
        for (DynamicObject temp : allGroupTemp) {
            int setorder = Integer.parseInt(temp.getString("setorder"));
            maxNum = setorder > maxNum ? setorder : maxNum;
        }
        return maxNum;
    }

    private DynamicObjectCollection getAllSortGroups(int maxNum) {
        QFilter modelQFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId());
        String selectFields = "id,group,template";
        QFilter maxQFilter = new QFilter("setorder", "<=", (Object)maxNum);
        return QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, maxQFilter}, (String)"setorder asc");
    }

    private Map<String, Long> getMap() {
        QFilter modelQFilter = new QFilter(MODEL, "=", (Object)this._ctx.getModelId());
        String queryFields = "id,group";
        DynamicObjectCollection tempIds = QueryServiceHelper.query((String)"bcm_templateentity", (String)queryFields, (QFilter[])new QFilter[]{modelQFilter}, null);
        HashSet templateIds = Sets.newHashSet();
        for (DynamicObject template : tempIds) {
            templateIds.add(template.getLong("id"));
        }
        Map<Long, Long> source2Right = TemplateUtils.getRightTplIdByVersioned(this._ctx.getModelId(), this._ctx.getFyId(), this._ctx.getPeriodId(), templateIds);
        HashMap<String, Long> map = new HashMap<String, Long>(this.INIT_TEN);
        for (DynamicObject template : tempIds) {
            Long sourceTempId = template.getLong("id");
            Long rightTempId = source2Right.get(sourceTempId);
            if (rightTempId == null) continue;
            map.put(template.getString("group"), rightTempId);
        }
        return map;
    }

    public String getDimensionText(Long temid, String orgNum) {
        StringBuilder sb = new StringBuilder();
        for (String dimNum : this._ctx.getComMemMaps().get(temid).keySet()) {
            String shortNumber;
            if (PresetConstant.ENTITY_DIM.equals(dimNum) || PresetConstant.FY_DIM.equals(dimNum) || PresetConstant.PERIOD_DIM.equals(dimNum)) continue;
            if (!this.shortNumbers.containsKey(dimNum)) {
                shortNumber = DimTypesEnum.getShortNumberByNumber((String)dimNum);
                if (StringUtils.isEmpty((String)shortNumber)) {
                    QFilter qf1 = new QFilter(MODEL, "=", (Object)this._ctx.getModelId());
                    QFilter qf2 = new QFilter(NUMBER, "=", (Object)dimNum);
                    DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"ShortNumber", (QFilter[])new QFilter[]{qf1, qf2});
                    shortNumber = dim.getString("ShortNumber");
                }
                this.shortNumbers.put(dimNum, shortNumber);
            }
            shortNumber = this.shortNumbers.get(dimNum);
            sb.append(shortNumber).append(':').append(this._ctx.getComMemMaps().get(temid).get(dimNum)).append(',');
        }
        return sb.toString().substring(0, sb.lastIndexOf(","));
    }

    public String checkDimMember(Map<String, String> pageview, List<String> rowcols, List<String> rowcolMemNum, Set<String> lossAndCashflowAccountSet) {
        String errormsg = null;
        for (int i = 0; i < rowcols.size(); ++i) {
            String memb = rowcolMemNum.get(i);
            String dimKey = rowcols.get(i);
            if (dimKey.equals(PresetConstant.FY_DIM)) {
                if ("CurrentYear".equals(memb) || "LastYear".equals(memb)) {
                    rowcolMemNum.set(i, PeriodUtils.trans2SpecificFy((String)this._ctx.getModelNum(), (String)this._ctx.getFyNum(), (String)memb).orElse(memb));
                }
            } else if (dimKey.equals(PresetConstant.PERIOD_DIM) && ("CurrentPeriod".equals(memb) || "LastPeriod".equals(memb))) {
                rowcolMemNum.set(i, (String)PeriodUtils.trans2SpecificPeriod((String)this._ctx.getModelNum(), (String)this._ctx.getPeriodNum(), (String)memb, (boolean)false).get());
            }
            if (!this.checkMcStatus(dimKey, memb)) continue;
            return String.format(ResManager.loadKDString((String)"%s\u6d41\u7a0b\u5df2\u7ecf\u63d0\u4ea4\u3002", (String)"OrgDataCollectService_5", (String)"fi-bcm-business", (Object[])new Object[0]), memb);
        }
        String changetypeMemberNum = null;
        String accountMemberNum = null;
        for (Map.Entry entry : pageview.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals(DimTypesEnum.CHANGETYPE.getNumber())) {
                changetypeMemberNum = value;
                continue;
            }
            if (!key.equals(DimTypesEnum.ACCOUNT.getNumber())) continue;
            accountMemberNum = value;
        }
        if (changetypeMemberNum == null) {
            changetypeMemberNum = OrgDataCollectService.getMemberNumber(DimTypesEnum.CHANGETYPE.getNumber(), rowcols, rowcolMemNum);
        }
        if (accountMemberNum == null) {
            accountMemberNum = OrgDataCollectService.getMemberNumber(DimTypesEnum.ACCOUNT.getNumber(), rowcols, rowcolMemNum);
        }
        if ("YTD".equals(changetypeMemberNum) || "CurrentPeriod".equals(changetypeMemberNum)) {
            DynamicObject sceneMember = (DynamicObject)ThreadCache.get((Object)this._ctx.getScenarioId(), () -> {
                QFilter qf = new QFilter("id", "=", (Object)this._ctx.getScenarioId());
                return QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)DCHANGE_TYPE, (QFilter[])new QFilter[]{qf});
            });
            if (DChangeTypeEnum.YTD.getIndex().equals(sceneMember.getString(DCHANGE_TYPE)) && "CurrentPeriod".equals(changetypeMemberNum)) {
                if (accountMemberNum != null && CollectionUtils.isNotEmpty(lossAndCashflowAccountSet) && lossAndCashflowAccountSet.contains(accountMemberNum)) {
                    errormsg = FormulaMessage.getYtdMseeage();
                }
            } else if (DChangeTypeEnum.CurrentPeriods.getIndex().equals(sceneMember.getString(DCHANGE_TYPE)) && "YTD".equals(changetypeMemberNum) && accountMemberNum != null && CollectionUtils.isNotEmpty(lossAndCashflowAccountSet) && lossAndCashflowAccountSet.contains(accountMemberNum)) {
                errormsg = FormulaMessage.getCurrentperiodMseeage();
            }
        }
        return errormsg;
    }

    public List<Long> checkCurrencyMcstatus() {
        ArrayList<Long> unCollectTmp = new ArrayList<Long>();
        for (Long templeteId : this._ctx.getAllExcuteTempIds()) {
            Map<String, String> pageviewdimemberNum = this._ctx.getComMemMaps().get(templeteId);
            Set<Map.Entry<String, String>> pageview = pageviewdimemberNum.entrySet();
            for (Map.Entry<String, String> entry : pageview) {
                if (!this.checkMcStatus(entry.getKey(), entry.getValue())) continue;
                unCollectTmp.add(templeteId);
            }
        }
        return unCollectTmp;
    }

    public boolean checkMcStatus(String key, String value) {
        if ("Currency".equals(key)) {
            if ("EC".equals(value) || this._ctx.getEc().equals(value)) {
                return this._ctx.getMc().getFlow().isSubmit();
            }
            if ("PC".equals(value) || this._ctx.getPc() != null && this._ctx.getPc().equals(value)) {
                return this._ctx.getMc().getPcFlow().isSubmit();
            }
        }
        return false;
    }

    public void setTmpId(long tmpId) {
        this.tmpId = tmpId;
    }

    public static Set<String> getLossAndCashflowAccountType(long modelId) {
        return (Set)GlobalCacheServiceHelper.getCommonCache().getOrLoad(Joiner.on((String)"_").join((Object)"getLossAndCashflowAccountSet", (Object)modelId, new Object[0]), () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model.id", "=", (Object)modelId));
            qfBuilder.add(new QFilter("accounttype", "in", Arrays.asList(AccountTypeEnum.LOSS.index, AccountTypeEnum.CASHFLOW.index)));
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number,accounttype", (QFilter[])qfBuilder.toArray());
            if (dys.size() > 0) {
                HashSet<String> accountTypeEnumSet = new HashSet<String>(dys.size());
                for (DynamicObject dy : dys) {
                    accountTypeEnumSet.add(dy.getString(NUMBER));
                }
                return accountTypeEnumSet;
            }
            return null;
        });
    }

    public static String getMemberNumber(String dimNumber, List<String> rowcols, List<String> rowcolMemNum) {
        int index = -1;
        int j = rowcols.size();
        for (int i = 0; i < j; ++i) {
            if (!dimNumber.equals(rowcols.get(i))) continue;
            index = i;
        }
        if (index != -1) {
            return rowcolMemNum.get(index);
        }
        return null;
    }

    private class BatchFormulaList {
        private List<AbstractFormula> acctFloatList = new ArrayList<AbstractFormula>();
        private long tmp;
        private int accountreclass;
        private String currency;
        private Sheet sheet;

        int size() {
            return this.acctFloatList.size();
        }

        BatchFormulaList(long tmp, int accountreclass, String currency, Sheet sheet) {
            this.tmp = tmp;
            this.accountreclass = accountreclass;
            this.currency = currency;
            this.sheet = sheet;
        }

        void add(AbstractFormula formula) {
            this.acctFloatList.add(formula);
            this.checkAndRun();
        }

        void addAll(Collection<? extends AbstractFormula> c) {
            this.acctFloatList.addAll(c);
            this.checkAndRun();
        }

        private void checkAndRun() {
            if (this.acctFloatList.size() >= OrgDataCollectService.this.dcsize) {
                this.run();
            }
        }

        private void run() {
            if (!this.acctFloatList.isEmpty()) {
                LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: begin calculateOtherFormula", OrgDataCollectService.this._ctx.getOrg(), OrgDataCollectService.this.tmpId));
                OrgDataCollectService.this.calculateOtherFormula(this.tmp, this.accountreclass, this.acctFloatList, this.currency, this.sheet);
                LOGGER.info(String.format("bcm_calculateByTemplate %s entity's template %s: end calculateOtherFormula", OrgDataCollectService.this._ctx.getOrg(), OrgDataCollectService.this.tmpId));
                this.acctFloatList.clear();
            }
        }
    }
}

