/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.refrence.CalcQueue;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.invest.model.PChildFormulaLogInfo;
import kd.fi.bcm.business.invest.sheet.formula.InvestFormulaParseHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.FormarResultServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AcctCollectConfigTypeEnum;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.parser.AntlrParser;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.parser.Parser;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.datacollect.DataCollectServiceHelper;
import kd.fi.bcm.spread.datacollect.ErrorMsg;
import kd.fi.bcm.spread.datacollect.SheetDataProvider;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;

public class ReportCalculateHelper {
    public static final String TRACESIGN = "datatrace";
    public static String RANGE = "range";
    private static final String SCENARIO = "scenario";
    private static final String YEAR = "year";
    private static final String PERIOD = "period";
    private static final String ORG = "org";
    public static final String FORMULA_FAIL_FLAG = "formula_fail";
    private static final Log LOGGER = LogFactory.getLog(ReportCalculateHelper.class);

    public static List<String> calculateSheet(Sheet sheet, ICalContext ctx) {
        return ReportCalculateHelper.calculateSheet(sheet, ctx, c -> true);
    }

    public static List<String> calculateSheet(Sheet sheet, ICalContext ctx, Function<Cell, Boolean> function) {
        return ReportCalculateHelper.calculateSheet(sheet, ctx, function, null);
    }

    public static List<String> calculateSheet(Sheet sheet, ICalContext ctx, Function<Cell, Boolean> function, Consumer<ErrorMsg> error) {
        long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        boolean iSDistZeroAndNull = ConfigServiceHelper.getBoolParam(ctx.getCubeNumber(), "isDistinguish0AndNull");
        boolean isStringCheck = ConfigServiceHelper.getBoolChildParam(modelId, "CM014", AcctCollectConfigTypeEnum.ISSTRINGCHECK.getNumber());
        boolean isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
        ctx.setProperty("isDistinguish0AndNull", iSDistZeroAndNull);
        CalculateService service = new CalculateService(ctx);
        service.setOpenTrace(isOpenTrace);
        service.setIgnoreError(isStringCheck);
        if (ctx.isFromInvest()) {
            service.setOpenTrace(false);
        } else {
            ctx.setExternalDataProvider(new SheetDataProvider(sheet));
        }
        ArrayList<String> cellAxis = new ArrayList<String>(10);
        HashMap es = new HashMap(16);
        Integer dataunit = (Integer)sheet.getUserObject("dataunit");
        HashMap<ExpressStatus, PChildFormulaLogInfo> pFormulaLogInfos = new HashMap<ExpressStatus, PChildFormulaLogInfo>(16);
        Consumer<Cell> consumer = cell -> {
            if (cell.hasFormula() && ((Boolean)function.apply((Cell)cell)).booleanValue()) {
                if (StringUtil.checkNumber((String)cell.getFormula())) {
                    BigDecimal formulaData = new BigDecimal(cell.getFormula());
                    Variant right = new Variant(Math.pow(10.0, dataunit.intValue()));
                    cell.setValue((Object)new Variant(formulaData).multiply(right).toBigDecimal());
                } else {
                    List pFormulaLogInfoList;
                    String forumla = cell.getFormula();
                    String axis = ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow());
                    cellAxis.add(axis);
                    es.put(axis, service.addCalculateExpress4Book(forumla, axis));
                    if (ctx.isFromInvest() && (pFormulaLogInfoList = (List)cell.getUserObject().get((Object)"PFormulaProcess")) != null) {
                        pFormulaLogInfoList.forEach(pFormulaLogInfo -> pFormulaLogInfo.getChildExpressMap().forEach((k, v) -> pFormulaLogInfos.put(service.addCalculateExpress4Book(v.getFormula(), axis, false), (PChildFormulaLogInfo)v)));
                    }
                }
            }
        };
        if (ctx.getProperty(RANGE) != null) {
            RangeModel rm = (RangeModel)ctx.getProperty(RANGE);
            sheet.iteratorRangeCells(rm.getY_start(), rm.getY_end(), rm.getX_start(), rm.getX_end(), consumer);
        } else {
            sheet.iteratorCells(consumer);
        }
        AntlrParser formalParser = new AntlrParser(service.getCalculateEngine().getBigfel());
        Map<String, String> logMsgMap = service.getLogMsg();
        ArrayList logMsgs = new ArrayList(10);
        ArrayList logTips = new ArrayList(16);
        Map paramIds = ReportCalculateHelper.collectLogParams(ctx.getCubeNumber(), ctx.getYear(), ctx.getPeriod(), ctx.getScenario(), ctx.getOrg());
        if (!cellAxis.isEmpty()) {
            service.batchCalculate();
            if (ctx.isFromInvest()) {
                pFormulaLogInfos.forEach((expressStatus, pFormulaLogInfo) -> {
                    pFormulaLogInfo.setFormula(service.trans2FormulaEexprss((ExpressStatus)expressStatus));
                    pFormulaLogInfo.setEvalExpress(service.trans2EvalExpress((ExpressStatus)expressStatus));
                    pFormulaLogInfo.setVal(service.evalExpress((ExpressStatus)expressStatus));
                });
            }
            Map<String, String> tipLogMsg = service.getTipLogMsg();
            cellAxis.forEach(arg_0 -> ReportCalculateHelper.lambda$calculateSheet$5(es, tipLogMsg, sheet, error, logMsgMap, ctx, (Parser)formalParser, logMsgs, paramIds, modelId, service, isStringCheck, iSDistZeroAndNull, isOpenTrace, arg_0));
        }
        if (!logMsgs.isEmpty()) {
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logMsgs.get(0)).getDynamicObjectType(), (Object[])logMsgs.toArray());
        }
        if (!logTips.isEmpty()) {
            BusinessDataWriter.save((IDataEntityType)((DynamicObject)logTips.get(0)).getDynamicObjectType(), (Object[])logTips.toArray());
        }
        service.clear();
        return cellAxis;
    }

    private static Map collectLogParams(String cube, String yearNum, String periodNum, String scenarioNum, String orgNum) {
        IDNumberTreeNode scenario = MemberReader.findScenaMemberByNum((String)cube, (String)scenarioNum);
        IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)cube, (String)yearNum);
        IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)cube, (String)periodNum);
        IDNumberTreeNode org = MemberReader.findEntityMemberByNum((String)cube, (String)orgNum);
        HashMap<String, Long> result = new HashMap<String, Long>(4);
        result.put(SCENARIO, scenario.getId());
        result.put(YEAR, fy.getId());
        result.put(PERIOD, period.getId());
        result.put(ORG, TreeStructureServiceHelper.getEntityBaseMemberId(org.getId()));
        return result;
    }

    private static /* synthetic */ void lambda$calculateSheet$5(Map es, Map tipLogMsg, Sheet sheet, Consumer error, Map logMsgMap, ICalContext ctx, Parser formalParser, List logMsgs, Map paramIds, long modelId, CalculateService service, boolean isStringCheck, boolean iSDistZeroAndNull, boolean isOpenTrace, String axis) {
        String parseExpr = ((ExpressStatus)es.get(axis)).getParseExpr();
        Point p = ExcelUtils.pos2Point((String)axis);
        if (tipLogMsg.containsKey(parseExpr)) {
            Cell cell = sheet.getCell(p.y, p.x);
            int cid = (Integer)cell.getUserObject("cid", (Object)0);
            if (error != null) {
                ErrorMsg errorMsg = new ErrorMsg(axis, cell.getFormula(), (String)tipLogMsg.get(parseExpr), cid);
                errorMsg.setType(DataCollectLogEnum.TIP.index);
                error.accept(errorMsg);
            }
        }
        if (!logMsgMap.isEmpty() && ConfigServiceHelper.getBoolParam(ctx.getCubeNumber(), "calErrorLogLevel")) {
            FelNode accts = formalParser.parse(parseExpr);
            Cell cell = sheet.getCell(p.y, p.x);
            int cid = (Integer)cell.getUserObject("cid", (Object)0);
            String logStr = (String)logMsgMap.get(accts.toString());
            if (StringUtils.isNotEmpty((String)logStr)) {
                logMsgs.add(DataCollectServiceHelper.getLog(cell.getFormula(), (Long)ctx.getProperty("templateId"), (Long)paramIds.get(ORG), cid, modelId, (Long)paramIds.get(PERIOD), (Long)paramIds.get(SCENARIO), (Long)paramIds.get(YEAR), logStr, axis));
            }
        }
        Object v = service.evalExpress((ExpressStatus)es.get(axis));
        if (isStringCheck || ctx.isFromInvest()) {
            StringBuffer sb = new StringBuffer();
            Cell cell = sheet.getCell(p.y, p.x);
            int cid = (Integer)cell.getUserObject("cid", (Object)0);
            if (ctx.isFromInvest() && v instanceof Throwable) {
                sb.append(((Throwable)v).getMessage());
            }
            if (((ExpressStatus)es.get(axis)).getException() == null) {
                try {
                    FelNode accts = formalParser.parse(parseExpr);
                    FormarResultServiceHelper.weakCheckFormar(accts, service, sb);
                }
                catch (Exception e) {
                    sb.append(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
                }
            }
            if (sb.length() > 0) {
                if (!isStringCheck && ctx.isFromInvest()) {
                    v = BigDecimal.ZERO;
                }
                if (error != null) {
                    error.accept(new ErrorMsg(axis, cell.getFormula(), sb.toString(), cid));
                }
            }
        }
        Cell cell = sheet.getCell(p.y, p.x);
        cell.removeUserObject(FORMULA_FAIL_FLAG);
        if (ctx.isFromInvest()) {
            String formula = service.trans2FormulaEexprssByHandler((ExpressStatus)es.get(axis));
            formula = formula.equals("null") ? ((ExpressStatus)es.get(axis)).getFormula() : formula;
            cell.setFormula(formula);
            formula = service.trans2EvalExpress((ExpressStatus)es.get(axis));
            cell.setUserObject("fp", (Object)formula);
            List pFormulaLogInfoList = (List)cell.getUserObject().remove((Object)"PFormulaProcess");
            if (pFormulaLogInfoList != null) {
                formula = (String)cell.getUserObject("fs", (Object)"");
                formula = formula + "\n" + InvestFormulaParseHelper.plantPFormulaLogInfoString(pFormulaLogInfoList);
                cell.setUserObject("fs", (Object)formula);
            }
            if (v instanceof CalcQueue) {
                v = ((CalcQueue)CalcQueue.class.cast(v)).getValue();
            } else if (v instanceof Throwable) {
                String msg = ResManager.loadKDString((String)"\u516c\u5f0f\u53d6\u6570\u5f02\u5e38\uff1a\u4f53\u7cfb%1$s\uff0c\u60c5\u666f%2$s\uff0c\u8d22\u5e74%3$s\uff0c\u671f\u95f4%4$s\uff0c\u5408\u5e76\u8282\u70b9%5$s\uff0c\u5e95\u7a3f%6$s\uff0c\u5355\u5143\u683c%7$s\u3002", (String)"ReportCalculateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]);
                String errorMsg = String.format(msg, ctx.getCubeNumber(), ctx.getScenario(), ctx.getYear(), ctx.getPeriod(), ctx.getOrg(), sheet.getSheetName(), axis);
                LOGGER.error(errorMsg, (Throwable)v);
                v = AdjustmentServiceHelper.toString_Adj((Throwable)v);
                cell.setUserObject(FORMULA_FAIL_FLAG, (Object)true);
                if (((String)v).getBytes().length > 1024) {
                    v = ((String)v).substring(0, 1024);
                }
                cell.setUserObject("fp", v);
            }
            cell.setValue(v);
        } else {
            DataTraceFrom dc;
            cell.setValue(v instanceof CalcQueue ? ((CalcQueue)CalcQueue.class.cast(v)).getValue() : v);
            if (cell.getValue() instanceof Number && !iSDistZeroAndNull && ((Number)cell.getValue()).doubleValue() == 0.0) {
                cell.setChangeVal(true);
            }
            if (isOpenTrace && (dc = service.getFormulaForTrace((ExpressStatus)es.get(axis))) != null) {
                sheet.getCell(p.y, p.x).setUserObject(TRACESIGN, (Object)dc);
            }
        }
    }
}

