/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.datacollect;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.VDataFormula;
import kd.fi.bcm.business.formula.calculate.XGetColSum;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.ExcRateFormula;
import kd.fi.bcm.business.formula.model.GetDimAttrFormula;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.PeriodFormula;
import kd.fi.bcm.business.formula.model.RefFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.formula.model.external.ExternalFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.DataCollectModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.spread.datacollect.FormulaChecker;
import kd.fi.bcm.spread.datacollect.OrgDCContext;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.DataAndJsonTranslator;
import kd.fi.bcm.spread.util.GZIPUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SpecialCalLogic {
    public static final Integer ENTITY_INDEX = 0;
    public static final Integer CURRENCY_INDEX = 4;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(SpecialCalLogic.class);

    public static void fixVFormulaHandle(ICalContext ctx, Map<String, String> dimNumMap, Map<String, String> dim2Number) {
        HashBasedTable exchangePeriod = HashBasedTable.create();
        HashMap periodAndYear4V = new HashMap(16);
        Long modelId = MemberReader.findModelIdByNum((String)ctx.getCubeNumber());
        boolean cm056 = ConfigServiceHelper.getBoolParam(modelId, "CM056");
        ctx.setFormulaHandle(f -> {
            if (f instanceof ExcRateFormula) {
                String currencyShortNumber;
                ArrayList<String> exixtnumber = new ArrayList<String>();
                HashMap<String, String> formulaDimNumber = new HashMap<String, String>(10);
                for (ParamItem item : f.getParamList()) {
                    String[] splitArr = VFormula.splitDimAndMemb(item.toString());
                    exixtnumber.add(splitArr[0].toLowerCase(Locale.ENGLISH));
                    formulaDimNumber.put(splitArr[0].toLowerCase(Locale.ENGLISH), splitArr[1]);
                }
                if (!exixtnumber.contains(DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH))) {
                    f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (String)dim2Number.get(DimTypesEnum.CURRENCY.getNumber().toLowerCase(Locale.ENGLISH))));
                    formulaDimNumber.put(DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH), "DC");
                    exixtnumber.add(DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH));
                }
                if (((String)formulaDimNumber.get(currencyShortNumber = DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH))).equals("DC")) {
                    long orgid = SpecialCalLogic.getOrgid(ctx, (String)dim2Number.get(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH)));
                    Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getCubeNumber(), orgid, (String)dim2Number.get(DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ENGLISH)), "DC", 0L, 0L);
                    f.getParamList().remove(exixtnumber.indexOf(DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH)));
                    f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (String)msg.p2));
                }
            } else if (f instanceof VFormula) {
                ArrayList<String> existnumber = new ArrayList<String>();
                HashMap<String, String> formulaDimNumber = new HashMap<String, String>(10);
                try {
                    SpecialCalLogic.convetVFormula(f);
                    for (ParamItem item : f.getParamList()) {
                        String[] splitArr = VFormula.splitDimAndMemb(item.toString());
                        existnumber.add(splitArr[0].toLowerCase(Locale.ENGLISH));
                        formulaDimNumber.put(splitArr[0].toLowerCase(Locale.ENGLISH), splitArr[1]);
                    }
                }
                catch (Exception e) {
                    f.setException((Exception)((Object)new InvalidParamException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"SpecialcalLogic_1", (String)"fi-bcm-business", (Object[])new Object[0]))));
                    log.error((Throwable)e);
                    return;
                }
                boolean isWithPeriod = existnumber.contains(DimTypesEnum.PERIOD.getShortNumber().toLowerCase(Locale.ENGLISH));
                String yearDimShortNum = DimTypesEnum.YEAR.getShortNumber();
                int yearIndex = existnumber.indexOf(yearDimShortNum.toLowerCase(Locale.ENGLISH));
                boolean isLastYear = false;
                isLastYear = yearIndex != -1 ? "LastYear".equalsIgnoreCase((String)formulaDimNumber.get(yearDimShortNum.toLowerCase(Locale.ENGLISH))) : "LastYear".equalsIgnoreCase((String)dimNumMap.get(yearDimShortNum));
                periodAndYear4V.put(f.getUUID(), new Pair((Object)isWithPeriod, (Object)isLastYear));
                List<String> oldProcess = Arrays.asList("IRpt", "CS");
                String processShortNum = DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH);
                if (oldProcess.contains(formulaDimNumber.get(processShortNum))) {
                    int index = existnumber.indexOf(processShortNum);
                    f.getParamList().remove(index);
                    f.getParamList().add(new ParamItem(DimTypesEnum.PROCESS.getShortNumber() + "." + "EIRpt"));
                    existnumber.remove(index);
                    existnumber.add(processShortNum);
                }
                dimNumMap.forEach((key, value) -> {
                    if (!existnumber.contains(key.toLowerCase(Locale.ENGLISH)) && dim2Number.get(value.toLowerCase(Locale.ENGLISH)) != null) {
                        f.getParamList().add(new ParamItem(key + "." + (String)dim2Number.get(value.toLowerCase(Locale.ENGLISH))));
                        existnumber.add(key.toLowerCase(Locale.ENGLISH));
                        formulaDimNumber.put(key.toLowerCase(Locale.ENGLISH), (String)dim2Number.get(value.toLowerCase(Locale.ENGLISH)));
                    }
                });
                if (cm056) {
                    ctx.setVFormulaPeriodHandle(formula -> SpecialCalLogic.dealPeriodBy056(modelId, formula, (HashBasedTable<String, String, String>)exchangePeriod, periodAndYear4V));
                }
            } else if (f instanceof RefFormula) {
                ((RefFormula)f).setDim2MemMap(Maps.newHashMap((Map)dim2Number));
            } else if (f instanceof ExternalFormula && f.getName().toLowerCase(Locale.ENGLISH).startsWith("acct")) {
                SpecialCalLogic.dealAccountForAcct(ctx, f);
            } else if (f instanceof PeriodFormula) {
                ((PeriodFormula)f).setCellMonth((String)dim2Number.get("period"));
                ((PeriodFormula)f).setRptMonth(ctx.getPeriod());
            } else if (f instanceof XGetColSum) {
                ((XGetColSum)f).setDimNumMap(dim2Number);
            } else if (f instanceof VDataFormula) {
                ((VDataFormula)f).setDimNumMap(dim2Number);
            }
        });
        SpecialCalLogic.fixCurYearAndPeriodHandle(ctx);
    }

    public static void convetVFormula(IFormula f) {
        String dims2mem;
        ParamList paramList = f.getParamList();
        if (paramList != null && paramList.size() == 1 && (dims2mem = SpecialCalLogic.getParam(f, "", 0)).indexOf(",") != -1) {
            ArrayList dim2MemList = Lists.newArrayList((Object[])dims2mem.split(","));
            for (int i = 0; i < dim2MemList.size(); ++i) {
                String param = (String)dim2MemList.get(i);
                if (StringUtils.isEmpty((CharSequence)param) || param.indexOf(46) == -1) {
                    f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570\u201c%s\u201d\u3002", (String)"VCalculate_1", (String)"fi-bcm-business", (Object[])new Object[0]), dims2mem))));
                    return;
                }
                if (i == 0) {
                    paramList.remove(i);
                    paramList.add(i, new ParamItem(param));
                    continue;
                }
                paramList.add(new ParamItem(param));
            }
        }
    }

    private static void dealPeriodBy056(long modelId, IFormula f, HashBasedTable<String, String, String> exchangePeriod, Map<String, Pair<Boolean, Boolean>> periodAndYear4V) {
        String exchangePeriodNum;
        Pair<Boolean, Boolean> periodAndYear = periodAndYear4V.remove(f.getUUID());
        if (((Boolean)periodAndYear.p1).booleanValue() || !((Boolean)periodAndYear.p2).booleanValue()) {
            return;
        }
        String periodNum = "";
        String sceneNum = "";
        ParamList paramList = f.getParamList();
        for (int i = 0; i < paramList.size(); ++i) {
            ParamItem item = (ParamItem)paramList.get(i);
            String[] splitArr = VFormula.splitDimAndMemb(item.toString());
            if (DimTypesEnum.PERIOD.getShortNumber().equalsIgnoreCase(splitArr[0])) {
                periodNum = splitArr[1];
                paramList.remove(item);
                continue;
            }
            if (!DimTypesEnum.SCENARIO.getShortNumber().equalsIgnoreCase(splitArr[0])) continue;
            sceneNum = splitArr[1];
        }
        String exchangePeriodForLastYear = periodNum;
        if (exchangePeriod.contains((Object)sceneNum, (Object)periodNum)) {
            exchangePeriodNum = (String)exchangePeriod.get((Object)sceneNum, (Object)periodNum);
            if (StringUtils.isNotEmpty((CharSequence)exchangePeriodNum)) {
                exchangePeriodForLastYear = exchangePeriodNum;
            }
        } else {
            exchangePeriodNum = ConfigServiceHelper.getExchangePeriodForLastYear(modelId, sceneNum, periodNum);
            if (StringUtils.isNotEmpty((CharSequence)exchangePeriodNum)) {
                exchangePeriodForLastYear = exchangePeriodNum;
            }
            exchangePeriod.put((Object)sceneNum, (Object)periodNum, (Object)exchangePeriodNum);
        }
        f.getParamList().add(new ParamItem(DimTypesEnum.PERIOD.getShortNumber() + "." + exchangePeriodForLastYear));
    }

    public static void dealAccountForAcct(ICalContext ctx, IFormula f) {
        if (f instanceof ExternalFormula && f.getName().toLowerCase(Locale.ENGLISH).startsWith("acct")) {
            String accountTypeStr;
            String orgStr;
            String accountBooksType = SpecialCalLogic.getParam(f, "", 1);
            String formulaOrg = SpecialCalLogic.getParam(f, "", 0);
            boolean hasEntity = StringUtils.isNotEmpty((CharSequence)formulaOrg);
            String string = orgStr = hasEntity ? formulaOrg : ctx.getOrg();
            if (StringUtils.isEmpty((CharSequence)accountBooksType) && StringUtils.isNotEmpty((CharSequence)(accountTypeStr = (String)ThreadCache.get((Object)("accountBookType" + orgStr), () -> {
                Long orgId = hasEntity ? MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)orgStr).getId() : ctx.getOrgId();
                return SpecialCalLogic.getAccountBookType(orgId);
            })))) {
                f.getParamList().remove(1);
                f.getParamList().add(1, new ParamItem(new StringExpr(accountTypeStr)));
            }
        }
    }

    private static String getAccountBookType(Long orgId) {
        Object accountType;
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"entitypart, entitypart.accounttype", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        String accountTypeStr = "";
        if (entity == null) {
            return accountTypeStr;
        }
        Object entitypart = entity.get("entitypart");
        if (entitypart != null && (accountType = ((DynamicObject)entitypart).get("accounttype")) != null) {
            accountTypeStr = ((DynamicObject)accountType).getString("number");
        }
        return accountTypeStr;
    }

    public static void fixGetAttrFormulaHandle(ICalContext ctx, SpreadManager spreadManager, Map<String, String> dim2Number) {
        Map dimensionShortNumber2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)ctx.getCubeNumber());
        Map<String, String> number2shortNum = dimensionShortNumber2NumberMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getValue(), e -> (String)e.getKey()));
        String orgNum = SpecialCalLogic.getNotLeafOrgNum(ctx, spreadManager);
        ctx.setFormulaHandle(f -> {
            SpecialCalLogic.fixGetAttrFormula(ctx, spreadManager, dim2Number, dimensionShortNumber2NumberMap, f);
            SpecialCalLogic.fixGetJLEntryFormula(spreadManager, dim2Number, dimensionShortNumber2NumberMap, number2shortNum, orgNum, f);
        });
    }

    private static String getNotLeafOrgNum(ICalContext ctx, SpreadManager spreadManager) {
        String orgNum = SpecialCalLogic.getEntityFilterDomainNumOrPage(spreadManager);
        return SpecialCalLogic.clearLeafOrg(ctx, orgNum);
    }

    private static String clearLeafOrg(ICalContext ctx, String orgNum) {
        if (StringUtils.isNotEmpty((CharSequence)orgNum)) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)orgNum);
            orgNum = IDNumberTreeNode.NotFoundTreeNode == entity || entity.isLeaf() ? "" : orgNum;
        }
        return orgNum;
    }

    private static void fixGetAttrFormula(ICalContext ctx, SpreadManager spreadManager, Map<String, String> dim2Number, Map<String, String> dimensionShortNumber2NumberMap, IFormula f) {
        if (f instanceof GetDimAttrFormula) {
            if ("DC".equals(dim2Number.get(DimTypesEnum.CURRENCY.getNumber()))) {
                try {
                    long orgid = SpecialCalLogic.getOrgid(ctx, dim2Number.get(DimTypesEnum.ENTITY.getNumber()));
                    Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getCubeNumber(), orgid, dim2Number.get(DimTypesEnum.PROCESS.getNumber()), "DC", 0L, 0L);
                    dim2Number.put(DimTypesEnum.CURRENCY.getNumber(), (String)msg.p2);
                }
                catch (Exception e) {
                    f.setException(e);
                    return;
                }
            }
            ((GetDimAttrFormula)f).setDim2MemMap(Maps.newHashMap(dim2Number));
            if (((ParamItem)((GetDimAttrFormula)f).getParamList().get(0)).getParam() instanceof ReferenceExpr) {
                List dimMemberList;
                Object userObject;
                String colrow = "";
                Point cellpoint = ExcelUtils.pos2Point((String)SpecialCalLogic.getParam(f, colrow, 0));
                Cell cell = null;
                List table = spreadManager.getBook().getSheet(0).getTable();
                List cols = (List)table.get(cellpoint.y);
                if (CollectionUtils.isEmpty((Collection)cols)) {
                    return;
                }
                cell = (Cell)cols.get(cellpoint.x);
                if (cell != null && (userObject = cell.getUserObject("KEY_DIM_FLAG")) != null && (dimMemberList = (List)userObject).size() == 1) {
                    HashMap map = Maps.newHashMap();
                    DimMember dimMember = (DimMember)dimMemberList.get(0);
                    String dimNum = dimMember.getDimension().getNumber();
                    for (Map.Entry<String, String> entry : dimensionShortNumber2NumberMap.entrySet()) {
                        if (!entry.getValue().equalsIgnoreCase(dimNum)) continue;
                        map.put("dimNum", entry.getKey());
                        break;
                    }
                    map.put("dimMemNum", dimMember.getNumber());
                    String name = dimMember.getName();
                    String simpleName = dimMember.getSimpleName();
                    if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)simpleName)) {
                        String entityNumberByDim = MemberReader.getEntityNumberByDim((String)ctx.getCubeNumber(), (String)dimNum);
                        QFilter qFilter = new QFilter("model.number", "=", (Object)ctx.getCubeNumber());
                        qFilter.and("number", "=", (Object)dimMember.getNumber());
                        qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                        DynamicObjectCollection dy = QueryServiceHelper.query((String)entityNumberByDim, (String)"name, simplename", (QFilter[])qFilter.toArray());
                        if (dy.size() > 0) {
                            name = ((DynamicObject)dy.get(0)).getString("name");
                            simpleName = ((DynamicObject)dy.get(0)).getString("simplename");
                        }
                    }
                    map.put("dimMemName", name);
                    map.put("simplename", simpleName);
                    ((GetDimAttrFormula)f).setColRowDim(map);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void fixGetJLEntryFormula(SpreadManager spreadManager, Map<String, String> dim2Number, Map<String, String> dimensionShortNumber2NumberMap, Map<String, String> number2shortNum, String orgNum, IFormula f) {
        if (f instanceof GetJLEntryFormula) {
            ParamList paramList = f.getParamList();
            String firstParam = SpecialCalLogic.getParam(f, "", 0);
            if (StringUtils.isEmpty((CharSequence)firstParam)) {
                paramList.set(0, new ParamItem(orgNum));
            }
            String thirdParam = SpecialCalLogic.getParam(f, "", 2);
            Boolean flag = false;
            String[] splitDim = thirdParam.split(",");
            Cell cell = null;
            List table = spreadManager.getBook().getSheet(0).getTable();
            HashMap dim2memMap = new HashMap(10);
            for (int i = 0; i < splitDim.length; ++i) {
                String[] dim2Ref;
                void var16_17;
                Map<String, String> map;
                String dim2memParam = splitDim[i];
                Map<String, String> map2 = SpecialCalLogic.splitDimAndNum(dim2memParam, "@");
                if (map2.size() == 0 && (map = SpecialCalLogic.splitDimAndNum(dim2memParam, ".")).size() == 0) {
                    Map<String, String> map3 = SpecialCalLogic.splitDimAndNum(dim2memParam, "|");
                }
                dim2memMap.putAll(var16_17);
                if (!splitDim[i].contains("|") || (dim2Ref = dim2memParam.split("\\|")).length != 2) continue;
                String ref = dim2Ref[1];
                String dimShortNum = dim2Ref[0];
                String dimNum = dimensionShortNumber2NumberMap.get(dimShortNum);
                if (StringUtils.isEmpty((CharSequence)dimNum)) continue;
                try {
                    Object userObject;
                    Expression parse = ExcelFormulaPaserHelper.parse((String)ref);
                    if (!(parse instanceof ReferenceExpr)) continue;
                    ReferenceExpr refExp = (ReferenceExpr)parse;
                    List cols = (List)table.get(refExp.getRow());
                    if (CollectionUtils.isNotEmpty((Collection)cols)) {
                        cell = (Cell)cols.get(refExp.getCol());
                    }
                    if (cell == null || !((userObject = cell.getUserObject("KEY_DIM_FLAG")) instanceof List)) continue;
                    List dimMemberList = (List)userObject;
                    for (DimMember dimMember : dimMemberList) {
                        String join;
                        if (!dimNum.equals(dimMember.getDimension().getNumber())) continue;
                        String number = dimMember.getNumber();
                        if (StringUtils.isNotEmpty((CharSequence)number) && number.contains(".")) {
                            number = "[" + number + "]";
                        }
                        splitDim[i] = join = String.join((CharSequence)".", dimShortNum, number);
                        flag = true;
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            List dim2memList = Arrays.stream(splitDim).collect(Collectors.toList());
            for (Map.Entry entry : dim2Number.entrySet()) {
                if (dim2memMap.containsKey(number2shortNum.get(entry.getKey()))) continue;
                String number = (String)entry.getValue();
                if (StringUtils.isNotEmpty((CharSequence)number) && number.contains(".")) {
                    number = "[" + number + "]";
                }
                dim2memList.add(String.join((CharSequence)".", number2shortNum.get(entry.getKey()), number));
                flag = true;
            }
            if (flag.booleanValue()) {
                String newThirdParam = String.join((CharSequence)",", dim2memList);
                paramList.set(2, new ParamItem(new StringExpr(newThirdParam)));
            }
        }
    }

    private static String getEntityFilterDomainNumOrPage(SpreadManager spreadManager) {
        List dimensions = spreadManager.getFilter().getFilterDomain().getDimensions();
        String orgNum = SpecialCalLogic.getEntityNumByDims(dimensions);
        if (StringUtils.isEmpty((CharSequence)orgNum)) {
            List pageDims = spreadManager.getFilter().getPageDomain().getDimensions();
            orgNum = SpecialCalLogic.getEntityNumByDims(pageDims);
        }
        return orgNum;
    }

    private static String getEntityNumByDims(List<IDimension> dimensions) {
        String orgNum = "";
        for (IDimension dimension : dimensions) {
            if (!DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(dimension.getNumber())) continue;
            IDimMember iDimMember = (IDimMember)dimension.getMembers().get(0);
            if (iDimMember == null) break;
            orgNum = iDimMember.getNumber();
            break;
        }
        return orgNum;
    }

    private static Map<String, String> splitDimAndNum(String dim2memParam, String reg) {
        HashMap<String, String> dim2MemMap = new HashMap<String, String>(1);
        if (dim2memParam.contains(reg)) {
            int first = dim2memParam.indexOf(reg);
            String dim = dim2memParam.substring(0, first);
            String member = dim2memParam.substring(first + 1);
            dim2MemMap.put(dim, member);
            return dim2MemMap;
        }
        return dim2MemMap;
    }

    private static void fixCurYearAndPeriodHandle(ICalContext ctx) {
        ctx.setDefaultParamHandle(f -> {
            if (f instanceof ExcRateFormula) {
                SpecialCalLogic.fixYearAndPeriod(f, ctx);
            } else if (f instanceof VFormula) {
                ArrayList<String> existnumber = new ArrayList<String>(16);
                HashMap<String, String> famulaDimNumber = new HashMap<String, String>(10);
                try {
                    for (ParamItem item : f.getParamList()) {
                        String[] splitArr = VFormula.splitDimAndMemb(item.toString());
                        existnumber.add(splitArr[0].toLowerCase(Locale.ENGLISH));
                        famulaDimNumber.put(splitArr[0].toLowerCase(Locale.ENGLISH), splitArr[1]);
                    }
                }
                catch (Exception e) {
                    f.setException(e);
                    log.error((Throwable)e);
                    return;
                }
                String processShortNum = DimTypesEnum.PROCESS.getShortNumber().toLowerCase(Locale.ENGLISH);
                String currencyShowNumber = DimTypesEnum.CURRENCY.getShortNumber().toLowerCase(Locale.ENGLISH);
                if (existnumber.contains(currencyShowNumber)) {
                    int index = existnumber.indexOf(currencyShowNumber);
                    String currencyNumber = (String)famulaDimNumber.get(currencyShowNumber);
                    if ("EC".equals(currencyNumber) || "DC".equals(currencyNumber)) {
                        String orgnum = (String)famulaDimNumber.get(DimTypesEnum.ENTITY.getShortNumber().toLowerCase(Locale.ENGLISH));
                        String process = (String)famulaDimNumber.get(processShortNum);
                        if (orgnum != null) {
                            try {
                                long orgId = SpecialCalLogic.getOrgid(ctx, orgnum);
                                Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getCubeNumber(), orgId, process, currencyNumber, 0L, 0L);
                                f.getParamList().remove(index);
                                f.getParamList().add(new ParamItem(DimTypesEnum.CURRENCY.getShortNumber() + "." + (String)msg.p2));
                            }
                            catch (Exception e) {
                                f.setException(e);
                                return;
                            }
                        }
                    }
                }
                SpecialCalLogic.fixYearAndPeriod(f, ctx);
            } else if (f instanceof RefFormula) {
                String curNum = ctx.getCurrency();
                curNum = SpecialCalLogic.getParam(f, curNum, CURRENCY_INDEX);
                Map<String, String> dim2Number = ((RefFormula)f).getDim2MemMap();
                String orgnum = dim2Number.get(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH));
                orgnum = SpecialCalLogic.getParam(f, orgnum, ENTITY_INDEX);
                if ("EC".equals(curNum) || "DC".equals(curNum)) {
                    String processNum = dim2Number.get(DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ENGLISH));
                    if (orgnum != null && processNum != null) {
                        try {
                            long orgid = SpecialCalLogic.getOrgid(ctx, orgnum);
                            Pair<String, String> msg = TransMemberUtil.transOrgAndCurbyOrgId(ctx.getCubeNumber(), orgid, processNum, curNum, 0L, 0L);
                            f.getParamList().remove(4);
                            f.getParamList().add(4, new ParamItem(new StringExpr((String)msg.p2)));
                        }
                        catch (Exception e) {
                            f.setException(e);
                        }
                    }
                }
            }
        });
    }

    private static long getOrgid(ICalContext ctx, String orgnum) {
        Long id;
        String longorgnum = "";
        String orgpnumber = (String)ctx.getProperty("orgpnumber");
        if (orgnum.contains("_")) {
            longorgnum = orgnum;
        } else if (StringUtils.isNotEmpty((CharSequence)orgpnumber)) {
            longorgnum = orgpnumber + "_" + orgnum;
        }
        IDNumberTreeNode entityMemberByNum = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)longorgnum);
        if (IDNumberTreeNode.NotFoundTreeNode.equals(entityMemberByNum)) {
            entityMemberByNum = MemberReader.findEntityMemberByNum((String)ctx.getCubeNumber(), (String)orgnum);
        }
        if ((id = entityMemberByNum.getId()) == 0L || id == -1L) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff1a%s\u3002", (String)"SpecialcalLogic_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgnum));
        }
        return id;
    }

    public static String getParam(IFormula f, String paramNum, int index) {
        ParamItem paramItem = (ParamItem)f.getParamList().get(index);
        if (paramItem != null && StringUtils.isNotEmpty((CharSequence)paramItem.toString())) {
            paramNum = paramItem.getParam() instanceof StringExpr ? ((StringExpr)paramItem.getParam()).getValue() : paramItem.getParam().toString();
        }
        return paramNum;
    }

    private static boolean fixYearAndPeriod(IFormula f, ICalContext ctx) {
        String yearmem = "";
        String preiodmem = "";
        for (int i = 0; i < f.getParamList().size(); ++i) {
            ParamItem item = (ParamItem)f.getParamList().get(i);
            String[] splitArr = VFormula.splitDimAndMemb(item.toString());
            if (DimTypesEnum.YEAR.getShortNumber().equalsIgnoreCase(splitArr[0])) {
                yearmem = splitArr[1];
                f.getParamList().remove(item);
                --i;
                continue;
            }
            if (!DimTypesEnum.PERIOD.getShortNumber().equalsIgnoreCase(splitArr[0])) continue;
            preiodmem = splitArr[1];
            f.getParamList().remove(item);
            --i;
        }
        if (StringUtils.isNotEmpty((CharSequence)yearmem)) {
            if ("CurrentYear".equals(yearmem)) {
                yearmem = ctx.getYear();
            } else if ("LastYear".equals(yearmem)) {
                Optional year = PeriodUtils.getLastYear((String)ctx.getCubeNumber(), (String)ctx.getYear());
                if (year.isPresent()) {
                    yearmem = (String)year.get();
                } else {
                    f.getParamList().add(new ParamItem("" + DimTypesEnum.YEAR.getShortNumber() + "." + yearmem + ""));
                    f.getParamList().add(new ParamItem("" + DimTypesEnum.PERIOD.getShortNumber() + "." + preiodmem + ""));
                    return false;
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)preiodmem)) {
            if ("CurrentPeriod".equals(preiodmem)) {
                preiodmem = ctx.getPeriod();
            } else if ("LastPeriod".equals(preiodmem)) {
                String curfy = StringUtils.isEmpty((CharSequence)yearmem) ? ctx.getYear() : yearmem;
                String[] yearandperiod = PeriodUtils.getLastPeriodIncludeYear((String)ctx.getCubeNumber(), (String)curfy, (String)ctx.getPeriod(), (boolean)true);
                if (yearandperiod[0] == null) {
                    f.getParamList().add(new ParamItem("" + DimTypesEnum.YEAR.getShortNumber() + "." + yearmem + ""));
                    f.getParamList().add(new ParamItem("" + DimTypesEnum.PERIOD.getShortNumber() + "." + preiodmem + ""));
                    return false;
                }
                yearmem = yearandperiod[0];
                preiodmem = yearandperiod[1];
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)yearmem)) {
            f.getParamList().add(new ParamItem("" + DimTypesEnum.YEAR.getShortNumber() + "." + yearmem + ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)preiodmem)) {
            f.getParamList().add(new ParamItem("" + DimTypesEnum.PERIOD.getShortNumber() + "." + preiodmem + ""));
        }
        if (ctx.getVFormulaPeriodHandle() != null) {
            ctx.getVFormulaPeriodHandle().handle(f);
        }
        return true;
    }

    public static Map<String, String> getDim2NumberLowCase(DataCollectModel dataCollectModel, long tid, String orgNum) {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = tid + "||" + orgNum;
        if (dataCollectModel.getIdMaps().containsKey(key)) {
            Map<String, String> m = dataCollectModel.getIdMaps().get(key);
            for (Map.Entry<String, String> e : m.entrySet()) {
                if (DimTypesEnum.CURRENCY.getNumber().equals(e.getKey()) && "EC".equals(e.getValue())) {
                    map.put(e.getKey().toLowerCase(Locale.ENGLISH), MemberReader.findEntityMemberByNum((String)dataCollectModel.getModelDy(), (String)orgNum).getCurrency());
                    continue;
                }
                map.put(e.getKey().toLowerCase(Locale.ENGLISH), e.getValue());
            }
        }
        return map;
    }

    public static Map<String, String> getDim2NumberLowCase(OrgDCContext ctx, long tid, String orgNum) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ctx.getComMemMaps().containsKey(tid)) {
            Map<String, String> m = ctx.getComMemMaps().get(tid);
            for (Map.Entry<String, String> e : m.entrySet()) {
                if (DimTypesEnum.CURRENCY.getNumber().equals(e.getKey()) && "EC".equals(e.getValue())) {
                    map.put(e.getKey().toLowerCase(Locale.ENGLISH), MemberReader.findEntityMemberByNum((String)ctx.getModelNum(), (String)orgNum).getCurrency());
                    continue;
                }
                map.put(e.getKey().toLowerCase(Locale.ENGLISH), e.getValue());
            }
        }
        return map;
    }

    public static void replaceOrgFormula(Collection<AbstractFormula> allformulas, Sheet sheet) {
        HashMap formula = new HashMap(16);
        allformulas.forEach(f -> {
            if (f.getRowcolMemNum().length > 0) {
                formula.put(SpecialCalLogic.getKey(f), f.getFormulaStr());
            }
        });
        sheet.iteratorCells(c -> {
            String key;
            if (c.isMdDataDomain() && formula.containsKey(key = SpecialCalLogic.getKey(c))) {
                c.setFormula((String)formula.get(key));
            }
        });
    }

    public static List<Cell> loadMyTemplateFormulasAndLocks(SpreadManager sm, long modelId, long templateId, long orgId, boolean isWithParent) {
        ArrayList<Cell> cells = new ArrayList<Cell>(16);
        Sheet sheet = sm.getBook().getSheet(0);
        if (sheet.getMaxCellId() == -1) {
            return cells;
        }
        IDNumberTreeNode numberTreeNode = MemberReader.findEntityMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)orgId);
        boolean self = ConfigServiceHelper.getBoolChildParam(modelId, "isSupportNewMytemplate", "self");
        Map<Integer, Object> orgCellFormulas = SpecialCalLogic.getOrgCellFormulasAndLocks(numberTreeNode, modelId, templateId, true, isWithParent && !self);
        Map<Integer, Object> orgCellLocks = SpecialCalLogic.getOrgCellFormulasAndLocks(numberTreeNode, modelId, templateId, false, isWithParent && !self);
        if (orgCellFormulas.isEmpty() && orgCellLocks.isEmpty()) {
            return cells;
        }
        sheet.iteratorCells(cell -> {
            Integer cellId = cell.getCellId();
            if (cellId != -1) {
                boolean isExit = false;
                if (orgCellFormulas.get(cellId) != null) {
                    cell.setFormula(orgCellFormulas.get(cellId).toString());
                    isExit = true;
                }
                if (orgCellLocks.get(cellId) != null) {
                    cell.setLock(((Boolean)orgCellLocks.get(cellId)).booleanValue());
                    isExit = true;
                }
                if (isExit) {
                    cells.add((Cell)cell);
                }
            }
        });
        return cells;
    }

    public static String dealSpreadJson(List<Cell> cells, String sheetname, String json) {
        String ssjson = JsonSerializerUtil.uncompress((String)json);
        JSONObject obj = JSONObjectUtil.parseObjectOrder((String)ssjson);
        JSONObject dataTable = DataAndJsonTranslator.getDataTable(obj, sheetname);
        FormulaChecker formulaChecker = new FormulaChecker();
        for (Cell c : cells) {
            JSONObject cell;
            if (c.hasFormula() && !formulaChecker.checkIsOnlyExcel(c.getFormula()) && c.getUserObject("locked") == null) continue;
            JSONObject rowObject = (JSONObject)dataTable.get((Object)(c.getRow() + ""));
            if (rowObject == null) {
                rowObject = new JSONObject();
                dataTable.put(c.getRow() + "", (Object)rowObject);
            }
            if ((cell = (JSONObject)rowObject.get((Object)(c.getCol() + ""))) == null) {
                cell = new JSONObject();
                rowObject.put(c.getCol() + "", (Object)cell);
            }
            if (c.getFormula() != null) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)c.getFormula())) {
                    cell.remove((Object)"formula");
                } else {
                    cell.put("formula", (Object)c.getFormula());
                }
                cell.put("value", (Object)0);
            }
            if (c.getUserObject("locked") == null) continue;
            cell.put("locked", (Object)c.isLock());
        }
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)obj.toJSONString()));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    private static Map<Integer, Object> getOrgCellFormulasAndLocks(IDNumberTreeNode numberTreeNode, long modelId, long templateId, boolean isFormula, boolean isNeedParent) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("template", "=", (Object)templateId);
        ArrayList<String> orgList = new ArrayList<String>(16);
        if (isNeedParent) {
            String[] split = numberTreeNode.getLongNumber().split("!");
            orgList.addAll(Arrays.asList(split));
            qFilter.and("orgnumber", "in", orgList);
        } else {
            qFilter.and("orgnumber", "=", (Object)numberTreeNode.getNumber());
        }
        String selecctPros = "";
        String entityName = "";
        if (isFormula) {
            selecctPros = "cell,formula,orgnumber";
            entityName = "bcm_cellformula";
        } else {
            selecctPros = "cell,lockstatus,orgnumber";
            entityName = "bcm_mytemplate_celllock";
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selecctPros, (QFilter[])qFilter.toArray());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return new HashMap<Integer, Object>(16);
        }
        HashMap<Integer, Object> result = new HashMap<Integer, Object>(dynamicObjects.size());
        HashBasedTable form2key2DTProps = HashBasedTable.create();
        String finalEntityName = entityName;
        if (isNeedParent) {
            Map orgCellFormula = dynamicObjects.stream().collect(Collectors.groupingBy(arg_0 -> SpecialCalLogic.lambda$getOrgCellFormulasAndLocks$11((Table)form2key2DTProps, finalEntityName, arg_0), Collectors.toList()));
            for (String org : orgList) {
                if (orgCellFormula.get(org) == null || orgCellFormula.get(org).isEmpty()) continue;
                for (DynamicObject dy : orgCellFormula.get(org)) {
                    result.put(dy.getInt(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, entityName, "cell", dy)), isFormula ? dy.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, entityName, "formula", dy)) : Boolean.valueOf(dy.getBoolean(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, entityName, "lockstatus", dy))));
                }
            }
        } else {
            dynamicObjects.forEach(arg_0 -> SpecialCalLogic.lambda$getOrgCellFormulasAndLocks$12(result, (Table)form2key2DTProps, finalEntityName, isFormula, arg_0));
        }
        return result;
    }

    private static String getKey(AbstractFormula formula) {
        return Joiner.on((String)"|").join((Object[])formula.getRowcolMemNum());
    }

    private static String getKey(Cell cell) {
        ArrayList mems = new ArrayList(10);
        cell.getMemberFromUserObject().forEach(m -> mems.add(m.getNumber()));
        return Joiner.on((String)"|").join(mems);
    }

    private static /* synthetic */ void lambda$getOrgCellFormulasAndLocks$12(Map result, Table form2key2DTProps, String finalEntityName, boolean isFormula, DynamicObject e) {
        result.put(e.getInt(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, finalEntityName, "cell", e)), isFormula ? e.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, finalEntityName, "formula", e)) : Boolean.valueOf(e.getBoolean(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, finalEntityName, "lockstatus", e))));
    }

    private static /* synthetic */ String lambda$getOrgCellFormulasAndLocks$11(Table form2key2DTProps, String finalEntityName, DynamicObject e) {
        return e.getString(TemplateUtil.getDTProperty((Table<String, String, IDataEntityProperty>)form2key2DTProps, finalEntityName, "orgnumber", e));
    }
}

