/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.TemplateServiceHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.DimmensionMappingEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.datacollect.AnalysisFormulaHandle;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import org.apache.commons.lang.ObjectUtils;

public class AnalysisFormulaUtil {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AnalysisFormulaUtil.class);
    private static final String NUMBER = "number";
    private static final int size = 5000;

    public static BasePointInfo getBasePointInfoByArea(TemplateModel templateModel, String area) {
        String data = templateModel.getRptData();
        SpreadManager spmodel = JsonSerializerUtil.toSpreadManager((String)data);
        BasePointInfo base = null;
        for (PositionInfo positionInfo : spmodel.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                String spreadArea = basePointInfo.getOriginalDynaRange();
                if (!SpreadAreaUtil.isInArea((String)area, (String)spreadArea)) continue;
                base = basePointInfo;
                break;
            }
            if (base == null) continue;
            break;
        }
        return base;
    }

    public static Map<String, Set<String>> getFloatDimmembMap(long tempId, String area, Map<String, Long> dim2memId) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        TemplateModel templateModel = TemplateServiceHelper.getTemplateModelById(tempId);
        BasePointInfo base = AnalysisFormulaUtil.getBasePointInfoByArea(templateModel, area);
        if (base != null) {
            long modelId = templateModel.getModelId();
            for (BasePointInnerLineInfo info : base.getBasePointInnerLineInfo()) {
                if (!info.isFloated()) continue;
                List scope = info.getDynaMembScopes();
                if (scope.isEmpty()) {
                    AnalysisFormulaUtil.setDefaultScope(modelId, info, scope);
                }
                HashSet numbers = new HashSet(16);
                for (DynaMembScopeInfo scinfo : scope) {
                    String number = scinfo.getMember().getNumber();
                    long memberId = ((DimMember)scinfo.getMember()).getId();
                    String uqCode = scinfo.getMember().getDimension().getUqCode();
                    if ("$Cur".equals(number)) {
                        memberId = dim2memId.get(scinfo.getMember().getDimension().getNumber());
                        IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)uqCode, (Long)memberId);
                        number = member.getNumber();
                    }
                    new MembRangeItem(uqCode, (Long)memberId, number, scinfo.getRangeId(), scinfo.isCustom(), (Object)modelId).matchItems(c -> numbers.add(c.number));
                }
                map.put(info.getDimension().getNumber(), numbers);
            }
        }
        return map;
    }

    public static Map<String, List<DynaMembScopeInfo>> getFloatDimmScope(TemplateModel templateModel, String area) {
        HashMap<String, List<DynaMembScopeInfo>> map = new HashMap<String, List<DynaMembScopeInfo>>(16);
        BasePointInfo base = AnalysisFormulaUtil.getBasePointInfoByArea(templateModel, area);
        if (base != null) {
            for (BasePointInnerLineInfo info : base.getBasePointInnerLineInfo()) {
                if (!info.isFloated()) continue;
                List scope = info.getDynaMembScopes();
                map.put(info.getDimension().getNumber(), scope);
            }
        }
        return map;
    }

    public static Map<String, List<String>> getFloatDim2ParamMap(long modelId) {
        QFBuilder builder = new QFBuilder("model", "=", (Object)modelId);
        builder.add("isfloat", "=", (Object)Character.valueOf(DimmensionMappingEnum.FORMULA.getIndex()));
        DynamicObjectCollection dimensionMap = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.number, commonassist,formula", (QFilter[])builder.toArray());
        HashMap<String, List<String>> dim2params = new HashMap<String, List<String>>(10);
        for (DynamicObject dy : dimensionMap) {
            String[] split;
            String commonassist = dy.getString("commonassist");
            if (!commonassist.contains("|") || (split = commonassist.split("\\|")).length != 2) continue;
            String param = split[1];
            dim2params.computeIfAbsent(dy.getString("dimension.number"), e -> new ArrayList(10)).add(param);
        }
        return dim2params;
    }

    public static Table<String, String, String> getParam2BcmDim(long modelId) {
        QFBuilder builder = new QFBuilder("model", "=", (Object)modelId);
        builder.add("isfloat", "=", (Object)Character.valueOf(DimmensionMappingEnum.FORMULA.getIndex()));
        DynamicObjectCollection dimensionMap = QueryServiceHelper.query((String)"bcm_dimensionmapnew", (String)"dimension.number, commonassist,formula", (QFilter[])builder.toArray());
        HashBasedTable table = HashBasedTable.create();
        for (DynamicObject dy : dimensionMap) {
            String[] split;
            String commonassist = dy.getString("commonassist");
            if (!commonassist.contains("|") || (split = commonassist.split("\\|")).length != 2) continue;
            String param = split[1];
            table.put((Object)dy.getString("formula").toLowerCase(), (Object)param, (Object)dy.getString("dimension.number"));
        }
        return table;
    }

    public static void setDefaultScope(long modelId, BasePointInnerLineInfo info, List<DynaMembScopeInfo> scope) {
        DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber(modelId, info.getDimension().getNumber(), info.getDimension().getUqCode());
        DimMember mem = new DimMember(info.getDimension().getName(), info.getDimension().getNumber(), "", info.getDimension());
        mem.setId(member.getLong("id"));
        scope.add(new DynaMembScopeInfo((IDimMember)mem, RangeEnum.VALUE_50.getValue()));
    }

    public static void generateFloatAcctDy(String acct, Pair<List<String>, List<String>> pair) {
        try {
            Expression exp = ExcelFormulaPaserHelper.parse((String)acct);
            AnalysisFormulaUtil.generateFloatAcctDyByExpression(exp, pair);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static Pair<Map<String, List<String>>, List<String>> getFormulaDimPairByCache(String acct) {
        return (Pair)ThreadCache.get((Object)acct, () -> AnalysisFormulaUtil.getFormulaDimPair(acct));
    }

    public static Pair<Map<String, List<String>>, List<String>> getFormulaDimPair(String acct) {
        Pair pair = Pair.onePair(new HashMap(10), (Object)Lists.newArrayList());
        Expression exp = AnalysisFormulaUtil.parseExpression(acct);
        AnalysisFormulaUtil.handleExpression(exp, e -> {
            FunctionExpr functionExpr = (FunctionExpr)e;
            String funcionName = functionExpr.getFuncionName().toLowerCase(Locale.ENGLISH);
            if (funcionName.startsWith("acct") || DataCollectUtil.getCanBatchFormulaNums().contains(funcionName)) {
                List<String> paramNumbers = DataCollectUtil.getFormualParamNumsByFormula(funcionName);
                List parameters = functionExpr.getParameters();
                if (parameters == null || parameters.isEmpty() || paramNumbers == null || paramNumbers.isEmpty() || parameters.size() > paramNumbers.size()) {
                    return;
                }
                for (int i = 0; i < parameters.size(); ++i) {
                    String floatParam;
                    Object params;
                    String param = parameters.get(i).toString();
                    if (param.indexOf("|@") != -1) {
                        params = param.split("\\|");
                        for (int j = 0; j < ((String[])params).length; ++j) {
                            if (!params[j].contains("@") || j <= 0 || ((List)pair.p2).contains(params[j - 1])) continue;
                            ((List)pair.p2).add(params[j - 1]);
                        }
                        continue;
                    }
                    if (param.indexOf("@") == -1 || (params = ((Map)pair.p1).computeIfAbsent(funcionName, p -> new ArrayList(10))).contains(floatParam = paramNumbers.get(i))) continue;
                    params.add(floatParam);
                }
            }
        });
        return pair;
    }

    public static Expression parseExpression(String acct) {
        Expression exp = (Expression)ThreadCache.get((Object)(acct + "expression"), () -> {
            try {
                return ExcelFormulaPaserHelper.parse((String)acct);
            }
            catch (Exception e) {
                return new StringExpr(String.format(ResManager.loadKDString((String)"\u516c\u5f0f%1$s\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s\u3002", (String)"AbstractFormulaHandler_1", (String)"fi-bcm-business", (Object[])new Object[0]), acct, e.getMessage()));
            }
        });
        return exp;
    }

    public static void generateFloatAcctDyByExpression(Expression exp, Pair<List<String>, List<String>> pair) {
        if (exp instanceof UnaryOperationExpr) {
            AnalysisFormulaUtil.generateFloatAcctDyByExpression(((UnaryOperationExpr)exp).getOperand(), pair);
        } else if (exp instanceof BinaryOperationExpr) {
            Expression leftExp = ((BinaryOperationExpr)exp).getLeft();
            Expression rightExp = ((BinaryOperationExpr)exp).getRight();
            AnalysisFormulaUtil.generateFloatAcctDyByExpression(leftExp, pair);
            AnalysisFormulaUtil.generateFloatAcctDyByExpression(rightExp, pair);
        } else if (exp instanceof FunctionExpr) {
            ExcelFormulaPaserHelper.walk((Expression)exp, e -> {
                if (e instanceof BinaryOperationExpr) {
                    AnalysisFormulaUtil.generateFloatAcctDyByExpression(e, pair);
                } else if (e instanceof FunctionExpr && ((FunctionExpr)e).getFuncionName().startsWith("ACCT")) {
                    String[] strs;
                    String acctStr = e.toString().replace("\"", "");
                    acctStr = acctStr.replace("[", "");
                    acctStr = acctStr.replace("]", "");
                    acctStr = acctStr.replace(")", "");
                    acctStr = acctStr.replace(" ", "");
                    for (String str : strs = acctStr.split(",")) {
                        if (!str.contains("@")) continue;
                        String[] params = str.split("\\|");
                        for (int i = 0; i < params.length; ++i) {
                            if (!params[i].contains("@") || i <= 0 || ((List)pair.p2).contains(params[i - 1])) continue;
                            ((List)pair.p1).add(params[i - 1] + "|" + params[i]);
                            ((List)pair.p2).add(params[i - 1]);
                        }
                    }
                }
            });
        }
    }

    public static void handleExpression(Expression exp, Consumer<Expression> consumer) {
        if (exp instanceof UnaryOperationExpr) {
            AnalysisFormulaUtil.handleExpression(((UnaryOperationExpr)exp).getOperand(), consumer);
        } else if (exp instanceof BinaryOperationExpr) {
            Expression leftExp = ((BinaryOperationExpr)exp).getLeft();
            Expression rightExp = ((BinaryOperationExpr)exp).getRight();
            AnalysisFormulaUtil.handleExpression(leftExp, consumer);
            AnalysisFormulaUtil.handleExpression(rightExp, consumer);
        } else if (exp instanceof FunctionExpr) {
            ExcelFormulaPaserHelper.walk((Expression)exp, e -> {
                if (e instanceof BinaryOperationExpr) {
                    AnalysisFormulaUtil.handleExpression(e, consumer);
                } else if (e instanceof FunctionExpr) {
                    consumer.accept(e);
                }
            });
        }
    }

    public static void descartes(List<List<String>> dimvalue, List<List<String>> result, int layer, List<String> curList) {
        block7: {
            block6: {
                if (layer >= dimvalue.size() - 1) break block6;
                if (dimvalue.get(layer).size() == 0) {
                    AnalysisFormulaUtil.descartes(dimvalue, result, layer + 1, curList);
                } else {
                    for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                        ArrayList<String> list = new ArrayList<String>(curList);
                        list.add(dimvalue.get(layer).get(i));
                        AnalysisFormulaUtil.descartes(dimvalue, result, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimvalue.size() - 1) break block7;
            if (dimvalue.get(layer).size() == 0) {
                result.add(curList);
            } else {
                for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                    ArrayList<String> list = new ArrayList<String>(curList);
                    list.add(dimvalue.get(layer).get(i));
                    result.add(list);
                }
            }
        }
    }

    public static HashMultimap<String, String> getAssgrpMapValue(Map<String, Set<String>> assgrpToDimvalueMap, AnalysisFormulaHandle<HashMultimap<String, String>, String, String> analysisFormulaHandle) {
        String key;
        int paramSize = (Integer)ThreadCache.get((Object)"queryParamSize", () -> {
            String queryParamSize = ConfigServiceHelper.getStringParam(0L, "queryParamSize");
            if (StringUtil.isNotEmpty((CharSequence)queryParamSize)) {
                return Integer.parseInt(queryParamSize);
            }
            return 5000;
        });
        HashMultimap result = HashMultimap.create();
        HashSet exclude = new HashSet(16);
        for (Map.Entry<String, Set<String>> entry : assgrpToDimvalueMap.entrySet()) {
            Pair<HashMultimap<String, String>, HashSet<String>> glDimBcmMem2GlMems;
            String valSource;
            key = entry.getKey();
            Set<String> value = entry.getValue();
            QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)key)};
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuesource", (QFilter[])filters);
            if (dyn == null || !"bd_customer".equals(valSource = dyn.getString("valuesource")) && !"bd_supplier".equals(valSource) && !"bd_bizpartner".equals(valSource)) continue;
            HashSet<String> val = new HashSet<String>(paramSize);
            if (value.size() > paramSize) {
                for (String v : value) {
                    val.add(v);
                    if (val.size() != paramSize) continue;
                    Pair<HashMultimap<String, String>, HashSet<String>> glDimBcmMem2GlMems2 = AnalysisFormulaUtil.getGlDimBcmMem2GlMems(key, val, valSource);
                    result.putAll((Multimap)glDimBcmMem2GlMems2.p1);
                    exclude.addAll((Collection)glDimBcmMem2GlMems2.p2);
                    val.clear();
                }
                if (val.size() == 0) continue;
                glDimBcmMem2GlMems = AnalysisFormulaUtil.getGlDimBcmMem2GlMems(key, val, valSource);
                result.putAll((Multimap)glDimBcmMem2GlMems.p1);
                exclude.addAll((Collection)glDimBcmMem2GlMems.p2);
                continue;
            }
            if (value.size() == 0) continue;
            glDimBcmMem2GlMems = AnalysisFormulaUtil.getGlDimBcmMem2GlMems(key, value, valSource);
            result.putAll((Multimap)glDimBcmMem2GlMems.p1);
            exclude.addAll((Collection)glDimBcmMem2GlMems.p2);
        }
        for (Map.Entry<String, Set<String>> entry : assgrpToDimvalueMap.entrySet()) {
            key = entry.getKey();
            for (String s : entry.getValue()) {
                String rekey;
                if (exclude.contains(s) || result.containsKey((Object)(rekey = String.join((CharSequence)"_-", key, s)))) continue;
                result.put((Object)rekey, (Object)s);
            }
        }
        if (analysisFormulaHandle != null) {
            analysisFormulaHandle.handle((HashMultimap<String, String>)result, null, null);
        }
        return result;
    }

    private static Pair<HashMultimap<String, String>, HashSet<String>> getGlDimBcmMem2GlMems(String key, Set<String> value, String valSource) {
        String numberStr = value.stream().collect(Collectors.joining(""));
        String md5 = StringUtils.stringToMD5((String)numberStr);
        Pair cacheResult = (Pair)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)(key + md5 + valSource), () -> {
            SQLBuilder4RDB sql = new SQLBuilder4RDB(500);
            if ("bd_bizpartner".equalsIgnoreCase(valSource)) {
                sql.append("select a.fnumber \"number\",b.fnumber \"cnumber\",a.fstatus \"status\", a.fenable \"enable\" from t_").append(valSource).append(" a left join t_org_org b on b.fid = a.finternalcompanyid where ").in("b.fnumber", (Collection)value).append(" union select a.fnumber \"number\",b.fnumber \"cnumber\",a.fstatus \"status\", a.fenable \"enable\" from t_").append(valSource).append(" a left join t_org_org b on b.fid = a.finternalcompanyid where ").in("a.fnumber", (Collection)value);
            } else {
                sql.append("select a.fnumber \"number\",b.fnumber \"cnumber\",a.fstatus \"status\", a.fenable \"enable\" from t_").append(valSource).append(" a left join t_").append(valSource).append("_b c on c.fid = a.fid left join t_org_org b on b.fid = c.finternalcompanyid where ").in("b.fnumber", (Collection)value).append(" union select a.fnumber \"number\",b.fnumber \"cnumber\",a.fstatus \"status\", a.fenable \"enable\" from t_").append(valSource).append(" a left join t_" + valSource + "_b c on c.fid = a.fid left join t_org_org b on b.fid = c.finternalcompanyid where ").in("a.fnumber", (Collection)value);
            }
            HashMultimap cache = HashMultimap.create();
            HashSet<String> exclude = new HashSet<String>(16);
            DataSet rows = DB.queryDataSet((String)"AnalysisFormulaUtil", (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString(), (Object[])sql.getParams());
            while (rows.hasNext()) {
                String rkey;
                Row assDyn = rows.next();
                if (!"C".equalsIgnoreCase(assDyn.getString("status")) || !"1".equals(assDyn.getString("enable"))) continue;
                String number = assDyn.getString(NUMBER);
                String cnumber = assDyn.getString("cnumber");
                if (value.contains(number) && value.contains(cnumber) && ObjectUtils.notEqual((Object)number, (Object)cnumber)) {
                    exclude.add(number);
                }
                if (value.contains(number) && !value.contains(cnumber)) {
                    rkey = key + "_-" + number;
                    cache.put((Object)rkey, (Object)number);
                }
                if (!value.contains(cnumber)) continue;
                rkey = key + "_-" + cnumber;
                cache.put((Object)rkey, (Object)number);
            }
            return new Pair((Object)cache, exclude);
        });
        return cacheResult;
    }

    public static List<DynamicObject> getFormulaDyo(SpreadManager spreadManager, long tempId, String cuc, boolean isCal) {
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>();
        spreadManager.getBook().getSheet(0).iteratorCells(cell -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intergration_entity");
            if (cell.hasFormula()) {
                if (cell.getUserObject("lockFormula") != null) {
                    return;
                }
                if (cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("get_dim_attr") || cell.getFormula().toLowerCase(Locale.ENGLISH).startsWith("getjlentry")) {
                    return;
                }
                if (!(isCal || cell.getFormula().contains("@") && cell.getMemberFromUserObject() != null)) {
                    return;
                }
                Map<String, String> floatmsg = AnalysisFormulaUtil.getfloatArea(cell.getRow(), cell.getCol(), spreadManager);
                if (floatmsg == null) {
                    if (isCal && cell.getFormula().contains("@")) {
                        dynamicObject.set("datafrom", (Object)("=" + cell.getFormula()));
                        dynamicObject.set("dimkey", (Object)"dimkey");
                        dynamicObject.set("MEMBKEY", (Object)ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()));
                        dynamicObject.set("template", (Object)tempId);
                        dynamicObject.set("CURRENCY", (Object)cuc);
                        dynamicObject.set("cellid", cell.getUserObject("cid", (Object)0));
                        ruleList.add(dynamicObject);
                    }
                    return;
                }
                dynamicObject.set("datafrom", (Object)("=" + cell.getFormula()));
                StringBuilder dimKey = new StringBuilder();
                StringBuilder membKey = new StringBuilder();
                for (Map.Entry<String, String> entry : floatmsg.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if ("area".equals(key)) {
                        dynamicObject.set("floatarea", (Object)value);
                        continue;
                    }
                    if ("floatindex".equals(key)) {
                        dynamicObject.set("floatindex", (Object)value);
                        continue;
                    }
                    membKey.append(value).append('|');
                    dimKey.append(key).append('|');
                }
                dynamicObject.set("template", (Object)tempId);
                dynamicObject.set("dimkey", (Object)dimKey);
                dynamicObject.set("MEMBKEY", (Object)membKey);
                dynamicObject.set("CURRENCY", (Object)cuc);
                dynamicObject.set("cellid", cell.getUserObject("cid", (Object)0));
                ruleList.add(dynamicObject);
            }
        });
        return ruleList;
    }

    public static DynamicObject getCellFormulaDyo(SpreadManager spreadManager, String formula, long tempId, String cuc, boolean isCal) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intergration_entity");
        dynamicObject.set("datafrom", (Object)("=" + formula));
        StringBuilder dimKey = new StringBuilder();
        StringBuilder membKey = new StringBuilder();
        dynamicObject.set("template", (Object)tempId);
        dynamicObject.set("dimkey", (Object)dimKey);
        dynamicObject.set("MEMBKEY", (Object)membKey);
        dynamicObject.set("CURRENCY", (Object)cuc);
        return dynamicObject;
    }

    public static Map<String, String> getfloatArea(int r, int c, SpreadManager spreadManager) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        block0: for (PositionInfo positionInfo : spreadManager.getAreaManager().getPostionInfoSet()) {
            String spreadArea = positionInfo.getAreaRange();
            String position = ExcelUtils.xy2Pos((int)c, (int)r);
            if (!SpreadAreaUtil.isInArea((String)(position + ":" + position), (String)spreadArea)) continue;
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                int maxcol;
                boolean isDirectHoriz = basePointInfo.isDirectHoriz();
                int minrow = isDirectHoriz ? ExcelUtils.pos2Y((String)positionInfo.getStartPosition()) : ExcelUtils.pos2Y((String)basePointInfo.getDynaRange().split(":")[0]);
                int maxrow = isDirectHoriz ? ExcelUtils.pos2Y((String)positionInfo.getAreaRange().split(":")[1]) : ExcelUtils.pos2Y((String)basePointInfo.getDynaRange().split(":")[1]);
                int mincol = isDirectHoriz ? ExcelUtils.pos2X((String)basePointInfo.getDynaRange().split(":")[0]) : ExcelUtils.pos2X((String)positionInfo.getStartPosition());
                int n = maxcol = isDirectHoriz ? ExcelUtils.pos2X((String)basePointInfo.getDynaRange().split(":")[1]) : ExcelUtils.pos2X((String)positionInfo.getAreaRange().split(":")[1]);
                if (mincol > c || minrow > r || maxcol < c || maxrow < r || (!isDirectHoriz || mincol != c) && (isDirectHoriz || minrow != r)) continue;
                int startpoint = isDirectHoriz ? ExcelUtils.pos2Y((String)positionInfo.getStartPosition()) : ExcelUtils.pos2X((String)positionInfo.getStartPosition());
                int memberindex = isDirectHoriz ? r - startpoint : c - startpoint;
                result.put("floatindex", String.valueOf(memberindex));
                if (basePointInfo.getFixMemberPosition().get(memberindex) == null) continue block0;
                result.put("area", basePointInfo.getOriginalDynaRange());
                if (isDirectHoriz) {
                    AnalysisFormulaUtil.fillFixMember(result, basePointInfo, memberindex);
                    AnalysisFormulaUtil.fillFloatMember(result, basePointInfo);
                } else {
                    AnalysisFormulaUtil.fillFloatMember(result, basePointInfo);
                    AnalysisFormulaUtil.fillFixMember(result, basePointInfo, memberindex);
                }
                return result;
            }
        }
        return null;
    }

    private static void fillFloatMember(Map<String, String> result, BasePointInfo basePointInfo) {
        for (BasePointInnerLineInfo innerLineInfo : basePointInfo.getBasePointInnerLineInfo()) {
            if (innerLineInfo.isFloated()) {
                result.put(innerLineInfo.getDimension().getNumber(), "@");
                continue;
            }
            IDimMember fixmem = ((DynaMembScopeInfo)innerLineInfo.getDynaMembScopes().get(0)).getMember();
            result.put(fixmem.getDimension().getNumber(), fixmem.getNumber());
        }
    }

    private static void fillFixMember(Map<String, String> result, BasePointInfo basePointInfo, int memberindex) {
        for (IDimMember member : (List)basePointInfo.getFixMemberPosition().get(memberindex)) {
            result.put(member.getDimension().getNumber(), member.getNumber());
        }
    }

    public static void functionTypeCheckByExpression(Expression exp, AtomicBoolean isCheck, Predicate predicate) {
        if (exp instanceof UnaryOperationExpr) {
            AnalysisFormulaUtil.functionTypeCheckByExpression(((UnaryOperationExpr)exp).getOperand(), isCheck, predicate);
        } else if (exp instanceof BinaryOperationExpr) {
            Expression leftExp = ((BinaryOperationExpr)exp).getLeft();
            Expression rightExp = ((BinaryOperationExpr)exp).getRight();
            AnalysisFormulaUtil.functionTypeCheckByExpression(leftExp, isCheck, predicate);
            AnalysisFormulaUtil.functionTypeCheckByExpression(rightExp, isCheck, predicate);
        } else if (!isCheck.get() && exp instanceof FunctionExpr) {
            ExcelFormulaPaserHelper.walk((Expression)exp, e -> {
                if (!isCheck.get() && e instanceof BinaryOperationExpr) {
                    AnalysisFormulaUtil.functionTypeCheckByExpression(e, isCheck, predicate);
                } else if (!isCheck.get() && e instanceof FunctionExpr && predicate.test(e) && e.toString().indexOf("@") != -1) {
                    isCheck.set(true);
                }
            });
        }
    }
}

