/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.model.key.IPackKey;
import kd.fi.bcm.business.formula.model.key.PackKey;
import kd.fi.bcm.business.formula.register.FormulaRegister;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.formula.AcctJudgeFormula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.DataCollectUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.AcctCollectConfigTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.spread.datacollect.model.RefParamResult;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import org.apache.commons.collections4.MapUtils;

public class CollectCalculateHelp {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, CollectCalculateHelp.class);
    public static final Set<String> batchSupportFormulas = DataCollectUtil.getCanBatchFormulaNums();
    public static final Set<String> batchSupportFormulas4bcm = new HashSet<String>(16);

    public static RefParamResult packRefParam(List<AbstractFormula> batchCalList, Map<String, String> glDimToBcmDim, Table<String, String, String> param2BcmDim, Map<String, Long> filterDimSetting) {
        RefParamResult refParamResult = new RefParamResult();
        if (CollectionUtil.isEmpty(batchCalList)) {
            return refParamResult;
        }
        Map<String, Set<String>> dimToMembs = AnalysisFormulaUtil.getFloatDimmembMap(batchCalList.get(0).getTempleId(), batchCalList.get(0).getFloatarea(), filterDimSetting);
        HashSet<Object> isSameGDim = new HashSet<Object>(10);
        for (AbstractFormula formula : batchCalList) {
            if (formula.getFormulaStr().startsWith("=V_DATA")) {
                refParamResult.setRefParam(dimToMembs);
                ArrayList<String> dims = new ArrayList<String>(10);
                for (String dim : formula.getRowcols()) {
                    if (!dimToMembs.containsKey(dim)) continue;
                    dims.add(dim);
                }
                refParamResult.setVDataDims(dims);
                if (!(formula instanceof AcctJudgeFormula)) continue;
                HashMap<String, String> varDimMap = new HashMap<String, String>(16);
                for (Map.Entry<String, Object> entry : ((AcctJudgeFormula)formula).getInParams().entrySet()) {
                    varDimMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
                int index = 0;
                for (String row : formula.getRowcols()) {
                    varDimMap.put(row.toLowerCase(), formula.getRowcolMemNum()[index]);
                    ++index;
                }
                refParamResult.setInParams(varDimMap);
                continue;
            }
            Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(formula.getFormulaStr());
            if (((List)pair.p2).isEmpty() && ((Map)pair.p1).isEmpty()) {
                formula.setMsg("not support formula format.");
                continue;
            }
            Map<String, Set<String>> floatParam = CollectCalculateHelp.collectFloatParamMems(param2BcmDim, dimToMembs, formula, pair);
            refParamResult.setFloatParam(floatParam);
            HashMap<String, Set<String>> glDimToBcmMembs = new HashMap<String, Set<String>>(10);
            if (!isSameGDim.add(pair.p2)) continue;
            for (String glDim : (List)pair.p2) {
                if (!dimToMembs.containsKey(glDimToBcmDim.get(glDim))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u7684\u201c%s\u201d\u7f3a\u5c11\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u53d6\u6570\u7684\u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e\u3002", (String)"CollectCalculateHelp_1", (String)"fi-bcm-business", (Object[])new Object[0]), glDim);
                    formula.setMsg(msg);
                    break;
                }
                glDimToBcmMembs.put(glDim, dimToMembs.get(glDimToBcmDim.get(glDim)));
            }
            if (formula.getMsg() != null) continue;
            HashMultimap glMem2BcmMems = HashMultimap.create();
            HashMap refParam = Maps.newHashMap();
            HashMultimap<String, String> glDimBcmMem2GlMems = AnalysisFormulaUtil.getAssgrpMapValue(glDimToBcmMembs, (dy, gldim, v) -> CollectCalculateHelp.createRefParam((HashMultimap<String, String>)dy, glDimToBcmDim, (HashMultimap<String, String>)glMem2BcmMems, refParam));
            refParamResult.setRefParam(refParam);
            refParamResult.setGlDimBcmMem2GlMems(glDimBcmMem2GlMems);
            refParamResult.setGlMem2BcmMems((HashMultimap<String, String>)glMem2BcmMems);
        }
        return refParamResult;
    }

    private static Map<String, Set<String>> collectFloatParamMems(Table<String, String, String> param2BcmDim, Map<String, Set<String>> dimToMembs, AbstractFormula formula, Pair<Map<String, List<String>>, List<String>> pair) {
        HashMap<String, Set<String>> floatParam = new HashMap<String, Set<String>>(10);
        block0: for (Map.Entry formula2params : ((Map)pair.p1).entrySet()) {
            String formulaNum = (String)formula2params.getKey();
            for (String param : (List)formula2params.getValue()) {
                String bcmDim = (String)param2BcmDim.get((Object)formulaNum, (Object)param);
                if (!dimToMembs.containsKey(bcmDim)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u7684 %s \u7f3a\u5c11\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u53d6\u6570\u7684\u6d6e\u52a8\u53c2\u6570\u6620\u5c04\u914d\u7f6e\u3002", (String)"CollectCalculateHelp_5", (String)"fi-bcm-business", (Object[])new Object[0]), param);
                    formula.setMsg(msg);
                    continue block0;
                }
                floatParam.put(formulaNum + "|" + param, dimToMembs.get(bcmDim));
            }
        }
        return floatParam;
    }

    private static void createRefParam(HashMultimap<String, String> result, Map<String, String> glDimToBcmDim, HashMultimap<String, String> glMem2BcmMems, Map<String, Set<String>> refParam) {
        if (result != null) {
            for (String key : result.keySet()) {
                String[] split = key.split("_-");
                if (split.length != 2) continue;
                String glDim = split[0];
                String bcmMem = split[1];
                String bcmDim = glDimToBcmDim.get(glDim);
                Set numbers = result.get((Object)key);
                for (String number : numbers) {
                    glMem2BcmMems.put((Object)(glDim + "-" + number), (Object)(bcmDim + "-" + bcmMem));
                    refParam.computeIfAbsent(glDim, e -> new HashSet()).add(number);
                }
            }
        }
    }

    public static List<IPackKey> batchPackKeys(List<ExpressStatus> expressStatusList, List<AbstractFormula> formulas, Map<String, Object> collectResultSet, Long modelId, HashMultimap<String, String> glMem2BcmMems, List<AbstractFormula> failFormula, Map<String, Integer> formulaKey2ParamIndex, Table<String, String, String> param2BcmDim) {
        HashSet<List<Object>> bcmDimMems = new HashSet<List<Object>>(16);
        List<Object> referenceBcmDimList = Lists.newArrayList();
        for (int i = 0; i < formulas.size(); ++i) {
            List<String> childParseExpr = expressStatusList.get(i).getChildParseExpr();
            AbstractFormula abstractFormula = formulas.get(i);
            List<Map<String, Object>> formulaResultList = CollectCalculateHelp.getFormulaResulaList(abstractFormula, childParseExpr, collectResultSet);
            ArrayList formulaParamIndex = Lists.newArrayList();
            if (MapUtils.isNotEmpty(formulaKey2ParamIndex)) {
                for (String string : childParseExpr) {
                    formulaParamIndex.add(formulaKey2ParamIndex.get(string));
                }
            }
            if (StringUtils.isNotEmpty((String)abstractFormula.getMsg())) {
                failFormula.add(abstractFormula);
                if (!ConfigServiceHelper.getBoolChildParam(modelId, "CM014", AcctCollectConfigTypeEnum.ISSTRINGCHECK.getNumber())) continue;
            }
            referenceBcmDimList = CollectCalculateHelp.bcmDimReference(abstractFormula);
            if (abstractFormula.getFormulaStr().startsWith("=V_DATA")) {
                for (Map map : formulaResultList) {
                    for (String dimJsonStr : map.keySet()) {
                        ArrayList<String> mems = new ArrayList<String>(10);
                        JSONArray array = JSONArray.parseArray((String)dimJsonStr);
                        for (Object object : array) {
                            mems.add(object.toString());
                        }
                        bcmDimMems.add(mems);
                    }
                }
                continue;
            }
            ArrayList<Pair<Map<String, List<String>>, List<String>>> childFormulaPair = new ArrayList<Pair<Map<String, List<String>>, List<String>>>(10);
            CollectCalculateHelp.walkFormula(CollectCalculateHelp.getExpression(abstractFormula), (Consumer<FunctionExpr>)((Consumer)e -> CollectCalculateHelp.getChildFormulaPair(e, childFormulaPair)));
            bcmDimMems.addAll(CollectCalculateHelp.getBcmMemFromFormulaResult(formulaResultList, referenceBcmDimList, childFormulaPair, glMem2BcmMems, formulaParamIndex, param2BcmDim));
        }
        ArrayList<IPackKey> packKeys = new ArrayList<IPackKey>(16);
        for (List list : bcmDimMems) {
            packKeys.add(new PackKey(list, referenceBcmDimList));
        }
        return packKeys;
    }

    private static Expression getExpression(AbstractFormula f) {
        Expression exp = null;
        try {
            exp = ExcelFormulaPaserHelper.parse((String)f.getFormulaStr());
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return exp;
    }

    private static List<String> bcmDimReference(AbstractFormula formula) {
        String[] rowcols = formula.getRowcols();
        String[] rowcolMemNum = formula.getRowcolMemNum();
        ArrayList referenceBcmDimList = Lists.newArrayList();
        for (int i = 0; i < rowcolMemNum.length; ++i) {
            if (!"@".equals(rowcolMemNum[i])) continue;
            referenceBcmDimList.add(rowcols[i]);
        }
        return referenceBcmDimList;
    }

    public static void walkFormula(Expression exp, Consumer<FunctionExpr> consumer) {
        ExcelFormulaPaserHelper.walk((Expression)exp, e -> {
            if (e instanceof FunctionExpr && consumer != null) {
                consumer.accept((Object)((FunctionExpr)e));
            }
        });
    }

    private static void getChildFormulaPair(FunctionExpr e, List<Pair<Map<String, List<String>>, List<String>>> childFormulaPair) {
        if (!FormulaRegister.getExcelNotSupportFormulas().contains(e.getFuncionName().toLowerCase(Locale.ENGLISH)) || CollectCalculateHelp.isNotBatchCalFormula(e)) {
            return;
        }
        Pair<Map<String, List<String>>, List<String>> pair = AnalysisFormulaUtil.getFormulaDimPairByCache(e.toString());
        childFormulaPair.add(pair);
    }

    private static boolean isNotBatchCalFormula(FunctionExpr e) {
        return !batchSupportFormulas.contains(e.getFuncionName().toLowerCase(Locale.ENGLISH)) || e.toString().indexOf("@") == -1;
    }

    public static Pair<List<String>, List<String>> getFormulaDimPair(String formulaStr) {
        Pair pair = Pair.onePair((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        AnalysisFormulaUtil.generateFloatAcctDy(formulaStr, (Pair<List<String>, List<String>>)pair);
        return pair;
    }

    private static List<List<String>> getBcmMemFromFormulaResult(List<Map<String, Object>> formulaResultList, List<String> referenceBcmDimList, List<Pair<Map<String, List<String>>, List<String>>> childFormulaPair, HashMultimap<String, String> glMem2BcmMems, List<Integer> formulaParamIndex, Table<String, String, String> param2BcmDim) {
        ArrayList<List<String>> bcmMemList = new ArrayList<List<String>>(16);
        for (int j = 0; j < formulaResultList.size(); ++j) {
            Pair<Map<String, List<String>>, List<String>> pair = childFormulaPair.get(j);
            List glIndex = (List)pair.p2;
            int floatParamIndex = -1;
            if (!formulaParamIndex.isEmpty()) {
                floatParamIndex = formulaParamIndex.get(j);
            }
            List<Object> bcmDims4floatParam = new ArrayList(10);
            if (floatParamIndex != -1) {
                bcmDims4floatParam = CollectCalculateHelp.getBcmDimsByParams(param2BcmDim, (Map)pair.p1);
            }
            for (String glDimMem : formulaResultList.get(j).keySet()) {
                int i;
                String[] split = glDimMem.split("\\|");
                int paramIndex = bcmDims4floatParam.isEmpty() ? split.length : floatParamIndex;
                HashMap<Object, String> membersByFormula = new HashMap<Object, String>(10);
                ArrayList memsList = Lists.newArrayList();
                if (split.length != glIndex.size() + bcmDims4floatParam.size()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u503c %s \u7ef4\u5ea6\u4e2a\u6570\u548c\u6d6e\u52a8\u7ef4\u5ea6\u6570\u91cf %d \u4e0d\u540c\u3002", (String)"CollectCalculateHelp_2", (String)"fi-bcm-business", (Object[])new Object[0]), glDimMem, glIndex.size() + bcmDims4floatParam.size());
                    throw new KDBizException(msg);
                }
                for (i = 0; i < paramIndex; ++i) {
                    glMem2BcmMems.get((Object)((String)glIndex.get(i) + "-" + split[i])).forEach(bcm2Mems -> {
                        int index = bcm2Mems.indexOf("-");
                        membersByFormula.put(bcm2Mems.substring(0, index), bcm2Mems.substring(index + 1));
                    });
                }
                for (i = 0; i < bcmDims4floatParam.size(); ++i) {
                    membersByFormula.put(bcmDims4floatParam.get(i), split[i + floatParamIndex]);
                }
                referenceBcmDimList.forEach(dim -> memsList.add(membersByFormula.get(dim)));
                bcmMemList.add(memsList);
            }
        }
        return bcmMemList;
    }

    public static List<String> getBcmDimsByParams(Table<String, String, String> param2BcmDim, Map<String, List<String>> paramDims) {
        ArrayList<String> bcmDims = new ArrayList<String>(10);
        if (MapUtils.isEmpty(paramDims)) {
            return bcmDims;
        }
        for (Map.Entry<String, List<String>> formulaNum2param : paramDims.entrySet()) {
            String formulaNum = formulaNum2param.getKey().toLowerCase();
            List<String> params = formulaNum2param.getValue();
            for (String param : params) {
                String bcmDim = (String)param2BcmDim.get((Object)formulaNum, (Object)param);
                bcmDims.add(bcmDim);
            }
        }
        return bcmDims;
    }

    private static List<Map<String, Object>> getFormulaResulaList(AbstractFormula formula, List<String> childParseExpr, Map<String, Object> collectResultSet) {
        ArrayList formulaResultList = Lists.newArrayList();
        for (String childUUID : childParseExpr) {
            String msg;
            Object v = collectResultSet.get(childUUID);
            if (v instanceof Map) {
                Map value = (Map)v;
                formulaResultList.add(value);
                continue;
            }
            if (v instanceof Exception) {
                msg = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u63a5\u53e3\u8fd4\u56de\u503c\u662f\u5f02\u5e38: %s\u3002", (String)"CollectCalculateHelp_3", (String)"fi-bcm-business", (Object[])new Object[0]), v);
                formula.setMsg(msg);
                formulaResultList.add(Maps.newHashMap());
                continue;
            }
            msg = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u63a5\u53e3\u8fd4\u56de\u503c\u662f\u7a7a\u3002", (String)"CollectCalculateHelp_4", (String)"fi-bcm-business", (Object[])new Object[0]), v);
            formula.setMsg(msg);
            formulaResultList.add(Maps.newHashMap());
        }
        return formulaResultList;
    }

    public static Boolean canBatchCal(AbstractFormula f) {
        AtomicBoolean canBatchCal = new AtomicBoolean(true);
        CollectCalculateHelp.walkFormula(CollectCalculateHelp.getExpression(f), (Consumer<FunctionExpr>)((Consumer)e -> CollectCalculateHelp.excuteCanBatchCal(e, canBatchCal)));
        return canBatchCal.get();
    }

    private static void excuteCanBatchCal(FunctionExpr e, AtomicBoolean canBatchCal) {
        if (canBatchCal.get() && FormulaRegister.getExcelNotSupportFormulas().contains(e.getFuncionName().toLowerCase(Locale.ENGLISH))) {
            canBatchCal.set(batchSupportFormulas.contains(e.getFuncionName().toLowerCase(Locale.ENGLISH)) || batchSupportFormulas4bcm.contains(e.getFuncionName().toLowerCase(Locale.ENGLISH)));
        }
    }

    static {
        batchSupportFormulas4bcm.add("v_data");
    }
}

