/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.model.excel.ApiResponseModel;
import kd.fi.bcm.business.model.excel.DimsReq;
import kd.fi.bcm.business.model.formula.Formula;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DataCollectUtils {
    public static String checkGlBookClosing(Long modelId, String org, String scenario, String year, String period) {
        boolean isMonth;
        boolean beforeClosingConfig = ConfigServiceHelper.getBoolParam(modelId, "CM042");
        boolean bl = isMonth = "MRpt".equals(scenario) && year != null && year.startsWith("FY") && period != null && period.startsWith("M_M");
        if (!beforeClosingConfig && isMonth) {
            Map<String, String> dimMemMapByNum = DataCollectUtils.getDimMemMapByNum(modelId, Collections.singletonList(org), "Entity");
            year = year.substring(2);
            period = period.substring(3);
            boolean bookClose = true;
            try {
                bookClose = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"GLAccountBookService", (String)"isAccountBookClose", (Object[])new Object[]{dimMemMapByNum.get(org), null, year, period});
            }
            catch (Exception e) {
                String mes = ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)10);
                return String.format(ResManager.loadKDString((String)"\u603b\u8d26\u63a5\u53e3\u5f02\u5e38, \u8df3\u8fc7\u7ed3\u8d26\u6821\u9a8c : %s", (String)"DataCollectedNewPlugin_34", (String)"fi-bcm-business", (Object[])new Object[0]), mes);
            }
            if (!bookClose) {
                throw new KDBizException(ResManager.loadKDString((String)"\u603b\u8d26\u672a\u7ed3\u8d26\uff0c\u4e0d\u5141\u8bb8\u516c\u5f0f\u53d6\u6570\u3002", (String)"AbstractMultiReportPlugin_845", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        return null;
    }

    public static ApiResponseModel checkAtIsEntityInput(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        if (unCheck || !isSaveByDim) {
            return new ApiResponseModel();
        }
        String audit = dimsReq.getAudit();
        if (audit != null && !"EntityInput".equals(audit)) {
            return new ApiResponseModel(false, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u8ba1\u7ebf\u7d22\u7684\u6210\u5458\u4e3a\u6570\u636e\u8f93\u5165 \u6709\u7ef4\u5ea6\u533a\u57df\u624d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\uff01", (String)"DataCollectUtils_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return new ApiResponseModel();
    }

    public static ApiResponseModel checkAtProcess(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        if (unCheck || !isSaveByDim) {
            return new ApiResponseModel();
        }
        String process = dimsReq.getProcess();
        if (process != null && !"EIRpt".equals(process)) {
            return new ApiResponseModel(false, ResManager.loadKDString((String)"\u53ea\u6709\u8fc7\u7a0b\u7684\u6210\u5458\u4e3aEIRpt \u6709\u7ef4\u5ea6\u533a\u57df\u624d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\uff01", (String)"DataCollectUtils_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return new ApiResponseModel();
    }

    public static ApiResponseModel checkAtCurrency(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        if (unCheck || !isSaveByDim) {
            return new ApiResponseModel();
        }
        Long orgId = dimsReq.getOrgId();
        String orgNum = dimsReq.getOrgNum();
        Long yearId = dimsReq.getYearId();
        Long periodId = dimsReq.getPeriodId();
        Long sceneId = dimsReq.getSceneId();
        String currency = dimsReq.getCurrency();
        if (!ExchangeQueryHelper.getAutoConvert(dimsReq.getModelId(), sceneId, yearId, periodId, SimpleVo.newOne(orgNum, orgId)).booleanValue()) {
            return new ApiResponseModel();
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bcm_entitymembertree");
        if (!(currency == null || "EC".equals(currency) || "DC".equals(currency) || currency.equals(dy.getString("currency.number")))) {
            return new ApiResponseModel(false, ResManager.loadKDString((String)"\u6709\u7ef4\u5ea6\u533a\u57df\u6298\u7b97\u5e01\u4e0d\u80fd\u6267\u884c\u516c\u5f0f\u53d6\u6570\uff01", (String)"DataCollectUtils_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return new ApiResponseModel();
    }

    public static ApiResponseModel checkAtUserDefine(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        Map<String, String> userDefineDim2Mem = dimsReq.getUserDefineDim2Mem();
        if (unCheck || !isSaveByDim || userDefineDim2Mem == null || userDefineDim2Mem.isEmpty()) {
            return new ApiResponseModel();
        }
        for (Map.Entry<String, String> dim2mem : userDefineDim2Mem.entrySet()) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)dimsReq.getCube(), (String)dim2mem.getKey(), (String)dim2mem.getValue());
            if (node == null || node.isLeaf() && !StorageTypeEnum.LABEL.getOIndex().equals(node.getStorageType().index)) continue;
            return new ApiResponseModel(false, ResManager.loadKDString((String)"\u89c6\u70b9\u9875\u9762\u7ef4\u4e2d\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u6216\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u6709\u7ef4\u5ea6\u533a\u57df\u4e0d\u5141\u8bb8\u516c\u5f0f\u53d6\u6570\uff01", (String)"DataCollectUtils_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return new ApiResponseModel();
    }

    public static ApiResponseModel checkDimType(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        Map<String, String> dim2mem = dimsReq.getDim2mem();
        boolean config043 = ConfigServiceHelper.getBoolParam(dimsReq.getModelId(), "CM043");
        if (unCheck || !isSaveByDim || dim2mem == null || dim2mem.isEmpty()) {
            return new ApiResponseModel();
        }
        for (Map.Entry<String, String> dimMem : dim2mem.entrySet()) {
            IDNumberTreeNode member;
            String dimNum = dimMem.getKey();
            String memNum = dimMem.getValue();
            if (config043 && DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum) && "MyCompany".equals(memNum) || (member = MemberReader.findMemberByNumber((String)dimsReq.getCube(), (String)dimNum, (String)memNum)) == null || member.isLeaf() && !StorageTypeEnum.LABEL.getOIndex().equals(member.getStorageType().index)) continue;
            return new ApiResponseModel(false, String.format(ResManager.loadKDString((String)"\u89c6\u70b9\u9875\u9762\u7ef4\u4e2d%s\u4e3a\u975e\u660e\u7ec6\u6210\u5458\u6216\u6807\u7b7e\u7c7b\u6210\u5458\uff0c\u6709\u7ef4\u5ea6\u533a\u57df\u4e0d\u5141\u8bb8\u516c\u5f0f\u53d6\u6570\uff01", (String)"DataCollectUtils_5", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum));
        }
        return new ApiResponseModel();
    }

    public static ApiResponseModel checkCal(boolean unCheck, boolean isSaveByDim, DimsReq dimsReq) {
        ApiResponseModel validateResult = DataCollectUtils.checkAtCurrency(!unCheck, isSaveByDim, dimsReq);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        validateResult = DataCollectUtils.checkAtIsEntityInput(!unCheck, isSaveByDim, dimsReq);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        validateResult = DataCollectUtils.checkAtProcess(!unCheck, isSaveByDim, dimsReq);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        validateResult = DataCollectUtils.checkAtUserDefine(!unCheck, isSaveByDim, dimsReq);
        if (!validateResult.isSuccess()) {
            return validateResult;
        }
        validateResult = DataCollectUtils.checkDimType(!unCheck, isSaveByDim, dimsReq);
        return validateResult;
    }

    public static Map<String, String> getDimMemMapByNum(Long modelId, Collection<String> mems, String entityNum) {
        Map<String, String> result = mems.stream().collect(Collectors.toMap(e -> e, e -> e, (v1, v2) -> v1));
        Long entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)entityNum);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bcmdim", "=", (Object)entityDimId);
        qFilter.and("bcmmember", "in", mems);
        DynamicObject[] memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"bcmmember,  asstmember", (QFilter[])qFilter.toArray());
        if (memberDims.length == 0) {
            return result;
        }
        for (DynamicObject memberDim : memberDims) {
            result.put(memberDim.getString("bcmmember"), memberDim.getString("asstmember"));
        }
        return result;
    }

    public static Map<String, String> getGlMemMapByNum(Long modelId, Collection<String> mems, String entityNum) {
        Map<String, String> result = mems.stream().collect(Collectors.toMap(e -> e, e -> e, (v1, v2) -> v1));
        Long entityDimId = null;
        try {
            entityDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)entityNum);
        }
        catch (Exception e2) {
            return result;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bcmdim", "=", (Object)entityDimId);
        qFilter.and("asstmember", "in", mems);
        DynamicObject[] memberDims = BusinessDataServiceHelper.load((String)"bcm_membermapentity", (String)"bcmmember,  asstmember", (QFilter[])qFilter.toArray());
        if (memberDims.length == 0) {
            return result;
        }
        for (DynamicObject memberDim : memberDims) {
            result.put(memberDim.getString("asstmember"), memberDim.getString("bcmmember"));
        }
        return result;
    }

    public static boolean acctFormulaPeriodIsTxt(String formulaNum) {
        Formula formulaByNumber = ResourcesLoaderUtil.getFormulaByNumber(formulaNum);
        for (Map<String, Object> param : formulaByNumber.getParam()) {
            if (!"period".equals(param.get("number"))) continue;
            return param.get("type").equals("textfield");
        }
        return false;
    }
}

