/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.util.ReportSourceUtil;

public class SpreadMemberUtil {
    public static IDimension getDimensionInAllDomain(DimTypesEnum dimType, List<IDimension> list) {
        for (IDimension dimension : list) {
            if (!dimType.getNumber().equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }

    public static String getDimNumberBySm(SpreadManager sm, DimTypesEnum dimType) {
        String processNumber = "";
        ArrayList<IDimension> dimensionList = new ArrayList<IDimension>();
        dimensionList.addAll(sm.getFilter().getPageDomain().getDimensions());
        dimensionList.addAll(sm.getFilter().getViewPointDomain().getDimensions());
        IDimension processDimension = SpreadMemberUtil.getDimensionInAllDomain(dimType, dimensionList);
        if (processDimension != null) {
            processNumber = ((IDimMember)processDimension.getMembers().get(0)).getNumber();
        }
        return processNumber;
    }

    public static long getOrgIdByOrgNumAndModelId(String orgNum, long modelId) {
        QFilter numberFilter = new QFilter("model", "=", (Object)modelId);
        numberFilter.and("number", "=", (Object)orgNum);
        return QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{numberFilter}).getLong("id");
    }

    public static long getOrgIdByOrgNumAndModelNum(String orgNum, String modelNum) {
        QFilter numberFilter = new QFilter("model.number", "=", (Object)modelNum);
        numberFilter.and("number", "=", (Object)orgNum);
        return QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{numberFilter}).getLong("id");
    }

    public static Map<String, Object> getCellInfo(SpreadManager sm, Map<DimTypesEnum, Object> params, Cell cell, long modelId, boolean isParSon) {
        HashMap<String, Object> cellInfo = new HashMap<String, Object>(16);
        Map tempMap = MemberReader.getDimNumberMapNameById((long)modelId);
        Map<String, String> dimMemberMap = SpreadMemberUtil.getCellDimMemberMap(sm, params, cell, modelId, isParSon);
        cellInfo.put("dimNumber2MembNumber", dimMemberMap);
        StringBuilder info = new StringBuilder();
        tempMap.forEach((dimNum, dimName) -> {
            String memNum = (String)dimMemberMap.get(dimNum);
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)memNum);
            String name = node.getName();
            info.append((String)dimName).append('|').append(memNum).append("  ").append(name).append(";\n");
        });
        Map<String, String> sourcecombo = SpreadMemberUtil.getCellDimMemberMap(sm, params, cell, modelId, true);
        long fsource = ReportSourceUtil.getSource(MemberReader.findModelNumberById((Object)modelId), sourcecombo);
        if (fsource != 0L) {
            info.append("\n").append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\uff1a%s", (String)"SpreadMemberUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]), OlapSourceEnum.getName((Object)fsource))).append(";\n");
        }
        cellInfo.put("infoText", info);
        return cellInfo;
    }

    public static Map<String, Object> getExtCellInfo(SpreadManager sm, PositionInfo posInfo, Map<DimTypesEnum, Object> params, Cell cell, long modelId, boolean isParSon) {
        HashMap<String, Object> cellInfo = new HashMap<String, Object>(16);
        Map tempMap = MemberReader.getDimNumberMapNameById((long)modelId);
        Map<String, String> dimMemberMap = SpreadMemberUtil.getExtCellDimMemberMap(sm, params, cell, modelId, isParSon);
        QFilter modelFilter = new QFilter("model.id", "=", (Object)modelId);
        List cols = posInfo.getExtendInfo().getCols();
        List floatDimNums = posInfo.getExtendInfo().getFloatDimNums();
        String selCol = sm.getExtHeadCol2(cell.getRow(), cell.getCol());
        ArrayList extCols = new ArrayList(cols);
        extCols.removeAll(floatDimNums);
        QFilter colFilter = new QFilter("number", "in", extCols);
        QFilter groupFilter = new QFilter("longnumber", "like", (Object)("Extends!" + posInfo.getExtendInfo().getExtGroup() + '!' + "%"));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,name", (QFilter[])new QFilter[]{modelFilter, colFilter, groupFilter});
        Map<String, String> colNum2Names = doc.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getString("name")));
        QFilter extModelFilter = new QFilter("number", "=", (Object)posInfo.getExtendInfo().getExtModelNumber());
        DynamicObject extModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"number,name", (QFilter[])new QFilter[]{modelFilter, extModelFilter});
        StringBuilder info = new StringBuilder();
        info.append(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b", (String)"SpreadMemberUtil_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append('|').append(extModel.getString("number")).append("  ").append(extModel.getString("name")).append(";\n");
        tempMap.forEach((dimNum, dimName) -> {
            if (dimMemberMap.get(dimNum) == null) {
                return;
            }
            String memNum = (String)dimMemberMap.get(dimNum);
            if (memNum == null) {
                return;
            }
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)memNum);
            String name = node.getName();
            info.append((String)dimName).append('|').append(memNum).append("  ").append(name).append(";\n");
        });
        for (String col : cols) {
            if (!col.equals(selCol) || !extCols.contains(col)) continue;
            info.append(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5b57\u6bb5\u6210\u5458", (String)"SpreadMemberUtil_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append('|').append(col).append("  ").append(colNum2Names.get(col)).append(";\n");
        }
        cellInfo.put("infoText", info);
        return cellInfo;
    }

    public static Map<String, String> getCellDimMemberMap(SpreadManager sm, Map<DimTypesEnum, Object> params, Cell cell, long modelId, boolean isParSon) {
        HashMap<String, String> commonMemberMap = new HashMap<String, String>(16);
        if (cell.isMdDataDomain()) {
            String orgNum = SpreadMemberUtil.fillPageDimMembers(modelId, sm, commonMemberMap);
            return SpreadMemberUtil.getCellDimMemberMap(commonMemberMap, orgNum, params, cell, modelId, isParSon);
        }
        return commonMemberMap;
    }

    public static String fillPageDimMembers(long modelId, SpreadManager sm, Map<String, String> pageMemberMap) {
        Pair<String, String> pair;
        String orgNum = "";
        List commonMemberList = sm.getFilter().getPageDomain().getAllMembers();
        commonMemberList.addAll(sm.getFilter().getViewPointDomain().getAllMembers());
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        String currencyNum = "";
        String processNum = "";
        for (IDimMember mem : commonMemberList) {
            String dimNum = mem.getDimension().getNumber();
            String memNum = mem.getNumber();
            if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                orgNum = StringUtils.isNotEmpty((String)mem.getPar_SonNum()) ? mem.getPar_SonNum() : MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memNum).getParent_SonNumber();
            } else if (PresetConstant.CURRENCY_DIM.equals(dimNum)) {
                currencyNum = memNum;
            } else if (PresetConstant.PROCESS_DIM.equals(dimNum)) {
                processNum = memNum;
            }
            pageMemberMap.put(dimNum, memNum);
        }
        if (StringUtils.isNotEmpty((String)currencyNum) && Lists.newArrayList((Object[])new String[]{"DC", "EC"}).contains(currencyNum) && StringUtils.isNotEmpty((String)orgNum) && StringUtils.isNotEmpty((String)processNum) && (pair = TransMemberUtil.getTransOrgAndCurbyOrgId(BcmThreadCache.findMemberByNum((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)orgNum), modelId, processNum, currencyNum)) != null && StringUtils.isNotEmpty((String)((String)pair.p2))) {
            pageMemberMap.put(PresetConstant.CURRENCY_DIM, (String)pair.p2);
        }
        return orgNum;
    }

    public static void dealCellOrgDimMemMap(Map<String, String> map) {
        String[] split;
        String orgNum = map.get(PresetConstant.ENTITY_DIM);
        if (StringUtils.isNotEmpty((String)orgNum) && (split = orgNum.split("_")).length == 2) {
            map.put(PresetConstant.ENTITY_DIM, split[1]);
        }
    }

    public static Map<String, String> getCellDimMemberMap(Map<String, String> pageMemberMap, String orgNum, Map<DimTypesEnum, Object> params, Cell cell, long modelId, boolean isParSon) {
        HashMap<String, String> commonMemberMap = new HashMap<String, String>(16);
        if (cell.isMdDataDomain()) {
            String processNum;
            String yearNum;
            String periodNum;
            commonMemberMap.putAll(pageMemberMap);
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            String currentRuntimePeriod = (String)params.get(DimTypesEnum.PERIOD);
            String currentRuntimeYear = (String)params.get(DimTypesEnum.YEAR);
            boolean periodIsPy = commonMemberMap.containsKey(PresetConstant.PERIOD_DIM);
            boolean yearIsPy = commonMemberMap.containsKey(PresetConstant.FY_DIM);
            boolean hasLastYear = false;
            for (IDimMember e : cell.getMemberFromUserObject()) {
                String memNum = e.getNumber();
                String dimNum = e.getDimension().getNumber();
                if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                    String string = orgNum = StringUtils.isNotEmpty((String)e.getPar_SonNum()) ? e.getPar_SonNum() : MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memNum).getParent_SonNumber();
                }
                if (PresetConstant.FY_DIM.equals(dimNum)) {
                    hasLastYear = "LastYear".equals(memNum) || "LastYear".equals(((DimMember)e).getOriNumber());
                    Optional fy = PeriodUtils.trans2SpecificFy((String)modelNumber, (String)currentRuntimeYear, (String)memNum);
                    if (fy.isPresent()) {
                        memNum = (String)fy.get();
                    }
                }
                if (PresetConstant.PERIOD_DIM.equals(dimNum) && "CurrentPeriod".equals(memNum)) {
                    memNum = currentRuntimePeriod;
                }
                commonMemberMap.put(dimNum, memNum);
            }
            String currencyNum = (String)commonMemberMap.get(PresetConstant.CURRENCY_DIM);
            if (StringUtils.isNotEmpty((String)currencyNum) && ("DC".equals(currencyNum) || "EC".equals(currencyNum))) {
                Pair<String, String> pair = TransMemberUtil.getTransOrgAndCurbyOrgId(MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNum), modelId, (String)commonMemberMap.get(PresetConstant.PROCESS_DIM), currencyNum);
                commonMemberMap.put(PresetConstant.CURRENCY_DIM, (String)pair.p2);
            }
            if (StringUtils.isNotEmpty((String)(periodNum = (String)commonMemberMap.get(PresetConstant.PERIOD_DIM))) && "LastPeriod".equals(periodNum) && StringUtils.isNotEmpty((String)(yearNum = (String)commonMemberMap.get(PresetConstant.FY_DIM))) && !Arrays.asList("LastYear", "CurrentYear", "AllYear", "Year").contains(yearNum)) {
                Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)modelNumber, (String)((String)commonMemberMap.get(PresetConstant.SCENE_DIM)), (String)currentRuntimePeriod, (String)yearNum, (String)"LastPeriod");
                if (StringUtils.isNotEmpty((String)((String)yearAndPeriod.p2))) {
                    commonMemberMap.put(PresetConstant.PERIOD_DIM, (String)yearAndPeriod.p2);
                }
                if (StringUtils.isNotEmpty((String)((String)yearAndPeriod.p1)) && !yearNum.equals(yearAndPeriod.p1)) {
                    commonMemberMap.put(PresetConstant.FY_DIM, (String)yearAndPeriod.p1);
                }
            }
            if (hasLastYear && !yearIsPy && periodIsPy) {
                commonMemberMap.put(PresetConstant.PERIOD_DIM, ConfigServiceHelper.getExchangePeriodForLastYear(modelId, (String)commonMemberMap.get(PresetConstant.SCENE_DIM), currentRuntimePeriod));
            }
            if (!isParSon && StringUtils.isNotEmpty((String)(processNum = (String)commonMemberMap.get(PresetConstant.PROCESS_DIM)))) {
                isParSon = OrgRelaProcessMembPool.isRelaProcess((String)processNum);
            }
            if (isParSon) {
                commonMemberMap.put(PresetConstant.ENTITY_DIM, orgNum);
            }
        }
        return commonMemberMap;
    }

    public static Map<String, String> getExtCellDimMemberMap(SpreadManager sm, Map<DimTypesEnum, Object> params, Cell cell, long modelId, boolean isParSon) {
        String processNum;
        HashMap<String, String> commonMemberMap = new HashMap<String, String>(16);
        List commonMemberList = sm.getFilter().getPageDomain().getAllMembers();
        commonMemberList.addAll(sm.getFilter().getViewPointDomain().getAllMembers());
        String orgNum = "";
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (IDimMember mem : commonMemberList) {
            String dimNum = mem.getDimension().getNumber();
            String memNum = mem.getNumber();
            if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                orgNum = StringUtils.isNotEmpty((String)mem.getPar_SonNum()) ? mem.getPar_SonNum() : MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memNum).getParent_SonNumber();
            }
            commonMemberMap.put(dimNum, memNum);
        }
        PositionInfo posInfo = sm.getInAreaExtPositionByXY(cell.getRow(), cell.getCol());
        List floatDimNums = posInfo.getExtendInfo().getFloatDimNums();
        floatDimNums.remove(DimTypesEnum.ENTITY.getNumber());
        for (String floatDimNum : floatDimNums) {
            commonMemberMap.remove(floatDimNum);
        }
        Map index2FloatDimNums = sm.getExtFloatDimInfoIncludeOrg(posInfo);
        Sheet sheet = sm.getBook().getSheet(0);
        for (Integer c : index2FloatDimNums.keySet()) {
            Cell curCell = sheet.getCell(cell.getRow(), c.intValue());
            if (curCell.getMemberFromUserObject() == null) continue;
            for (IDimMember e : curCell.getMemberFromUserObject()) {
                String memNum = e.getNumber();
                String dimNum = e.getDimension().getNumber();
                if (PresetConstant.ENTITY_DIM.equals(dimNum)) {
                    orgNum = StringUtils.isNotEmpty((String)e.getPar_SonNum()) ? e.getPar_SonNum() : MemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)memNum).getParent_SonNumber();
                }
                commonMemberMap.put(dimNum, memNum);
            }
        }
        String currencyNum = (String)commonMemberMap.get(PresetConstant.CURRENCY_DIM);
        if (StringUtils.isNotEmpty((String)currencyNum) && ("DC".equals(currencyNum) || "EC".equals(currencyNum))) {
            Pair<String, String> pair = TransMemberUtil.getTransOrgAndCurbyOrgId(MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNum), modelId, (String)commonMemberMap.get(PresetConstant.PROCESS_DIM), currencyNum);
            commonMemberMap.put(PresetConstant.CURRENCY_DIM, (String)pair.p2);
        }
        if (!isParSon && StringUtils.isNotEmpty((String)(processNum = (String)commonMemberMap.get(PresetConstant.PROCESS_DIM)))) {
            isParSon = OrgRelaProcessMembPool.isRelaProcess((String)processNum);
        }
        if (isParSon) {
            commonMemberMap.put(PresetConstant.ENTITY_DIM, orgNum);
        }
        return commonMemberMap;
    }
}

