/**
 * 规则执行脚本统一放在这里进行管理，请增加或修改时增加注释。
 */

var ctx = outline.getComputingContext();

function isNull(arg){
  return arg === null || arg ==="" || arg === undefined;
}

function getArrayArg(params) {
    var length = params.length;
    var args = __builtin__.createObjectArray(length);
    for(var i = 0;i<length;i++){
        args[i] = params[i];
    }
    return args;
}

function scope(){
    return __builtin__.create(getArrayArg(arguments));
}

function factorList(){
    return __builtin__.createScriptFactorList();
}

function runRule(scope) {
    var length = arguments.length;
    if (length == 1) {
        ruleNumber = arguments[0];
    }else{
        ruleNumber = arguments[1];
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runRule(scope, ruleNumber);
}

function runConvert() {
    var length = arguments.length;
    var scope;
    var scrCurrency,targetCurrency;
    if (length == 3) {
        scope = arguments[0];
        scrCurrency = arguments[1];
        targetCurrency = arguments[2];
    }else if(length == 2){
        scrCurrency = arguments[0];
        targetCurrency = arguments[1];
    }else{
        debug(length + typeof (length))
    	throw "折算公式参数设置错误!";
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runConvert(scope, scrCurrency, targetCurrency);
}

function runConsolidate(scope) {
    var length = arguments.length;
    if (length == 1) {
        calCondition = arguments[0];
    } else {
        calCondition = arguments[1];
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.runConsolidate(scope, calCondition);
}

function run() {
    var args = getArrayArg(arguments)
    var objects = __builtin__.transParamsWithScope(args);
    expressions = __builtin__.createStringArray(objects.length-1);
    for(var i = 1; i < objects.length; i++) {
        __builtin__.addString(expressions,i-1,objects[i]);
    }
    var scope = objects[0];
    __builtin__.compute('fel','',scope,expressions);
}

function copy() {
    var args = getArrayArg(arguments)
    var rightExpression = args[0];
    var scope = __builtin__.getScopeInfo(args[1])
    __builtin__.copy(rightExpression, scope);
}

function runs() {
    var args = getArrayArg(arguments)
    var objects = __builtin__.transParamsWithScope(args);
    expressions = __builtin__.createStringArray(objects.length-1);
    for(var i = 1; i < objects.length; i++) {
        __builtin__.addString(expressions,i-1,objects[i]);
    }
    var scope = objects[0];
    __builtin__.computeSerial('fel','',scope,expressions);
}

// scope范围生效以就近原则，靠近调用方则scope内容有优先权
function getRuntimeScope(scope){
    return ctx.getRuntimeScope(scope);
}

// scope片段作用范围定义，以endFix结束，开始会压入scope栈队列中，结束后会弹出栈
function fix(scopeItems){
    var newScope = __builtin__.create(scopeItems);
    ctx.pushScope(newScope);
}

function endFix(){
    ctx.popScope();
}

//片段作用精度定义，以endRound结束
function round(precision){
    ctx.pushPrecision(precision);
}

function endRound(){
    ctx.popPrecision();
}

function isInstanceofScope(arg){
  return __builtin__.isInstanceofScope(arg);
}

function agg(scope) {
    var length = arguments.length;
    var members;
    if (length == 1) {
        members = __builtin__.createStringArray(1);
        __builtin__.addString(members, 0, arguments[0]);
    } else {
        members = __builtin__.createStringArray(length - 1);
        for (var i = 1; i < length; i++) {
            __builtin__.addString(members, i - 1, arguments[i])
        }
    }
    scope = __builtin__.getScopeInfo(scope);
    scope = getRuntimeScope(scope);
    __builtin__.agg(scope, members);
}


/**
 * 新版本的v函数
 * @param expression 表达式或范围对象
 * @param defaultValue 为空时默认返回值
 */
function v() {
    var args = getArrayArg(arguments)
    return  __builtin__.evalNew(args);
}

/**
 * inv 函数: 获取指定投维度组合的权益变动数据
 * @param dimStr 维度组合字符串, 必须
 * @param typeStr 取数类型, P本期, Y年累计, E期末, 不区分大小写，必须
 */
function inv(dimStr,typeStr){
    if(typeof(dimStr)!='string' || typeof(typeStr) != 'string'){
        throw "inv公式参数类型不正确!";
    }
    return __builtin__.inv(dimStr, typeStr);
}

/**
 * 单元格值的保存
 */
function save(scope,value){
    //因为需要校验维度是否已指定，getRuntimeScope在放到save里调用
    return __builtin__.save(scope,value);
}

/**
 * 获取cellSet集
 */
function getCellSet(){
	var length = arguments.length;
	if(length > 1){
        var isAsc = arguments[1];
        return __builtin__.getCellSet(getRuntimeScope(arguments[0]),false,isAsc);
    }else{
        return __builtin__.getCellSet(getRuntimeScope(arguments[0]),false);
    }
}

function ismember(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isMember(arg, mergeScope);
}

function properties() {
    var length = arguments.length;
    var mergeScope = getRuntimeScope(null);
    if (length == 2) {
        return outline.searchProperties(arguments[0], CE, arguments[1], mergeScope);
    } else if (length == 3) {
        return outline.searchProperties(arguments[0], arguments[1], arguments[2], mergeScope);
    }
    var errMsg = 'invalid param ';
    for(var j = 0; j < length; j++) {
        errMsg  += arguments[j] + ','
    }
    throw errMsg;
}

function idescendants(dimension, name) {
    return outline.searchIdesc(dimension, name);
}

function descendants(dimension, name) {
    return outline.searchDescendants(dimension, name);
}

function isparent(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isParent(arg, mergeScope);
}

function isiparent(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIparent(arg, mergeScope);
}

function isancest(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isAncest(arg, mergeScope);
}

function isiancest(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIancest(arg, mergeScope);
}

function ischild(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isChild(arg, mergeScope);
}

function isichild(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIchild(arg, mergeScope);
}

function isdescendants(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isDescendants(arg, mergeScope);
}

function isidescendant(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIdescendant(arg, mergeScope);
}

function issibling(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isSibling(arg, mergeScope);
}

function isisibling(arg) {
    var mergeScope = getRuntimeScope(null);
    return outline.isIsibling(arg, mergeScope);
}

function isproperties(dimension, properity, value) {
    var mergeScope = getRuntimeScope(null);
    return outline.isProperties(dimension, properity, value, mergeScope);
}

function debug(arg){
    __builtin__.debug(arg);
}
function log(arg){
    __builtin__.log(arg);
}

Math.sum = function () {
    var sum = 0;
    var length = arguments.length;
    for (var i = 0; i < length; i++) {
        sum +=arguments[i];
    }
    return sum;
}

Math.avg = function() {
    var sum = 0;
    var length = arguments.length;
    for (var i = 0; i < length; i++) {
        sum +=arguments[i];
    }
    return sum/length;
};

function esp(){
    return __builtin__.esp(getArrayArg(arguments));
}

function getRate(){
    return __builtin__.getRate(getArrayArg(arguments));
}

function setRate(){
    return __builtin__.setRate(getArrayArg(arguments));
}


function import(){
    return __builtin__.importScriptLib(getArrayArg(arguments));
}


function getConAttr() {
    return __builtin__.getConAttr(getArrayArg(arguments));
}

function getJournal(){
    var jlObj = new Journal(ctx);
    return jlObj;
}

//缓存全局数据
function setCache(cacheKey,v){
	__builtin__.setCache(cacheKey,v);
}

//从缓存中取数，没有则load
function getCache(cacheKey,f){
	return __builtin__.loadOrCache(cacheKey,f);
}

function beginBatch(){
	__builtin__.beginBatch();
}

function endBatch(){
	__builtin__.endBatch();
}

function formatString(){
    return __builtin__.formatString(getArrayArg(arguments));
}

/**
 * translate 函数: 指定组织编码和折算目标币种编码，调用系统折算逻辑执行从组织的EC币到目标币的折算，不容许在EIRpt、ERAdj、IRpt及RAdj上执行
 * @param entCode 折算组织编码
 * @param tarCurrency 折算目标币种编码
 */
function translate(entCode, tarCurrency){
    if(typeof(entCode)!='string' || typeof(tarCurrency) != 'string'){
        throw "translate 公式参数类型不正确!";
    }
    __builtin__.translate(entCode, tarCurrency);
}

function clear(scope){
    __builtin__.clear(scope);
}

function getLastYearEnd(){
   return __builtin__.getLastYearEnd();
}
function getEntityLastPeriod(args){
    return __builtin__.getEntityLastPeriod(args);
}
function getAccountLastPeriod(args){
    return __builtin__.getAccountLastPeriod(args);
}
function getSpecialLastPeriod(entity, account){
    return __builtin__.getSpecialLastPeriod(entity, account);
}

function getLastPeriod(){
   return __builtin__.getLastPeriod();
}

function shareJournal(virEntCode) {
    return __builtin__.shareJournal(virEntCode);
}

function getOwnership(){
    return JSON.parse(__builtin__.getOwnership(getArrayArg(arguments)));
}

function  setOwnership(){
    return __builtin__.setOwnership(getArrayArg(arguments));
}

function  delOwnership(){
    return __builtin__.delOwnership(getArrayArg(arguments));
}


function isInstanceofScope(arg){
    return __builtin__.isInstanceofScope(arg);
}

function getXDMSet() {
    return __builtin__.getXDMSet(getArrayArg(arguments));
}


/**
 * xRuns执行对应拓展数据模型中的字段赋值
 * @param node ScriptAllMemberExtDimensionNode对象（XDM对象）
 * @param XDMScopeInfo  范围
 * @param expressions  表达式
 */
function xRuns() {
    var args = getArrayArg(arguments);
    //范围参数有可能不会传, true代表传入(其中顺便校验了xdm参数和表达式必须存在)
    var checkXdmScope = __builtin__.checkXdmScope(args);
    var beforeExpression = 2;
    var xdmScope = args[1];
    if(!checkXdmScope){
        beforeExpression = 1;
        xdmScope = __builtin__.creatNewXdmScope();
    }
    expressions = __builtin__.createStringArray(args.length - beforeExpression);
    for(var i = beforeExpression; i < args.length; i++) {
        __builtin__.addString(expressions,i-beforeExpression,args[i]);
    }

    __builtin__.xRuns(args[0],xdmScope,expressions);
}

/**
 * 将获取的数据集写入到目标维度组合中
 * @param dimStr 目标维度组合中
 * @param xDataSet  拓展数据模型的getColSumSet方法返回的数据集，包含多维字段及数据列
 */
function xSyn() {
    return __builtin__.xSyn(getArrayArg(arguments));
}

function getInvestInfo(){
    if(arguments.length>3){
        return JSON.parse(__builtin__.getInvestInfo(arguments[0], arguments[1],arguments[2],arguments[3]));
    }
    return JSON.parse(__builtin__.getInvestInfo(arguments[0], arguments[1],arguments[2]));
}

function getOwnershipMap(){
    var args = getArrayArg(arguments);
    return __builtin__.getOwnershipMap(args[0], args[1],args[2]);
}

function isRptStatMatched(){
    return __builtin__.isRptStatMatched(getArrayArg(arguments));
}

function getRptStats(){
    return __builtin__.getRptStats(getArrayArg(arguments));
}

function xCopy() {
    return __builtin__.xCopy(getArrayArg(arguments));
}

function XDMScope() {
    return __builtin__.XDMScope(getArrayArg(arguments));
}


function when() {
    return __builtin__.when(getArrayArg(arguments));
}

function getConFlowStatus(){
    return __builtin__.getConFlowStatus(getArrayArg(arguments));
}

function genDimKey() {
    var args = getArrayArg(arguments);
    if (args.length == 0) {
        return "";
    } else {
        var matchs = args[0].match("[.@]");
        if (matchs) {
            var obj = {};
            args.forEach(function(arg) {
                var dimMem = arg.split(matchs[0]);
                obj[dimMem[0]] = dimMem[1];
            })
            return obj;
        } else {
            var  res = args[0];
            for (var i = 1; i < args.length; i++) {
                res += "|" + args[i];
            }
            return res;
        }
    }
}

function splitDimKey(arg) {
    if (typeof(arg) == 'string' ) {
        if (arg.includes("|")) {
            return arg.split("|");
        } else {
            return arg;
        }
    } else {
        var res = "";
        for (let key in arg) {
            res += key + "@" + arg[key] + ",";
        }
        return res.substring(0, res.length - 1);
    }
}