/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.upgradeservice;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class BookRegisterUpgradeService
implements IUpgradeService {
    private static final DBRoute FI = DBRoute.of((String)"fi");
    Map<String, BookRegisterInfo> bookRegisters = new HashMap<String, BookRegisterInfo>(8);
    static List<String> fields = Arrays.asList("fid", "fcloud", "fbizapp", "fformid", "fbookorg", "fbooktypefieldid", "fcloseoperation", "fclosemservice", "fbookentityid", "fbtonbookentity", "forgonbookentity", "fquerymservice", "FValidatePreTX", "FSkipMode");
    Map<String, String> entityId2Key = new HashMap<String, String>(8);
    Map<String, String> bizAppId2Num = new HashMap<String, String>(8);
    String cloudSql = "select b.fnumber cloudnum from t_meta_bizapp a left join t_meta_bizcloud b on a.fbizcloudid = b.fid where a.fnumber = ?";
    Map<String, String> bizApp2CloudNum = new HashMap<String, String>(8);
    static final Map<String, ThreeTuple<String, String, String>> app2BookEntity = new HashMap<String, ThreeTuple<String, String, String>>();

    BookRegisterInfo getOrCreateNew(String bizApp) {
        return this.bookRegisters.computeIfAbsent(bizApp, key -> {
            BookRegisterInfo bookRegisterInfo = new BookRegisterInfo();
            bookRegisterInfo.setId(Long.valueOf(DB.genLongId((String)"t_bd_accountbookregister")));
            bookRegisterInfo.setCloud("");
            bookRegisterInfo.setBookEntityId("");
            bookRegisterInfo.setBookTypeFieldOnBookEntity("");
            bookRegisterInfo.setOrgFieldOnBookEntity("");
            bookRegisterInfo.setQueryBookMservice("");
            bookRegisterInfo.setClosePeriodMservice("");
            bookRegisterInfo.setCloseEntityOfCloseOp("");
            bookRegisterInfo.setOrgFieldOnCloseEntity("");
            bookRegisterInfo.setBookTypeFieldOnCloseEntity("");
            bookRegisterInfo.setCloseOperationKey("");
            bookRegisterInfo.setValidateBeforeTX(true);
            bookRegisterInfo.setSkipMode("0");
            return bookRegisterInfo;
        });
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        if (DB.exitsTable((DBRoute)new DBRoute("fi"), (String)"t_bd_accountbookregister")) {
            this.upgrade1();
        }
        if (DB.exitsTable((DBRoute)new DBRoute("fi"), (String)"t_fcm_financialconfig")) {
            this.upgrade2();
        }
        if (DB.exitsTable((DBRoute)new DBRoute("fi"), (String)"t_fcm_app_account")) {
            this.upgrade3();
        }
        this.doSave(this.bookRegisters);
    }

    private void doSave(Map<String, BookRegisterInfo> bookRegisters) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                Object[] savedIds = bookRegisters.values().stream().map(BookRegisterInfo::getId).toArray();
                DB.execute((DBRoute)FI, (SqlBuilder)new SqlBuilder().appendIn("delete from t_bd_accountbookregister where fid ", savedIds));
                List params = bookRegisters.values().stream().map(bookRegister -> {
                    ThreeTuple<String, String, String> bookEntity;
                    Object[] param = new Object[fields.size()];
                    param[0] = bookRegister.getId();
                    String bizApp = bookRegister.getBizApp();
                    param[1] = StringUtils.isEmpty((String)bookRegister.getCloud()) ? this.getCloudNum(bizApp) : bookRegister.getCloud();
                    param[2] = bizApp;
                    param[3] = bookRegister.getCloseEntityOfCloseOp();
                    if (!StringUtils.isEmpty((String)bookRegister.getCloseEntityOfCloseOp()) && StringUtils.isEmpty((String)bookRegister.getOrgFieldOnCloseEntity())) {
                        bookRegister.setOrgFieldOnCloseEntity("org");
                    }
                    param[4] = bookRegister.getOrgFieldOnCloseEntity();
                    param[5] = bookRegister.getBookTypeFieldOnCloseEntity();
                    param[6] = bookRegister.getCloseOperationKey();
                    param[7] = bookRegister.getClosePeriodMservice();
                    if (StringUtils.isEmpty((String)bookRegister.getBookEntityId()) && (bookEntity = app2BookEntity.get(bizApp)) != null) {
                        bookRegister.setBookEntityId((String)bookEntity.item1);
                        bookRegister.setOrgFieldOnBookEntity((String)bookEntity.item2);
                        bookRegister.setBookTypeFieldOnBookEntity((String)bookEntity.item3);
                    }
                    param[8] = bookRegister.getBookEntityId() == null ? "" : bookRegister.getBookEntityId();
                    param[9] = bookRegister.getBookTypeFieldOnBookEntity();
                    param[10] = bookRegister.getOrgFieldOnBookEntity();
                    param[11] = bookRegister.getQueryBookMservice();
                    param[12] = bookRegister.isValidateBeforeTX();
                    param[13] = bookRegister.getSkipMode();
                    return param;
                }).collect(Collectors.toList());
                String holders = fields.stream().map(x -> "?").collect(Collectors.joining(", "));
                DB.executeBatch((DBRoute)FI, (String)String.format("INSERT INTO t_bd_accountbookregister (%s) VALUES(%s)", String.join((CharSequence)",", fields), holders), params);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    void upgrade1() {
        DB.query((DBRoute)new DBRoute("fi"), (String)"select fid, fbizapp,FCloud,FBookEntityId,FOrgOnBookEntity,FBtOnBookEntity,FQueryMservice,fformid,FBookOrg,fbooktypefieldid,FCloseOperation,FCloseMservice,FValidatePreTX,FSkipMode from t_bd_accountbookregister", null, resultSet -> {
            while (resultSet.next()) {
                BookRegisterInfo bookRegister = this.getOrCreateNew(resultSet.getString("fbizapp"));
                bookRegister.setId(Long.valueOf(resultSet.getLong("fid")));
                bookRegister.setBizApp(resultSet.getString("fbizapp"));
                bookRegister.setCloud(resultSet.getString("FCloud"));
                bookRegister.setBookEntityId(resultSet.getString("FBookEntityId"));
                bookRegister.setOrgFieldOnBookEntity(resultSet.getString("FOrgOnBookEntity"));
                bookRegister.setBookTypeFieldOnBookEntity(resultSet.getString("FBtOnBookEntity"));
                bookRegister.setQueryBookMservice(resultSet.getString("FQueryMservice"));
                bookRegister.setCloseEntityOfCloseOp(resultSet.getString("fformid"));
                bookRegister.setOrgFieldOnCloseEntity(resultSet.getString("FBookOrg"));
                bookRegister.setBookTypeFieldOnCloseEntity(resultSet.getString("fbooktypefieldid"));
                bookRegister.setCloseOperationKey(resultSet.getString("FCloseOperation"));
                bookRegister.setClosePeriodMservice(resultSet.getString("FCloseMservice"));
                bookRegister.setValidateBeforeTX(resultSet.getBoolean("FValidatePreTX"));
                bookRegister.setSkipMode(resultSet.getString("FSkipMode"));
            }
            return null;
        });
    }

    void upgrade2() {
        DB.query((DBRoute)new DBRoute("fi"), (String)"select fcheckoutentity ,fcheckoutop ,ftype ,fbizappid ,fbooktypefiled from t_fcm_financialconfig", null, resultSet -> {
            while (resultSet.next()) {
                String bizAppNum = this.getBizAppNum(resultSet.getString("fbizappid"));
                BookRegisterInfo bookRegister = this.getOrCreateNew(bizAppNum);
                if (StringUtils.isEmpty((String)bookRegister.getQueryBookMservice())) {
                    bookRegister.setQueryBookMservice("fi,gl,FinancialBooksService,queryAccountBooks");
                }
                if (StringUtils.isEmpty((String)bookRegister.getBizApp())) {
                    bookRegister.setBizApp(bizAppNum);
                }
                if (StringUtils.isEmpty((String)bookRegister.getCloseEntityOfCloseOp())) {
                    bookRegister.setCloseEntityOfCloseOp(this.getEntityKey(resultSet.getString("fcheckoutentity")));
                }
                if ("0".equals(resultSet.getString("ftype"))) {
                    if (StringUtils.isEmpty((String)bookRegister.getBookTypeFieldOnCloseEntity())) {
                        bookRegister.setBookTypeFieldOnCloseEntity(resultSet.getString("fbooktypefiled"));
                    }
                    bookRegister.setCloseOperationKey(resultSet.getString("fcheckoutop"));
                    continue;
                }
                if (!"cal".equals(bookRegister.getBizApp())) continue;
                bookRegister.setClosePeriodMservice("fi,cal,CloseService,closePeriod");
            }
            return null;
        });
    }

    void upgrade3() {
        DB.query((DBRoute)new DBRoute("fi"), (String)"select fbizappid ,faccountentity ,faccounttype from t_fcm_app_account", null, resultSet -> {
            while (resultSet.next()) {
                String bizAppNum = this.getBizAppNum(resultSet.getString("fbizappid"));
                BookRegisterInfo bookRegister = this.getOrCreateNew(bizAppNum);
                if (!StringUtils.isEmpty((String)bookRegister.getBizApp())) continue;
                bookRegister.setBizApp(bizAppNum);
            }
            return null;
        });
    }

    String getEntityKey(String entityId) {
        return this.entityId2Key.computeIfAbsent(entityId, entity -> (String)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)new SqlBuilder().append("select fid from t_meta_mainentityinfo where fdentityid = ?", new Object[]{entity}), resultSet -> resultSet.next() ? resultSet.getString("fid") : ""));
    }

    String getBizAppNum(String bizAppId) {
        return this.bizAppId2Num.computeIfAbsent(bizAppId, appId -> (String)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)new SqlBuilder().append("select fnumber, fbizcloudid from t_meta_bizapp where fid = ?", new Object[]{bizAppId}), resultSet -> resultSet.next() ? resultSet.getString("fnumber") : ""));
    }

    String getCloudNum(String bizApp) {
        return this.bizApp2CloudNum.computeIfAbsent(bizApp, app -> (String)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)new SqlBuilder().append(this.cloudSql, new Object[]{bizApp}), resultSet -> resultSet.next() ? resultSet.getString("cloudnum") : ""));
    }

    static {
        app2BookEntity.put("gl", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"gl_accountbook", (Object)"org", (Object)"bookstype"));
        app2BookEntity.put("fa", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"fa_assetbook", (Object)"org", (Object)"depreuse"));
        app2BookEntity.put("ar", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"ar_policy", (Object)"useorg", (Object)"policytype"));
        app2BookEntity.put("cal", (ThreeTuple<String, String, String>)new ThreeTuple((Object)"cal_bd_costaccount", (Object)"calorg", (Object)"booktype"));
    }
}

