/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRef;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ThreadLocals;
import kd.fi.bd.accounttableref.AccountTableRefServiceParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.BizHappenUtils;
import kd.fi.bd.util.ContextUtil;

public class AccountOpContext {
    private static final ThreadLocal<AccountOpContext> context = ThreadLocals.create();
    private static final ThreadLocal<Map<Long, Set<Long>>> parentOrgThl = ThreadLocals.create();
    private static final ThreadLocal<Map<Long, Map<Long, Set<String>>>> numberMapInDBThl = ThreadLocals.create();
    private static final ThreadLocal<Set<Long>> addNewAccoutThl = ThreadLocals.create();
    private Map<Long, Long> accCreateOrgIds = new HashMap<Long, Long>();
    private Map<Long, DynamicObject> custAccounts = new HashMap<Long, DynamicObject>();
    private Map<Long, DynamicObject> versAccounts = new HashMap<Long, DynamicObject>();
    private List<DynamicObject> updLeafAccounts = new ArrayList<DynamicObject>();
    private List<DynamicObject> updFullNameAccounts = new ArrayList<DynamicObject>();
    private Map<Object, DynamicObject> parentAccounts = new HashMap<Object, DynamicObject>();
    private Map<Object, Date> parentIdDates = new HashMap<Object, Date>();
    private Map<String, AccountTableRefServiceParam> refServiceParamMap = new HashMap<String, AccountTableRefServiceParam>();
    private Map<Long, Map<Long, Map<String, Set<Long>>>> atOrgAccounts = new HashMap<Long, Map<Long, Map<String, Set<Long>>>>();
    private Set<String> newLeafParentNum = new HashSet<String>();
    private Set<Long> clearCacheOrgs = new HashSet<Long>();
    private Map<Long, Long> orgPorgs = new HashMap<Long, Long>();
    private Map<Long, String> orgNums = new HashMap<Long, String>();
    private Map<Long, String> orgIdNumNameMap = new HashMap<Long, String>();
    private Map<Long, Map<Long, Boolean>> existSubOrgBizMasterAccounts = new HashMap<Long, Map<Long, Boolean>>();
    private Map<Long, Map<Long, Boolean>> existAllBizMasterAccounts = new HashMap<Long, Map<Long, Boolean>>();
    private Map<Long, Long> newAcctOldAcctId = new HashMap<Long, Long>();
    private List<Object[]> excParams = new ArrayList<Object[]>();
    private List<Object[]> useRegParams = new ArrayList<Object[]>();
    private Set<Long> deletePids = new HashSet<Long>();
    private List<Object[]> selfDomParams = new ArrayList<Object[]>();
    private Map<Date, Map<Long, Boolean>> dateAcctidEnables = new HashMap<Date, Map<Long, Boolean>>();
    private Map<Object, DynamicObject> dbDyos = new HashMap<Object, DynamicObject>();
    private Map<Long, Set<Long>> excAcctidOrgIds = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> tableIdTypeIds = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> pidSubIds = new HashMap<Long, Set<Long>>();
    private Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> tableOrgSubAccts = new HashMap<Long, Map<Long, Map<String, Set<DynamicObject>>>>();
    private Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> tableOrgPAccts = new HashMap<Long, Map<Long, Map<String, Set<DynamicObject>>>>();

    public void setClearCacheOrgs(Set<Long> clearCacheOrgs) {
        this.clearCacheOrgs = clearCacheOrgs;
    }

    public Set<Long> getClearCacheOrgs() {
        return this.clearCacheOrgs;
    }

    public Set<String> getNewLeafParentNum() {
        return this.newLeafParentNum;
    }

    static AccountOpContext getContext() {
        return context.get();
    }

    protected void setContext(AccountOpContext ctx) {
        context.set(ctx);
    }

    static void init() {
        AccountOpContext ctx = new AccountOpContext();
        context.set(ctx);
    }

    static void init(ExtendedDataEntity[] dataEntities, OperateOption option) {
        AccountOpContext ctx = new AccountOpContext();
        context.set(ctx);
        AccountOpContext.initparams(ctx, dataEntities);
        AccountOpContext.initDbDyos(ctx, dataEntities);
        AccountOpContext.initTableRefEnabledParams(ctx, dataEntities);
        AccountOpContext.initAccountNumberList(dataEntities);
        AccountOpContext.initAddNewAccount(dataEntities);
        AccountOpContext.initParentAccount(ctx, dataEntities);
        AccountOpContext.initTableOrgAcctNumber(ctx, dataEntities);
        AccountOpContext.initParentAccountInfo(ctx, dataEntities);
    }

    Map<Long, DynamicObject> getCustAccountMap() {
        return this.custAccounts;
    }

    Map<Long, Long> getAccCreateOrgIds() {
        return this.accCreateOrgIds;
    }

    Map<Object, DynamicObject> getParentAccounts() {
        return this.parentAccounts;
    }

    Map<Object, DynamicObject> getDbDyos() {
        return this.dbDyos;
    }

    Map<Long, Long> getOrgPorgs() {
        return this.orgPorgs;
    }

    Map<Long, String> getOrgNums() {
        return this.orgNums;
    }

    Map<Long, String> getOrgIdNumNameMap() {
        return this.orgIdNumNameMap;
    }

    Map<Long, Set<Long>> getTableIdTypeIds() {
        return this.tableIdTypeIds;
    }

    Map<Long, Set<Long>> getPidSubIds() {
        return this.pidSubIds;
    }

    Map<String, AccountTableRefServiceParam> getRefServiceParam() {
        return this.refServiceParamMap;
    }

    Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> getTableOrgSubAccts() {
        return this.tableOrgSubAccts;
    }

    Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> getTableOrgPAccts() {
        return this.tableOrgPAccts;
    }

    public Map<Long, Map<Long, Map<String, Set<Long>>>> getAtOrgAccounts() {
        return this.atOrgAccounts;
    }

    public void setAtOrgAccounts(Map<Long, Map<Long, Map<String, Set<Long>>>> atOrgAccounts) {
        this.atOrgAccounts = atOrgAccounts;
    }

    protected Set<Long> getDeletePids() {
        return this.deletePids;
    }

    protected Map<Long, Set<Long>> getExcAcctidOrgIds() {
        return this.excAcctidOrgIds;
    }

    protected List<Object[]> getSelfDomParams() {
        return this.selfDomParams;
    }

    protected Map<Date, Map<Long, Boolean>> getDateAcctidEnables() {
        return this.dateAcctidEnables;
    }

    Set<Long> getAllParentOrgIds(long useOrgId) {
        Map<Long, Set<Long>> orgSets = parentOrgThl.get();
        if (orgSets == null) {
            orgSets = new HashMap<Long, Set<Long>>(3);
            parentOrgThl.set(orgSets);
        }
        return orgSets.computeIfAbsent(useOrgId, key -> {
            HashSet<Long> orgIds = new HashSet<Long>(10);
            long parentId = this.getParentOrgIds(useOrgId);
            while (parentId != 0L) {
                orgIds.add(parentId);
                parentId = this.getParentOrgIds(parentId);
            }
            return orgIds;
        });
    }

    public Map<Object, Date> getParentIdDates() {
        return this.parentIdDates;
    }

    public void setParentIdDates(Map<Object, Date> parentIdDates) {
        this.parentIdDates = parentIdDates;
    }

    Map<Long, Long> getNewAcctOldAcctId() {
        return this.newAcctOldAcctId;
    }

    List<Object[]> getExcParams() {
        return this.excParams;
    }

    List<Object[]> getUseRegParams() {
        return this.useRegParams;
    }

    Set<String> getAccountNumbers(long accountTableId, long orgId) {
        return numberMapInDBThl.get().get(accountTableId).get(orgId);
    }

    List<DynamicObject> getCustVersAccounts() {
        ArrayList<DynamicObject> accounts = new ArrayList<DynamicObject>(this.custAccounts.size() + this.versAccounts.size());
        accounts.addAll(this.custAccounts.values());
        accounts.addAll(this.versAccounts.values());
        return accounts;
    }

    protected List<DynamicObject> getUpdateAccounts() {
        ArrayList<DynamicObject> accounts = new ArrayList<DynamicObject>(this.updLeafAccounts.size());
        accounts.addAll(this.updLeafAccounts);
        return accounts;
    }

    protected List<DynamicObject> getUpdFullNameAccounts() {
        ArrayList<DynamicObject> accounts = new ArrayList<DynamicObject>(this.updFullNameAccounts.size());
        accounts.addAll(this.updFullNameAccounts);
        return accounts;
    }

    DynamicObject getCustAccount(DynamicObject account, long orgId, Date currDate, boolean isExistBiz, DynamicObject dbAccount) {
        if (account == null) {
            return null;
        }
        long pId = account.getLong("id");
        DynamicObject newParent = this.custAccounts.get(pId);
        if (newParent != null) {
            return null;
        }
        long createOrgId = account.getLong("createorg_id");
        if (createOrgId != orgId) {
            newParent = this.custAccount(account, orgId);
            this.custAccounts.put(pId, newParent);
            this.accCreateOrgIds.put(pId, createOrgId);
            this.newAcctOldAcctId.put(newParent.getLong("id"), pId);
        } else {
            newParent = account;
            this.updLeafAccounts.add(newParent);
        }
        if (isExistBiz) {
            if ("1900-01-01".equals(DateUtils.formatString((Date)currDate, (String)"yyyy-MM-dd"))) {
                throw new KDBizException("logic error, please contact developer to track.");
            }
            newParent.set("enddate", (Object)currDate);
        } else if (dbAccount != null) {
            newParent.set("enddate", dbAccount.get("enddate"));
            newParent.set("startdate", dbAccount.get("startdate"));
        }
        return newParent;
    }

    DynamicObject getVersAccount(DynamicObject account, long orgId, Date currDate, long oldAcctId) {
        if (account == null) {
            return null;
        }
        long pId = account.getLong("id");
        DynamicObject newParent = this.versAccounts.get(pId);
        if (newParent != null) {
            return null;
        }
        account.set("createorg_id", (Object)orgId);
        account.set("org_id", (Object)orgId);
        newParent = this.versAccount(account, currDate);
        this.versAccounts.put(pId, newParent);
        this.prepareServiceParam(orgId, newParent.getLong("accounttable_id"), currDate, newParent.getLong("id"), oldAcctId);
        this.newAcctOldAcctId.put(newParent.getLong("id"), oldAcctId);
        return newParent;
    }

    void custVersAccount(DynamicObject account, long orgId, DynamicObject child, Date currDate, boolean isVersionAddLeaf) {
        long pId;
        DynamicObject newParent;
        if (account == null) {
            return;
        }
        if (child != null) {
            child.set("startdate", account.get("startdate"));
        }
        if ((newParent = this.custAccounts.get(pId = account.getLong("id"))) != null) {
            return;
        }
        newParent = this.versAccounts.get(pId);
        if (newParent != null) {
            if (child != null) {
                child.set("startdate", (Object)currDate);
            }
            return;
        }
        long createOrgId = account.getLong("createorg_id");
        if (createOrgId != orgId) {
            newParent = this.custAccount(account, orgId);
            this.newAcctOldAcctId.put(newParent.getLong("id"), pId);
            this.custAccounts.put(pId, newParent);
            this.accCreateOrgIds.put(pId, createOrgId);
        } else {
            newParent = account;
            if (child != null && newParent.getBoolean("isleaf")) {
                this.updLeafAccounts.add(newParent);
            }
        }
        if (isVersionAddLeaf || BizHappenUtils.existsOnOrgDomain((long)account.getLong("masterid"), (long)orgId, null)) {
            newParent = this.versAccount(newParent, currDate);
            if (child != null) {
                newParent.set("masterid", (Object)newParent.getLong("id"));
                child.set("masterid", (Object)account.getLong("masterid"));
                child.set("startdate", (Object)currDate);
            }
            this.newAcctOldAcctId.put(newParent.getLong("id"), pId);
            this.versAccounts.put(pId, newParent);
        }
        if (child != null && newParent.getInt("orgcontrollevel") < child.getInt("level")) {
            newParent.set("orgcontrollevel", (Object)child.getInt("level"));
        }
        newParent.set("isleaf", (Object)false);
        this.prepareServiceParam(orgId, newParent.getLong("accounttable_id"), currDate, newParent.getLong("id"), account.getLong("id"));
        if (child != null) {
            child.set("parent_id", newParent.get("id"));
        }
    }

    protected static void initOrgRelated(AccountOpContext ctx, long useorgId) {
        AccountOpContext.initOrgPorgs(ctx, useorgId);
        AccountOpContext.initOrgNums(ctx);
    }

    private static void initOrgPorgs(AccountOpContext ctx, long useorgId) {
        Map<Long, Long> orgPorgs = ctx.getOrgPorgs();
        Long porgId = orgPorgs.get(useorgId);
        if (porgId == null) {
            porgId = ctx.getParentOrgIds(useorgId);
            orgPorgs.put(useorgId, porgId);
        }
    }

    private static void initOrgNums(AccountOpContext ctx) {
        Map<Long, Long> orgPorgs = ctx.getOrgPorgs();
        HashSet<Long> ids = new HashSet<Long>(1000);
        if (!orgPorgs.isEmpty()) {
            ids.addAll(orgPorgs.keySet());
            ids.addAll(orgPorgs.values());
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"initOrgNums", (String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
                for (Row row : dt) {
                    ctx.getOrgNums().put(row.getLong("id"), row.getString("number"));
                    ctx.getOrgIdNumNameMap().put(row.getLong("id"), row.getString("number") + " " + row.getString("name"));
                }
            }
        }
    }

    protected String getOrgNum(long orgId) {
        String orgNum = this.getOrgNums().get(orgId);
        if (orgNum == null) {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"initOrgNums", (String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray(), null);){
                for (Row row : dt) {
                    orgNum = row.getString("number");
                    this.getOrgNums().put(orgId, orgNum);
                    this.getOrgIdNumNameMap().put(row.getLong("id"), row.getString("number") + " " + row.getString("name"));
                }
            }
        }
        return orgNum;
    }

    protected String getOrgNumAndName(long orgId) {
        String orgNumName = this.getOrgIdNumNameMap().get(orgId);
        if (orgNumName == null) {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"initOrgNums", (String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray(), null);){
                for (Row row : dt) {
                    this.getOrgNums().put(orgId, row.getString("number"));
                    orgNumName = row.getString("number") + " " + row.getString("name");
                    this.getOrgIdNumNameMap().put(orgId, orgNumName);
                }
            }
        }
        return orgNumName;
    }

    protected static void initTableOrgPaccts(AccountOpContext ctx, long tableId, long porgId, String number) {
        Set<DynamicObject> paccts;
        Map<String, Set<DynamicObject>> allpaccts;
        Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> tableOrgPAccts = ctx.getTableOrgPAccts();
        Map<Long, Map<String, Set<DynamicObject>>> orgPaccts = tableOrgPAccts.get(tableId);
        if (orgPaccts == null) {
            orgPaccts = new HashMap<Long, Map<String, Set<DynamicObject>>>();
            tableOrgPAccts.put(tableId, orgPaccts);
        }
        if ((allpaccts = orgPaccts.get(porgId)) == null) {
            allpaccts = new HashMap<String, Set<DynamicObject>>();
            orgPaccts.put(porgId, allpaccts);
        }
        if ((paccts = allpaccts.get(number)) == null) {
            List ids;
            paccts = new HashSet<DynamicObject>();
            if (porgId != 0L && !(ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{AccountUtils.getBaseDataFilter((long)porgId), new QFilter("accounttable", "=", (Object)tableId), new QFilter("number", "=", (Object)number), new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate())}, null, (int)-1)).isEmpty()) {
                DynamicObject[] dyos;
                for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                    paccts.add(dyo);
                }
            }
            allpaccts.put(number, paccts);
        }
    }

    protected static void initPidSubIds(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        Map<Long, Set<Long>> pidSubids = ctx.getPidSubIds();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject obj = extendedDataEntity.getDataEntity();
            pidSubids.computeIfAbsent(obj.getLong("id"), k -> new HashSet());
        }
        if (!pidSubids.isEmpty()) {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"initPidSubIds", (String)"bd_accountview", (String)"id,parent", (QFilter[])new QFilter("parent", "in", pidSubids.keySet()).toArray(), null);){
                for (Row row : dt) {
                    Set<Long> subIds = pidSubids.get(row.getLong("parent"));
                    subIds.add(row.getLong("id"));
                }
            }
        }
    }

    private static void initparams(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        Map<Long, Set<Long>> tableIdTypeIds = ctx.getTableIdTypeIds();
        Map<Long, Map<Long, Map<String, Set<DynamicObject>>>> tableOrgSubAccts = ctx.getTableOrgSubAccts();
        HashMap<Long, Map> tableOrgSubAcctDates = new HashMap<Long, Map>();
        Map<Long, Set<Long>> excAcctidOrgIds = ctx.getExcAcctidOrgIds();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject obj = entity.getDataEntity();
            long tableId = obj.getLong("accounttable_id");
            tableIdTypeIds.computeIfAbsent(tableId, k -> new HashSet());
            long useOrgId = obj.getLong("useorg_id");
            if (!obj.getDataEntityState().getFromDatabase() || obj.getLong("id") == 0L) continue;
            tableOrgSubAccts.computeIfAbsent(tableId, k -> new HashMap()).computeIfAbsent(useOrgId, k -> new HashMap()).computeIfAbsent(obj.getString("number"), k -> new HashSet());
            tableOrgSubAcctDates.computeIfAbsent(tableId, k -> new HashMap()).computeIfAbsent(useOrgId, k -> new HashMap()).computeIfAbsent(obj.getString("number"), k -> obj.getDate("enddate"));
            excAcctidOrgIds.computeIfAbsent(obj.getLong("id"), k -> new HashSet());
        }
        if (!tableIdTypeIds.isEmpty()) {
            Throwable throwable = null;
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)"initparams", (String)"bd_accounttype", (String)"id,accounttableid", (QFilter[])new QFilter("accounttableid", "in", tableIdTypeIds.keySet()).toArray(), null);){
                for (Row row : dt) {
                    tableIdTypeIds.get(row.getLong("accounttableid")).add(row.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (!excAcctidOrgIds.isEmpty()) {
            StringBuilder sqlstr = new StringBuilder("select fdataid,fuseorgid from t_bd_accountexc where fdataid in (").append(AccountVersionUtil.getIds(excAcctidOrgIds.keySet())).append(')');
            try (DataSet dataSet = DB.queryDataSet((String)"initparams", (DBRoute)DBRoute.of((String)"gl"), (String)sqlstr.toString());){
                for (Row row : dataSet) {
                    excAcctidOrgIds.get(row.getLong("fdataid")).add(row.getLong("fuseorgid"));
                }
            }
        }
        for (Map.Entry entry : tableOrgSubAccts.entrySet()) {
            long tableId = (Long)entry.getKey();
            Map orgSubAccts = (Map)entry.getValue();
            for (Map.Entry orgEntry : orgSubAccts.entrySet()) {
                Map allSubAccts = (Map)orgEntry.getValue();
                long orgId = (Long)orgEntry.getKey();
                Map allDates = (Map)((Map)tableOrgSubAcctDates.get(tableId)).get(orgId);
                if (allSubAccts.isEmpty()) continue;
                String selectFields = "id,number,acnotice,ischangecurrency,bw,isqty,createorg.id createorg_id,enddate";
                Set allChildOrgs = BDUtil.listAllChildOrgs((long)orgId, (boolean)false);
                DynamicObjectCollection subAccts = BatchProcessUtil.batchQueryDynColl((Collection)allChildOrgs, batchOrgs -> QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("accounttable", "=", (Object)tableId), new QFilter("createorg", "in", (Object)batchOrgs.toArray()), new QFilter("number", "in", allSubAccts.keySet())}));
                for (DynamicObject subAcct : subAccts) {
                    String number = subAcct.getString("number");
                    if (((Date)allDates.get(number)).compareTo(subAcct.getDate("enddate")) > 0) continue;
                    ((Set)allSubAccts.get(number)).add(subAcct);
                }
                DynamicObjectCollection curOrgSubaccts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,parent.number,acnotice,ischangecurrency,bw,isqty,createorg.id createorg_id,enddate", (QFilter[])new QFilter[]{new QFilter("accounttable", "=", (Object)tableId), AccountUtils.getBaseDataFilter((long)orgId), new QFilter("parent.number", "in", allSubAccts.keySet())});
                for (DynamicObject subAcct : curOrgSubaccts) {
                    String pnumber = subAcct.getString("parent.number");
                    if (((Date)allDates.get(pnumber)).compareTo(subAcct.getDate("enddate")) > 0) continue;
                    ((Set)allSubAccts.get(pnumber)).add(subAcct);
                }
            }
        }
    }

    private static void initDbDyos(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject obj = entity.getDataEntity();
            if (!obj.getDataEntityState().getFromDatabase()) continue;
            ctx.getDbDyos().put(obj.getPkValue(), null);
        }
        if (!ctx.getDbDyos().isEmpty()) {
            DynamicObject[] dyos;
            for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((Object[])ctx.getDbDyos().keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                ctx.getDbDyos().put(dyo.get("id"), dyo);
            }
        }
    }

    private static void initTableRefEnabledParams(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        HashMap<Date, List> dateAcctIds = new HashMap<Date, List>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            Date startDate = acct.getDate("startdate");
            dateAcctIds.computeIfAbsent(startDate, k -> new ArrayList()).add(acct.getLong("id"));
            DynamicObject parent = acct.getDynamicObject("parent");
            if (parent == null) continue;
            dateAcctIds.computeIfAbsent(startDate, k -> new ArrayList()).add(parent.getLong("id"));
        }
        for (Map.Entry entry : dateAcctIds.entrySet()) {
            ctx.getDateAcctidEnables().put((Date)entry.getKey(), AccountRefUtils.isAccountTableRefEnabled((Date)((Date)entry.getKey()), (List)((List)entry.getValue())));
        }
    }

    private static void initAccountNumberList(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity entity : dataEntities) {
            long createorgid;
            Map numbers;
            DynamicObject acct = entity.getDataEntity();
            DynamicObject accttable = acct.getDynamicObject("accounttable");
            long accttableid = accttable == null ? acct.getLong("accounttable_id") : accttable.getLong("id");
            Map<Long, Map<Long, Set<String>>> numberMap = numberMapInDBThl.get();
            if (numberMap == null) {
                numberMap = new HashMap<Long, Map<Long, Set<String>>>(1);
                numberMapInDBThl.set(numberMap);
            }
            if ((numbers = numberMap.computeIfAbsent(accttableid, k -> new HashMap(1))).get(createorgid = acct.getLong("createorg_id")) != null) continue;
            HashSet<String> numberList = new HashSet<String>(100);
            QFilter qaccttable = new QFilter("accounttable", "=", (Object)accttableid);
            DynamicObjectCollection dbaccts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{qaccttable, AccountUtils.getBaseDataFilter((long)createorgid)});
            for (DynamicObject dbacct : dbaccts) {
                numberList.add(dbacct.getString("number"));
            }
            numbers.put(createorgid, numberList);
        }
    }

    private static void initAddNewAccount(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            if (acct.getDataEntityState().getFromDatabase()) continue;
            Set<Long> accSet = addNewAccoutThl.get();
            if (accSet == null) {
                accSet = new HashSet<Long>(10);
                addNewAccoutThl.set(accSet);
            }
            if (acct.getLong("id") == 0L) continue;
            accSet.add(acct.getLong("id"));
        }
    }

    private static void initParentAccount(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        HashSet<Long> parentIds = new HashSet<Long>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            DynamicObject parent = acct.getDynamicObject("parent");
            if (parent == null) continue;
            long parentId = parent.getLong("id");
            parentIds.add(parentId);
            ctx.parentIdDates.put(parentId, acct.getDate("startdate"));
            if (parent.getLong("createorg_id") == acct.getLong("useorg_id") && parent.getLong("id") == parent.getLong("masterid")) {
                ctx.existAllBizMasterAccounts.computeIfAbsent(acct.getLong("useorg_id"), k -> new HashMap()).put(parent.getLong("masterid"), false);
                continue;
            }
            ctx.existSubOrgBizMasterAccounts.computeIfAbsent(acct.getLong("useorg_id"), k -> new HashMap()).put(parent.getLong("masterid"), false);
        }
        if (!parentIds.isEmpty()) {
            DynamicObject[] dyos;
            for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((Object[])parentIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"))) {
                ctx.parentAccounts.put(dyo.getPkValue(), dyo);
            }
        }
    }

    private static void initTableOrgAcctNumber(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        HashMap<Long, Map> atOrgAccs = new HashMap<Long, Map>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            DynamicObject parent = acct.getDynamicObject("parent");
            if (acct.getDataEntityState().getFromDatabase() || parent == null) continue;
            Map orgAccs = atOrgAccs.computeIfAbsent(acct.getLong("accounttable_id"), key -> new HashMap());
            Map accs = orgAccs.computeIfAbsent(acct.getLong("createorg_id"), key -> new HashMap());
            accs.put(acct.getString("number"), acct);
        }
        if (!atOrgAccs.isEmpty()) {
            ctx.atOrgAccounts = new HashMap<Long, Map<Long, Map<String, Set<Long>>>>(atOrgAccs.size());
            for (Map.Entry entry : atOrgAccs.entrySet()) {
                Map orgAccNums = ctx.atOrgAccounts.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<Long, Map<String, Set<Long>>>>)((Function<Long, Map>)key -> new HashMap()));
                for (Map.Entry orgAcc : ((Map)entry.getValue()).entrySet()) {
                    orgAccNums.put(orgAcc.getKey(), AccountOpContext.getSameNameAccounts(ctx, (Long)orgAcc.getKey(), (Long)entry.getKey(), (Map)orgAcc.getValue()));
                }
            }
        }
    }

    private static void initParentAccountInfo(AccountOpContext ctx, ExtendedDataEntity[] dataEntities) {
        HashMap<Long, Set> orgParentAccounts = new HashMap<Long, Set>();
        HashMap<Long, List> fromDatabaseAccounts = new HashMap<Long, List>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject acct = entity.getDataEntity();
            DynamicObject parent = acct.getDynamicObject("parent");
            if (acct.getDataEntityState().getFromDatabase()) {
                fromDatabaseAccounts.computeIfAbsent(acct.getLong("useorg_id"), key -> new ArrayList(10)).add(acct);
                continue;
            }
            if (parent == null) continue;
            long accId = parent.getLong("id");
            if (addNewAccoutThl.get().contains(accId)) continue;
            Set paccts = orgParentAccounts.computeIfAbsent(acct.getLong("createorg_id"), key -> new HashSet(10));
            paccts.add(accId);
        }
        if (ctx.parentAccounts.isEmpty() && fromDatabaseAccounts.isEmpty()) {
            return;
        }
        Map<Object, DynamicObject> parents = ctx.parentAccounts;
        for (Map.Entry en : orgParentAccounts.entrySet()) {
            List curOrgfromDatabaseAccounts;
            Set pIds = (Set)en.getValue();
            ArrayList<DynamicObject> ps = new ArrayList<DynamicObject>(pIds.size());
            for (Object paccId : pIds) {
                if (!parents.containsKey(paccId)) continue;
                DynamicObject parent = parents.get(paccId);
                ps.add(parent);
            }
            if (!fromDatabaseAccounts.containsKey(en.getKey()) || (curOrgfromDatabaseAccounts = (List)fromDatabaseAccounts.remove(en.getKey())) == null) continue;
            ps.addAll(curOrgfromDatabaseAccounts);
        }
    }

    protected void prepareServiceParam(long orgId, long tableId, Date versiondate, long newAcctId, long oldAcctId) {
        AccountTableRefServiceParam param = this.refServiceParamMap.computeIfAbsent(AccountVersionUtil.getRefServiceKey((long)orgId, (long)tableId, (Date)versiondate), k -> new AccountTableRefServiceParam(orgId, tableId, versiondate, new AccountTableRef(tableId, tableId, new AccountRef())));
        param.getAccountTableRef().getAccountRef().addAccountRef(Long.valueOf(newAcctId), Long.valueOf(oldAcctId), new HashMap(1));
    }

    private DynamicObject custAccount(DynamicObject account, long orgId) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject custAccount = (DynamicObject)cloneUtils.clone((IDataEntityBase)account);
        this.resetPropValue(custAccount);
        custAccount.set("createorg_id", (Object)orgId);
        custAccount.set("org_id", (Object)orgId);
        custAccount.set("id", (Object)ORM.create().genLongId("bd_accountview"));
        return custAccount;
    }

    private DynamicObject versAccount(DynamicObject account, Date currDate) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newAccount = (DynamicObject)cloneUtils.clone((IDataEntityBase)account);
        this.resetPropValue(newAccount);
        if ("1900-01-01".equals(DateUtils.formatString((Date)currDate, (String)"yyyy-MM-dd"))) {
            throw new KDBizException("logic error, please contact developer to track.");
        }
        account.set("enddate", (Object)currDate);
        newAccount.set("startdate", (Object)currDate);
        newAccount.set("enddate", (Object)AccountVersionUtil.getEndDate());
        newAccount.set("id", (Object)ORM.create().genLongId("bd_accountview"));
        return newAccount;
    }

    private long getParentOrgIds(long orgId) {
        QFilter f2 = new QFilter("view", "=", (Object)10);
        QFilter f3 = new QFilter("org", "=", (Object)orgId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BDUtil.class.getName(), (String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f2, f3}, null);){
            if (dataSet.hasNext()) {
                long l = dataSet.next().getLong("parent");
                return l;
            }
        }
        return 0L;
    }

    private void resetPropValue(DynamicObject account) {
        DynamicObject parent = account.getDynamicObject("parent");
        if (parent == null) {
            account.set("fullname", account.get("name"));
            account.set("longnumber", account.get("number"));
        } else {
            ILocaleString currentName = (ILocaleString)account.get("name");
            ILocaleString parentFullName = parent.getLocaleString("fullname");
            LocaleString currentFullName = new LocaleString();
            for (Map.Entry nameEntry : parentFullName.entrySet()) {
                String key = (String)nameEntry.getKey();
                String value = (String)nameEntry.getValue();
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                currentFullName.put((Object)key, (Object)StringUtils.join((Object[])new Object[]{value, StringUtils.isEmpty((CharSequence)((CharSequence)currentName.get((Object)key))) ? currentName.getDefaultItem() : currentName.get((Object)key)}, (String)"_"));
            }
            String parentLongnumber = parent.getString("longnumber");
            String currentLongnumber = parentLongnumber + "_" + account.getString("number");
            account.set("fullname", (Object)currentFullName);
            account.set("longnumber", (Object)currentLongnumber);
        }
        Date now = new Date();
        account.set("createtime", (Object)now);
        account.set("modifytime", (Object)now);
        long userId = ContextUtil.getUserId();
        account.set("creator_id", (Object)userId);
        account.set("modifier_id", (Object)userId);
    }

    private static Map<String, Set<Long>> getSameNameAccounts(AccountOpContext ctx, Long orgId, long accountTableId, Map<String, DynamicObject> accounts) {
        Set<Long> orgIds = ctx.getAllParentOrgIds(orgId);
        HashMap<String, Set<Long>> orgAccMap = new HashMap<String, Set<Long>>(10);
        if (orgIds.isEmpty()) {
            return orgAccMap;
        }
        QFilter qf = new QFilter("createorg", "in", orgIds);
        qf.and(new QFilter("accounttable", "=", (Object)accountTableId));
        qf.and(new QFilter("number", "in", accounts.keySet()));
        qf.and(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)AccountOpContext.class.getName(), (String)"bd_accountview", (String)"createorg,masterid,number,name", (QFilter[])qf.toArray(), (String)"createorg");){
            for (Row row : ds) {
                String accNumber = row.getString("number");
                String accName = row.getString("name");
                DynamicObject account = accounts.get(accNumber);
                if (Objects.isNull(account) || row.getLong("masterid").longValue() == account.getLong("masterid") || !accName.equals(account.getString("name"))) continue;
                Set orgIdSet = orgAccMap.computeIfAbsent(accNumber, key -> new HashSet(3));
                orgIdSet.add(row.getLong("createorg"));
            }
        }
        return orgAccMap;
    }
}

