/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountTableUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.vo.CommonAssist;

public class AccountTableSaveValidator
extends AbstractValidator {
    private static final String ACCOUNTLEVEL = "accountlevel";
    private static final String LEVELSPLIT = "-";

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("bd_accounttable");
    }

    public void validate() {
        HashSet<Long> accountTableIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            accountTableIdSet.add(dataEntity.getDataEntity().getLong("id"));
        }
        String selectProperties = "id, comassistentry.seq, comassistnumber, comassistname, valuesourcetype, valuesource, assistantvaluesource.id, isbalance, isrequire";
        Map accountTableIdToDyoMap = AccountTableUtil.getAccountTableFromDB(accountTableIdSet, (String)selectProperties);
        Set usedAccountTableSet = AccountTableUtil.getUsedAccountTableId(accountTableIdSet);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String accountlevel = dataEntity.getValue(ACCOUNTLEVEL).toString();
            if (!this.isCorrectFormat(accountlevel).booleanValue()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u7ea7\u6b21\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u7ea7\u6b21\u8d85\u8fc7\u5341\u4f4d\u3002", (String)"AccountTableSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            if (accountlevel.split(LEVELSPLIT).length > 10) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ea7\u6b21\u8d85\u8fc7\u5341\u4f4d\u3002", (String)"AccountTableSaveValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            if (accountlevel.contains("0")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7ea7\u6b21\u4e0d\u80fd\u8bbe\u7f6e\u4e3a0\u3002", (String)"AccountTableSaveValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            if (this.checkCorrectConfig(dataEntity)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u56fd\u9645\u4f1a\u8ba1\u51c6\u5219\uff0c\u8bf7\u914d\u7f6e\u79d1\u76ee\u8868\u5206\u9694\u7b26\u3002", (String)"AccountTableSaveValidator_17", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            DynamicObject table = dataEntity.getDataEntity();
            boolean isFromdatabase = table.getDataEntityState().getFromDatabase();
            if (isFromdatabase) {
                this.queryAcctLevel(table, accountlevel, dataEntity);
            }
            Map<Long, List<CommonAssist>> tableIdToComAssistsMap = this.getComAssistMap(accountTableIdToDyoMap);
            this.checkHasLicense(dataEntity, tableIdToComAssistsMap);
            this.checkComAssistMustInput(dataEntity);
            this.checkComAssistUnique(dataEntity);
            this.checkComAssistCount(dataEntity);
            this.checkBalanceAssistIsFirst(dataEntity);
            this.checkComAssistChanged(dataEntity, tableIdToComAssistsMap, usedAccountTableSet);
        }
    }

    private boolean checkCorrectConfig(ExtendedDataEntity dataEntity) {
        Boolean isinternational = (Boolean)dataEntity.getValue("isinternational");
        String seperator = (String)dataEntity.getValue("seperator");
        return isinternational != false && StringUtils.isEmpty((String)seperator);
    }

    private void queryAcctLevel(DynamicObject table, String accountlevel, ExtendedDataEntity dataEntity) {
        try (DataSet dt = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"fibd"), (String)String.format("select max(flevel) l from t_bd_account where faccounttableid=%d", table.getPkValue()));){
            while (dt.hasNext()) {
                Row row = dt.next();
                if (row.get("l") == null) {
                    return;
                }
                long l = row.getLong("l");
                if (l == 0L) continue;
                DynamicObject tableInDB = QueryServiceHelper.queryOne((String)"bd_accounttable", (String)"accountlevel,maxlevel", (QFilter[])new QFilter("id", "=", table.getPkValue()).toArray());
                String accountlevelDB = tableInDB.getString(ACCOUNTLEVEL);
                String[] splitTableLevelDB = accountlevelDB.split(LEVELSPLIT);
                String[] splitTableLevel = accountlevel.split(LEVELSPLIT);
                if ((long)splitTableLevel.length < l) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u5df2\u6709\u7b2c%1$d\u7ea7\u6b21\u7684\u79d1\u76ee\uff0c\u65e0\u6cd5\u5220\u51cf\u79d1\u76ee\u8868\u7ea7\u6b21\u5230%2$d\u7ea7\u4ee5\u4e0b\u3002", (String)"AccountTableSaveValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), l, l), ErrorLevel.Error);
                    return;
                }
                int i = 0;
                while ((long)i < l) {
                    String sDB = splitTableLevelDB[i];
                    String s = splitTableLevel[i];
                    if (!sDB.equals(s)) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u8868\u5df2\u6709\u7b2c%1$d\u7ea7\u6b21\u7684\u79d1\u76ee\uff0c\u65e0\u6cd5\u4fee\u6539\u79d1\u76ee\u8868\u7ea7\u6b21\u7684\u7b2c%2$d\u7ea7\u3002", (String)"AccountTableSaveValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), i + 1, i + 1), ErrorLevel.Error);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private Boolean isCorrectFormat(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return Boolean.FALSE;
        }
        if (!this.isDigit(String.valueOf(str.charAt(str.length() - 1))).booleanValue()) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < str.length(); i += 2) {
            if (this.isDigit(String.valueOf(str.charAt(i))).booleanValue()) continue;
            return Boolean.FALSE;
        }
        for (int j = 1; j < str.length() - 1; j += 2) {
            if (LEVELSPLIT.equals(String.valueOf(str.charAt(j)))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean isDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void checkComAssistMustInput(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection comAssistDyns = dataEntity.getDataEntity().getDynamicObjectCollection("comassistentry");
        for (DynamicObject comAssistDyn : comAssistDyns) {
            if ("1".equals(comAssistDyn.getString("valuesourcetype")) && Objects.isNull(comAssistDyn.get("valuesource"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u7684\u503c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountTableSaveValidator_15", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            if (!"2".equals(comAssistDyn.getString("valuesourcetype")) || !Objects.isNull(comAssistDyn.get("assistantvaluesource"))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u7684\u8f85\u52a9\u503c\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountTableSaveValidator_16", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
    }

    private void checkComAssistUnique(ExtendedDataEntity dataEntity) {
        List comAssistList = AccountTableUtil.createCommonAssist((DynamicObjectCollection)dataEntity.getDataEntity().getDynamicObjectCollection("comassistentry"));
        HashSet<String> comAssistNumberSet = new HashSet<String>(8);
        HashSet<String> comAssistNameSet = new HashSet<String>(8);
        HashSet<String> comAssistValSourceSet = new HashSet<String>(8);
        for (CommonAssist comAssist : comAssistList) {
            if (comAssistNumberSet.contains(comAssist.getNumber())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u7f16\u7801\u4e0d\u552f\u4e00\u3002", (String)"AccountTableSaveValidator_12", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            comAssistNumberSet.add(comAssist.getNumber());
            if (comAssistNameSet.contains(comAssist.getName())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u540d\u79f0\u4e0d\u552f\u4e00\u3002", (String)"AccountTableSaveValidator_13", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            comAssistNameSet.add(comAssist.getName());
            if (comAssistValSourceSet.contains(comAssist.getValueSource())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c\u6765\u6e90\u6216\u8f85\u52a9\u503c\u6765\u6e90\u4e0d\u552f\u4e00\u3002", (String)"AccountTableSaveValidator_14", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            comAssistValSourceSet.add(comAssist.getValueSource());
        }
    }

    private void checkHasLicense(ExtendedDataEntity dataEntity, Map<Long, List<CommonAssist>> tableIdToComAssistsMap) {
        List comAssistList;
        DynamicObject accountTable = dataEntity.getDataEntity();
        List curComAssistList = AccountTableUtil.createCommonAssist((DynamicObjectCollection)accountTable.getDynamicObjectCollection("comassistentry"));
        if (!curComAssistList.equals(comAssistList = (List)tableIdToComAssistsMap.getOrDefault(accountTable.getLong("id"), new ArrayList(8))) && !AccountTableUtil.getHasLicense().getHasLicense().booleanValue()) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u8bb8\u53ef\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u516c\u5171\u7ef4\u5ea6\u3002", (String)"AccountTableSaveValidator_10", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void checkComAssistCount(ExtendedDataEntity dataEntity) {
        Integer comAssistMaxCount = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.accounttable.comAssistMaxCount", (int)2);
        DynamicObject accountTable = dataEntity.getDataEntity();
        DynamicObjectCollection comAssistEntry = accountTable.getDynamicObjectCollection("comassistentry");
        if (CollectionUtils.isNotEmpty((Collection)comAssistEntry) && comAssistEntry.size() > comAssistMaxCount) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u6700\u591a\u8bbe\u7f6e%s\u4e2a\u3002", (String)"AccountTableSaveValidator_5", (String)"fi-bd-opplugin", (Object[])new Object[]{comAssistMaxCount}), ErrorLevel.Error);
            return;
        }
        Integer balanceAssistMaxCount = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.accounttable.balanceAssistMaxCount", (int)1);
        int balanceAssistCount = 0;
        for (DynamicObject comAssistDyo : comAssistEntry) {
            if (!comAssistDyo.getBoolean("isbalance") || ++balanceAssistCount <= balanceAssistMaxCount) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e73\u8861\u516c\u5171\u7ef4\u5ea6\u53ea\u80fd\u8bbe\u7f6e%s\u4e2a\u3002", (String)"AccountTableSaveValidator_6", (String)"fi-bd-opplugin", (Object[])new Object[]{balanceAssistMaxCount}), ErrorLevel.Error);
            return;
        }
    }

    private void checkComAssistChanged(ExtendedDataEntity dataEntity, Map<Long, List<CommonAssist>> tableIdToComAssistsMap, Set<Long> usedAccountTableSet) {
        List curComAssistList;
        DynamicObject accountTableDyo = dataEntity.getDataEntity();
        List<CommonAssist> comAssistFromDBList = tableIdToComAssistsMap.get(accountTableDyo.getLong("id"));
        if (usedAccountTableSet.contains(accountTableDyo.getLong("id")) && this.isChangedComAssist(curComAssistList = AccountTableUtil.createCommonAssist((DynamicObjectCollection)accountTableDyo.getDynamicObjectCollection("comassistentry")), comAssistFromDBList)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u65b0\u589e\u3001\u4fee\u6539\u3001\u5220\u9664\u516c\u5171\u7ef4\u5ea6\u3002", (String)"AccountTableSaveValidator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private boolean isChangedComAssist(List<CommonAssist> comAssistList, List<CommonAssist> otherComAssistList) {
        if (comAssistList.size() != otherComAssistList.size()) {
            return Boolean.TRUE;
        }
        for (int index = 0; index < comAssistList.size(); ++index) {
            if (comAssistList.get(index).equals((Object)otherComAssistList.get(index))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkBalanceAssistIsFirst(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection comAssistEntry = dataEntity.getDataEntity().getDynamicObjectCollection("comassistentry");
        for (DynamicObject entryRow : comAssistEntry) {
            if (entryRow.getBoolean("isbalance") && entryRow.getInt("seq") != 1) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e73\u8861\u7ef4\u5ea6\u5fc5\u987b\u8bbe\u7f6e\u5230\u7b2c\u4e00\u884c\u3002", (String)"AccountTableSaveValidator_9", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            if (!entryRow.getBoolean("isbalance") || entryRow.getInt("seq") != 1) continue;
            return;
        }
    }

    private Map<Long, List<CommonAssist>> getComAssistMap(Map<Long, DynamicObject> accountTableIdToDyoMap) {
        HashMap<Long, List<CommonAssist>> comAssistMap = new HashMap<Long, List<CommonAssist>>(8);
        for (Map.Entry<Long, DynamicObject> accountTableIdToDyoEntry : accountTableIdToDyoMap.entrySet()) {
            Long accountTableId = accountTableIdToDyoEntry.getKey();
            DynamicObject accountTableDyo = accountTableIdToDyoEntry.getValue();
            DynamicObjectCollection comAssistEntry = accountTableDyo.getDynamicObjectCollection("comassistentry");
            comAssistMap.put(accountTableId, AccountTableUtil.createCommonAssist((DynamicObjectCollection)comAssistEntry));
        }
        return comAssistMap;
    }
}

