/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.BaseDataDisableValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.ContextUtil;

public class AccountViewDisablePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("disabler");
        e.getFieldKeys().add("disabledate");
        e.getFieldKeys().add("createorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        BaseDataDisableValidator validator = new BaseDataDisableValidator();
        String entityKey = this.billEntityType.getName();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Object> accountList = new ArrayList<Object>();
        for (DynamicObject object : e.getDataEntities()) {
            Long accountId = object.getLong("id");
            DynamicObject accountObj = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
            Long userOrgId = accountObj.getLong("createorg_id");
            accountList.addAll(this.getAllSubAccts(accountObj, userOrgId));
            accountList.addAll(this.getAccountByMasterId(accountObj));
        }
        HashSet accountIds = accountList.stream().collect(Collectors.toCollection(HashSet::new));
        this.disabledSubAccount(accountIds);
    }

    private List<Object> getAllSubAccts(DynamicObject curAcct, long curOrgId) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)true);
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(curAcct.get("longnumber") + "%"));
        QFilter qaccttable = new QFilter("accounttable", "=", curAcct.get("accounttable.id"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qorg, qaccttable, qnumber}, null, (int)-1);
    }

    private List<Object> getAccountByMasterId(DynamicObject accountObj) {
        QFilter qaccttable = new QFilter("accounttable", "=", (Object)accountObj.getLong("accounttable_id"));
        QFilter qlevel = new QFilter("level", "=", (Object)accountObj.getLong("level"));
        QFilter qnumber = new QFilter("number", "=", (Object)accountObj.getString("number"));
        String useorg = this.getOption().getVariableValue("createOrg", "0");
        QFilter qcreateorg = new QFilter("createorg_id", "=", (Object)Long.valueOf(useorg));
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{qaccttable, qlevel, qnumber, qcreateorg}, null, (int)-1);
    }

    private void disabledSubAccount(HashSet<Object> objectHashSet) {
        DynamicObject[] accList = BusinessDataServiceHelper.load((Object[])objectHashSet.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(accList.length);
        for (DynamicObject entity : accList) {
            entity.set("enable", (Object)"0");
            entity.set("disabledate", (Object)new Date());
            entity.set("disabler", (Object)ContextUtil.getUserId());
            recordList.add(entity);
        }
        BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"), (Object[])recordList.toArray(new DynamicObject[0]));
        this.operationResult.setSuccess(true);
    }
}

