/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;

public class AccountViewEnableValidator
extends AbstractValidator {
    public void validate() {
        long useOrgId = Long.parseLong(this.getOption().getVariableValue("useorg"));
        HashSet<Long> diffpIds = new HashSet<Long>();
        HashSet<Long> parentIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> idToParentMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> idToOrgAccountMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
        HashMap<Long, Long> idToPOrgAccountIdMap = new HashMap<Long, Long>();
        HashSet<Long> thisObjIds = new HashSet<Long>();
        HashMap acctsMap = BDUtil.getDynamicDatas((ExtendedDataEntity[])this.dataEntities);
        for (DynamicObject obj : acctsMap.values()) {
            DynamicObject superiorObj;
            long acctId = obj.getLong("id");
            thisObjIds.add(acctId);
            DynamicObject parentObj = AccountVersionUtil.getParentAcct((DynamicObject)obj, (long)useOrgId, Optional.empty(), (boolean)true);
            if (parentObj != null && "0".equals(parentObj.getString("enable"))) {
                long pid = parentObj.getLong("id");
                parentIdSet.add(pid);
                idToParentMap.put(pid, parentObj);
                idToPidMap.put(acctId, pid);
            }
            if ((superiorObj = this.querySuperiorAccount(obj)) == null) continue;
            long pid = superiorObj.getLong("id");
            parentIdSet.add(pid);
            idToOrgAccountMap.put(pid, superiorObj);
            idToPOrgAccountIdMap.put(acctId, pid);
        }
        if (parentIdSet.size() > 0) {
            for (Long parentId : parentIdSet) {
                if (thisObjIds.contains(parentId)) continue;
                diffpIds.add(parentId);
            }
        }
        if (!diffpIds.isEmpty()) {
            for (Iterator<Object> iterator : this.dataEntities) {
                String pnumber;
                DynamicObject acctObj = iterator.getDataEntity();
                long acctId = acctObj.getLong("id");
                boolean isSelected = this.extracted(acctsMap, acctObj);
                if (isSelected || !"0".equals(iterator.getDataEntity().getString("enable"))) continue;
                Long pid = (Long)idToPidMap.get(acctId);
                if (idToParentMap.get(pid) != null) {
                    pnumber = ((DynamicObject)idToParentMap.get(pid)).getString("number");
                    this.addErrorMessage((ExtendedDataEntity)iterator, String.format(ResManager.loadKDString((String)"\u6709\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u79d1\u76ee\u3010%s\u3011\u8bf7\u5148\u542f\u7528\u8be5\u79d1\u76ee\u3002", (String)"AccountViewEnableValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber));
                    continue;
                }
                pid = (Long)idToPOrgAccountIdMap.get(acctId);
                if (idToOrgAccountMap.get(pid) == null) continue;
                pnumber = ((DynamicObject)idToOrgAccountMap.get(pid)).getString("number");
                this.addErrorMessage((ExtendedDataEntity)iterator, String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u6709\u672a\u542f\u7528\u79d1\u76ee\u3010%s\u3011\u8bf7\u5148\u542f\u7528\u8be5\u79d1\u76ee\u3002", (String)"AccountViewEnableValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber));
            }
        }
    }

    private Boolean extracted(Map<Long, DynamicObject> acctsMap, DynamicObject acctObj) {
        long parentId = acctObj.getLong("parent_id");
        if (parentId != 0L) {
            DynamicObject parentDy = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bd_accountview");
            if (acctsMap.containsKey(parentId) && 0L == parentDy.getLong("parent_id")) {
                return true;
            }
            boolean isParentDisable = parentDy.getBoolean("enable");
            boolean isParentToParentSelected = acctsMap.containsKey(parentDy.getLong("parent_id"));
            if (isParentDisable && isParentToParentSelected) {
                return true;
            }
            return this.extracted(acctsMap, parentDy);
        }
        return false;
    }

    private DynamicObject querySuperiorAccount(DynamicObject acct) {
        List superiorAccount = OrgUnitServiceHelper.getSuperiorOrgs((String)"10", (long)acct.getLong("createorg_id"));
        if (superiorAccount == null || superiorAccount.size() == 0 || superiorAccount.size() == 1 && (Long)superiorAccount.get(0) == 0L) {
            return null;
        }
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)((Long)superiorAccount.get(0)));
        QFilter accTableFilter = new QFilter("accounttable", "=", (Object)acct.getLong("accounttable_id"));
        QFilter numberFilter = new QFilter("number", "=", (Object)acct.getString("number"));
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate());
        QFilter statusFilter = new QFilter("enable", "=", (Object)"0");
        return BusinessDataServiceHelper.loadSingle((String)"bd_accountview", (String)"id,longnumber", (QFilter[])new QFilter[]{orgFilter, accTableFilter, numberFilter, endDateFilter, statusFilter});
    }
}

