/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.enums.CashFlowItemErrorCode;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.opplugin.CashFlowItemSaveVaildator;
import kd.fi.bd.opplugin.CashflowItemContext;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;

public class CashFlowItemSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CashFlowItemSaveOp.class);
    private static final DBRoute FI = DBRoute.of((String)"fi");
    private Map<Long, List<Long>> old2NewIds = new HashMap<Long, List<Long>>();
    private List<Long> addLeafIds = new ArrayList<Long>();
    private Map<Long, Long> item2createOrg = new HashMap<Long, Long>();
    private long userOrg = 0L;
    private long parentId = 0L;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CashFlowItemSaveVaildator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (CashflowItemOptionVarManager.isOnlyValidate((OperateOption)this.getOption())) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6b64\u6b21\u64cd\u4f5c\u53ea\u505a\u6821\u9a8c\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"CashFlowItemSaveOp_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return;
        }
        List validExtDataEntities = e.getValidExtDataEntities();
        Iterator iterator = validExtDataEntities.iterator();
        while (iterator.hasNext()) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    long parentItemCreateOrgId;
                    ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)iterator.next();
                    DynamicObject originalObj = extendedDataEntity.getDataEntity();
                    OperateOption option = this.getOption();
                    boolean isaddleaf = this.isAddLeaf(originalObj);
                    if (isaddleaf) {
                        this.parentId = originalObj.getDynamicObject("parent").getLong("id");
                        this.addLeafIds.add(originalObj.getLong("parent_id"));
                        this.item2createOrg.put(this.parentId, originalObj.getLong("createorg_id"));
                    }
                    this.userOrg = originalObj.getLong("useorg_id");
                    boolean isImportVersion = false;
                    String importtype = (String)option.getVariables().get("importtype");
                    if (isaddleaf && importtype != null && importtype.equals("new") && this.userOrg != (parentItemCreateOrgId = originalObj.getDynamicObject("parent").getLong("createorg_id"))) {
                        isImportVersion = true;
                    }
                    if (CashflowItemOptionVarManager.isVersion((OperateOption)option) || isImportVersion) {
                        if (isaddleaf) {
                            originalObj.set("ctrlstrategy", (Object)originalObj.getDynamicObject("parent").getString("ctrlstrategy"));
                            if (this.isExistBiz(originalObj.getDynamicObject("parent"), this.userOrg) || CashflowItemOptionVarManager.isVersionAddLeaf((OperateOption)option)) {
                                this.versonedAddLeaf(originalObj);
                                continue;
                            }
                            this.personalAddLeaf(originalObj);
                            continue;
                        }
                        long itemId = originalObj.getLong("id");
                        if (CashflowItemOptionVarManager.isAssistChange((OperateOption)option)) {
                            boolean isExistBiz = this.isExistBiz(originalObj, this.userOrg);
                            if (!originalObj.getBoolean("isleaf") || !isExistBiz) {
                                this.personalized(originalObj);
                            } else {
                                DynamicObject dbEntity = CashflowItemContext.get().getDbDataEntity().get(itemId);
                                if (originalObj.getDate("startdate").compareTo(dbEntity.getDate("startdate")) == 0) {
                                    this.personalized(originalObj);
                                } else {
                                    this.versoned(originalObj);
                                }
                            }
                            iterator.remove();
                        } else if (this.createBySelf(originalObj)) {
                            Map<Long, DynamicObject> dataEntity = CashflowItemContext.get().getDbDataEntity();
                            originalObj.set("startdate", (Object)dataEntity.get(originalObj.getLong("id")).getDate("startdate"));
                        } else {
                            this.personalized(originalObj);
                            iterator.remove();
                        }
                        this.assign(itemId);
                        continue;
                    }
                    DynamicObject parent = originalObj.getDynamicObject("parent");
                    if (parent == null) continue;
                    originalObj.set("ctrlstrategy", (Object)parent.getString("ctrlstrategy"));
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                    tx.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject cashflow : e.getDataEntities()) {
            DynamicObject dbDyn;
            if (!cashflow.getDataEntityState().getFromDatabase() || (dbDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)cashflow.getPkValue(), (String)"gl_cashflowitem", (String)"isexchangerate")).getString("isexchangerate").equals(cashflow.getString("isexchangerate"))) continue;
            List orgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(cashflow.getLong("createorg_id")), (boolean)true);
            Map childIds = CashflowRelationFactory.get().getAllSubCfIncludeAssign(Long.valueOf(cashflow.getLong("id")), cashflow.getString("longnumber"), orgIds, false);
            if (CollectionUtils.isEmpty((Map)childIds)) continue;
            Object[] childCashflowItem = BusinessDataServiceHelper.load((Object[])childIds.keySet().toArray(new Long[0]), (DynamicObjectType)cashflow.getDynamicObjectType());
            ArrayList<DynamicObject> changeChildItem = new ArrayList<DynamicObject>(childCashflowItem.length);
            for (DynamicObject dynamicObject : childCashflowItem) {
                if (dynamicObject.getString("isexchangerate").equals(cashflow.getString("isexchangerate"))) continue;
                dynamicObject.set("isexchangerate", (Object)cashflow.getBoolean("isexchangerate"));
                changeChildItem.add(dynamicObject);
            }
            if (CollectionUtils.isEmpty(changeChildItem)) continue;
            BusinessDataWriter.save((IDataEntityType)cashflow.getDynamicObjectType(), (Object[])childCashflowItem);
        }
    }

    private void assign(long curItemId) {
        List<Long> verData = this.old2NewIds.get(curItemId);
        if (verData != null && !verData.isEmpty()) {
            Map batchAssignWithDetail;
            List<Long> assignOrg = this.queryAssignOrg(curItemId, this.userOrg);
            logger.info("curItemId:{}, assignData:{}, assignOrg:{}", new Object[]{curItemId, verData, assignOrg});
            if (!assignOrg.isEmpty() && (batchAssignWithDetail = BaseDataServiceHelper.batchAssignWithDetail((String)"gl_cashflowitem", (Long)this.userOrg, new ArrayList<Long>(verData), new ArrayList<Long>(assignOrg))) != null && !batchAssignWithDetail.isEmpty()) {
                logger.error("autoAssignFail:{}", (Object)batchAssignWithDetail.toString());
                OperationResult operationResult = this.getOperationResult();
                operationResult.setShowMessage(true);
                operationResult.setSuccess(false);
                List allErrorInfo = operationResult.getAllErrorInfo();
                for (Map.Entry entry : batchAssignWithDetail.entrySet()) {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo(CashFlowItemErrorCode.AUTO_ASSIGN.getValue(), ErrorLevel.Error, entry.getKey());
                    String message = ((Map)entry.getValue()).entrySet().stream().map(x -> (String)x.getValue()).collect(Collectors.joining(";"));
                    operateErrorInfo.setMessage(message);
                    allErrorInfo.add(operateErrorInfo);
                }
            }
        }
    }

    private List<Long> queryAssignOrg(long dataId, long createOrgId) {
        List subordinateOrgs = BDUtil.getAllSubordinateOrgs((Object)createOrgId, (boolean)false);
        if (subordinateOrgs == null || subordinateOrgs.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        Set assignOrgIds = CashflowRelationFactory.get().queryAssignOrgIds(dataId);
        assignOrgIds.retainAll(subordinateOrgs);
        return new ArrayList<Long>(assignOrgIds);
    }

    private boolean createBySelf(DynamicObject originalObj) {
        return originalObj.getLong("createorg_id") == originalObj.getLong("useorg_id");
    }

    private void personalized(DynamicObject originalObj) {
        long id = originalObj.getLong("id");
        this.item2createOrg.put(id, originalObj.getLong("createorg_id"));
        Map<Long, DynamicObject> dataEntity = CashflowItemContext.get().getDbDataEntity();
        originalObj.set("startdate", (Object)dataEntity.get(originalObj.getLong("id")).getDate("startdate"));
        if (this.createBySelf(originalObj)) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{originalObj});
        } else {
            BaseDataServiceHelper.handleModify((DynamicObject)originalObj);
            this.old2NewIds.computeIfAbsent(id, x -> new ArrayList()).add(originalObj.getLong("id"));
        }
    }

    private void versoned(DynamicObject originalObj) {
        long id = originalObj.getLong("id");
        this.item2createOrg.put(id, originalObj.getLong("createorg_id"));
        if (this.createBySelf(originalObj)) {
            this.updateEnddate(originalObj.getDate("startdate"), id);
            this.saveHistoryInfo(originalObj);
            this.old2NewIds.computeIfAbsent(id, x -> new ArrayList()).add(originalObj.getLong("id"));
        } else {
            DynamicObject originalFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)originalObj.getPkValue(), (DynamicObjectType)originalObj.getDynamicObjectType());
            originalFromDB.set("useorg", (Object)originalObj.getDynamicObject("useorg"));
            originalFromDB.set("enddate", (Object)originalObj.getDate("startdate"));
            BaseDataServiceHelper.handleModify((DynamicObject)originalFromDB);
            this.saveHistoryInfo(originalObj);
            this.old2NewIds.computeIfAbsent(id, x -> new ArrayList()).add(originalFromDB.getLong("id"));
            this.old2NewIds.computeIfAbsent(id, x -> new ArrayList()).add(originalObj.getLong("id"));
        }
    }

    private void updateLeaf(Object pkValue) {
        String sql = "update t_gl_cashflowitem set fisleaf='0' where fid = ?";
        DB.execute((DBRoute)FI, (String)sql, (Object[])new Object[]{pkValue});
    }

    private void personalAddLeaf(DynamicObject originalObj) {
        DynamicObject parent = originalObj.getDynamicObject("parent");
        this.parentId = parent.getLong("id");
        this.item2createOrg.put(this.parentId, parent.getLong("createorg_id"));
        if (parent.getLong("createorg_id") == originalObj.getLong("useorg_id")) {
            this.updateLeaf(parent.getPkValue());
        } else {
            parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getLong("id"), (String)"gl_cashflowitem");
            parent.set("isleaf", (Object)"0");
            parent.set("useorg", (Object)originalObj.getDynamicObject("useorg"));
            BaseDataServiceHelper.handleModify((DynamicObject)parent);
            this.old2NewIds.computeIfAbsent(this.parentId, x -> new ArrayList()).add(parent.getLong("id"));
        }
        originalObj.set("parent", (Object)parent);
        originalObj.set("startdate", (Object)parent.getDate("startdate"));
    }

    private void versonedAddLeaf(DynamicObject originalObj) {
        DynamicObject parent = originalObj.getDynamicObject("parent");
        parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parent.getLong("id"), (String)"gl_cashflowitem");
        this.item2createOrg.put(this.parentId, parent.getLong("createorg_id"));
        if (parent.getLong("createorg_id") == originalObj.getLong("useorg_id")) {
            this.updateEnddate(originalObj.getDate("startdate"), parent.getPkValue());
        } else {
            parent.set("enddate", (Object)originalObj.getDate("startdate"));
            parent.set("useorg", (Object)originalObj.getDynamicObject("useorg"));
            BaseDataServiceHelper.handleModify((DynamicObject)parent);
            this.old2NewIds.computeIfAbsent(this.parentId, x -> new ArrayList()).add(parent.getLong("id"));
        }
        parent.set("isleaf", (Object)"0");
        parent.set("startdate", (Object)originalObj.getDate("startdate"));
        parent.set("enddate", (Object)CashflowItemVersionUtil.getEndDate());
        parent.set("useorg", (Object)originalObj.getDynamicObject("useorg"));
        parent.set("createorg", (Object)originalObj.getDynamicObject("createorg"));
        this.saveHistoryInfo(parent);
        this.old2NewIds.computeIfAbsent(this.parentId, x -> new ArrayList()).add(parent.getLong("id"));
        originalObj.set("parent", (Object)parent);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject entity : e.getDataEntities()) {
            long entityId = entity.getLong("id");
            DynamicObject parent = entity.getDynamicObject("parent");
            if (parent != null && this.addLeafIds.contains(this.parentId)) {
                this.old2NewIds.computeIfAbsent(this.parentId, x -> new ArrayList()).add(entityId);
                CashFlowItemHelper.replaceDBItem((Long)this.userOrg, (Long)parent.getLong("masterid"), (Long)entityId);
            }
            this.assign(this.parentId);
        }
    }

    private void saveHistoryInfo(DynamicObject dataInfo) {
        BaseDataServiceImpl.saveHistoryInfo((DynamicObject)dataInfo);
    }

    private void updateEnddate(Date endDate, Object pkValue) {
        String sql1 = "update t_gl_cashflowitem set fenddate = ? where fid = ?";
        DB.execute((DBRoute)FI, (String)sql1, (Object[])new Object[]{endDate, pkValue});
        new DataEntityCacheManager("t_gl_cashflowitem").removeByPrimaryKey(new Object[]{pkValue});
    }

    private boolean isAddLeaf(DynamicObject oldObj) {
        return Objects.nonNull(oldObj.getDynamicObject("parent")) && oldObj.getDynamicObject("parent").getBoolean("isleaf");
    }

    private boolean isExistBiz(DynamicObject entity, long userOrg) {
        return CashflowItemCheckUtil.existsBizOnOrg((long)entity.getLong("masterid"), (long)userOrg, null);
    }
}

