/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.cashflow.CashflowRelationFactory;
import kd.fi.bd.cfversion.CashflowItemOptionVarManager;
import kd.fi.bd.cfversion.CashflowPropertyCheck;
import kd.fi.bd.cfversion.CheckResult;
import kd.fi.bd.util.CashflowItemCheckUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;

public class CashflowItemDeleteValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Set<Long>> org2ItemIds = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> org2SubOrgIds = new HashMap<Long, Set<Long>>();
        this.prepareMap(org2ItemIds, org2SubOrgIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject cashFlowItem;
            CashflowPropertyCheck check;
            CheckResult result;
            QFilter fcreateOrg;
            QFilter fnumber;
            DynamicObjectCollection objects;
            QFilter forg;
            QFilter flevel;
            QFilter fnum;
            Set assignOrg;
            boolean isVersionDel;
            DynamicObject dyn = dataEntity.getDataEntity();
            long id = dyn.getLong("id");
            long masterId = dyn.getLong("masterid");
            long orgId = dyn.getLong("createorg_id");
            Date startDate = dyn.getDate("startdate");
            if (CashflowItemVersionUtil.getEndDate().compareTo(dyn.getDate("enddate")) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u65b0\u7248\u672c\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5\u3002", (String)"CashflowItemDeleteValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean bl = isVersionDel = this.getOption().containsVariable("versiondelete") && this.getOption().getVariableValue("versiondelete").equals("1");
            if (CashflowItemVersionUtil.isEnableVersion() && !isVersionDel && id != masterId) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u88ab\u7248\u672c\u5316\uff0c\u8bf7\u524d\u5f80\u7248\u672c\u5316\u8bb0\u5f55\u8868\u5220\u9664\u3002", (String)"CashflowItemDeleteValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (isVersionDel && id == masterId) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u521d\u59cb\u5316\u7248\u672c\uff0c\u8bf7\u524d\u5f80\u73b0\u91d1\u6d41\u91cf\u5217\u8868\u5220\u9664\u3002", (String)"CashflowItemDeleteValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long useOrg = Long.parseLong(this.getOption().getVariableValue("useorg"));
            if (CashflowItemVersionUtil.isEnableVersion() && id == masterId && useOrg == orgId && !(assignOrg = CashflowRelationFactory.get().queryAssignOrgIds(id)).isEmpty()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u88ab\u5206\u914d\u7ed9\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u5148\u53d6\u6d88\u5206\u914d\u3002", (String)"CashflowItemDeleteValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Set customizedOrgIds = CashflowRelationFactory.get().queryIndivisionOrgIds(id, null);
            if (id == masterId && !customizedOrgIds.isEmpty()) {
                String errTips = this.getOrgNames(customizedOrgIds);
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u9879\u76ee\u7684\u4e2a\u6027\u5316\u6570\u636e\u3002\u4e2a\u6027\u5316\u8fc7\u8be5\u9879\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s\u3002", (String)"CashflowItemDeleteValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTips), ErrorLevel.Error);
                continue;
            }
            Set subAccts = (Set)org2ItemIds.get(orgId);
            if (subAccts != null && subAccts.contains(masterId)) {
                Set subOrgRange = (Set)org2SubOrgIds.get(orgId);
                String errTips = this.getOrgNames(subOrgRange);
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u4e0b\u7ea7\u3002\u5b58\u5728\u4e0b\u7ea7\u9879\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s\u3002", (String)"CashflowItemDeleteValidator_5", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTips), ErrorLevel.Error);
                continue;
            }
            if (CashflowItemCheckUtil.existsBizOnOrg((long)masterId, (long)orgId, (Date)startDate)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5b58\u5728\u51ed\u8bc1\uff0c\u521d\u59cb\u5316\u6216\u4f59\u989d\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CashflowItemDeleteValidator_6", (String)"fi-bd-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (CashflowItemOptionVarManager.isAssign((OperateOption)this.getOption())) continue;
            if (id != masterId) {
                CashflowPropertyCheck check2;
                CheckResult result2;
                Optional preVersion = CashflowItemVersionUtil.findPreVersion((DynamicObject)dyn, (long)dyn.getLong("createorg_id"));
                if (!preVersion.isPresent()) continue;
                DynamicObject preDynObj = (DynamicObject)preVersion.get();
                if (!customizedOrgIds.isEmpty()) {
                    boolean isCustom = false;
                    try (DataSet dataSet = CashflowRelationFactory.get().queryDataInfoByNumber(new ArrayList(customizedOrgIds), Collections.singletonList(preDynObj.getString("number")), "id");){
                        for (Row row : dataSet) {
                            if (row.getLong("id").longValue() != preDynObj.getLong("id")) continue;
                            isCustom = true;
                            break;
                        }
                    }
                    if (isCustom) {
                        String errTips = this.getOrgNames(customizedOrgIds);
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u6838\u7b97\u7ec4\u7ec7\u8be5\u9879\u76ee\u7684\u4e2a\u6027\u5316\u6570\u636e\u3002\u4e2a\u6027\u5316\u8fc7\u8be5\u9879\u76ee\u7684\u7ec4\u7ec7\u4e3a\uff1a%s\u3002", (String)"CashflowItemDeleteValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), errTips), ErrorLevel.Error);
                        continue;
                    }
                }
                if ((result2 = (check2 = new CashflowPropertyCheck()).saveCheck(preDynObj, false, Long.parseLong(this.getOption().getVariableValue("useorg")))).getStatus() == CashflowPropertyCheck.Status.SUCCESS) continue;
                String msg = null;
                switch (result2.getCheckType()) {
                    case CUR_SUPERIOR: {
                        msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u5f53\u524d\u7ec4\u7ec7\u6838\u7b97\u7ef4\u5ea6\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"CashflowItemDeleteValidator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        break;
                    }
                    case ORG_SUPERIOR: {
                        msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u4e00\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"CashflowItemDeleteValidator_8", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        break;
                    }
                    case CUR_SUBORDINATE: {
                        msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u4e00\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"CashflowItemDeleteValidator_9", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                        break;
                    }
                    case ORG_SUBORDINATE: {
                        msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0d\u6ee1\u8db3\u5206\u914d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%s", (String)"CashflowItemDeleteValidator_10", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    }
                }
                this.addMessage(dataEntity, String.format(msg, result2.getErrorMsg()), ErrorLevel.Error);
                continue;
            }
            DynamicObject parent = dyn.getDynamicObject("parent");
            if (parent == null || dyn.getDate("startdate").compareTo(CashflowItemVersionUtil.getBeginDate()) == 0) continue;
            String longNum = dyn.getString("longnumber");
            String number = longNum.substring(0, longNum.lastIndexOf("@"));
            long userOrgId = dyn.getLong("createorg_id");
            QFilter fnum_like = new QFilter("longnumber", "like", (Object)(number + "@%"));
            boolean isExistLeaf = QueryServiceHelper.exists((String)"gl_cashflowitem", (QFilter[])new QFilter[]{fnum_like, fnum = new QFilter("number", "!=", (Object)dyn.getString("number")), flevel = new QFilter("level", "=", (Object)dyn.getInt("level")), forg = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)userOrgId)});
            if (isExistLeaf || (objects = QueryServiceHelper.query((String)"CashflowItemDeleteValidator_validate", (String)"gl_cashflowitem", (String)"id, startdate", (QFilter[])new QFilter[]{fnumber = new QFilter("number", "=", (Object)parent.getString("number")), fcreateOrg = new QFilter("createorg", "=", (Object)userOrgId)}, (String)"startdate")).size() < 2 || (result = (check = new CashflowPropertyCheck()).saveCheck(cashFlowItem = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)objects.get(objects.size() - 2)).getLong("id"), (String)"gl_cashflowitem"), true, Long.parseLong(this.getOption().getVariableValue("useorg")))).getStatus() == CashflowPropertyCheck.Status.SUCCESS) continue;
            String msg = null;
            switch (result.getCheckType()) {
                case CUR_SUPERIOR: {
                    msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee:%1$s \u4e0d\u6ee1\u8db3\u5f53\u524d\u7ec4\u7ec7\u6838\u7b97\u7ef4\u5ea6\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"CashflowItemDeleteValidator_11", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    break;
                }
                case ORG_SUPERIOR: {
                    msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee:%1$s \u4e0d\u6ee1\u8db3\u4e0a\u7ea7\u7ec4\u7ec7\u540c\u4e00\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"CashflowItemDeleteValidator_12", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    break;
                }
                case CUR_SUBORDINATE: {
                    msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee:%1$s \u4e0d\u6ee1\u8db3\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u4e00\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"CashflowItemDeleteValidator_13", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                    break;
                }
                case ORG_SUBORDINATE: {
                    msg = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u7248\u672c\u540e\uff0c\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee:%1$s \u4e0d\u6ee1\u8db3\u5206\u914d\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u4e0a\u4e0b\u7ea7\u7ba1\u63a7\u6821\u9a8c\uff1a%2$s", (String)"CashflowItemDeleteValidator_14", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                }
            }
            this.addMessage(dataEntity, String.format(msg, parent.getString("number"), result.getErrorMsg()), ErrorLevel.Error);
        }
    }

    private String getOrgNames(Set<Long> subOrgRange) {
        DynamicObjectCollection qryResult = QueryServiceHelper.query((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", subOrgRange)});
        Set orgInfos = qryResult.stream().map(d -> d.getString("name") + "(" + d.getString("number") + ")").collect(Collectors.toSet());
        String errTips = String.join((CharSequence)",", orgInfos);
        return errTips;
    }

    private void prepareMap(Map<Long, Set<Long>> org2ItemIds, Map<Long, Set<Long>> org2SubOrgIds) {
        HashSet<Long> orgIds = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> mids = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            orgIds.add(dataEntity.getLong("createorg_id"));
            mids.add(dataEntity.getLong("masterid"));
        }
        Map<Long, List> subMap = orgIds.stream().collect(Collectors.toMap(x -> x, x -> OrgUnitServiceHelper.getAllSubordinateOrgs((Long)10L, Collections.singletonList(x), (boolean)true)));
        for (Map.Entry<Long, List> entry : subMap.entrySet()) {
            long orgId = entry.getKey();
            List subOrgIds = entry.getValue();
            QFilter fcrateOrg = new QFilter("createorg", "in", (Object)subOrgIds);
            QFilter fmid = new QFilter("parent.masterid", "in", mids);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CashflowItemDeleteValidator#prepareMap", (String)"gl_cashflowitem", (String)"id,createorg,parent.masterid", (QFilter[])new QFilter[]{fcrateOrg, fmid}, null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    Set itemIdsSet = org2ItemIds.computeIfAbsent(orgId, k -> new HashSet());
                    itemIdsSet.add(row.getLong("parent.masterid"));
                    Set subOrgIdsSet = org2SubOrgIds.computeIfAbsent(orgId, k -> new HashSet());
                    subOrgIdsSet.add(row.getLong("createorg"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }
}

