/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.BaseDataDisableValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CashflowItemDisablePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("createorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        BaseDataDisableValidator validator = new BaseDataDisableValidator();
        String entityKey = this.billEntityType.getName();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Object> itemList = new ArrayList<Object>();
        for (DynamicObject object : e.getDataEntities()) {
            Long itemId = object.getLong("id");
            DynamicObject itemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"gl_cashflowitem");
            Long userOrgId = itemObj.getLong("createorg_id");
            itemList.addAll(this.getAllSubItems(itemObj, userOrgId));
            itemList.addAll(this.getItemByMid(itemObj));
        }
        Set itemIds = itemList.stream().collect(Collectors.toCollection(HashSet::new));
        this.disabledSubCashFlowItem(itemIds);
    }

    private List<Object> getAllSubItems(DynamicObject itemObj, long curOrgId) {
        ArrayList<Long> paramOrg = new ArrayList<Long>();
        paramOrg.add(curOrgId);
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", paramOrg, (boolean)true);
        QFilter qnumber = new QFilter("longnumber", "like", (Object)(itemObj.get("longnumber") + "%"));
        QFilter qorg = new QFilter("createorg", "in", (Object)orgIds);
        return QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qorg, qnumber}, null, (int)-1);
    }

    private List<Object> getItemByMid(DynamicObject itemObj) {
        QFilter qlevel = new QFilter("level", "=", (Object)itemObj.getLong("level"));
        QFilter qnumber = new QFilter("number", "=", (Object)itemObj.getString("number"));
        String useorg = this.getOption().getVariableValue("createOrg", "0");
        QFilter qcreateorg = new QFilter("createorg_id", "=", (Object)Long.valueOf(useorg));
        return QueryServiceHelper.queryPrimaryKeys((String)"gl_cashflowitem", (QFilter[])new QFilter[]{qlevel, qnumber, qcreateorg}, null, (int)-1);
    }

    private void disabledSubCashFlowItem(Set<Object> itemIds) {
        DynamicObject[] itemList = BusinessDataServiceHelper.load((Object[])itemIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"));
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(itemList.length);
        for (DynamicObject entity : itemList) {
            entity.set("enable", (Object)"0");
            recordList.add(entity);
        }
        BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_cashflowitem"), (Object[])recordList.toArray(new DynamicObject[0]));
        this.operationResult.setSuccess(true);
    }
}

