/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.CashflowItemVersionUtil;

public class CashflowItemEnableValidator
extends AbstractValidator {
    public void validate() {
        long useOrgId = Long.parseLong(this.getOption().getVariableValue("useorg"));
        HashSet<Long> diffpIds = new HashSet<Long>();
        HashSet<Long> parentIdSet = new HashSet<Long>();
        HashMap<Long, DynamicObject> idToParentMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> idToorgItem = new HashMap<Long, DynamicObject>();
        HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
        HashMap<Long, Long> idToPorgItemMap = new HashMap<Long, Long>();
        HashMap acctsMap = BDUtil.getDynamicDatas((ExtendedDataEntity[])this.dataEntities);
        HashSet<Long> thisObjIds = new HashSet<Long>(acctsMap.size());
        for (DynamicObject obj : acctsMap.values()) {
            DynamicObject superiorObj;
            long itemId = obj.getLong("id");
            thisObjIds.add(itemId);
            DynamicObject parentObj = this.getParent(obj, useOrgId);
            if (parentObj != null && "0".equals(parentObj.getString("enable"))) {
                long pid = parentObj.getLong("id");
                parentIdSet.add(pid);
                idToParentMap.put(pid, parentObj);
                idToPidMap.put(itemId, pid);
            }
            if ((superiorObj = this.querySuperiorItem(obj)) == null) continue;
            long pid = superiorObj.getLong("id");
            parentIdSet.add(pid);
            idToorgItem.put(pid, superiorObj);
            idToPorgItemMap.put(itemId, pid);
        }
        if (parentIdSet.size() > 0) {
            for (Long parentId : parentIdSet) {
                if (thisObjIds.contains(parentId)) continue;
                diffpIds.add(parentId);
            }
        }
        if (!diffpIds.isEmpty()) {
            for (Iterator<Object> iterator : this.dataEntities) {
                String pnumber;
                DynamicObject item = iterator.getDataEntity();
                long itemId = item.getLong("id");
                boolean isSelected = this.extracted(acctsMap, item);
                if (isSelected || !"0".equals(iterator.getDataEntity().getString("enable"))) continue;
                Long pid = (Long)idToPidMap.get(itemId);
                if (idToParentMap.get(pid) != null) {
                    pnumber = ((DynamicObject)idToParentMap.get(pid)).getString("number");
                    this.addErrorMessage((ExtendedDataEntity)iterator, String.format(ResManager.loadKDString((String)"\u6709\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3010%s\u3011\u8bf7\u5148\u542f\u7528\u8be5\u9879\u76ee\u3002", (String)"CashflowItemEnableValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber));
                    continue;
                }
                pid = (Long)idToPorgItemMap.get(itemId);
                if (idToorgItem.get(pid) == null) continue;
                pnumber = ((DynamicObject)idToorgItem.get(pid)).getString("number");
                this.addErrorMessage((ExtendedDataEntity)iterator, String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u6709\u672a\u542f\u7528\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3010%s\u3011\u8bf7\u5148\u542f\u7528\u8be5\u9879\u76ee\u3002", (String)"CashflowItemEnableValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), pnumber));
            }
        }
    }

    private DynamicObject getParent(DynamicObject item, long useOrgId) {
        if (item.getDynamicObject("parent") == null) {
            return null;
        }
        String pnumber = item.getDynamicObject("parent").getString("number");
        QFilter fnumber = new QFilter("number", "=", (Object)pnumber);
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)useOrgId);
        QFilter fDate = new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate());
        QFilter allFilter = fnumber.and(baseFilter).and(fDate);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])allFilter.toArray());
    }

    private Boolean extracted(Map<Long, DynamicObject> itemMap, DynamicObject itemObj) {
        long parentId = itemObj.getLong("parent_id");
        if (parentId != 0L) {
            DynamicObject parentDy = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"gl_cashflowitem");
            if (itemMap.containsKey(parentId) && 0L == parentDy.getLong("parent_id")) {
                return true;
            }
            boolean isParentDisable = parentDy.getBoolean("enable");
            boolean isParentToParentSelected = itemMap.containsKey(parentDy.getLong("parent_id"));
            if (isParentDisable && isParentToParentSelected) {
                return true;
            }
            return this.extracted(itemMap, parentDy);
        }
        return false;
    }

    private DynamicObject querySuperiorItem(DynamicObject item) {
        List superiorItem = OrgUnitServiceHelper.getSuperiorOrgs((String)"10", (long)item.getLong("createorg_id"));
        if (superiorItem == null || superiorItem.size() == 0 || superiorItem.size() == 1 && (Long)superiorItem.get(0) == 0L) {
            return null;
        }
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)((Long)superiorItem.get(0)));
        QFilter numberFilter = new QFilter("number", "=", (Object)item.getString("number"));
        QFilter endDateFilter = new QFilter("enddate", "=", (Object)CashflowItemVersionUtil.getEndDate());
        QFilter statusFilter = new QFilter("enable", "=", (Object)"0");
        return BusinessDataServiceHelper.loadSingle((String)"gl_cashflowitem", (String)"id,longnumber", (QFilter[])new QFilter[]{orgFilter, numberFilter, endDateFilter, statusFilter});
    }
}

