/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.PeriodUtil;

public class PeriodSaveOp
extends AbstractOperationServicePlugIn {
    private static final String PERIODOUTLINE = "periodoutline";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void setDataEntities(ExtendedDataEntity[] dataEntities) {
                super.setDataEntities(dataEntities);
                Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).forEach(x$0 -> PeriodSaveOp.this.fillPeriodYear1(x$0));
            }

            public void validate() {
                HashMap<Long, String> periodsMapDB = new HashMap<Long, String>();
                ArrayList<Long> periodIds = new ArrayList<Long>();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object row2;
                    DynamicObject dyo = dataEntity.getDataEntity();
                    if (!dyo.getDataEntityState().getFromDatabase()) continue;
                    Object pkvalue = dyo.getPkValue();
                    int periodYear = dyo.getInt("periodyear");
                    int periodYearDB = 0;
                    periodsMapDB.clear();
                    DynamicObjectCollection entry = dyo.getDynamicObjectCollection("period_entry");
                    periodIds.clear();
                    long typeId = dyo.getLong("group_id");
                    for (Object row2 : entry) {
                        long pkid = PeriodUtil.getPkId((long)typeId, (int)periodYear, (int)Integer.parseInt(row2.get("periodnumber").toString()), (boolean)row2.getBoolean("isadjustperiod"));
                        periodIds.add(pkid);
                    }
                    DataSet periodsDB = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)"id,periodyear,name", (QFilter[])new QFilter(PeriodSaveOp.PERIODOUTLINE, "=", (Object)Long.parseLong(String.valueOf(pkvalue))).toArray(), (String)"id");
                    row2 = null;
                    try {
                        while (periodsDB.hasNext()) {
                            Row row3 = periodsDB.next();
                            periodYearDB = row3.getInteger("periodyear");
                            periodsMapDB.put(row3.getLong("id"), row3.getString("name"));
                        }
                    }
                    catch (Throwable row3) {
                        row2 = row3;
                        throw row3;
                    }
                    finally {
                        if (periodsDB != null) {
                            if (row2 != null) {
                                try {
                                    periodsDB.close();
                                }
                                catch (Throwable row3) {
                                    ((Throwable)row2).addSuppressed(row3);
                                }
                            } else {
                                periodsDB.close();
                            }
                        }
                    }
                    Set periodIdsDB = periodsMapDB.keySet();
                    if (periodYearDB != periodYear) {
                        String refResult = PeriodUtil.isReferenced(new ArrayList(periodIdsDB), (String)"bd_period");
                        if (refResult.isEmpty()) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5e74\u671f\u95f4\u5df2\u88ab%2$s\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u4f1a\u8ba1\u5e74\u5ea6", (String)"PeriodSaveOp_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), periodYearDB, refResult), ErrorLevel.Error);
                        continue;
                    }
                    for (Map.Entry periodsEntry : periodsMapDB.entrySet()) {
                        Object periodIdDB = periodsEntry.getKey();
                        String value = (String)periodsEntry.getValue();
                        if (periodIds.contains(periodIdDB)) continue;
                        ArrayList oneList = new ArrayList();
                        oneList.add(periodIdDB);
                        String refResult = PeriodUtil.isReferenced(oneList, (String)"bd_period");
                        if (refResult.isEmpty()) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4ece\u671f\u95f4\u660e\u7ec6\u5206\u5f55\u4e2d\u5220\u9664\u201c%1$s\u201d\u671f\uff0c%2$s\u5df2\u88ab%3$s\u5f15\u7528\u3002", (String)"PeriodSaveOp_2", (String)"fi-bd-opplugin", (Object[])new Object[0]), value, value, refResult), ErrorLevel.Error);
                    }
                }
            }
        });
    }

    private void fillPeriodYear1(DynamicObject dataEntity) {
        int periodYear1 = dataEntity.getInt("periodyear1");
        int periodYear = dataEntity.getInt("periodyear");
        if (periodYear1 == 0 && periodYear != 0) {
            dataEntity.set("periodyear1", (Object)periodYear);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject dyo : e.getDataEntities()) {
            DynamicObject periodType = dyo.getDynamicObject("group");
            int year = dyo.getInt("periodyear");
            DynamicObjectCollection entry = dyo.getDynamicObjectCollection("period_entry");
            ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(entry.size());
            MainEntityType periodEntityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
            long typeId = (Long)periodType.getPkValue();
            int numbersize = "4".equals(periodType.getString("generatetype")) && entry.size() >= 100 ? 1000 : 100;
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject dynaObj = new DynamicObject((DynamicObjectType)periodEntityType);
                int periodNum = Integer.parseInt(((DynamicObject)entry.get(i)).get("periodnumber").toString());
                boolean isAdjustPeriod = (Boolean)((DynamicObject)entry.get(i)).get("isadjustperiod");
                long pk = PeriodUtil.getPkId((long)typeId, (int)year, (int)periodNum, (boolean)isAdjustPeriod);
                periodEntityType.getPrimaryKey().setValue((Object)dynaObj, (Object)pk);
                dynaObj.set(PERIODOUTLINE, dyo.getPkValue());
                dynaObj.set("periodtype", (Object)periodType);
                dynaObj.set("periodyear", (Object)year);
                dynaObj.set("name", ((DynamicObject)entry.get(i)).get("periodname"));
                dynaObj.set("number", isAdjustPeriod ? year * numbersize + periodNum + "T" : Integer.valueOf(year * numbersize + periodNum));
                dynaObj.set("begindate", ((DynamicObject)entry.get(i)).get("begindate"));
                dynaObj.set("enddate", ((DynamicObject)entry.get(i)).get("enddate"));
                dynaObj.set("periodnumber", ((DynamicObject)entry.get(i)).get("periodnumber"));
                dynaObj.set("periodquarter", ((DynamicObject)entry.get(i)).get("periodquarter"));
                dynaObj.set("isadjustperiod", (Object)isAdjustPeriod);
                dataEntities.add(dynaObj);
            }
            if (dataEntities.isEmpty()) continue;
            QFilter qperiodtype = new QFilter("periodtype", "=", periodType.get("id"));
            QFilter qperiodoutline = new QFilter(PERIODOUTLINE, "=", dyo.getPkValue());
            DeleteServiceHelper.delete((String)"bd_period", (QFilter[])new QFilter[]{qperiodoutline, qperiodtype});
            SaveServiceHelper.save((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
        }
    }
}

