/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.fi.bd.opplugin.accountimport.AccountImportUtil;
import kd.fi.bd.opplugin.accountimport.AccountKeyVO;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.OrgVO;
import org.apache.commons.lang3.ObjectUtils;

public class AccountImportContext {
    private final ExtendedDataEntity[] sourceBills;
    private long accTableId;
    private long accTableOrgId;
    private BiTreeNode<Long, OrgVO> treeNode = new BiTreeNode();
    private Set<String> accountNumberSet = new HashSet<String>(10);
    private Map<String, Long> orgMap = new HashMap<String, Long>(10);
    private Map<Long, Tuple<String, Integer>> accCtrlStrategyLevelMap = new HashMap<Long, Tuple<String, Integer>>(8);
    private Map<String, Integer> numberCountMap = new HashMap<String, Integer>(10);
    private Map<AccountKeyVO, Long> currOrgAccountMap = new HashMap<AccountKeyVO, Long>(8);

    public AccountImportContext(ExtendedDataEntity[] billdatas) {
        this.sourceBills = billdatas;
        this.checkData();
    }

    private void checkData() {
        this.prepareTableDataCache();
        this.queryCurrOrgAccount();
    }

    private void queryCurrOrgAccount() {
        if (this.accountNumberSet.isEmpty() || this.orgMap.values().isEmpty()) {
            return;
        }
        HashMap<Long, Set<Long>> orgAccMap = new HashMap<Long, Set<Long>>(8);
        this.currOrgAccountMap = AccountImportUtil.getCurrOrgAccount(this.accTableId, this.accountNumberSet, orgAccMap, this.accCtrlStrategyLevelMap);
    }

    private void prepareTableDataCache() {
        HashSet<String> orgNumberSet = new HashSet<String>(10);
        DynamicObject accTableDy = this.sourceBills[0].getDataEntity().getDynamicObject("accounttable");
        String accTableNumber = accTableDy.getString("number");
        this.accTableId = accTableDy.getLong("id");
        this.accTableOrgId = accTableDy.getDynamicObject("org").getLong("id");
        this.treeNode = BDUtil.buildSubTreeByOrgId(Optional.of(this.accTableOrgId));
        for (ExtendedDataEntity extendedDataEntity : this.sourceBills) {
            long useOrgId;
            String key;
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject createOrg = data.getDynamicObject("createorg");
            String accountNumber = data.getString("number");
            orgNumberSet.add(createOrg.getString("number"));
            this.accountNumberSet.add(accountNumber);
            DynamicObject parentDy = data.getDynamicObject("parent");
            if (null != parentDy) {
                this.accountNumberSet.add(parentDy.getString("number"));
            }
            int count = this.numberCountMap.get(key = (useOrgId = data.getLong("useorg_id")) + accTableNumber + accountNumber) == null ? 1 : this.numberCountMap.get(key) + 1;
            this.numberCountMap.put(key, count);
        }
        this.orgMap = AccountImportUtil.getOrgNumberMap(orgNumberSet);
    }

    public static OperateOption dealImportAccount(Boolean isAddNew, DynamicObject dbDynamicObject, DynamicObject dynamicObject) {
        OperateOption operateOption = OperateOption.create();
        long createOrgId = dynamicObject.getLong("createorg_id");
        long useOrgId = dynamicObject.getLong("useorg_id");
        if (!isAddNew.booleanValue()) {
            if (dbDynamicObject != null) {
                Map accountProp = AccountVersionControlChecker.getWithoutEntryAccountProp((DynamicObject)dynamicObject);
                Map dbAccountProp = AccountVersionControlChecker.getWithoutEntryAccountProp((DynamicObject)dbDynamicObject);
                boolean accountPropEqual = dbAccountProp.equals(accountProp);
                if (accountPropEqual) {
                    boolean entryEqual = AccountVersionControlChecker.compareAccountEntryIsEqual((DynamicObject)dynamicObject, (DynamicObject)dbDynamicObject);
                    if (!entryEqual) {
                        operateOption.setVariableValue("isversion", "1");
                    }
                } else {
                    operateOption.setVariableValue("isversion", "1");
                }
                AccountImportContext.dealProperty(dbDynamicObject, dynamicObject, operateOption);
            }
        } else {
            long parentCreateOrgId;
            operateOption.setVariableValue("isaddnew", "1");
            if (dynamicObject.getInt("level") != 1 && useOrgId != (parentCreateOrgId = dynamicObject.getDynamicObject("parent").getLong("createorg_id"))) {
                operateOption.setVariableValue("isversion", "1");
            }
        }
        return operateOption;
    }

    private static void dealProperty(DynamicObject dbDynamicObject, DynamicObject dynamicObject, OperateOption operateOption) {
        Date dbStartDate = dbDynamicObject.getDate("startdate");
        Date startDate = dynamicObject.getDate("startdate");
        DataEntityPropertyCollection propertyies = dynamicObject.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyies) {
            boolean isEntryProp = property instanceof EntryProp;
            if (isEntryProp) {
                if (property.getName().equals("checkitementry")) {
                    AccountImportContext.dealEntryProp(dynamicObject, dbDynamicObject, "checkitementry", "asstactitem", operateOption);
                    continue;
                }
                AccountImportContext.dealEntryProp(dynamicObject, dbDynamicObject, "currencyentry", "currency", operateOption);
                continue;
            }
            if ("startdate".equals(property.getName()) && dbStartDate.compareTo(startDate) != 0 && !AccountImportUtil.isFromVersionAddLeaf(dynamicObject.getLong("masterid"))) {
                dbDynamicObject.set(property, (Object)dbDynamicObject.getDate("startdate"));
                continue;
            }
            dbDynamicObject.set(property, dynamicObject.get(property));
        }
    }

    private static void dealEntryProp(DynamicObject dynamicObject, DynamicObject dbDynamicObject, String entryMark, String keyFieldName, OperateOption operateOption) {
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection(entryMark);
        DynamicObjectCollection entryDb = dbDynamicObject.getDynamicObjectCollection(entryMark);
        List entryDbItemIds = BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)entryDb, (String)keyFieldName);
        List currEntryItemIds = BDUtil.getKeyFieldIdsInEntry((DynamicObjectCollection)entry, (String)keyFieldName);
        ArrayList<DynamicObject> deleteEntrys = new ArrayList<DynamicObject>(8);
        HashSet<DynamicObject> addEntrys = new HashSet<DynamicObject>(8);
        boolean isAddAssist = false;
        if (entry.isEmpty() && !entryDb.isEmpty()) {
            entryDb.clear();
        }
        if (!entry.isEmpty() && entryDb.isEmpty()) {
            entryDb.addAll((Collection)entry);
            return;
        }
        for (DynamicObject currEntry : entry) {
            for (DynamicObject dbEntry : entryDb) {
                DynamicObject currItem = currEntry.getDynamicObject(keyFieldName);
                DynamicObject dbItem = dbEntry.getDynamicObject(keyFieldName);
                Object dbAsstactItemId = dbItem.getPkValue();
                if (null == currItem) continue;
                if (dbAsstactItemId == currItem.getPkValue()) {
                    DataEntityPropertyCollection propertyCollection = currEntry.getDynamicObjectType().getProperties();
                    currEntry.set("id", (Object)dbEntry.getLong("id"));
                    for (IDataEntityProperty property : propertyCollection) {
                        dbEntry.set(property, currEntry.get(property));
                    }
                    continue;
                }
                if (!currEntryItemIds.contains(dbAsstactItemId)) {
                    deleteEntrys.add(dbEntry);
                    if (entryDbItemIds.contains(currItem.getLong("id"))) continue;
                    addEntrys.add(currEntry);
                    continue;
                }
                if (entryDbItemIds.contains(currItem.getLong("id"))) continue;
                addEntrys.add(currEntry);
                if (!entryMark.equals("checkitementry") || isAddAssist) continue;
                operateOption.setVariableValue("isAddAllAssgrps", "1");
            }
        }
        entryDb.removeAll(deleteEntrys);
        entryDb.addAll(addEntrys);
    }

    public static Map<Integer, String> setImportAccAssist(JSONObject data, Map<String, Map<String, List<String>>> currEntry) {
        JSONArray currencyEntry;
        HashMap<Integer, String> errorMessageMap = new HashMap<Integer, String>(8);
        JSONObject createOrg = data.getJSONObject("createorg");
        JSONObject accountTable = data.getJSONObject("accounttable");
        JSONArray checkitementry = data.getJSONArray("checkitementry");
        String createOrgNum = createOrg.getString("number");
        String accTableNumber = accountTable.getString("number");
        String number = data.getString("number");
        String key = AccountImportContext.buildKey(new Object[]{createOrgNum, accTableNumber, number});
        if (null != checkitementry) {
            AccountImportContext.dealImportEntry(checkitementry, key, "asstactitem", currEntry, errorMessageMap);
        }
        if (null != (currencyEntry = data.getJSONArray("currencyentry"))) {
            AccountImportContext.dealImportEntry(currencyEntry, key, "currency", currEntry, errorMessageMap);
        }
        return errorMessageMap;
    }

    private static void dealImportEntry(JSONArray entryRows, String key, String entryType, Map<String, Map<String, List<String>>> currEntry, Map<Integer, String> errorMessageMap) {
        if (!"currency".equals(entryType) && !"asstactitem".equals(entryType)) {
            throw new KDBizException("wrong entry type:" + entryType);
        }
        HashMap<String, List> currInfoEntry = new HashMap<String, List>(8);
        for (Object entry : entryRows) {
            Object currEntryData;
            int rowNum = 0;
            JSONObject jsonObject = (JSONObject)entry;
            if (jsonObject.containsKey((Object)"rowNum")) {
                rowNum = jsonObject.getInteger("rowNum");
            }
            if (ObjectUtils.isEmpty((Object)(currEntryData = jsonObject.get((Object)entryType)))) {
                String message = "asstactitem".equals(entryType) ? ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u5206\u5f55\u662f\u5426\u586b\u5199\u4e86\u5f02\u5e38\u6570\u636e(\u5185\u7801\u3001\u6838\u7b97\u7ef4\u5ea6.\u540d\u79f0\u3001\u5fc5\u5f55\u3001\u660e\u7ec6\u3001\u5f80\u6765\u6838\u7b97)\u3002", (String)"AccountImportContext_1", (String)"fi-bd-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5e01\u79cd\u5206\u5f55\u662f\u5426\u586b\u5199\u4e86\u5f02\u5e38\u6570\u636e(\u5e01\u79cd.\u540d\u79f0)\u3002", (String)"AccountImportContext_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
                if (errorMessageMap.containsKey(rowNum)) {
                    String mess = errorMessageMap.get(rowNum) + " " + message;
                    errorMessageMap.put(rowNum, mess);
                    break;
                }
                errorMessageMap.put(rowNum, message);
                break;
            }
            String currEntryValue = jsonObject.getJSONObject(entryType).getString("number");
            currInfoEntry.computeIfAbsent(key, k -> new ArrayList(8)).add(currEntryValue);
        }
        currEntry.computeIfAbsent(entryType, k -> new HashMap(8)).putAll(currInfoEntry);
    }

    public static String buildKey(Object[] params) {
        return StringUtils.join((Object[])params, (String)"");
    }

    public Map<String, Integer> getNumberCountMap() {
        return this.numberCountMap;
    }

    public BiTreeNode<Long, OrgVO> getAccTableOrgTreeNode() {
        return this.treeNode;
    }

    public Map<AccountKeyVO, Long> getCurrOrgAccountMap() {
        return this.currOrgAccountMap;
    }

    public Map<Long, Tuple<String, Integer>> getAccCtrlStrategyMap() {
        return this.accCtrlStrategyLevelMap;
    }

    public long getAccTableId() {
        return this.accTableId;
    }

    public long getAccTableOrgId() {
        return this.accTableOrgId;
    }
}

