/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountimport;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.opplugin.accountimport.AccountKeyVO;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.vo.OrgVO;

public class AccountImportUtil {
    public static long getParentOrg(long useOrgId, BiTreeNode<Long, OrgVO> treeNode) {
        long parentOrg = 0L;
        List child = treeNode.getChild();
        for (BiTreeNode childNode : child) {
            Map currNodeInfoMap = BiTreeNode.toMap((BiTreeNode)childNode);
            if (!currNodeInfoMap.containsKey(useOrgId)) continue;
            parentOrg = (Long)((BiTreeNode)currNodeInfoMap.get(useOrgId)).getParentId();
            break;
        }
        return parentOrg;
    }

    public static Map<AccountKeyVO, Long> getCurrOrgAccount(long tableId, Set<String> accountNumberSet, final Map<Long, Set<Long>> orgAccMap, final Map<Long, Tuple<String, Integer>> accCtrlStrategyLevelMap) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select a.fid,a.fcreateorgid,a.fnumber,a.faccounttableid,b.fuseorgid,a.fctrlstrategy,a.fcontrollevel from ", new Object[0]);
        sqlBuilder.append(" t_bd_account a inner join t_bd_account_u b on a.fid = b.fdataid where ", new Object[0]);
        sqlBuilder.appendIn(" a.fnumber ", new ArrayList<String>(accountNumberSet));
        sqlBuilder.append(" and a.faccounttableid = ? ", new Object[]{tableId});
        sqlBuilder.append(" and a.fenddate = ? ", new Object[]{AccountVersionUtil.getEndDate()});
        return (Map)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<AccountKeyVO, Long>>(){
            Map<AccountKeyVO, Long> currOrgAccountMap = new HashMap<AccountKeyVO, Long>(8);

            public Map<AccountKeyVO, Long> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    long accTableId = rs.getLong("faccounttableid");
                    long useOrgId = rs.getLong("fuseorgid");
                    String accountNumber = rs.getString("fnumber");
                    long accountId = rs.getLong("fid");
                    this.currOrgAccountMap.put(new AccountKeyVO(accTableId, useOrgId, accountNumber), accountId);
                    orgAccMap.computeIfAbsent(useOrgId, k -> new HashSet(8)).add(accountId);
                    accCtrlStrategyLevelMap.put(accountId, new Tuple((Object)rs.getString("fctrlstrategy"), (Object)rs.getInt("fcontrollevel")));
                }
                return this.currOrgAccountMap;
            }
        });
    }

    public static Map<String, Long> getOrgNumberMap(Set<String> orgNumberSet) {
        if (orgNumberSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(8);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"bd_accountimport_getorgid", (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumberSet)}, null);){
            for (Row row : orgDataSet) {
                numberIdMap.put(row.getString("number"), row.getLong("id"));
            }
        }
        return numberIdMap;
    }

    public static boolean isFromVersionAddLeaf(Long masterId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 1 a.fmasterid from t_bd_account a inner join ", new Object[0]);
        sqlBuilder.append("t_bd_account b on a.fmasterid = b.fmasterid and a.flevel <> b.flevel ", new Object[0]);
        sqlBuilder.append("and a.faccounttableid = b.faccounttableid", new Object[0]);
        sqlBuilder.append("where a.fmasterid = ? ", new Object[]{masterId});
        Boolean isBizAddLeaf = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                return resultSet.next();
            }
        });
        QFilter masterIdFilter = new QFilter("id", "=", (Object)masterId);
        masterIdFilter.and(new QFilter("masterid", "=", (Object)masterId));
        masterIdFilter.and("startdate", "!=", (Object)AccountVersionUtil.getInitBeginDate());
        return isBizAddLeaf != false || QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])masterIdFilter.toArray());
    }
}

