/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountingsys;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.util.AccountingSysUtil;

public class AccountingSysSaveValidator
extends AbstractValidator {
    private static final String ENABLE_GROUP_LOCAL_CURRENCY = "enablegrplocalcur";
    private static final String CONVERSION_METHOD = "conversionmethod";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject accountingSys = dataEntity.getDataEntity();
            long accountingSysId = accountingSys.getLong("id");
            if (accountingSysId == 0L || !AccountingSysUtil.isHaveBizByAccountBook((long)accountingSysId) || !this.isChangeGroupLocalCurrencyFields(accountingSys)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4f53\u7cfb\u4e0b\u6709\u4f1a\u8ba1\u8d26\u7c3f\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u96c6\u56e2\u672c\u4f4d\u5e01\u76f8\u5173\u7684\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AccountingSysSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isChangeGroupLocalCurrencyFields(DynamicObject accountingSys) {
        StringBuilder selectProperties = new StringBuilder(CONVERSION_METHOD);
        List configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId((String)"bd_accountingsys");
        for (LocalCurrencyConfigVO configVO : configVOList) {
            selectProperties.append(",").append(configVO.getCurrencyField()).append(",").append(configVO.getExRateField());
        }
        DynamicObject oldAccountingSys = BusinessDataServiceHelper.loadSingleFromCache((Object)accountingSys.getLong("id"), (String)"bd_accountingsys", (String)selectProperties.toString());
        if (Objects.nonNull(oldAccountingSys)) {
            boolean changeMulCurField = false;
            for (LocalCurrencyConfigVO configVO : configVOList) {
                if (accountingSys.getLong(configVO.getCurrencyField() + "_id") == oldAccountingSys.getLong(configVO.getCurrencyField() + "_id") && accountingSys.getLong(configVO.getExRateField() + "_id") == oldAccountingSys.getLong(configVO.getExRateField() + "_id")) continue;
                changeMulCurField = true;
                break;
            }
            return changeMulCurField || !accountingSys.getString(CONVERSION_METHOD).equals(oldAccountingSys.getString(CONVERSION_METHOD));
        }
        return false;
    }
}

