/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accountingsys;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountDataMutexUtil;
import kd.fi.bd.util.AccountVersionUtil;

public class UpdateVoucherValidator
extends AbstractValidator {
    private Set<Long> mutexAccountIds = new HashSet<Long>(16);

    public UpdateVoucherValidator(Set<Long> mutexAccountIds) {
        this.mutexAccountIds = mutexAccountIds;
    }

    public void validate() {
        String useOrg = this.getOption().getVariableValue("useorg", "0");
        long useOrgId = Long.parseLong(useOrg);
        String accountTable = this.getOption().getVariableValue("accounttable", "0");
        if (useOrg.equals("0") || accountTable.equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u548c\u79d1\u76ee\u8868\u3002", (String)"UpdateVoucherValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        DynamicObject orgStruct = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"isleaf", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)useOrgId), new QFilter("view", "=", (Object)10L), new QFilter("view.isdefault", "=", (Object)true)});
        if (!orgStruct.getBoolean("isleaf")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u7ec4\u7ec7\u3002", (String)"UpdateVoucherValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        }
        String lockKey = "fi/bd/updatevoucher/" + useOrg + accountTable;
        ExtendedDataEntity[] extendedDataEntityArray = null;
        try (DLock lock = DLock.create((String)lockKey).fastMode();){
            if (!lock.tryLock()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u7ec4\u7ec7\u201d\u3001\u201c\u79d1\u76ee\u8868\u201d\u6b63\u5728\u8fdb\u884c\u51ed\u8bc1\u66f4\u65b0\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"UpdateVoucherValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable object) {
            extendedDataEntityArray = object;
            throw object;
        }
        HashMap<Long, ExtendedDataEntity> pendingAccounts = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject accountDyn = dataEntity.getDataEntity();
            pendingAccounts.put(accountDyn.getLong("id"), dataEntity);
        }
        Map requireMutex = AccountDataMutexUtil.requireMutex((String)"bd_accountview", pendingAccounts.keySet());
        for (Map.Entry entry : requireMutex.entrySet()) {
            this.addErrorMessage((ExtendedDataEntity)pendingAccounts.get(entry.getKey()), (String)entry.getValue());
            pendingAccounts.remove(entry.getKey());
        }
        for (Map.Entry entry : pendingAccounts.entrySet()) {
            ExtendedDataEntity dataEntity;
            this.mutexAccountIds.add((Long)entry.getKey());
            dataEntity = (ExtendedDataEntity)entry.getValue();
            DynamicObject account = dataEntity.getDataEntity();
            if (account.getDate("enddate").compareTo(AccountVersionUtil.getEndDate()) != 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee%s\u4e0d\u662f\u6700\u65b0\u7248\u672c\u79d1\u76ee\u8bf7\u9009\u62e9\u6700\u65b0\u7248\u672c\u79d1\u76ee\u3002", (String)"UpdateVoucherValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number")));
            }
            if (account.getBoolean("isleaf")) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u4e0d\u662f\u660e\u7ec6\u79d1\u76ee\u3002", (String)"UpdateVoucherValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]), account.getString("number")));
        }
    }
}

