/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accounttableref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.accounttableref.VirtualOrgExcuteParam;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefDeleteValidator
extends AbstractValidator {
    private static final String NAME_SUFFIX = ".name";
    private static final String DELIMITER = "\u3001";
    private static final String FI = "fi";
    private static final String FUSEORGID = "fuseorgid";
    private static final String ASSIGN_SQL = "select fuseorgid from T_BD_ACCOUNTTABLEREFUSEREG u where fisassign = '1' and fdataid = ";

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            this.singleValidate(extendedDataEntity);
        }
    }

    private void singleValidate(ExtendedDataEntity extendedDataEntity) {
        if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])new QFilter("accountref", "=", extendedDataEntity.getBillPkId()).toArray())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u7248\u672c\u5316\u65b9\u6848\u5df2\u6709\u7248\u672c\u5316\u8bb0\u5f55\uff0c\u8bf7\u5148\u786e\u4fdd\u65b9\u6848\u4e3a\u5df2\u542f\u7528\u72b6\u6001\uff0c\u70b9\u51fb\u5220\u9664\u7248\u672c\u5316\u8bb0\u5f55\uff0c\u518d\u5220\u9664\u65b9\u6848\u3002", (String)"AccountTableRefDeleteValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
        } else {
            Throwable throwable;
            DataSet ds;
            DynamicObject refDO = extendedDataEntity.getDataEntity();
            Date enableDate = refDO.getDate("enabledate");
            long oldAcctTabId = refDO.getLong("oldacttable_id");
            long newAcctTabId = refDO.getLong("newacttable_id");
            long createOrgId = refDO.getLong("createorg_id");
            HashSet<Long> assignOrgIds = new HashSet<Long>(16);
            assignOrgIds.add(createOrgId);
            DynamicObject accountTableRef = BusinessDataServiceHelper.loadSingleFromCache((Object)refDO.getLong("masterid"), (String)"bd_accounttableref", (String)"createorg_id");
            long currOpOrg = Long.parseLong(this.getOption().getVariableValue("createorg"));
            if (accountTableRef.getLong("createorg_id") != currOpOrg) {
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", new ArrayList(assignOrgIds), (boolean)true);
                ds = BatchProcessUtil.batchQueryDataSet((Collection)allSubordinateOrgs, batchOrgs -> {
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append(ASSIGN_SQL + refDO.getLong("masterid"), new Object[0]);
                    sqlBuilder.appendIn(" and fuseorgid ", batchOrgs.toArray());
                    return DB.queryDataSet((String)VirtualOrgExcuteParam.class.getName(), (DBRoute)DBRoute.of((String)FI), (SqlBuilder)sqlBuilder);
                });
                throwable = null;
                try {
                    for (Row row : ds) {
                        assignOrgIds.add(row.getLong(FUSEORGID));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds != null) {
                        if (throwable != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(ASSIGN_SQL + refDO.getLong("masterid"), new Object[0]);
            ds = DB.queryDataSet((String)VirtualOrgExcuteParam.class.getName(), (DBRoute)DBRoute.of((String)FI), (SqlBuilder)sqlBuilder);
            throwable = null;
            try {
                for (Row row : ds) {
                    assignOrgIds.add(row.getLong(FUSEORGID));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("org", "in", assignOrgIds);
            qfBuilder.add("oldaccttab", "=", (Object)oldAcctTabId);
            qfBuilder.add("accounttable", "=", (Object)newAcctTabId);
            qfBuilder.add("enabledate", "=", (Object)enableDate);
            Map bookVersions = BusinessDataServiceHelper.loadFromCache((String)"gl_book_version", (String)"org.name", (QFilter[])qfBuilder.toArray());
            if (!bookVersions.isEmpty()) {
                Set orgNames = bookVersions.values().stream().map(x -> x.getString("org.name")).collect(Collectors.toSet());
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u7248\u672c\u5316\u65b9\u6848\u5df2\u6709\u7248\u672c\u5316\u8bb0\u5f55\uff0c\u8bf7\u5148\u786e\u4fdd\u65b9\u6848\u4e3a\u5df2\u542f\u7528\u72b6\u6001\uff0c\u70b9\u51fb\u5220\u9664\u7248\u672c\u5316\u8bb0\u5f55\uff0c\u518d\u5220\u9664\u65b9\u6848\u3002", (String)"AccountTableRefDeleteValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]), String.join((CharSequence)DELIMITER, orgNames)));
            }
        }
    }
}

