/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.accounttableref;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefOpService;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionControlChecker;
import kd.fi.bd.util.QFBuilder;

public class AccountTableRefSaveValidator
extends AbstractValidator {
    private static final String PAUSE = "\u3001";
    private static final String[] CASH_ARG_FIELDS = new String[]{"iscash", "isbank", "iscashequivalent"};
    public static final String ID_SUFFIX = "_id";
    private static Log LOGGER = LogFactory.getLog(AccountTableRefSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
            this.unSupportComAssist(extendedDataEntity);
            boolean singleValidate = this.singleValidate(extendedDataEntity);
            if (!singleValidate) continue;
            this.restore(extendedDataEntity);
        }
    }

    private void unSupportComAssist(ExtendedDataEntity extendedDataEntity) {
        DynamicObject accountTableVersion = extendedDataEntity.getDataEntity();
        long oldAccountTableId = accountTableVersion.getLong("oldacttable.id");
        long newAccountTableId = accountTableVersion.getLong("newacttable.id");
        DynamicObjectCollection accountTableDyns = QueryServiceHelper.query((String)"bd_accounttable", (String)"comassistentry", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)new Long[]{oldAccountTableId, newAccountTableId})});
        for (DynamicObject accountTableDyn : accountTableDyns) {
            if (accountTableDyn.getLong("comassistentry") == 0L) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u516c\u5171\u7ef4\u5ea6\u7684\u79d1\u76ee\u8868\u4e0d\u5141\u8bb8\u505a\u79d1\u76ee\u8868\u7248\u672c\u5316\u3002", (String)"AccountTableRefSaveValidator_22", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void restore(ExtendedDataEntity extendedDataEntity) {
        boolean isEntryChange;
        DynamicObject newData = extendedDataEntity.getDataEntity();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", extendedDataEntity.getBillPkId());
        DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttableref", (QFilter[])qfBuilder.toArray());
        DynamicObject restoreData = null;
        boolean isPersonalized = false;
        long useOrgId = newData.getLong("useorg_id");
        long createOrgId = newData.getLong("createorg_id");
        if (useOrgId != createOrgId) {
            isPersonalized = true;
            qfBuilder.clear();
            qfBuilder.add("org", "=", (Object)useOrgId);
            qfBuilder.add("accountref", "=", extendedDataEntity.getBillPkId());
            qfBuilder.add("enablestatus", "=", (Object)"D");
            if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray()) && !Objects.isNull(originalData)) {
                restoreData = this.getChangeData(originalData, newData);
            }
        } else {
            qfBuilder.clear();
            qfBuilder.add("accountref", "=", extendedDataEntity.getBillPkId());
            qfBuilder.add("enablestatus", "=", (Object)"D");
            if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
                restoreData = this.getChangeData(originalData, newData);
            }
        }
        if (null != restoreData && (isEntryChange = restoreData.getDynamicObjectCollection("mappingentry").stream().anyMatch(x -> x.getBoolean("ischange")))) {
            Tuple restoreResult = AccountTableRefOpService.restoreAfterSave((DynamicObject)restoreData, (long)useOrgId, (boolean)isPersonalized);
            boolean isSuccess = (Boolean)restoreResult.item1;
            if (!isSuccess) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8fd8\u539f\u5df2\u542f\u7528\u7684\u6570\u636e\u5931\u8d25\u3002", (String)"AccountTableRefSaveValidator_19", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                this.getOption().setVariableValue("op_report", restoreResult.item2.toString());
            }
        }
    }

    private DynamicObject getChangeData(DynamicObject oldData, DynamicObject newData) {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("AccountTableRef_ReStore rows\uff1a");
        long oldDataNewAccountTableId = oldData.getLong("newacttable_id");
        long newDataNewAccountTableId = newData.getLong("newacttable_id");
        boolean doLog = false;
        if (oldDataNewAccountTableId == newDataNewAccountTableId) {
            Map<Long, Long> newDataOldIdAndNewId = newData.getDynamicObjectCollection("mappingentry").stream().collect(Collectors.toMap(x -> x.getLong("oldaccount_id"), x -> x.getLong("newaccount_id"), (oldVal, newVal) -> newVal));
            DynamicObjectCollection mappingEntries = oldData.getDynamicObjectCollection("mappingentry");
            oldData.set("isentrychange", (Object)false);
            for (DynamicObject entry : mappingEntries) {
                if (newDataOldIdAndNewId.remove(entry.getLong("oldaccount_id"), entry.getLong("newaccount_id"))) continue;
                doLog = true;
                entry.set("ischange", (Object)true);
                logBuilder.append(entry.getInt("seq"));
                logBuilder.append(",");
            }
        } else {
            oldData.set("isentrychange", (Object)true);
            logBuilder.append("all rows");
            doLog = true;
            DynamicObjectCollection mappingEntries = oldData.getDynamicObjectCollection("mappingentry");
            for (DynamicObject entry : mappingEntries) {
                entry.set("ischange", (Object)true);
            }
        }
        if (doLog) {
            LOGGER.error(logBuilder.toString());
        }
        return oldData;
    }

    private boolean singleValidate(ExtendedDataEntity extendedDataEntity) {
        long createOrgId;
        long newAccountTableId;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accountref", "=", extendedDataEntity.getBillPkId());
        qfBuilder.add("enablestatus", "=", (Object)"C");
        if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u542f\u7528\u79d1\u76ee\u8868\u7248\u672c\u5316\u540e\uff0c\u8bf7\u5148\u53cd\u542f\u7528\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"AccountTableRefSaveValidator_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject accountTableRefDO = extendedDataEntity.getDataEntity();
        if (!"1".equals(accountTableRefDO.getString("ctrlstrategy"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u5f53\u524d\u7ec4\u7ec7\u7684\u63a7\u5236\u7b56\u7565\u4e3a\u9010\u7ea7\u5206\u914d\u3002", (String)"AccountTableRefSaveValidator_18", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return false;
        }
        long oldAccountTableId = accountTableRefDO.getLong("oldacttable_id");
        if (oldAccountTableId == (newAccountTableId = accountTableRefDO.getLong("newacttable_id"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u8868\u4e0e\u76ee\u6807\u79d1\u76ee\u8868\u76f8\u540c\u3002", (String)"AccountTableRefSaveValidator_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return false;
        }
        qfBuilder.clear();
        qfBuilder.add("newacttable", "=", (Object)accountTableRefDO.getLong("newacttable_id"));
        qfBuilder.add("oldacttable", "=", (Object)oldAccountTableId);
        qfBuilder.add("id", "!=", extendedDataEntity.getBillPkId());
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accounttableref", (Long)accountTableRefDO.getLong("useorg_id")));
        if (QueryServiceHelper.exists((String)"bd_accounttableref", (QFilter[])qfBuilder.toArray())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6e90\u79d1\u76ee\u8868\u4e0e\u76ee\u6807\u79d1\u76ee\u8868\u7684\u5bf9\u7167\u5173\u7cfb\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AccountTableRefSaveValidator_2", (String)"fi-bd-opplugin", (Object[])new Object[0]));
            return false;
        }
        long id = accountTableRefDO.getLong("id");
        long masterId = accountTableRefDO.getLong("masterid");
        long useOrgId = accountTableRefDO.getLong("useorg_id");
        if (useOrgId != (createOrgId = accountTableRefDO.getLong("createorg_id")) || id != masterId) {
            if (useOrgId != createOrgId) {
                qfBuilder.clear();
                qfBuilder.add("org", "=", (Object)accountTableRefDO.getLong("useorg_id"));
                qfBuilder.add("accountref.masterId", "=", (Object)masterId);
                qfBuilder.add("enablestatus", "!=", (Object)"D");
                if (QueryServiceHelper.exists((String)"bd_accttabref_record", (QFilter[])qfBuilder.toArray())) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u79d1\u76ee\u8868\u7248\u672c\u5316\uff0c\u8bf7\u5148\u53cd\u542f\u7528\u540e\u518d\u8fdb\u884c\u4e2a\u6027\u5316\u3002", (String)"AccountTableRefSaveValidator_3", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            qfBuilder.clear();
            qfBuilder.add("id", "=", (Object)masterId);
            DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttableref", (QFilter[])qfBuilder.toArray());
            if (!Objects.isNull(originalData) && oldAccountTableId != originalData.getLong("oldacttable_id")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u6e90\u79d1\u76ee\u3002", (String)"AccountTableRefSaveValidator_4", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return this.validateAccountMappingEntries(extendedDataEntity);
    }

    private boolean validateAccountMappingEntries(ExtendedDataEntity extendedDataEntity) {
        DynamicObject accountTableRefDO = extendedDataEntity.getDataEntity();
        long orgId = accountTableRefDO.getLong("useorg_id");
        boolean checkAccountType = accountTableRefDO.getBoolean("checkaccounttype");
        DynamicObjectCollection mappingEntries = accountTableRefDO.getDynamicObjectCollection("mappingentry");
        Map id2rows = mappingEntries.stream().filter(x -> null != x && null != x.getDynamicObject("oldaccount")).collect(Collectors.groupingBy(x -> x.getDynamicObject("oldaccount").getLong("id"), Collectors.mapping(x -> x.getInt("seq"), Collectors.toList())));
        List errorMsgs = id2rows.values().stream().filter(x -> x.size() > 1).map(x -> String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u65e7\u79d1\u76ee\u91cd\u590d\u3002", (String)"AccountTableRefSaveValidator_5", (String)"fi-bd-opplugin", (Object[])new Object[0]), StringUtils.join((Object[])x.toArray(), (String)PAUSE))).collect(Collectors.toList());
        long oldAccountTableId = accountTableRefDO.getLong("oldacttable_id");
        long newAccountTableId = accountTableRefDO.getLong("newacttable_id");
        Set orgOldAccountIds = AccountUtils.getAccountIdSet((long)orgId, (long)oldAccountTableId, (Date)accountTableRefDO.getDate("enabledate"), null);
        Set orgNewAccountIds = AccountUtils.getAccountIdSet((long)orgId, (long)newAccountTableId, (Date)accountTableRefDO.getDate("enabledate"), null);
        for (DynamicObject row : mappingEntries) {
            String seq = row.getString("seq");
            DynamicObject oldAccount = row.getDynamicObject("oldaccount");
            DynamicObject newAccount = row.getDynamicObject("newaccount");
            if (Objects.isNull(oldAccount)) continue;
            if (!orgOldAccountIds.remove(oldAccount.getLong("id"))) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"AccountTableRefSaveValidator_7", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            if (Objects.isNull(newAccount)) continue;
            if (!orgNewAccountIds.contains(newAccount.getLong("id"))) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"AccountTableRefSaveValidator_9", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            boolean oldIsLeaf = oldAccount.getBoolean("isleaf");
            boolean newIsLeaf = newAccount.getBoolean("isleaf");
            if (oldIsLeaf && !newIsLeaf) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u4e0e\u76ee\u6807\u79d1\u76ee\u660e\u7ec6\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"AccountTableRefSaveValidator_10", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            if (checkAccountType) {
                long oldAccountTypeId = oldAccount.getLong("accounttype_id");
                long newAccountTypeId = newAccount.getLong("accounttype_id");
                Map types = BusinessDataServiceHelper.loadFromCache((String)"bd_accounttype", (String)"accounttype", (QFilter[])new QFilter("id", "in", (Object)new Long[]{oldAccountTypeId, newAccountTypeId}).toArray());
                DynamicObject oldType = (DynamicObject)types.get(oldAccountTypeId);
                DynamicObject newType = (DynamicObject)types.get(newAccountTypeId);
                if (oldType == null || newType == null || !oldType.getString("accounttype").equals(newType.getString("accounttype"))) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6e90\u79d1\u76ee\u4e0e\u76ee\u6807\u79d1\u76ee\u79d1\u76ee\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"AccountTableRefSaveValidator_12", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
                }
            }
            if (AccountVersionControlChecker.accountCurrencyControlCheck((DynamicObject)oldAccount, (DynamicObject)newAccount)) {
                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u76ee\u6807\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\u672a\u5305\u542b\u6e90\u79d1\u76ee\u5e01\u79cd\u6838\u7b97\u8303\u56f4\u3002", (String)"AccountTableRefSaveValidator_23", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            long count = row.getDynamicObjectCollection("assgrpentry").stream().collect(Collectors.groupingBy(x -> x.getLong("assisttype_id"))).values().stream().filter(x -> x.size() > 1).count();
            if (count <= 0L) continue;
            errorMsgs.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\u8bbe\u7f6e\u6838\u7b97\u7ef4\u5ea6\u91cd\u590d\u3002", (String)"AccountTableRefSaveValidator_21", (String)"fi-bd-opplugin", (Object[])new Object[0]), seq));
        }
        for (String errorMsg : errorMsgs) {
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
        return errorMsgs.isEmpty();
    }
}

