/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.billparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.fa.business.util.BillUtil;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.opplugin.billparam.validator.FaBillParamBizServiceValidator;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.fa.enums.BillParamValueTypeEnum;

public class FaBillParamSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(FaBillParamSaveOp.class);
    public static final String FIELD_SUFFIX = "val";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    boolean isExist;
                    DynamicObject dataObj = dataEntity.getDataEntity();
                    Boolean canModify = dataObj.getBoolean("canmodify");
                    if (!canModify.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u53c2\u6570\u4e0d\u53ef\u4fee\u6539\u3002", (String)"FaBillParamSaveOp_1", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                    }
                    String bizCloudId = dataObj.getString(BillUtil.dot((String[])new String[]{"bizcloud", "id"}));
                    String bizAppId = dataObj.getString(BillUtil.dot((String[])new String[]{"bizapp", "id"}));
                    Long billId = dataObj.getLong("id");
                    Long orgId = dataObj.getLong(BillUtil.dot((String[])new String[]{"org", "id"}));
                    Long assetBookId = dataObj.getLong(BillUtil.dot((String[])new String[]{"assetbook", "id"}));
                    Long depreUseId = dataObj.getLong(BillUtil.dot((String[])new String[]{"depreuse", "id"}));
                    String entityNumber = dataObj.getString(BillUtil.dot((String[])new String[]{"entity", "number"}));
                    String param = dataObj.getDynamicObject("paramtype").getString("number");
                    ArrayList<QFilter> filterList = new ArrayList<QFilter>(6);
                    filterList.add(new QFilter("param", "=", (Object)param));
                    if (StringUtils.isNotEmpty((String)bizCloudId)) {
                        filterList.add(new QFilter("bizcloud", "=", (Object)bizCloudId));
                    }
                    if (StringUtils.isNotEmpty((String)bizAppId)) {
                        filterList.add(new QFilter("bizapp", "=", (Object)bizAppId));
                    }
                    if (StringUtils.isNotEmpty((String)entityNumber)) {
                        filterList.add(new QFilter("entity", "=", (Object)entityNumber));
                    }
                    if (orgId != null && orgId != 0L) {
                        filterList.add(new QFilter("org", "=", (Object)orgId));
                    }
                    if (assetBookId != null && assetBookId != 0L) {
                        filterList.add(new QFilter("assetbook", "=", (Object)assetBookId));
                    }
                    if (depreUseId != null && depreUseId != 0L) {
                        filterList.add(new QFilter("depreuse", "=", (Object)depreUseId));
                    }
                    if (billId != null && billId != 0L) {
                        filterList.add(new QFilter("id", "!=", (Object)billId));
                    }
                    if (isExist = QueryServiceHelper.exists((String)"fa_billparam", (QFilter[])filterList.toArray(new QFilter[1]))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u53c2\u6570\u6216\u542f\u7528\u5df2\u6709\u914d\u7f6e\u3002", (String)"FaBillParamSaveOp_0", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (dataObj.getString("value").length() <= 200) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u6570\u503c\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\uff01", (String)"FaBillParamSaveOp_2", (String)"fi-bd-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.addValidator((AbstractValidator)new FaBillParamBizServiceValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataObjs;
        super.beginOperationTransaction(e);
        for (DynamicObject data : dataObjs = e.getDataEntities()) {
            DynamicObject billParamTypeObj = data.getDynamicObject("paramtype");
            if (billParamTypeObj == null) continue;
            data.set("param", (Object)billParamTypeObj.getString("number"));
            this.setValue(data);
        }
    }

    private void setValue(DynamicObject paramObj) {
        DynamicObject paramType = paramObj.getDynamicObject("paramtype");
        String showValueField = FaBillParamSaveOp.getShowValueField(paramType);
        BillParamValueTypeEnum valueTypeEnum = BillParamValueTypeEnum.getEnumByType((String)paramType.getString("valuetype"));
        Object showValue = paramObj.get(showValueField);
        String value = null;
        if (showValue != null) {
            switch (valueTypeEnum) {
                case DATE: {
                    value = DateUtils.formatString((Date)((Date)showValue), (String)"yyyy-MM-dd");
                    break;
                }
                case COMBOX: {
                    value = Arrays.stream(((String)showValue).split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                    break;
                }
                default: {
                    value = showValue.toString();
                }
            }
        }
        paramObj.set("value", value);
    }

    public static String getShowValueField(DynamicObject paramTypeObj) {
        String valueType;
        String valueField = "value";
        if (paramTypeObj != null && StringUtils.isNotEmpty((String)(valueType = paramTypeObj.getString("valuetype"))) && !BillParamValueTypeEnum.TEXT.getType().equals(valueType)) {
            valueField = valueType + FIELD_SUFFIX;
        }
        return valueField;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            BillParamUtil.removeKeyFromCache((String)dataEntity.getString("param"));
        }
    }
}

