/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.opplugin.billparam;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.enums.BillParamValueTypeEnum;

public class FaBillParamTypeSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String number;
                    String bizAppId;
                    String bizCloudId;
                    DynamicObject billParamTypeObj = dataEntity.getDataEntity();
                    Long id = billParamTypeObj.getLong("id");
                    String checkMsg = FaBillParamTypeSaveOp.this.uniqueCheck(id, bizCloudId = billParamTypeObj.getString("bizcloud"), bizAppId = billParamTypeObj.getString("bizapp"), number = billParamTypeObj.getString("number"));
                    if (StringUtils.isNotEmpty((String)checkMsg)) {
                        this.addErrorMessage(dataEntity, checkMsg);
                    }
                    if (StringUtils.isNotEmpty((String)(checkMsg = FaBillParamTypeSaveOp.this.checkReferenced4Modify(id, number)))) {
                        this.addErrorMessage(dataEntity, checkMsg);
                    }
                    if (!StringUtils.isNotEmpty((String)(checkMsg = FaBillParamTypeSaveOp.this.checkDefaultValue(billParamTypeObj)))) continue;
                    this.addErrorMessage(dataEntity, checkMsg);
                }
            }
        });
    }

    private String uniqueCheck(Long id, String bizCloudId, String bizAppId, String number) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (id != null && id != 0L) {
            filterList.add(new QFilter("id", "!=", (Object)id));
        }
        filterList.add(new QFilter("bizcloud", "=", (Object)bizCloudId));
        filterList.add(new QFilter("bizapp", "=", (Object)bizAppId));
        filterList.add(new QFilter("number", "=", (Object)number));
        boolean isExist = QueryServiceHelper.exists((String)"fa_billparam_type", (QFilter[])filterList.toArray(new QFilter[1]));
        if (isExist) {
            return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u914d\u7f6e\uff0c\u8bf7\u4fee\u6539\u53c2\u6570\u3002", (String)"FaBillParamTypeSave_0", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkReferenced4Modify(Long id, String number) {
        boolean isReferenced;
        if (id == null || id == 0L) {
            return null;
        }
        DynamicObject recordData = QueryServiceHelper.queryOne((String)"fa_billparam_type", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (!recordData.getString("number").equalsIgnoreCase(number) && (isReferenced = QueryServiceHelper.exists((String)"fa_billparam", (QFilter[])new QFilter[]{new QFilter("paramtype", "=", (Object)id)}))) {
            return ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u7f16\u7801\u3002", (String)"FaBillParamTypeSave_1", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkDefaultValue(DynamicObject dataObj) {
        JSONObject rangeJson;
        String defaultVal = dataObj.getString("defaultval");
        BillParamValueTypeEnum typeEnum = BillParamValueTypeEnum.getEnumByType((String)dataObj.getString("valuetype"));
        if (StringUtils.isEmpty((String)defaultVal) || !BillParamValueTypeEnum.COMBOX.equals((Object)typeEnum)) {
            return null;
        }
        String rangeStr = dataObj.getString("paramrange");
        if (StringUtils.isNotEmpty((String)rangeStr) && !(rangeJson = JSONObject.parseObject((String)rangeStr)).containsKey((Object)defaultVal)) {
            return ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u4e0d\u5728\u6570\u636e\u8303\u56f4\u5185\u3002", (String)"FaBillParamTypeSave_2", (String)"fi-bd-opplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

