/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AbstractBaseDataCtrlPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AccountCtrlPlugin
extends AbstractBaseDataCtrlPlugin {
    private static final String SPLIT = "_";

    public Boolean chectDuplicate(String entityType, Long orgID, List<Long> idList) {
        DynamicObjectCollection chooseaccts;
        boolean isHas = false;
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgID);
        if (ids != null && QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{ids}) && (chooseaccts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number,accounttable", (QFilter[])new QFilter("id", "in", (Object)idList.toArray()).toArray())).size() > 0) {
            int i;
            QFilter qaccttable = new QFilter("accounttable", "=", ((DynamicObject)chooseaccts.get(0)).get("accounttable"));
            DynamicObjectCollection targetaccts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,number", (QFilter[])new QFilter[]{ids, qaccttable});
            ArrayList<Long> targetIds = new ArrayList<Long>(targetaccts.size());
            ArrayList<String> targetNumbers = new ArrayList<String>(targetaccts.size());
            for (i = 0; i < targetaccts.size(); ++i) {
                targetNumbers.add(((DynamicObject)targetaccts.get(i)).getString("number"));
                targetIds.add(((DynamicObject)targetaccts.get(i)).getLong("id"));
            }
            for (i = 0; i < chooseaccts.size(); ++i) {
                String chooseNum = ((DynamicObject)chooseaccts.get(i)).getString("number");
                long chooseId = ((DynamicObject)chooseaccts.get(i)).getLong("id");
                if (!targetNumbers.contains(chooseNum) || targetIds.contains(chooseId)) continue;
                return true;
            }
        }
        return isHas;
    }

    private String[] getAllParentLnums(String longnumber, String split) {
        String[] splitStrs = longnumber.split(split);
        String[] result = new String[splitStrs.length];
        StringBuilder curLnumsb = new StringBuilder();
        for (int i = 0; i < splitStrs.length; ++i) {
            if (curLnumsb.length() == 0) {
                curLnumsb.append(splitStrs[i]);
            } else {
                curLnumsb.append(SPLIT).append(splitStrs[i]);
            }
            result[i] = curLnumsb.toString();
        }
        return result;
    }

    private boolean isCompleteTree(String longnumber, Set<String> acctlNumSet) {
        String[] plnums;
        boolean isComplete = true;
        for (String plnum : plnums = this.getAllParentLnums(longnumber, SPLIT)) {
            if (acctlNumSet.contains(plnum)) continue;
            isComplete = false;
        }
        return isComplete;
    }

    public Map<Long, List<Long>> assignCheck(List<Long> dataIDs, List<Long> orgIDs) {
        HashMap<Long, Set> tableAcctlNumsMap = new HashMap<Long, Set>();
        HashMap<Long, Set> tableSuccessAcctlnumsMap = new HashMap<Long, Set>();
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"longnumber,accounttable,isleaf", (QFilter[])new QFilter("id", "in", dataIDs).toArray(), (String)"level");){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                long accounttableId = row.getLong("accounttable");
                Set acctlNumSet = tableAcctlNumsMap.computeIfAbsent(accounttableId, key -> new HashSet());
                String longnumber = row.getString("longnumber");
                acctlNumSet.add(longnumber);
                if (!row.getBoolean("isleaf").booleanValue() || !this.isCompleteTree(longnumber, acctlNumSet)) continue;
                Set successAcctLnums = tableSuccessAcctlnumsMap.computeIfAbsent(accounttableId, key -> new HashSet());
                for (String plnum : this.getAllParentLnums(longnumber, SPLIT)) {
                    successAcctLnums.add(plnum);
                }
            }
        }
        HashMap<Long, List<Long>> failResult = new HashMap<Long, List<Long>>(dataIDs.size());
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,longnumber,accounttable", (QFilter[])new QFilter("id", "in", dataIDs).toArray(), (String)"accounttable");){
            Row row = null;
            while (dt.hasNext()) {
                row = dt.next();
                long accounttableId = row.getLong("accounttable");
                Set successAcctLnums = (Set)tableSuccessAcctlnumsMap.get(accounttableId);
                String longnumber = row.getString("longnumber");
                if (successAcctLnums != null && successAcctLnums.contains(longnumber)) continue;
                failResult.put(row.getLong("id"), orgIDs);
            }
        }
        return failResult;
    }

    public List<Long[]> unAssignCheck(List<Long[]> unAssignDatas) {
        long useOrgId;
        HashMap<Long, Set> orgAcctIdsMap = new HashMap<Long, Set>(10);
        for (Long[] data : unAssignDatas) {
            long acctId = data[0];
            useOrgId = data[1];
            Set acctIds = orgAcctIdsMap.computeIfAbsent(useOrgId, key -> new HashSet());
            acctIds.add(acctId);
        }
        Set<Long> entityOrgs = this.getEntityOrg(orgAcctIdsMap.keySet());
        ArrayList<Long[]> result = new ArrayList<Long[]>(unAssignDatas.size());
        for (Map.Entry entry : orgAcctIdsMap.entrySet()) {
            useOrgId = (Long)entry.getKey();
            if (!entityOrgs.contains(useOrgId)) continue;
            Set<Long> failAccts = this.getFailAccts(useOrgId, (Set)entry.getValue());
            for (Long failAcct : failAccts) {
                result.add(new Long[]{failAcct, useOrgId});
            }
        }
        return result;
    }

    private Set<Long> getFailAccts(long useOrgId, Set<Long> ids) {
        Row row;
        HashSet<Long> failAccts = new HashSet<Long>();
        try (DataSet initBalDt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)this.getSql("initbal", useOrgId, this.getIdsStr(ids)));){
            while (initBalDt.hasNext()) {
                row = initBalDt.next();
                failAccts.add(row.getLong("fid"));
            }
        }
        var6_5 = null;
        try (DataSet voucherDt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)this.getSql("voucher", useOrgId, this.getIdsStr(ids)));){
            while (voucherDt.hasNext()) {
                row = voucherDt.next();
                failAccts.add(row.getLong("fid"));
            }
        }
        catch (Throwable row2) {
            var6_5 = row2;
            throw row2;
        }
        var6_5 = null;
        try (DataSet inireciDt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)this.getSql("inireci", useOrgId, this.getIdsStr(ids)));){
            while (inireciDt.hasNext()) {
                row = inireciDt.next();
                failAccts.add(row.getLong("fid"));
            }
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        return failAccts;
    }

    private String getIdsStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append("'");
            sb.append(id);
            sb.append("'");
        }
        return sb.toString();
    }

    private String getSql(String key, long orgId, String idsStr) {
        String sql = "";
        switch (key) {
            case "initbal": {
                sql = "select fid from t_bd_account av where exists (select 1 from t_gl_initbalance where forgid = %s and faccountid in (%s) and faccountid=av.fid) AND av.fid IN (%s)";
                break;
            }
            case "voucher": {
                sql = "select fid from t_bd_account av where exists (SELECT 1 from t_gl_voucher A left join  t_gl_voucherentry B on A.fid=B.fid where A.forgid = %s and B.faccountid in (%s) and B.faccountid=av.fid) and av.fid in (%s)";
                break;
            }
            case "inireci": {
                sql = "select fid from t_bd_account av where exists (select 1 from t_gl_reci_init_state where forgid = %s and faccountid in (%s) and faccountid=av.fid) AND av.fid IN (%s)";
            }
        }
        return String.format(sql, orgId, idsStr, idsStr);
    }

    private Set<Long> getEntityOrg(Set<Long> filterOrg) {
        HashSet<Long> result = new HashSet<Long>();
        QFilter orgFiler = new QFilter("org", "in", filterOrg);
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{orgFiler, entityFilter}, null);){
            for (Row row : dataSet) {
                result.add(row.getLong("org"));
            }
        }
        return result;
    }
}

