/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.bd.formplugin.AccountEditView;

public class AccountEditAttributeManager {
    private static final String[] BOOLEAN_ATTRIBUTE_FIELDS_1 = new String[]{"ismanual", "isallowca"};
    private static final String[] BOOLEAN_ATTRIBUTE_FIELDS_2 = new String[]{"acnotice", "ischangecurrency", "isjournal"};

    protected AccountEditAttributeManager() {
    }

    protected void enableManageBySubOrgOrSubAccount(AccountEditView accountEditView) {
        DataSet allDirectSubordinateAccounts;
        HashSet<String> fieldDisabledSet = new HashSet<String>();
        DataSet allDirectSubordinateOrgAccounts = accountEditView.getAllSubordinateOrgAccounts();
        if (Objects.nonNull(allDirectSubordinateOrgAccounts)) {
            for (Row row : allDirectSubordinateOrgAccounts) {
                this.enableHandel(row, fieldDisabledSet);
            }
        }
        if (Objects.nonNull(allDirectSubordinateAccounts = accountEditView.getAllDirectSubordinateAccounts())) {
            for (Row row : allDirectSubordinateAccounts) {
                this.enableHandel(row, fieldDisabledSet);
            }
        }
        if (!fieldDisabledSet.isEmpty()) {
            accountEditView.getAccountEditView().setEnable(Boolean.FALSE, fieldDisabledSet.toArray(new String[0]));
        }
    }

    private void enableHandel(Row row, Set<String> fieldDisabledSet) {
        for (String field : BOOLEAN_ATTRIBUTE_FIELDS_1) {
            if (!row.getBoolean(field).booleanValue()) continue;
            fieldDisabledSet.add(field);
        }
        String dcControl = row.getString("accrualdirection");
        if ("nocontrol".equals(dcControl)) {
            fieldDisabledSet.add("accrualdirection");
        }
        if (!row.getBoolean("isqty").booleanValue()) {
            fieldDisabledSet.add("isqty");
            fieldDisabledSet.add("measureunit");
            fieldDisabledSet.add("measureunitgroup");
        }
        for (String field : BOOLEAN_ATTRIBUTE_FIELDS_2) {
            if (row.getBoolean(field).booleanValue()) continue;
            fieldDisabledSet.add(field);
        }
        String currencyType = row.getString("acctcurrency");
        if ("allcurrency".equals(currencyType)) {
            fieldDisabledSet.add("nocurrency");
            fieldDisabledSet.add("descurrency");
        } else if ("descurrency".equals(currencyType)) {
            fieldDisabledSet.add("nocurrency");
        }
    }
}

