/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.metadata.edit.AccountEdit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.consts.MappingTypeEnum;
import kd.fi.bd.formplugin.info.AccountFieldInfo;
import kd.fi.bd.formplugin.info.AssgrepCompareInfo;
import kd.fi.bd.formplugin.info.FieldInfo;
import kd.fi.bd.formplugin.utils.DynamicModifyViewAndModelUtil;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DynamicObjectSerializeUtil;
import kd.fi.bd.util.FibdApp;

public class AccountMappingEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(AccountMappingEditPlugin.class);
    private static final String CACHE_ORIGINAL_ENTITY = "cache_original_entity";
    private static final String CACHE_INIT = "cache_init";
    private static final String CACHE_AUTO_MAPPING_ALL = "cache_auto_mapping_all";
    private static final String CALL_BACK_AUTO_MAPPING = "call_back_auto_mapping";
    private static final String CTRL_MAPPING_ENTRY_OPTIONS = "mappingentryoptions";
    private static final String BTN_AUTO_MAPPING = "automapping";
    private static final String BTN_ASSGREP_COMPARE = "assgrepcompare";
    private static final String FLAG_TRUE = "true";
    private static final String FLAG_FALSE = "false";
    private static final String CALLBACK_MODIFY = "callback_modify";
    private static final String OPTION_IS_MODIFY_CONFIRM = "is_modify_confirm";
    private static final String[] BUDGET_ARRAY = new String[]{"A", "B", "C"};
    private static final String[] ENTRY_OPTIONS = new String[]{"newentry", "deleteentry", "assgrepcompare", "automapping"};

    public void initialize() {
        super.initialize();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{CTRL_MAPPING_ENTRY_OPTIONS});
        BasedataEdit srcAccountTable = (BasedataEdit)this.getView().getControl("srcacttable");
        srcAccountTable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit goalAccountTable = (BasedataEdit)this.getView().getControl("goalacttable");
        goalAccountTable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Set<Object> actFieldKeySet = new HashSet();
        try {
            actFieldKeySet = this.getActTableFieldKeyFromModel();
            this.getModel().updateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : actFieldKeySet) {
            BasedataEdit account = (BasedataEdit)this.getView().getControl(string);
            if (account == null) continue;
            account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        Set<Object> actFieldKeySet = new HashSet();
        try {
            actFieldKeySet = this.getActTableFieldKeyFromModel();
        }
        catch (Exception e1) {
            logger.warn("exception caught", (Throwable)e1);
        }
        if (actFieldKeySet.contains(key)) {
            AccountEdit fieldEdit = new AccountEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey("mappingshowentry");
            fieldEdit.setDisplayProp("number,name");
            e.setControl((Control)fieldEdit);
        } else if ("ismapping".equals(key)) {
            TextEdit fieldEdit = new TextEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(this.getView());
            fieldEdit.setEntryKey("mappingshowentry");
            e.setControl((Control)fieldEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType entityType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)entityType.clone();
        }
        catch (CloneNotSupportedException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            throw new KDBizException((Throwable)e1, BosErrorCode.systemError, new Object[0]);
        }
        if (this.getPageCache().get(CACHE_INIT) == null) {
            BaseShowParameter param = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pkId = param.getPkId();
            if (pkId != null) {
                DynamicObject editData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)newMainType.getName());
                String mappingType = editData.getString("mappingtype");
                DynamicObjectCollection actTbFieldMapping = editData.getDynamicObjectCollection("acttbfieldmappingentry");
                ArrayList<AccountFieldInfo> actFieldList = new ArrayList<AccountFieldInfo>();
                for (DynamicObject dyn : actTbFieldMapping) {
                    AccountFieldInfo field = new AccountFieldInfo();
                    DynamicObject accountTable = dyn.getDynamicObject("acttb");
                    String fieldKey = dyn.getString("fieldkey");
                    field.setActTableId(accountTable.getLong("id"));
                    field.setActTableName(new LocaleString(accountTable.getString("name")));
                    field.setFieldName(this.getFieldName(new LocaleString(accountTable.getString("name")), mappingType, fieldKey));
                    field.setFieldKey(fieldKey);
                    actFieldList.add(field);
                }
                this.rebuildModelAndGrid(actFieldList, newMainType, true, mappingType);
                e.setNewEntityType(newMainType);
            }
            this.getPageCache().put(CACHE_INIT, FLAG_TRUE);
        } else {
            List<AccountFieldInfo> actFieldList = this.getActFieldFromModel();
            String mappingType = this.getModel().getValue("mappingtype").toString();
            this.rebuildModelAndGrid(actFieldList, newMainType, false, mappingType);
            e.setNewEntityType(newMainType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String dataStr = this.getPageCache().get(CACHE_ORIGINAL_ENTITY);
        if (dataStr != null) {
            DynamicObject editData = DynamicObjectSerializeUtil.deserialize((String)dataStr, (DynamicObjectType)this.getModel().getDataEntityType());
            DynamicObjectCollection actMapData = editData.getDynamicObjectCollection("acttbfieldmappingentry");
            ArrayList<AccountFieldInfo> actList = new ArrayList<AccountFieldInfo>();
            for (DynamicObject map : actMapData) {
                AccountFieldInfo field = new AccountFieldInfo();
                DynamicObject actTb = map.getDynamicObject("acttb");
                field.setActTableId(actTb.getLong("id"));
                field.setActTableName(new LocaleString(actTb.getString("name")));
                field.setFieldKey(map.getString("fieldkey"));
                actList.add(field);
            }
            this.saveActTableMapToModel(actList);
            DynamicObjectCollection showEntry = editData.getDynamicObjectCollection("mappingshowentry");
            this.copyDynamicObjectData(editData, this.getModel().getDataEntity(true));
            if (showEntry != null && !showEntry.isEmpty()) {
                int[] index = this.getModel().batchCreateNewEntryRow("mappingshowentry", showEntry.size());
                int i = 0;
                Map<Long, String> actTableFieldMap = this.getActTableFieldMapFromModel();
                for (DynamicObject row : showEntry) {
                    for (AccountFieldInfo field : actList) {
                        String fieldKey = field.getFieldKey();
                        DynamicObject fieldData = row.getDynamicObject(fieldKey);
                        if (fieldData == null) continue;
                        if ("src_act".equals(fieldKey)) {
                            this.getModel().setValue(fieldKey, (Object)fieldData.getLong("id"), index[i]);
                            continue;
                        }
                        long actTableId = fieldData.getLong("accounttable_id");
                        fieldKey = actTableFieldMap.get(actTableId);
                        if (fieldKey == null || "src_act".equals(fieldKey)) continue;
                        this.getModel().setValue(fieldKey, (Object)fieldData.getLong("id"), index[i]);
                    }
                    ++i;
                }
            }
            this.getModel().updateCache();
            this.getView().updateView();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.onlyViewWhileNotCreateOrgOrPersonalized();
        this.loadData();
        String mappingType = this.getModel().getValue("mappingtype").toString();
        if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            this.updateIsMappingAfterLoadData();
        } else {
            IFormView view = this.getView();
            view.setEnable(Boolean.valueOf(false), new String[]{"goalacttable"});
            view.setVisible(Boolean.valueOf(false), new String[]{BTN_AUTO_MAPPING});
        }
    }

    private void onlyViewWhileNotCreateOrgOrPersonalized() {
        Long createOrgID = (Long)this.getModel().getValue("createorg_id");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isPersonalizedModify = customParams.getOrDefault("isPersonalizedModify", Boolean.FALSE);
        if (createOrgID.longValue() != this.getUseOrgId() && !isPersonalizedModify.booleanValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, ENTRY_OPTIONS);
        }
    }

    private long getUseOrgId() {
        IPageCache parentPageCache;
        String orgValue;
        IFormView parentView;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)parentPageId) && !Objects.isNull(parentView = this.getView().getViewNoPlugin(parentPageId)) && StringUtils.isNotBlank((CharSequence)(orgValue = (parentPageCache = parentView.getPageCache()).get("createOrg")))) {
            return Long.parseLong(orgValue);
        }
        logger.info("can not catch selected org at page cache for createOrg key.");
        return 0L;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_AUTO_MAPPING.equals(key)) {
            if (this.checkMappingData()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u91cd\u65b0\u5bf9\u7167\u5df2\u586b\u79d1\u76ee\uff1f", (String)"AccountMappingEditPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALL_BACK_AUTO_MAPPING));
            }
        } else if (BTN_ASSGREP_COMPARE.equals(key) && this.checkMappingData()) {
            this.showAssgrepCompare();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (key == null) {
            return;
        }
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        if (key.equals("srcacttable") || key.equals("goalacttable")) {
            Long useOrgId = this.getUseOrgId();
            List superiorOrgIds = BDUtil.getAllSuperiorOrgIds((Object)useOrgId, (boolean)true);
            qFilters.add(new QFilter("org", "in", (Object)superiorOrgIds));
            if (MappingTypeEnum.PRIMARY_SECONDARY.getValue().equals(this.getModel().getValue("mappingtype"))) {
                List<Long> oppositeTableIds;
                List<Long> list = oppositeTableIds = key.equals("srcacttable") ? this.getGoalActTableIdList() : Collections.singletonList((Long)this.getModel().getValue("srcacttable_id"));
                if (!oppositeTableIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "not in", oppositeTableIds));
                }
            }
        }
        if (key.equals("src_act") || key.startsWith("goal_act")) {
            List<AccountFieldInfo> actFieldList = this.getActFieldFromModel();
            Long actTableId = this.getActTableIdByFieldKey(actFieldList, key);
            if (actTableId == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed1\u5b9a\u79d1\u76ee\u8868\u3002", (String)"AccountMappingEditPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return;
            }
            qFilters.add(new QFilter("accounttable", "=", (Object)actTableId));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
            String mappingType = this.getModel().getValue("mappingtype").toString();
            if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
                boolean flag = false;
                if (key.startsWith("goal_act")) {
                    flag = true;
                }
                List<Long> accountTypeIds = this.getAccountTypeId(flag);
                qFilters.add(new QFilter("accounttype", "in", accountTypeIds));
            }
            Long useOrgId = this.getUseOrgId();
            Set ids = AccountUtils.queryAccountIds((long)useOrgId, (long)actTableId, null);
            QFilter acountDataFilter = AccountUtils.getAccountDataFilter((long)useOrgId, (long)actTableId);
            if (key.equals("src_act")) {
                DynamicObjectCollection showEntry = this.getModel().getEntryEntity("mappingshowentry");
                HashSet<Object> accountIds = new HashSet<Object>(showEntry.size());
                for (DynamicObject dyn : showEntry) {
                    DynamicObject srcAct = dyn.getDynamicObject("src_act");
                    if (srcAct == null) continue;
                    accountIds.add(srcAct.getPkValue());
                }
                ids.removeAll(accountIds);
                acountDataFilter = new QFilter("id", "in", (Object)ids);
            }
            qFilters.add(acountDataFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        String mappingType = model.getValue("mappingtype").toString();
        if ("srcacttable".equals(propName)) {
            DynamicObject srcActTable;
            if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType) && (srcActTable = (DynamicObject)this.getModel().getValue("srcacttable")) != null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                dynamicObjectCollection.add((Object)srcActTable);
                model.setValue("goalacttable", (Object)dynamicObjectCollection);
            }
            this.buildMappingEntry(mappingType);
            this.loadSrcAct(mappingType);
        } else if ("goalacttable".equals(propName)) {
            this.buildMappingEntry(mappingType);
            if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
                this.updateIsMappingAfterLoadData();
            }
        } else if ("src_act".equals(propName) || propName.startsWith("goal_act")) {
            if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
                this.updateIsMapping(rowIndex);
            }
        } else if ("mappingtype".equals(propName)) {
            model.setValue("goalacttable", null);
            model.setValue("srcacttable", null);
            IFormView view = this.getView();
            if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(e.getChangeSet()[0].getNewValue())) {
                view.setEnable(Boolean.valueOf(false), new String[]{"goalacttable"});
                view.setVisible(Boolean.valueOf(false), new String[]{BTN_AUTO_MAPPING});
            } else {
                view.setEnable(Boolean.valueOf(true), new String[]{"goalacttable"});
                view.setVisible(Boolean.valueOf(true), new String[]{BTN_AUTO_MAPPING});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            boolean fromDatabase;
            boolean isConfirm = ((Save)source).getOption().containsVariable(OPTION_IS_MODIFY_CONFIRM);
            if (!isConfirm && (fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase())) {
                String mappingType = this.getModel().getValue("mappingtype").toString();
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u53ef\u80fd\u5df2\u7ecf\u8fdb\u884c\u8fc7\u51ed\u8bc1\u534f\u540c\uff0c\u4fee\u6539\u4e4b\u540e\uff0c\u8bf7\u6ce8\u610f\u662f\u5426\u9700\u8981\u91cd\u65b0\u534f\u540c\u51ed\u8bc1\u3002", (String)"AccountMappingEditPlugin_20", (String)FibdApp.instance.formpluginModule(), (Object[])new Object[0]);
                if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
                    message = ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u5bf9\u7167\u5173\u7cfb\u5df2\u8fdb\u884c\u9884\u7b97\u5206\u5f55\u751f\u6210\uff0c\u4fee\u6539\u540e\u8bf7\u6ce8\u610f\u662f\u5426\u9700\u91cd\u65b0\u751f\u6210\u3002", (String)"AccountMappingEditPlugin_23", (String)FibdApp.instance.formpluginModule(), (Object[])new Object[0]);
                }
                this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_MODIFY, (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            args.setCancel(true);
            if (this.checkOrgAndNumber() && this.checkMappingData() && this.checkDuplicationData() && this.checkDataValidity()) {
                this.handleSaveAccountMapping(args);
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getParentView().invokeOperation("refresh");
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        DynamicObject copyFrom = BusinessDataServiceHelper.loadSingle((Object)param.getPkId(), (String)"bd_accountmapping");
        this.copyDynamicObjectData(copyFrom, this.getModel().getDataEntity(true));
        this.loadData();
        String mappingType = this.getModel().getValue("mappingtype").toString();
        if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            this.updateIsMappingAfterLoadData();
        }
        this.getModel().setValue("number", null);
        this.getModel().setValue("name", null);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CALL_BACK_AUTO_MAPPING.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getPageCache().put(CACHE_AUTO_MAPPING_ALL, FLAG_TRUE);
            } else {
                this.getPageCache().put(CACHE_AUTO_MAPPING_ALL, FLAG_FALSE);
            }
            this.actAutoMapping();
        } else if (CALLBACK_MODIFY.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPTION_IS_MODIFY_CONFIRM, FLAG_TRUE);
            this.getView().invokeOperation("save", operateOption);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Map srcActTable = (Map)sourceData.get("srcacttable");
        String srcActTableNumber = (String)srcActTable.get("number");
        Long createOrgId = (Long)this.getModel().getValue("createorg_id");
        List mappingInfoEntry = (List)sourceData.get("mappinginfoentry");
        for (Map mappingInfo : mappingInfoEntry) {
            Map srcAccount = (Map)mappingInfo.get("srcact");
            String srcActNumber = (String)srcAccount.remove("number");
            Long accountId = this.getAccountId(srcActTableNumber, createOrgId, srcActNumber);
            srcAccount.put("id", accountId);
        }
    }

    private Long getAccountId(String actTableNumber, Long orgId, String accountNumber) {
        DynamicObject accountTableDyn = BusinessDataServiceHelper.loadSingle((String)"bd_accounttable", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)actTableNumber)});
        long accountTableId = accountTableDyn.getLong("id");
        HashMap<String, Long> acct = new HashMap<String, Long>();
        try (DataSet ds = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id, number", null);){
            for (Row row : ds) {
                acct.put(row.getString("number"), row.getLong("id"));
            }
        }
        Long acctId = (Long)acct.get(accountNumber);
        if (acctId == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"AccountMappingEditPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), accountNumber));
        }
        return acctId;
    }

    private void buildMappingEntry(String mappingType) {
        DynamicObject srcActTable = (DynamicObject)this.getModel().getValue("srcacttable");
        DynamicObjectCollection goalActTables = (DynamicObjectCollection)this.getModel().getValue("goalacttable");
        ArrayList<AccountFieldInfo> accountFields = new ArrayList<AccountFieldInfo>();
        if (srcActTable != null) {
            AccountFieldInfo srcActField = new AccountFieldInfo();
            srcActField.setFieldKey("src_act");
            srcActField.setActTableId(srcActTable.getLong("id"));
            srcActField.setActTableName(new LocaleString(srcActTable.getString("name")));
            srcActField.setFieldName(this.getFieldName(new LocaleString(srcActTable.getString("name")), mappingType, "src_act"));
            accountFields.add(srcActField);
        }
        int cnt = 0;
        for (DynamicObject goalActTable : goalActTables) {
            AccountFieldInfo goalActField = new AccountFieldInfo();
            String fieldKey = "goal_act" + cnt++;
            goalActField.setFieldKey(fieldKey);
            DynamicObject accountTable = goalActTable.getDynamicObject("fbasedataid");
            goalActField.setActTableId(accountTable.getLong("id"));
            goalActField.setActTableName(new LocaleString(accountTable.getString("name")));
            goalActField.setFieldName(this.getFieldName(new LocaleString(accountTable.getString("name")), mappingType, "goal_act"));
            accountFields.add(goalActField);
        }
        this.saveActTableMapToModel(accountFields);
        this.rebuildDataEntity(accountFields, mappingType);
    }

    private void saveActTableMapToModel(List<AccountFieldInfo> actList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("acttbfieldmappingentry");
        for (AccountFieldInfo actField : actList) {
            int rowIndex = model.createNewEntryRow("acttbfieldmappingentry");
            model.setValue("acttb", (Object)actField.getActTableId(), rowIndex);
            model.setValue("fieldkey", (Object)actField.getFieldKey(), rowIndex);
        }
    }

    private void rebuildModelAndGrid(List<AccountFieldInfo> actList, MainEntityType mainEntityType, boolean rebuildGrid, String mappingType) {
        DynamicModifyViewAndModelUtil.rebuildEntityType(mainEntityType, "mappingshowentry", actList, this.getIsMappingField(mappingType));
        this.drawGrid(actList, rebuildGrid, mappingType);
        mainEntityType.createPropIndexsNoCache();
        this.getModel().updateCache();
    }

    private void drawGrid(List<AccountFieldInfo> actFieldList, boolean rebuildGrid, String mappingType) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        EntryAp entryAp4Act = DynamicModifyViewAndModelUtil.createDynamicEntryAp4Act("mappingshowentry", actFieldList);
        EntryAp entryAp4Text = DynamicModifyViewAndModelUtil.createDynamicEntryAp4Text("mappingshowentry", this.getIsMappingField(mappingType));
        entryAp4Act.getItems().addAll(entryAp4Text.getItems());
        List newColumns = (List)entryAp4Act.createControl().get("columns");
        cols.addAll(newColumns);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("mappingshowentry");
        List items = entryGrid.getItems();
        items.clear();
        List fieldEdits = ((Container)entryAp4Act.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            items.add(fieldEdit);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>(8);
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod("mappingshowentry", "createGridColumns", new Object[]{meta});
        }
    }

    private void rebuildDataEntity(List<AccountFieldInfo> actFieldList, String mappingType) {
        IDataModel model = this.getModel();
        DynamicObject oriEntity = model.getDataEntity(true);
        String dataStr = DynamicObjectSerializeUtil.serialize((DynamicObject)oriEntity, (DynamicObjectType)model.getDataEntityType());
        this.getPageCache().put(CACHE_ORIGINAL_ENTITY, dataStr);
        this.rebuildModelAndGrid(actFieldList, this.getModel().getDataEntityType(), true, mappingType);
        model.beginInit();
        model.createNewData((Object)new DynamicObject((DynamicObjectType)model.getDataEntityType()));
        model.endInit();
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>(8);
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"AccountMappingEditPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", false);
        return col;
    }

    private List<FieldInfo> getIsMappingField(String mappingType) {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            return fieldInfoList;
        }
        FieldInfo field = new FieldInfo();
        field.setFieldKey("ismapping");
        field.setFieldName(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5168\u5bf9\u7167", (String)"AccountMappingEditPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0])));
        fieldInfoList.add(field);
        return fieldInfoList;
    }

    private void copyDynamicObjectData(DynamicObject from, DynamicObject to) {
        DataEntityPropertyCollection propColl = to.getDataEntityType().getProperties();
        for (IDataEntityProperty prop : propColl) {
            String propName = prop.getName();
            if ("mappingshowentry".equals(propName)) continue;
            if (prop instanceof DynamicCollectionProperty) {
                DynamicObjectCollection fromColl = from.getDynamicObjectCollection(propName);
                DynamicObjectCollection toColl = to.getDynamicObjectCollection(propName);
                toColl.clear();
                for (DynamicObject fromRow : fromColl) {
                    DynamicObject toRow = toColl.addNew();
                    this.copyDynamicObjectData(fromRow, toRow);
                }
                continue;
            }
            to.set(propName, from.get(propName));
        }
    }

    private List<AccountFieldInfo> getActFieldFromModel() {
        ArrayList<AccountFieldInfo> actFieldList = new ArrayList<AccountFieldInfo>();
        DynamicObjectCollection actTbFieldMapping = this.getModel().getEntryEntity("acttbfieldmappingentry");
        for (DynamicObject dyn : actTbFieldMapping) {
            AccountFieldInfo accountField = new AccountFieldInfo();
            DynamicObject accountTable = dyn.getDynamicObject("acttb");
            if (accountTable != null) {
                long accountTableId = accountTable.getLong("id");
                String accountTableName = accountTable.getString("name");
                accountField.setActTableId(accountTableId);
                accountField.setActTableName(new LocaleString(accountTableName));
                accountField.setFieldName(new LocaleString(accountTableName));
            }
            accountField.setFieldKey(dyn.getString("fieldkey"));
            actFieldList.add(accountField);
        }
        return actFieldList;
    }

    private Set<String> getActTableFieldKeyFromModel() {
        HashSet<String> fieldKeySet = new HashSet<String>();
        DynamicObjectCollection actMapData = this.getModel().getEntryEntity("acttbfieldmappingentry");
        for (DynamicObject map : actMapData) {
            fieldKeySet.add(map.getString("fieldkey"));
        }
        return fieldKeySet;
    }

    private Map<Long, String> getActTableFieldMapFromModel() {
        DynamicObjectCollection actMapData = this.getModel().getEntryEntity("acttbfieldmappingentry");
        HashMap<Long, String> actFieldMap = new HashMap<Long, String>(8);
        for (DynamicObject map : actMapData) {
            DynamicObject actTb = map.getDynamicObject("acttb");
            if (actTb == null) continue;
            actFieldMap.put(actTb.getLong("id"), map.getString("fieldkey"));
        }
        return actFieldMap;
    }

    private Long getActTableIdByFieldKey(List<AccountFieldInfo> actFieldList, String fieldKey) {
        for (AccountFieldInfo field : actFieldList) {
            String key = field.getFieldKey();
            if (key == null || !key.equals(fieldKey)) continue;
            return field.getActTableId();
        }
        return null;
    }

    private boolean checkOrgAndNumber() {
        Long createOrgId = (Long)this.getModel().getValue("createorg_id");
        if (createOrgId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMappingEditPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        String number = (String)this.getModel().getValue("number");
        if (kd.bos.util.StringUtils.isBlank((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMappingEditPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter createOrgFilter = new QFilter("createorg", "=", (Object)createOrgId);
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        QFilter idFilter = new QFilter("id", "!=", pkValue);
        boolean exists = QueryServiceHelper.exists((String)"bd_accountmapping", (QFilter[])new QFilter[]{createOrgFilter, numberFilter, idFilter});
        if (exists) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u201c\u7f16\u7801\u201d\u3001\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u5747\u5df2\u5b58\u5728\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"AccountMappingEditPlugin_7", (String)"fi-bd-formplugin", (Object[])new Object[0]), number));
        }
        return !exists;
    }

    private boolean checkMappingData() {
        DynamicObject srcActTable = (DynamicObject)this.getModel().getValue("srcacttable");
        if (srcActTable == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u79d1\u76ee\u8868\u3002", (String)"AccountMappingEditPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection goalActTables = (DynamicObjectCollection)this.getModel().getValue("goalacttable");
        if (goalActTables.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u79d1\u76ee\u8868\u3002", (String)"AccountMappingEditPlugin_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject saveData = this.getModel().getDataEntity(true);
        DynamicObjectCollection showEntry = saveData.getDynamicObjectCollection("mappingshowentry");
        HashMap<Long, Integer> srcActMap = new HashMap<Long, Integer>(8);
        for (DynamicObject showRow : showEntry) {
            int rowIndex = showRow.getInt("seq");
            DynamicObject showSrcAct = showRow.getDynamicObject("src_act");
            if (showSrcAct == null) {
                String actTbName = saveData.getDynamicObject("srcacttable").getLocaleString("name").getLocaleValue();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bf9\u7167\u4fe1\u606f\u4e2d\u6e90\u79d1\u76ee\u8868\u3010%1$s\u3011\u7b2c\u3010%2$d\u3011\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountMappingEditPlugin_10", (String)"fi-bd-formplugin", (Object[])new Object[0]), actTbName, rowIndex), Integer.valueOf(5000));
                return false;
            }
            boolean exist = srcActMap.containsKey(showSrcAct.getLong("id"));
            if (exist) {
                String srcActName = showSrcAct.getString("name");
                String srcActNumber = showSrcAct.getString("number");
                int preRowIndex = (Integer)srcActMap.get(showSrcAct.getLong("id"));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bf9\u7167\u4fe1\u606f\u4e2d\u6e90\u79d1\u76ee\u3010%1$s\u3011\u7b2c\u3010%2$d\u3011\u884c\u548c\u7b2c\u3010%3$d\u3011\u884c\u91cd\u590d\u3002", (String)"AccountMappingEditPlugin_11", (String)"fi-bd-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", srcActNumber, srcActName), preRowIndex, rowIndex), Integer.valueOf(5000));
                return false;
            }
            srcActMap.put(showSrcAct.getLong("id"), rowIndex);
        }
        return true;
    }

    private boolean checkDuplicationData() {
        DynamicObject saveData = this.getModel().getDataEntity(true);
        DynamicObject srcActTable = saveData.getDynamicObject("srcacttable");
        DynamicObjectCollection goalActTables = saveData.getDynamicObjectCollection("goalacttable");
        Object id = saveData.getPkValue();
        long createOrgId = saveData.getLong("createorg_id");
        QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountmapping", (Long)createOrgId);
        QFilter idFilter = new QFilter("id", "!=", id);
        QFilter srcActTableFilter = new QFilter("srcacttable", "=", srcActTable.getPkValue());
        String mappingType = saveData.getString("mappingtype");
        QFilter mappingTypeFilter = new QFilter("mappingtype", "=", (Object)mappingType);
        DynamicObject[] sameSrcActTableData = BusinessDataServiceHelper.load((String)"bd_accountmapping", (String)"goalacttable", (QFilter[])new QFilter[]{idFilter, baseFilter, srcActTableFilter, mappingTypeFilter});
        if (sameSrcActTableData.length > 0) {
            ArrayList<Long> goalActTableIdList = new ArrayList<Long>(goalActTables.size());
            for (DynamicObject dyn : goalActTables) {
                goalActTableIdList.add(dyn.getLong("fbasedataid_id"));
            }
            for (DynamicObject data : sameSrcActTableData) {
                DynamicObjectCollection actTableList = data.getDynamicObjectCollection("goalacttable");
                ArrayList<Long> actTableIdList = new ArrayList<Long>(actTableList.size());
                for (DynamicObject dyn : actTableList) {
                    actTableIdList.add(dyn.getLong("fbasedataid_id"));
                }
                ArrayList<Long> tempList = new ArrayList<Long>(goalActTableIdList.size());
                tempList.addAll(goalActTableIdList);
                tempList.retainAll(actTableIdList);
                if (tempList.isEmpty()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5bf9\u7167\u5173\u7cfb\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002", (String)"AccountMappingEditPlugin_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkDataValidity() {
        DynamicObject saveData = this.getModel().getDataEntity(true);
        String mappingType = saveData.getString("mappingtype");
        DynamicObjectCollection entryShow = saveData.getDynamicObjectCollection("mappingshowentry");
        for (DynamicObject row : entryShow) {
            int seq = row.getInt("seq");
            DynamicObject showSrcAct = row.getDynamicObject("src_act");
            String showSrcActName = showSrcAct.getString("name");
            String showSrcActNumber = showSrcAct.getString("number");
            DynamicObject srcActTypeDyn = showSrcAct.getDynamicObject("accounttype");
            String srcActType = srcActTypeDyn.getString("accounttype");
            boolean srcIsCashType = showSrcAct.getBoolean("iscash") || showSrcAct.getBoolean("isbank") || showSrcAct.getBoolean("iscashequivalent");
            boolean srcIsBw = showSrcAct.getBoolean("bw");
            boolean srcPLAccount = "0".equals(showSrcAct.getString("pltype"));
            boolean srcActIsLeaf = showSrcAct.getBoolean("isleaf");
            if (!srcActIsLeaf) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\uff1a\u6e90\u79d1\u76ee\u3010%2$s\u3011\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u3002", (String)"AccountMappingEditPlugin_13", (String)"fi-bd-formplugin", (Object[])new Object[0]), seq, String.join((CharSequence)",", showSrcActNumber, showSrcActName)));
                return false;
            }
            Set<String> fieldKeySet = this.getActTableFieldKeyFromModel();
            for (String fieldKey : fieldKeySet) {
                boolean goalIsCashType;
                DynamicObject showGoalAct;
                if ("src_act".equals(fieldKey) || (showGoalAct = row.getDynamicObject(fieldKey)) == null) continue;
                boolean bl = goalIsCashType = showGoalAct.getBoolean("iscash") || showGoalAct.getBoolean("isbank") || showGoalAct.getBoolean("iscashequivalent");
                if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType) && srcIsCashType != goalIsCashType) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u975e\u73b0\u91d1\u7c7b\u79d1\u76ee\u4e0d\u80fd\u5bf9\u5e94\u73b0\u91d1\u7c7b\u79d1\u76ee\u3002", (String)"AccountMappingEditPlugin_15", (String)"fi-bd-formplugin", (Object[])new Object[0]), seq));
                    return false;
                }
                boolean goalPLAccount = "0".equals(showGoalAct.getString("pltype"));
                if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType) && srcPLAccount != goalPLAccount) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u635f\u76ca\u7c7b\u79d1\u76ee\u4e0d\u80fd\u5bf9\u5e94\u975e\u635f\u76ca\u7c7b\u79d1\u76ee\u3002", (String)"AccountMappingEditPlugin_24", (String)"fi-bd-formplugin", (Object[])new Object[0]), seq));
                    return false;
                }
                boolean goalIsBw = showGoalAct.getBoolean("bw");
                if (!MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType) && srcIsBw != goalIsBw) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u8868\u5185\u79d1\u76ee\u4e0d\u80fd\u5bf9\u5e94\u8868\u5916\u79d1\u76ee\u3002", (String)"AccountMappingEditPlugin_14", (String)"fi-bd-formplugin", (Object[])new Object[0]), seq, String.join((CharSequence)",", showSrcActNumber)));
                    return false;
                }
                boolean goalActIsLeaf = showGoalAct.getBoolean("isleaf");
                if (goalActIsLeaf) continue;
                String goalActName = showGoalAct.getString("name");
                String goalActNumber = showGoalAct.getString("number");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\uff1a\u76ee\u6807\u79d1\u76ee\u3010%2$s\u3011\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u3002", (String)"AccountMappingEditPlugin_16", (String)"fi-bd-formplugin", (Object[])new Object[0]), seq, String.join((CharSequence)",", goalActNumber, goalActName)));
                return false;
            }
        }
        return true;
    }

    private void handleSaveAccountMapping(BeforeDoOperationEventArgs args) {
        BaseShowParameter baseParam = (BaseShowParameter)this.getView().getFormShowParameter();
        String formId = baseParam.getFormId();
        DynamicObject saveData = this.getModel().getDataEntity(true);
        DynamicObjectCollection showEntry = saveData.getDynamicObjectCollection("mappingshowentry");
        DynamicObjectCollection saveEntry = saveData.getDynamicObjectCollection("mappinginfoentry");
        saveEntry.clear();
        Set<String> actTableField = this.getActTableFieldKeyFromModel();
        int seq = 0;
        for (DynamicObject showRow : showEntry) {
            DynamicObject showSrcAct = showRow.getDynamicObject("src_act");
            int rowIndex = showRow.getInt("seq");
            boolean existMapping = false;
            for (String fieldKey : actTableField) {
                DynamicObject showGoalAct;
                if ("src_act".equals(fieldKey) || (showGoalAct = showRow.getDynamicObject(fieldKey)) == null) continue;
                DynamicObject saveRow = saveEntry.addNew();
                saveRow.set("seq", (Object)seq++);
                saveRow.set("srcact", (Object)showSrcAct);
                saveRow.set("srcact_id", (Object)showSrcAct.getLong("id"));
                saveRow.set("goalact", (Object)showGoalAct);
                saveRow.set("goalact_id", (Object)showGoalAct.getLong("id"));
                saveRow.set("rowindex", (Object)rowIndex);
                existMapping = true;
            }
            if (existMapping) continue;
            DynamicObject saveRow = saveEntry.addNew();
            saveRow.set("seq", (Object)seq++);
            saveRow.set("srcact", (Object)showSrcAct);
            saveRow.set("srcact_id", (Object)showSrcAct.getLong("id"));
            saveRow.set("rowindex", (Object)rowIndex);
        }
        long pkId = saveData.getLong("id");
        DynamicObject originData = pkId == 0L ? BusinessDataServiceHelper.newDynamicObject((String)formId) : BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
        this.copyDynamicObjectData(saveData, originData);
        Save save = (Save)args.getSource();
        OperateOption option = save.getOption();
        option = option == null ? OperateOption.create() : option;
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)formId, (DynamicObject[])new DynamicObject[]{originData}, (OperateOption)option);
        if (!result.isSuccess()) {
            if (result.isShowMessage()) {
                this.getView().showOperationResult(result);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AccountMappingEditPlugin_17", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            List pkIdList = result.getSuccessPkIds();
            this.getModel().setValue("id", pkIdList.get(0));
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().updateView("mappinginfoentry");
        }
    }

    private void loadData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Set<String> actFieldKeySet = this.getActTableFieldKeyFromModel();
        Map<Long, String> actFieldMap = this.getActTableFieldMapFromModel();
        int maxIndex = -1;
        DynamicObjectCollection saveEntity = model.getEntryEntity("mappinginfoentry");
        for (DynamicObject saveRow : saveEntity) {
            int rowIndex = saveRow.getInt("rowindex");
            if (rowIndex <= maxIndex) continue;
            maxIndex = rowIndex;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int fieldColIndex = 0;
        HashMap<String, Integer> fieldKeyMap = new HashMap<String, Integer>(16);
        for (String actFieldKey : actFieldKeySet) {
            vs.addField(actFieldKey, new Object[0]);
            fieldKeyMap.put(actFieldKey, fieldColIndex++);
        }
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (DynamicObject saveRow : saveEntity) {
            String goalActKey;
            DynamicObject goalAct;
            int rowIndex = saveRow.getInt("rowindex");
            Object[] rowVal = new Object[actFieldKeySet.size()];
            DynamicObject srcAct = saveRow.getDynamicObject("srcact");
            if (srcAct != null) {
                long srcActId = srcAct.getLong("id");
                rowVal[((Integer)fieldKeyMap.get((Object)"src_act")).intValue()] = srcActId;
            }
            if ((goalAct = saveRow.getDynamicObject("goalact")) != null) {
                goalActKey = actFieldMap.get(goalAct.getLong("accounttable_id"));
                long goalActId = goalAct.getLong("id");
                rowVal[((Integer)fieldKeyMap.get((Object)goalActKey)).intValue()] = goalActId;
            }
            if (indexSet.contains(rowIndex) && goalAct != null) {
                goalActKey = actFieldMap.get(goalAct.getLong("accounttable_id"));
                vs.set(goalActKey, (Object)goalAct.getLong("id"), rowIndex - 1);
                continue;
            }
            vs.addRow(rowVal);
            indexSet.add(rowIndex);
        }
        model.batchCreateNewEntryRow("mappingshowentry", vs);
        model.endInit();
    }

    private void actAutoMapping() {
        DynamicObjectCollection showEntry = this.getModel().getEntryEntity("mappingshowentry");
        List<AccountFieldInfo> actFieldList = this.getActFieldFromModel();
        String isMappingAll = this.getPageCache().get(CACHE_AUTO_MAPPING_ALL);
        for (DynamicObject showRow : showEntry) {
            DynamicObject showSrcAct = showRow.getDynamicObject("src_act");
            if (showSrcAct == null) continue;
            String srcActNumber = showSrcAct.getString("number");
            Long createOrgId = (Long)this.getModel().getValue("createorg_id");
            for (AccountFieldInfo actField : actFieldList) {
                QFilter baseDataFilter;
                QFilter enddateFilter;
                QFilter isLeafFilter;
                QFilter enableFilter;
                QFilter actNumberFilter;
                String fieldKey = actField.getFieldKey();
                if ("src_act".equals(fieldKey)) continue;
                DynamicObject goalAct = showRow.getDynamicObject(fieldKey);
                if (FLAG_FALSE.equals(isMappingAll) && goalAct != null) continue;
                Long goalActTableId = this.getActTableIdByFieldKey(actFieldList, fieldKey);
                QFilter actTableFilter = new QFilter("accounttable", "=", (Object)goalActTableId);
                boolean exists = QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{actTableFilter, actNumberFilter = new QFilter("number", "=", (Object)srcActNumber), enableFilter = new QFilter("enable", "=", (Object)"1"), isLeafFilter = new QFilter("isleaf", "=", (Object)"1"), enddateFilter = new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()), baseDataFilter = AccountUtils.getAccountDataFilter((long)createOrgId, (long)goalActTableId)});
                if (!exists) continue;
                goalAct = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{actTableFilter, actNumberFilter, enableFilter, isLeafFilter, enddateFilter, baseDataFilter});
                long goalActId = goalAct.getLong("id");
                int seq = showRow.getInt("seq");
                this.getModel().setValue(fieldKey, (Object)goalActId, seq - 1);
            }
        }
    }

    private void updateIsMappingAfterLoadData() {
        DynamicObjectCollection showEntry = this.getModel().getEntryEntity("mappingshowentry");
        for (int i = 0; i < showEntry.size(); ++i) {
            this.updateIsMapping(i);
        }
    }

    private void updateIsMapping(int rowIndex) {
        Object srcActTable = this.getModel().getValue("srcacttable");
        if (srcActTable == null) {
            this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u5426", (String)"AccountMappingEditPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
            return;
        }
        DynamicObject srcAct = (DynamicObject)this.getModel().getValue("src_act", rowIndex);
        if (srcAct == null) {
            this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u5426", (String)"AccountMappingEditPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
            return;
        }
        String srcActNumber = srcAct.getString("number");
        EntryGrid showEntry = (EntryGrid)this.getView().getControl("mappingshowentry");
        List items = showEntry.getItems();
        boolean hasGoalAct = false;
        for (Control item : items) {
            String fieldKey = item.getKey();
            if (fieldKey == null || !fieldKey.startsWith("goal_act")) continue;
            hasGoalAct = true;
            DynamicObject goalAct = (DynamicObject)this.getModel().getValue(fieldKey, rowIndex);
            if (goalAct == null) {
                this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u5426", (String)"AccountMappingEditPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
                return;
            }
            String goalActNumber = goalAct.getString("number");
            if (goalActNumber.equals(srcActNumber)) continue;
            this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u5426", (String)"AccountMappingEditPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
            return;
        }
        if (hasGoalAct) {
            this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u662f", (String)"AccountMappingEditPlugin_19", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
        } else {
            this.getModel().setValue("ismapping", (Object)ResManager.loadKDString((String)"\u5426", (String)"AccountMappingEditPlugin_18", (String)"fi-bd-formplugin", (Object[])new Object[0]), rowIndex);
        }
    }

    private void loadSrcAct(String mappingType) {
        this.getModel().deleteEntryData("mappingshowentry");
        DynamicObject srcActTable = (DynamicObject)this.getModel().getValue("srcacttable");
        if (srcActTable == null) {
            return;
        }
        ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(10);
        otherFilters.add(new QFilter("enable", "=", (Object)"1"));
        otherFilters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            List<Long> accountTypeIds = this.getAccountTypeId(false);
            otherFilters.add(new QFilter("accounttype", "in", accountTypeIds));
        }
        otherFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        DataSet dataSet = AccountUtils.queryAccountDataSet((long)((Long)this.getModel().getValue("createorg_id")), (long)((Long)srcActTable.getPkValue()), (String)"id,number", otherFilters, (String)"number");
        ArrayList<Long> accountIds = new ArrayList<Long>(10);
        for (Row row : dataSet) {
            accountIds.add(row.getLong("id"));
        }
        if (Objects.isNull(accountIds) || accountIds.isEmpty()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("mappingshowentry");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("src_act", new Object[0]);
        for (Long accountId : accountIds) {
            vs.addRow(new Object[]{accountId});
        }
        model.batchCreateNewEntryRow("mappingshowentry", vs);
        model.endInit();
        this.getView().updateView();
    }

    private void showAssgrepCompare() {
        String formId = "bd_assgrepcompare";
        FormShowParameter param = new FormShowParameter();
        param.setFormId(formId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject srcActTable = (DynamicObject)this.getModel().getValue("srcacttable");
        param.setCustomParam("srcActTableId", (Object)srcActTable.getLong("id"));
        param.setCustomParam("goalActTableId", this.getGoalActTableIdList());
        param.setCustomParam("orgId", (Object)this.getModel().getValue("createorg_id").toString());
        param.setCustomParam("assgrepCompareInfo", this.buildAssgrepCompareInfo());
        param.setCustomParam("mappingType", (Object)this.getModel().getValue("mappingtype").toString());
        this.getView().showForm(param);
    }

    private List<AssgrepCompareInfo> buildAssgrepCompareInfo() {
        ArrayList<AssgrepCompareInfo> compareInfoList = new ArrayList<AssgrepCompareInfo>();
        DynamicObjectCollection showEntry = this.getModel().getEntryEntity("mappingshowentry");
        Set<String> fieldKeySet = this.getActTableFieldKeyFromModel();
        for (DynamicObject showRow : showEntry) {
            int seq = showRow.getInt("seq");
            if (this.compareAssgrep(seq - 1)) continue;
            DynamicObject srcAct = showRow.getDynamicObject("src_act");
            long srcActTableId = srcAct.getLong("accounttable_id");
            long srcActId = srcAct.getLong("id");
            List<Long> srcAssgrepIdList = this.getAssgrepIdList(srcAct);
            int emptyGoalAct = 0;
            for (String fieldKey : fieldKeySet) {
                if ("src_act".equals(fieldKey)) continue;
                DynamicObject goalAct = showRow.getDynamicObject(fieldKey);
                if (goalAct == null) {
                    ++emptyGoalAct;
                    continue;
                }
                long goalActTableId = goalAct.getLong("accounttable_id");
                long goalActId = goalAct.getLong("id");
                List<Long> goalAssgrepIdList = this.getAssgrepIdList(goalAct);
                AssgrepCompareInfo compareInfo = new AssgrepCompareInfo(srcActTableId, srcActId, srcAssgrepIdList, goalActTableId, goalActId, goalAssgrepIdList, seq);
                compareInfoList.add(compareInfo);
            }
            if (this.getGoalActTableIdList().size() != emptyGoalAct) continue;
            AssgrepCompareInfo compareInfo = new AssgrepCompareInfo(srcActTableId, srcActId, srcAssgrepIdList, null, null, null, seq);
            compareInfoList.add(compareInfo);
        }
        return compareInfoList;
    }

    private boolean compareAssgrep(int rowIndex) {
        DynamicObject srcAct = (DynamicObject)this.getModel().getValue("src_act", rowIndex);
        DynamicObjectCollection srcCheckItemEntry = srcAct.getDynamicObjectCollection("checkitementry");
        HashSet<Long> srcAssgrepIdSet = new HashSet<Long>();
        for (DynamicObject item : srcCheckItemEntry) {
            DynamicObject assgrep = item.getDynamicObject("asstactitem");
            if (assgrep == null) continue;
            srcAssgrepIdSet.add(assgrep.getLong("id"));
        }
        Set<String> fieldKeySet = this.getActTableFieldKeyFromModel();
        for (String fieldKey : fieldKeySet) {
            if ("src_act".equals(fieldKey) || "ismapping".equals(fieldKey)) continue;
            DynamicObject goalAct = (DynamicObject)this.getModel().getValue(fieldKey, rowIndex);
            if (goalAct == null) {
                return false;
            }
            DynamicObjectCollection goalCheckItemEntry = goalAct.getDynamicObjectCollection("checkitementry");
            if (goalCheckItemEntry.isEmpty() && !srcAssgrepIdSet.isEmpty()) {
                return false;
            }
            for (DynamicObject item : goalCheckItemEntry) {
                DynamicObject assgrep = item.getDynamicObject("asstactitem");
                long assgrepId = assgrep.getLong("id");
                if (srcAssgrepIdSet.contains(assgrepId)) continue;
                return false;
            }
        }
        return true;
    }

    private List<Long> getAssgrepIdList(DynamicObject account) {
        DynamicObjectCollection checkItemEntry = account.getDynamicObjectCollection("checkitementry");
        ArrayList<Long> assgrepIdList = new ArrayList<Long>();
        for (DynamicObject item : checkItemEntry) {
            DynamicObject assgrep = item.getDynamicObject("asstactitem");
            if (assgrep == null) continue;
            long assgrepId = assgrep.getLong("id");
            assgrepIdList.add(assgrepId);
        }
        return assgrepIdList;
    }

    private List<Long> getGoalActTableIdList() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObjectCollection goalActTables = (DynamicObjectCollection)this.getModel().getValue("goalacttable");
        for (DynamicObject goalActTable : goalActTables) {
            DynamicObject accountTable = goalActTable.getDynamicObject("fbasedataid");
            long id = accountTable.getLong("id");
            idList.add(id);
        }
        return idList;
    }

    private List<Long> getAccountTypeId(boolean flag) {
        ArrayList<Long> idList = new ArrayList<Long>(16);
        QFilter qFilter = flag ? new QFilter("accounttype", "in", (Object)BUDGET_ARRAY) : new QFilter("accounttype", "not in", (Object)BUDGET_ARRAY);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttype", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                idList.add(row.getLong("id"));
            }
        }
        return idList;
    }

    private LocaleString getFieldName(LocaleString name, String mappingType, String acctType) {
        if (MappingTypeEnum.BUDGET_ACCOUNTING.getValue().equals(mappingType)) {
            if ("src_act".equals(acctType)) {
                return new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee", (String)"AccountMappingEditPlugin_21", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
            return new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee", (String)"AccountMappingEditPlugin_22", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
        return name;
    }
}

