/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.PermissonType;

public class CashflowConfigPlugin
extends AbstractFormPlugin {
    private List<Long> periodType = new ArrayList<Long>(1);
    private DBRoute fi = DBRoute.of((String)"fi");
    private Map<Long, Date> errorMsg = new HashMap<Long, Date>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        int index = this.getModel().getEntryCurrentRowIndex("entry");
        long org = (Long)this.getModel().getValue("org_id", index);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"curperiod.begindate curdate, cashinitperiod.begindate initdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org)}, null);
        dataSet = dataSet.select(new String[]{"curdate", "case initdate when null then curdate else initdate end initdate"}).groupBy().min("curdate").min("initdate").finish();
        if (!dataSet.isEmpty()) {
            Date initdate;
            Row next = dataSet.next();
            Date curdate = next.getDate("curdate");
            Date minDate = curdate.before(initdate = next.getDate("initdate")) ? curdate : initdate;
            DateEdit dateEdit = (DateEdit)this.getControl("localsetdate");
            dateEdit.setMinDate(minDate);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List pkSet = BDUtil.getAcctOrgPkList((String)"gl_accountbook", (PermissonType)PermissonType.NEW);
        try (DataSet ds = BatchProcessUtil.batchQueryDataSet((Collection)pkSet, batchData -> QueryServiceHelper.queryDataSet((String)"CashflowConfigPlugin", (String)"gl_accountbook", (String)"org,localset,localsetdate,cashinitperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData)}, (String)"org"));){
            IDataModel m = this.getModel();
            m.beginInit();
            DynamicObjectCollection col = m.getEntryEntity("entry");
            m.deleteEntryData("entry");
            col.clear();
            long org = 0L;
            DataSet dataSet = ds.filter("cashinitperiod <> 0");
            for (Row row : dataSet) {
                if (org != 0L && row.getLong("org") == org) continue;
                org = row.getLong("org");
                int i = m.createNewEntryRow("entry");
                m.setValue("org", (Object)row.getLong("org"), i);
                m.setValue("localset", (Object)row.getBoolean("localset"), i);
                m.setValue("localsetdate", (Object)row.getDate("localsetdate"), i);
            }
            m.endInit();
            this.getView().updateView("entry");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(key)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entry = (DynamicObjectCollection)model.getValue("entry");
            HashMap<Long, DynamicObject> org2Row = new HashMap<Long, DynamicObject>(entry.size());
            for (DynamicObject row : entry) {
                org2Row.put(row.getLong("org_id"), row);
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashflowConfigPlugin", (String)"gl_accountbook", (String)"org,localset,localsetdate", (QFilter[])new QFilter[]{new QFilter("org", "in", org2Row.keySet())}, (String)"org");){
                HashMap<Long, Tuple2<Date, Date>> pendingData = new HashMap<Long, Tuple2<Date, Date>>(8);
                HashMap<Long, String> firstCheckErrorMsg = new HashMap<Long, String>(16);
                HashMap<Long, String> orgId2Name = new HashMap<Long, String>(org2Row.size());
                for (Row rowDB : ds) {
                    long org = rowDB.getLong("org");
                    DynamicObject rowDyn = (DynamicObject)org2Row.get(org);
                    DynamicObject orgDyn = rowDyn.getDynamicObject("org");
                    orgId2Name.put(org, orgDyn.getString("name"));
                    boolean curLocalSet = rowDyn.getBoolean("localset");
                    Date curLocalSetDate = rowDyn.getDate("localsetdate");
                    boolean dbLocalSet = rowDB.getBoolean("localset");
                    Date dbLocalSetDate = rowDB.getDate("localsetdate");
                    if (curLocalSet && dbLocalSet) {
                        if (dbLocalSetDate.getTime() == curLocalSetDate.getTime()) continue;
                        Date checkDate = dbLocalSetDate.getTime() < curLocalSetDate.getTime() ? dbLocalSetDate : curLocalSetDate;
                        pendingData.put(org, (Tuple2<Date, Date>)new Tuple2((Object)checkDate, (Object)curLocalSetDate));
                        continue;
                    }
                    if (curLocalSet && !dbLocalSet) {
                        pendingData.put(org, (Tuple2<Date, Date>)new Tuple2((Object)curLocalSetDate, (Object)curLocalSetDate));
                        continue;
                    }
                    if (curLocalSet || !dbLocalSet) continue;
                    firstCheckErrorMsg.put(org, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7531\u672c\u65b9\u6307\u5b9a\u6539\u4e3a\u5bf9\u65b9\u6307\u5b9a\u3002", (String)"CashflowConfigPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
                int successCount = 0;
                if (!pendingData.isEmpty()) {
                    successCount = this.dealChange(pendingData);
                }
                int errorCount = this.errorMsg.size() + firstCheckErrorMsg.size();
                int allCount = errorCount + successCount;
                if (errorCount == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"CashflowConfigPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                } else if (allCount > 1) {
                    MessageBoxOptions options = MessageBoxOptions.OK;
                    ConfirmTypes confirmTypes = ConfirmTypes.Save;
                    String successMsg = String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s\u4e2a\u7ec4\u7ec7\uff0c\u5931\u8d25%2$s\u4e2a\u7ec4\u7ec7\u3002", (String)"CashflowConfigPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]), successCount, errorCount);
                    this.getView().showConfirm(successMsg, this.buildErrorMsg(firstCheckErrorMsg, orgId2Name), options, confirmTypes, null, null);
                } else {
                    this.getView().showErrorNotification(this.buildErrorMsg(firstCheckErrorMsg, orgId2Name));
                }
            }
        }
    }

    private String buildErrorMsg(Map<Long, String> errorMap, Map<Long, String> orgId2Name) {
        StringBuilder sb = new StringBuilder(16);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry<Long, String> entry : errorMap.entrySet()) {
            sb.append(orgId2Name.get(entry.getKey()));
            sb.append("\uff1a");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        for (Map.Entry<Long, Object> entry : this.errorMsg.entrySet()) {
            sb.append(orgId2Name.get(entry.getKey()));
            sb.append("\uff1a");
            sb.append(format.format((Date)entry.getValue()));
            sb.append(ResManager.loadKDString((String)"\u8bbe\u7f6e\u65e5\u671f\u4e4b\u540e\u5b58\u5728\u73b0\u91d1\u6d41\u91cf\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u66f4\u6539\u6307\u5b9a\u72b6\u6001\u3002", (String)"CashflowConfigPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    private int dealChange(Map<Long, Tuple2<Date, Date>> pendingData) {
        int successCount = 0;
        this.initPeriodType(pendingData.keySet());
        String sql = "update t_bd_accountbooks set flocalset= ? , flocalsetdate= ? where forgid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(8);
        for (Map.Entry<Long, Tuple2<Date, Date>> pendindEntry : pendingData.entrySet()) {
            Tuple2<Date, Date> pendingDate = pendindEntry.getValue();
            long org = pendindEntry.getKey();
            if (!this.bizHappend((Date)pendingDate.t1, org)) {
                params.add(new Object[]{true, pendingDate.t2, org});
                ++successCount;
                continue;
            }
            this.errorMsg.put(org, (Date)pendingDate.t1);
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, params);
            BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"));
        }
        return successCount;
    }

    private void initPeriodType(Set<Long> orgs) {
        SqlBuilder sb = new SqlBuilder();
        sb.appendIn("select fperiodtypeid from t_bd_accountbooks where forgid ", orgs.toArray());
        sb.append(" group by fperiodtypeid", new Object[0]);
        this.periodType = (List)DB.query((DBRoute)this.fi, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet resultSet) throws Exception {
                ArrayList<Long> bookTypes = new ArrayList<Long>(1);
                while (resultSet.next()) {
                    bookTypes.add(resultSet.getLong(1));
                }
                return bookTypes;
            }
        });
    }

    private boolean bizHappend(Date curLocalSetDate, long orgId) {
        List<Long> periodIds = this.getAllAfterPeriod(curLocalSetDate);
        SqlBuilder vouSql = new SqlBuilder();
        vouSql.append("select top 1 v.fid from t_gl_voucher v inner join t_gl_voucherentry ve on v.fid = ve.fid where v.forgid = ? ", new Object[]{orgId});
        vouSql.appendIn(" and v.fperiodid ", periodIds.toArray());
        vouSql.append(" and v.fbookeddate >= ? ", new Object[]{curLocalSetDate});
        vouSql.append(" and ve.forgid = ? ", new Object[]{orgId});
        vouSql.appendIn(" and ve.fperiodid ", periodIds.toArray());
        vouSql.append("and (ve.fmaincfitemid > 0 or ve.fsuppcfitemid >0)", new Object[0]);
        boolean hasBiz = (Boolean)DB.query((DBRoute)this.fi, (SqlBuilder)vouSql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                return resultSet.next();
            }
        });
        if (!hasBiz) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashflowConfigPlugin", (String)"gl_accountbook", (String)"cashinitperiod,bookstype", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)}, null);){
                ArrayList<Long> bookTypes = new ArrayList<Long>(2);
                for (Row row : ds) {
                    if (!periodIds.contains(row.getLong("cashinitperiod"))) continue;
                    bookTypes.add(row.getLong("bookstype"));
                }
                if (!bookTypes.isEmpty()) {
                    hasBiz = QueryServiceHelper.exists((String)"gl_initcashflow", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("booktype", "in", bookTypes)});
                }
            }
        }
        return hasBiz;
    }

    private List<Long> getAllAfterPeriod(Date curLocalSetDate) {
        ArrayList<Long> periodIds = new ArrayList<Long>(16);
        QFilter typeF = new QFilter("periodtype", "in", this.periodType);
        QFilter dateF = new QFilter("enddate", ">=", (Object)curLocalSetDate);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashflowConfigPlugin", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{typeF, dateF}, null);){
            for (Row row : ds) {
                periodIds.add(row.getLong("id"));
            }
        }
        return periodIds;
    }
}

