/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.bd.util.ContextUtil;

public class PeriodEdit
extends AbstractBillPlugIn
implements ClickListener {
    public void initialize() {
        this.addClickListeners(new String[]{"generateperiod"});
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("period_entry");
        int period = (Integer)model.getValue("period");
        int size = entrys.size();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "submit": 
            case "saveandaddnew": 
            case "save_btn": {
                if (!this.checkData()) {
                    evt.setCancel(true);
                }
                if (entrys.isEmpty() || entrys.size() == period) break;
                model.beginInit();
                model.setValue("period", (Object)entrys.size());
                model.endInit();
                this.getView().updateView("period");
                break;
            }
            case "generateperiod_btn": {
                if (this.checkBeforeGen(model, period)) break;
                evt.setCancel(Boolean.TRUE.booleanValue());
                break;
            }
            case "insertadjust": {
                if (size == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u8c03\u6574\u671f\u3002", (String)"PeriodEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean r = this.checkCanotInsert(model);
                if (!r) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u9009\u4e2d\u6bcf\u5b63\u5b63\u672b\u6216\u8005\u6700\u540e\u4e00\u671f\u624d\u80fd\u589e\u52a0\u8c03\u6574\u671f\uff0c\u4e14\u6bcf\u5b63\u5b63\u672b\u53ea\u80fd\u589e\u52a0\u4e00\u4e2a\u8c03\u6574\u671f\uff0c\u800c\u671f\u672b\u8c03\u6574\u671f\u6700\u591a\u589e\u52a0\u4e09\u4e2a\u3002", (String)"PeriodEdit_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (model.getEntryEntity("period_entry").isEmpty()) break;
                int index = model.getEntryCurrentRowIndex("period_entry");
                model.insertEntryRow("period_entry", index + 1);
                model.setEntryCurrentRowIndex("period_entry", index + 1);
                break;
            }
            case "deleteadjust": {
                int periodNum;
                int year;
                if (size == 0) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u8c03\u6574\u671f\u3002", (String)"PeriodEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                int index = model.getEntryCurrentRowIndex("period_entry");
                if (index == -1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"PeriodEdit_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean isAdjust = this.checkIsAdjust(model, index);
                if (!isAdjust) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u8c03\u6574\u671f\u5206\u5f55\u3002", (String)"PeriodEdit_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean isLastAdjust = this.checkIsLastAdjust(model, index);
                if (!isLastAdjust) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u671f\u4e4b\u540e\u7684\u8c03\u6574\u671f\u53ea\u80fd\u5220\u9664\u6700\u540e\u7684\u8c03\u6574\u671f\u3002", (String)"PeriodEdit_23", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject periodType = (DynamicObject)model.getValue("group");
                long typeId = (Long)periodType.getPkValue();
                long periodId = typeId * 100000000L + (long)((year = Integer.parseInt(String.valueOf(model.getValue("periodyear1")))) * 10000) + (long)((periodNum = model.getEntryRowEntity("period_entry", index).getInt("periodnumber")) * 10) + 1L;
                if (QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter("period", "=", (Object)periodId).toArray())) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8c03\u6574\u671f\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PeriodEdit_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (model.getEntryEntity("period_entry").isEmpty()) break;
                model.deleteEntryRow("period_entry", index);
            }
        }
    }

    private boolean checkBeforeGen(IDataModel model, int period) {
        int truetimes;
        DynamicObject group = (DynamicObject)model.getValue("group");
        int times = group.getInt("times");
        String adjusttype = (String)model.getValue("adjusttype");
        int n = truetimes = "3".equals(adjusttype) ? times * 2 : times;
        if (period <= truetimes) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u6570\u5fc5\u987b\u591a\u4e8e\u9ed8\u8ba4\u8c03\u6574\u671f\u6570\u3002", (String)"PeriodEdit_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (period - truetimes < truetimes && "3".equals(adjusttype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u8c03\u6574\u671f\u7b56\u7565\u4e3a\u6309\u5b63\u8c03\u6574\u65f6\uff0c\u975e\u8c03\u6574\u671f\u6570\u5e94\u8be5\u5927\u4e8e\u9ed8\u8ba4\u8c03\u6574\u6b21\u6570\u3002", (String)"PeriodEdit_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Date outlineBeginDate = (Date)model.getDataEntity().get("outlinebegindate");
        Date outlineEndDate = (Date)model.getDataEntity().get("outlineenddate");
        int totaldays = (int)((outlineEndDate.getTime() - outlineBeginDate.getTime()) / 86400000L) + 1;
        if (this.checkPerPeiordDate(period, totaldays, truetimes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u4f1a\u8ba1\u671f\u95f4\u81f3\u5c11\u4e3a\u4e00\u5929\uff0c\u4f1a\u8ba1\u671f\u95f4\u6570\u4e0d\u5f97\u591a\u4e8e\u5f53\u5e74\u5929\u6570\u548c\u9ed8\u8ba4\u8c03\u6574\u671f\u6570\u4e4b\u548c\u3002", (String)"PeriodEdit_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean checkCanotInsert(IDataModel model) {
        DynamicObjectCollection entrys = model.getEntryEntity("period_entry");
        int size = entrys.size();
        int index = model.getEntryCurrentRowIndex("period_entry");
        if (index == -1) {
            return false;
        }
        if (index < size - 1) {
            DynamicObject curEntry = (DynamicObject)entrys.get(index);
            int curperiodquarter = curEntry.getInt("periodquarter");
            boolean curIsAdjust = curEntry.getBoolean("isadjustperiod");
            DynamicObject nextEntry = (DynamicObject)entrys.get(index + 1);
            int nextperiodquarter = nextEntry.getInt("periodquarter");
            if (curperiodquarter == nextperiodquarter) {
                return false;
            }
            if (curIsAdjust) {
                return false;
            }
        } else if (index > 1) {
            DynamicObjectCollection lastThreeEntitys = new DynamicObjectCollection();
            lastThreeEntitys.add(entrys.get(index));
            lastThreeEntitys.add(entrys.get(index - 1));
            lastThreeEntitys.add(entrys.get(index - 2));
            if (((DynamicObject)lastThreeEntitys.get(0)).getBoolean("isadjustperiod") && ((DynamicObject)lastThreeEntitys.get(1)).getBoolean("isadjustperiod") && ((DynamicObject)lastThreeEntitys.get(2)).getBoolean("isadjustperiod")) {
                return false;
            }
        }
        return true;
    }

    private boolean checkIsAdjust(IDataModel model, int index) {
        DynamicObject curEntry = (DynamicObject)model.getEntryEntity("period_entry").get(index);
        return curEntry.getBoolean("isadjustperiod");
    }

    private boolean checkIsLastAdjust(IDataModel model, int index) {
        DynamicObjectCollection entryEntitys = model.getEntryEntity("period_entry");
        int lastIndex = entryEntitys.size() - 1;
        return index == lastIndex || !((DynamicObject)entryEntitys.get(index + 1)).getBoolean("isadjustperiod");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        IDataModel model = this.getModel();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "generateperiod_btn": {
                this.generatePeriod();
                break;
            }
            case "insertadjust": {
                int row = model.getEntryCurrentRowIndex("period_entry");
                this.setAdjustPeriodEntry(model, row);
                break;
            }
            case "deleteadjust": {
                model.beginInit();
                this.resetPeriod(model, -1);
                model.endInit();
                this.getView().updateView("period");
            }
        }
    }

    private void setAdjustPeriodEntry(IDataModel model, int row) {
        int size = model.getEntryEntity("period_entry").size();
        DynamicObject periousEntry = (DynamicObject)model.getEntryEntity("period_entry").get(row - 1);
        int year = Integer.parseInt(String.valueOf(model.getValue("periodyear1")));
        if (periousEntry != null) {
            model.beginInit();
            model.setValue("periodnumber", size == row + 1 ? Integer.valueOf(periousEntry.getInt("periodnumber") + 1) : periousEntry.get("periodnumber"), row);
            model.setValue("periodnumber2", size == row + 1 ? Integer.valueOf(periousEntry.getInt("periodnumber") + 1) : String.format(ResManager.loadKDString((String)"%s(\u8c03\u6574)", (String)"PeriodEdit_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), periousEntry.get("periodnumber")), row);
            model.setValue("begindate", (Object)this.getFormatBeginDate(periousEntry.getDate("enddate")).getTime(), row);
            model.setValue("enddate", periousEntry.get("enddate"), row);
            model.setValue("periodname", (Object)this.getPeriodName(year, (Integer)model.getValue("periodnumber"), true, (String)model.getValue("generatetype")), row);
            this.resetPeriod(model, 1);
            model.endInit();
            this.getView().updateView("period");
            this.getView().updateView("periodnumber", row);
            this.getView().updateView("periodnumber2", row);
            this.getView().updateView("periodname", row);
            this.getView().updateView("begindate", row);
            this.getView().updateView("enddate", row);
            model.setValue("periodquarter", periousEntry.get("periodquarter"), row);
            model.setValue("isadjustperiod", (Object)"1", row);
        }
    }

    private void resetPeriod(IDataModel model, int count) {
        int period = (Integer)model.getValue("period");
        model.setValue("period", (Object)(period + count));
    }

    private DynamicObject getPeriod(long id) {
        return QueryServiceHelper.queryOne((String)"bd_period_type", (String)"generatetype,adjusttype,times", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
    }

    private void setPeriod(Object generateType, Object adjustType, Object times) {
        IDataModel model = this.getModel();
        int basenum = "3".equals(generateType) ? 52 : 12;
        int truetimes = "3".equals(adjustType) ? Integer.parseInt(String.valueOf(times)) * 2 : Integer.parseInt(String.valueOf(times));
        model.setValue("period", (Object)(basenum + truetimes));
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        long outlineId = (Long)model.getDataEntity().getPkValue();
        model.setValue("periodyear1", model.getValue("periodyear"));
        this.setYearComs(1950L, 2049L);
        Map<Object, DynamicObject> coll = this.getPeriodListByOutlineId(outlineId);
        model.deleteEntryData("period_entry");
        for (Map.Entry<Object, DynamicObject> entry : coll.entrySet()) {
            DynamicObject obj = entry.getValue();
            int rowIndex = model.createNewEntryRow("period_entry");
            boolean isadjustperiod = obj.getBoolean("isadjustperiod");
            long periodnumber = obj.getLong("periodnumber");
            model.setValue("periodid", obj.get("id"), rowIndex);
            model.setValue("periodnumber", (Object)periodnumber, rowIndex);
            model.setValue("periodnumber2", false == isadjustperiod || obj.getInt("periodquarter") == 4 ? Long.valueOf(periodnumber) : String.format(ResManager.loadKDString((String)"%s(\u8c03\u6574)", (String)"PeriodEdit_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), periodnumber), rowIndex);
            model.setValue("periodname", obj.get("name"), rowIndex);
            model.setValue("begindate", obj.get("begindate"), rowIndex);
            model.setValue("enddate", obj.get("enddate"), rowIndex);
            model.setValue("periodquarter", obj.get("periodquarter"), rowIndex);
            model.setValue("isadjustperiod", obj.get("isadjustperiod"), rowIndex);
        }
    }

    private boolean checkPerPeiordDate(int period, int totaldays, int truetimes) {
        return period - truetimes > totaldays;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject obj = changeData.getDataEntity();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String proName = e.getProperty().getName();
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        String generatetype = (String)model.getValue("generatetype");
        switch (proName) {
            case "period": {
                int truetimes;
                Date outlineBeginDate = (Date)model.getDataEntity().get("outlinebegindate");
                Date outlineEndDate = (Date)model.getDataEntity().get("outlineenddate");
                int totaldays = (int)((outlineEndDate.getTime() - outlineBeginDate.getTime()) / 86400000L) + 1;
                String adjusttype = (String)model.getValue("adjusttype");
                DynamicObject group = (DynamicObject)model.getValue("group");
                int times = group.getInt("times");
                int n = truetimes = "3".equals(adjusttype) ? times * 2 : times;
                if (this.checkPerPeiordDate((Integer)changeData.getNewValue(), totaldays, truetimes)) {
                    model.beginInit();
                    model.setValue("period", (Object)(totaldays + truetimes));
                    model.endInit();
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u4f1a\u8ba1\u671f\u95f4\u81f3\u5c11\u4e3a\u4e00\u5929\uff0c\u4f1a\u8ba1\u671f\u95f4\u6570\u4e0d\u5f97\u591a\u4e8e\u5f53\u5e74\u5929\u6570\u548c\u9ed8\u8ba4\u8c03\u6574\u671f\u6570\u4e4b\u548c\u3002", (String)"PeriodEdit_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    view.updateView("period");
                } else {
                    this.generatePeriod();
                }
                model.setEntryCurrentRowIndex("period_entry", 0);
                break;
            }
            case "periodname": {
                break;
            }
            case "group": {
                DynamicObject periodtype = (DynamicObject)obj.get("group");
                if (periodtype == null) break;
                long periodtype_id = (Long)periodtype.get("id");
                int periodyear = this.getYear(periodtype_id);
                model.setValue("periodyear1", (Object)String.valueOf(periodyear));
                break;
            }
            case "periodyear1": {
                model.setValue("periodyear", model.getValue("periodyear1"));
                this.genPeriodDate(model, obj.getInt("periodyear"));
                if (newValue == null) break;
                this.generatePeriod();
                break;
            }
            case "outlinebegindate": {
                if (!"1".equals(generatetype)) {
                    this.setEndDate(model);
                }
                if (newValue == null) break;
                this.generatePeriod();
                break;
            }
            case "outlinebegindate1": {
                model.setValue("outlinebegindate", model.getValue("outlinebegindate1"));
                break;
            }
            case "outlineenddate": {
                if (newValue == null) break;
                this.generatePeriod();
                break;
            }
            case "enddate": {
                if (!"4".equals(generatetype)) break;
                this.resetPeriodEntry(rowIndex, newValue, proName, model);
                break;
            }
            case "begindate": {
                if (!"4".equals(generatetype)) break;
                this.resetPeriodEntry(rowIndex, newValue, proName, model);
                break;
            }
            case "generatetype": {
                if (!"4".equals(generatetype)) break;
                this.getModel().setValue("outlinebegindate1", this.getModel().getValue("outlinebegindate"));
                this.getView().setEnable(Boolean.TRUE, new String[]{"period"});
            }
        }
    }

    private long getPeriodEntryIdByIndex(int rowIndex, IDataModel model) {
        DynamicObject period = (DynamicObject)model.getEntryEntity("period_entry").get(rowIndex);
        DynamicObject periodType = (DynamicObject)model.getValue("group");
        long typeId = periodType.getLong("id");
        int year = Integer.parseInt(String.valueOf(model.getValue("periodyear1")));
        int periodNum = period.getInt("periodnumber");
        boolean isAdjustPeriod = period.getBoolean("isadjustperiod");
        long pk = typeId * 100000000L + (long)(year * 10000) + (long)(periodNum * 10);
        if (isAdjustPeriod) {
            ++pk;
        }
        return pk;
    }

    private void resetPeriodEntry(int rowIndex, Object newValue, String key, IDataModel model) {
        DynamicObjectCollection entry = model.getEntryEntity("period_entry");
        Calendar c = Calendar.getInstance();
        IFormView view = this.getView();
        c.setTime((Date)newValue);
        Integer[] dateParams = null;
        block4 : switch (key) {
            case "enddate": {
                boolean isAdjust;
                DynamicObject period;
                int i;
                DynamicObject curPeriod = (DynamicObject)entry.get(rowIndex);
                dateParams = new Integer[]{23, 59, 59};
                Date newDate = this.setDate((Date)newValue, dateParams);
                model.setValue("enddate", (Object)newDate, rowIndex);
                boolean curisAdjust = curPeriod.getBoolean("isadjustperiod");
                if (curisAdjust) {
                    model.beginInit();
                    model.setValue("begindate", (Object)this.getFormatBeginDate(c.getTime()).getTime(), rowIndex);
                    model.endInit();
                    for (i = rowIndex - 1; i >= 0 && i < entry.size(); --i) {
                        period = (DynamicObject)entry.get(i);
                        isAdjust = period.getBoolean("isadjustperiod");
                        if (!isAdjust) {
                            model.beginInit();
                            model.setValue("enddate", (Object)this.getFormatEndDate(c.getTime()).getTime(), i);
                            model.endInit();
                            view.updateView("enddate", i);
                            break;
                        }
                        Date adjustDate = this.getFormatEndDate(c.getTime()).getTime();
                        model.beginInit();
                        model.setValue("begindate", (Object)adjustDate, i);
                        model.setValue("enddate", (Object)adjustDate, i);
                        model.endInit();
                        view.updateView("begindate", i);
                        view.updateView("enddate", i);
                    }
                }
                for (i = rowIndex + 1; i < entry.size(); ++i) {
                    period = (DynamicObject)entry.get(i);
                    isAdjust = period.getBoolean("isadjustperiod");
                    if (!isAdjust) {
                        c.add(5, 1);
                        model.beginInit();
                        model.setValue("begindate", (Object)this.getFormatBeginDate(c.getTime()).getTime(), i);
                        model.endInit();
                        view.updateView("begindate", i);
                        break block4;
                    }
                    model.beginInit();
                    model.setValue("begindate", (Object)this.getFormatBeginDate(c.getTime()).getTime(), i);
                    model.setValue("enddate", (Object)this.getFormatEndDate(c.getTime()).getTime(), i);
                    model.endInit();
                    view.updateView("begindate", i);
                    view.updateView("enddate", i);
                }
                break;
            }
            case "begindate": {
                dateParams = new Integer[]{0, 0, 0};
                Date newBeginDate = this.setDate((Date)newValue, dateParams);
                DynamicObject curPeriod = (DynamicObject)entry.get(rowIndex);
                model.setValue("begindate", (Object)newBeginDate, rowIndex);
                boolean curisAdjust = curPeriod.getBoolean("isadjustperiod");
                if (curisAdjust) {
                    Date adjustDate;
                    boolean isAdjust;
                    DynamicObject period;
                    int i;
                    model.beginInit();
                    model.setValue("enddate", (Object)this.getFormatEndDate(c.getTime()).getTime(), rowIndex);
                    model.endInit();
                    view.updateView("enddate", rowIndex);
                    for (i = rowIndex - 1; i >= 0 && i < entry.size(); --i) {
                        period = (DynamicObject)entry.get(i);
                        isAdjust = period.getBoolean("isadjustperiod");
                        if (!isAdjust) {
                            model.beginInit();
                            model.setValue("enddate", (Object)this.getFormatEndDate(c.getTime()).getTime(), i);
                            model.endInit();
                            view.updateView("enddate", i);
                            break;
                        }
                        adjustDate = this.getFormatEndDate(c.getTime()).getTime();
                        model.beginInit();
                        model.setValue("begindate", (Object)adjustDate, i);
                        model.setValue("enddate", (Object)adjustDate, i);
                        model.endInit();
                        view.updateView("begindate", i);
                        view.updateView("enddate", i);
                    }
                    for (i = rowIndex + 1; i < entry.size(); ++i) {
                        period = (DynamicObject)entry.get(i);
                        isAdjust = period.getBoolean("isadjustperiod");
                        if (!isAdjust) {
                            c.add(5, 1);
                            model.beginInit();
                            model.setValue("begindate", (Object)this.getFormatBeginDate(c.getTime()).getTime(), i);
                            model.endInit();
                            view.updateView("begindate", i);
                            break block4;
                        }
                        adjustDate = this.getFormatEndDate(c.getTime()).getTime();
                        model.beginInit();
                        model.setValue("begindate", (Object)adjustDate, i);
                        model.setValue("enddate", (Object)adjustDate, i);
                        model.endInit();
                        view.updateView("begindate", i);
                        view.updateView("enddate", i);
                    }
                } else {
                    c.add(5, -1);
                    for (int i = rowIndex - 1; i >= 0 && i < entry.size(); --i) {
                        DynamicObject period = (DynamicObject)entry.get(i);
                        boolean isAdjust = period.getBoolean("isadjustperiod");
                        if (!isAdjust) {
                            model.beginInit();
                            model.setValue("enddate", (Object)this.getFormatEndDate(c.getTime()).getTime(), i);
                            model.endInit();
                            view.updateView("enddate", i);
                            break block4;
                        }
                        Date adjustDate = this.getFormatEndDate(c.getTime()).getTime();
                        model.beginInit();
                        model.setValue("begindate", (Object)adjustDate, i);
                        model.setValue("enddate", (Object)adjustDate, i);
                        model.endInit();
                        view.updateView("begindate", i);
                        view.updateView("enddate", i);
                    }
                }
                break;
            }
        }
    }

    private Date setDate(Date newValue, Integer[] dateParams) {
        Date newDate = newValue;
        newDate.setHours(dateParams[0]);
        newDate.setMinutes(dateParams[1]);
        newDate.setSeconds(dateParams[2]);
        return newDate;
    }

    private void setEndDate(IDataModel model) {
        Date beginDate = (Date)model.getValue("outlinebegindate");
        if (null == beginDate) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(beginDate);
        if (c.getActualMaximum(5) == c.get(5)) {
            c.add(2, 12);
            c.set(5, c.getActualMaximum(5) - 1);
        } else {
            c.add(2, 12);
            c.add(5, -1);
        }
        model.setValue("outlineenddate", (Object)this.getFormatEndDate(c.getTime()).getTime());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject periodtype = (DynamicObject)model.getValue("group");
        int periodyear = Calendar.getInstance().getWeekYear();
        if (periodtype != null) {
            long periodtype_id = periodtype.getLong("id");
            periodyear = OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) ? this.getYear(periodtype_id) : Integer.parseInt(String.valueOf(model.getValue("periodyear1")));
            model.setValue("periodyear1", (Object)String.valueOf(periodyear));
            DynamicObject periodType = this.getPeriod(periodtype_id);
            Object generateType = periodType.get("generatetype");
            Object adjustType = periodType.get("adjusttype");
            Object times = periodType.get("times");
            model.setValue("generatetype", generateType);
            model.setValue("adjusttype", adjustType);
            model.setValue("times", times);
            this.setPeriod(generateType, adjustType, times);
        } else {
            model.setValue("periodyear1", (Object)String.valueOf(periodyear));
        }
        model.setValue("periodyear", (Object)periodyear);
        if (!OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.genPeriodDate(model, periodyear);
        }
        this.generatePeriod();
    }

    private void setDateFormat() {
        IFormView view = this.getView();
        Long userID = ContextUtil.getUserId();
        String format = InteServiceHelper.getDateFormat((Long)userID);
        HashMap<String, String> editor = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> item = new HashMap<String, HashMap<String, String>>();
        editor.put("df", format);
        item.put("item", editor);
        view.updateControlMetadata("outlinebegindate", item);
        view.updateControlMetadata("outlinebegindate1", item);
        view.updateView("outlinebegindate");
        view.updateView("outlinebegindate1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockField();
        IDataModel model = this.getModel();
        String generatetype = (String)model.getValue("generatetype");
        if ("4".equals(generatetype)) {
            model.setValue("outlinebegindate1", model.getValue("outlinebegindate"));
            this.getView().setEnable(Boolean.TRUE, new String[]{"period"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"begindate", "enddate", "periodquarter"});
        }
        this.setDateFormat();
    }

    private void lockField() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        int periodyear = Integer.parseInt(String.valueOf(model.getValue("periodyear1")));
        DynamicObject group = (DynamicObject)model.getValue("group");
        if (group != null) {
            QFilter qgroup = new QFilter("group", "=", (Object)group.getLong("id"));
            QFilter qperiodyear = new QFilter("periodyear", "<", (Object)periodyear);
            DynamicObjectCollection lastPeriods = QueryServiceHelper.query((String)"bd_periodoutline_tree", (String)"id,periodyear", (QFilter[])new QFilter[]{qgroup, qperiodyear}, (String)"periodyear asc");
            if (!lastPeriods.isEmpty()) {
                view.setEnable(Boolean.FALSE, new String[]{"outlinebegindate", "outlinebegindate1"});
                ArrayList<ComboItem> comboitemList = new ArrayList<ComboItem>();
                ComboEdit com = (ComboEdit)this.getControl("periodyear1");
                ComboItem lastitem = new ComboItem();
                LocaleString lcaption = new LocaleString(String.valueOf(((DynamicObject)lastPeriods.get(0)).getInt("periodyear") - 1));
                lastitem.setCaption(lcaption);
                lastitem.setValue(String.valueOf(String.valueOf(((DynamicObject)lastPeriods.get(0)).getInt("periodyear") - 1)));
                comboitemList.add(lastitem);
                ComboItem nextitem = new ComboItem();
                LocaleString ncaption = new LocaleString(String.valueOf(periodyear));
                nextitem.setCaption(ncaption);
                nextitem.setValue(String.valueOf(String.valueOf(periodyear)));
                comboitemList.add(nextitem);
                com.setComboItems(comboitemList);
            }
            qperiodyear = new QFilter("periodyear", "=", (Object)(periodyear + 1));
            DynamicObject nextPeriod = QueryServiceHelper.queryOne((String)"bd_periodoutline_tree", (String)"id,outlinebegindate,outlineenddate", (QFilter[])new QFilter[]{qgroup, qperiodyear});
            if (nextPeriod != null) {
                view.setEnable(Boolean.FALSE, new String[]{"periodyear1", "outlinebegindate", "outlinebegindate1", "outlineenddate"});
            }
            if (!OperationStatus.ADDNEW.equals((Object)view.getFormShowParameter().getStatus())) {
                DynamicObjectCollection entry = model.getEntryEntity("period_entry");
                Object[] periodids = new Object[entry.size()];
                for (int i = 0; i < entry.size(); ++i) {
                    periodids[i] = ((DynamicObject)entry.get(i)).get("periodid");
                }
                if (nextPeriod != null) {
                    this.setYearComs(periodyear, periodyear);
                }
            }
        }
    }

    private void genPeriodDate(IDataModel model, int year) {
        Calendar c = Calendar.getInstance();
        Date begin = (Date)model.getValue("outlinebegindate");
        model.beginInit();
        if (begin == null) {
            c.set(year, 0, 1);
            begin = this.getFormatBeginDate(c.getTime()).getTime();
            model.setValue("outlinebegindate", (Object)begin);
            model.setValue("outlinebegindate1", (Object)begin);
        } else {
            c.setTime(begin);
            int fixday = 0;
            if (year % 4 != 0 && c.get(2) == 1 && c.get(5) == 29) {
                fixday = -1;
            }
            c.set(1, year);
            c.add(5, fixday);
            begin = this.getFormatBeginDate(c.getTime()).getTime();
            model.setValue("outlinebegindate", (Object)begin);
            model.setValue("outlinebegindate1", (Object)begin);
        }
        if (c.getActualMaximum(5) == c.get(5)) {
            c.add(2, 12);
            c.set(5, c.getActualMaximum(5) - 1);
        } else {
            c.add(2, 12);
            c.add(5, -1);
        }
        Date endDate = this.getFormatEndDate(c.getTime()).getTime();
        model.setValue("outlineenddate", (Object)endDate);
        DynamicObject periodtype = (DynamicObject)model.getValue("group");
        QFilter qtype = new QFilter("group", "=", (Object)Long.parseLong(String.valueOf(periodtype.getPkValue())));
        QFilter qyear = new QFilter("periodyear", "=", (Object)(year - 1)).or(new QFilter("periodyear", "=", (Object)(year + 1)));
        DynamicObjectCollection periodoutlines = QueryServiceHelper.query((String)"bd_periodoutline_tree", (String)"id,periodyear,outlinebegindate,outlineenddate", (QFilter[])new QFilter[]{qtype, qyear}, (String)"periodyear asc");
        if (!periodoutlines.isEmpty()) {
            for (DynamicObject outline : periodoutlines) {
                int periodyear = outline.getInt("periodyear");
                if (year - 1 == periodyear) {
                    Date outlineenddate = outline.getDate("outlineenddate");
                    c.setTime(outlineenddate);
                    c.add(5, 1);
                    Date thisBegin = this.getFormatBeginDate(c.getTime()).getTime();
                    model.setValue("outlinebegindate", (Object)thisBegin);
                    model.setValue("outlinebegindate1", (Object)thisBegin);
                    this.setEndDate(model);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"outlinebegindate", "outlinebegindate1"});
                    if (!"4".equals(periodtype.getString("generatetype"))) continue;
                    this.getView().setEnable(Boolean.TRUE, new String[]{"outlineenddate"});
                    continue;
                }
                Date outlinebegindate = outline.getDate("outlinebegindate");
                c.setTime(outlinebegindate);
                c.add(5, -1);
                Date thisEnd = this.getFormatEndDate(c.getTime()).getTime();
                model.setValue("outlineenddate", (Object)thisEnd);
                c.setTime(outlinebegindate);
                c.add(1, -1);
                Date thisBegin = this.getFormatEndDate(c.getTime()).getTime();
                model.setValue("outlinebegindate", (Object)thisBegin);
                model.setValue("outlinebegindate1", (Object)thisBegin);
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlineenddate"});
                if (!"4".equals(periodtype.getString("generatetype"))) continue;
                this.getView().setEnable(Boolean.TRUE, new String[]{"outlinebegindate", "outlinebegindate1"});
            }
        }
        model.endInit();
        this.getView().updateView("outlineenddate");
        this.getView().updateView("outlinebegindate1");
        this.getView().updateView("outlinebegindate");
    }

    private String getPeriodName(int year, int periodNum, boolean isAdjustPeriod, String generatetype) {
        String pnumber = "4".equals(generatetype) ? String.valueOf(1000 + periodNum).substring(1) : String.valueOf(1000 + periodNum).substring(2);
        String adjustStr = isAdjustPeriod ? ResManager.loadKDString((String)"(\u8c03\u6574)", (String)"PeriodEdit_25", (String)"fi-bd-formplugin", (Object[])new Object[0]) : "";
        String znFormat = ResManager.loadKDString((String)"%1$d\u5e74%2$s\u671f%3$s", (String)"PeriodEdit_28", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        String usFormat = ResManager.loadKDString((String)"\u671f %1$s \u5e74 %2$d %3$s", (String)"PeriodEdit_29", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        Lang lang = RequestContext.get().getLang();
        if (Lang.zh_CN.equals((Object)lang)) {
            return String.format(znFormat, year, periodNum, adjustStr);
        }
        return String.format(usFormat, pnumber, year, adjustStr);
    }

    private void generatePeriod() {
        List<Map<String, Object>> list;
        IDataModel model = this.getModel();
        if (!this.checkBeforeGen(model, (Integer)model.getValue("period"))) {
            return;
        }
        IFormView view = this.getView();
        String generatetype = (String)model.getValue("generatetype");
        String _year = String.valueOf(model.getValue("periodyear1"));
        if (StringUtils.isEmpty((Object)_year.trim())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f1a\u8ba1\u5e74\u5ea6\u3002", (String)"PeriodEdit_12", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        int periodyear = Integer.parseInt(_year);
        String adjusttype = (String)model.getValue("adjusttype");
        DynamicObject periodtype = (DynamicObject)model.getValue("group");
        Object times = periodtype.get("times");
        if (!"4".equals(generatetype)) {
            this.setPeriod(generatetype, adjusttype, times);
        }
        if ((list = this.getPeriodList(generatetype, periodyear)) == null) {
            return;
        }
        Map<String, Object> map = null;
        model.deleteEntryData("period_entry");
        model.beginInit();
        model.batchCreateNewEntryRow("period_entry", list.size());
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            String isadjust = map.get("isAdjustPeriod").toString();
            String periodnumber = map.get("periodNumber").toString();
            model.setValue("periodnumber", (Object)periodnumber, i);
            String periodNumber2 = "0".equals(isadjust) || "2".equals(adjusttype) || "4".equals(String.valueOf(map.get("quarter"))) ? periodnumber : String.format(ResManager.loadKDString((String)"%s(\u8c03\u6574)", (String)"PeriodEdit_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), periodnumber);
            model.setValue("periodnumber2", (Object)periodNumber2, i);
            model.setValue("periodname", (Object)this.getPeriodName(periodyear, Integer.parseInt(periodnumber), "1".equals(isadjust), generatetype), i);
            model.setValue("begindate", (Object)((Date)map.get("beginDate")), i);
            model.setValue("enddate", (Object)((Date)map.get("endDate")), i);
            model.setValue("periodquarter", (Object)map.get("quarter").toString(), i);
            model.setValue("isadjustperiod", (Object)isadjust, i);
        }
        model.endInit();
        view.updateView("period");
        view.updateView("period_entry");
    }

    private List<Map<String, Object>> getPeriodList(String generatetype, int periodyear) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Calendar c = Calendar.getInstance();
        Map<String, Object> map = null;
        IDataModel model = this.getModel();
        String adjusttype = (String)model.getValue("adjusttype");
        int period = (Integer)model.getValue("period");
        Date outlineBeginDate = (Date)model.getDataEntity().get("outlinebegindate");
        Date outlineEndDate = (Date)model.getDataEntity().get("outlineenddate");
        c.setTime(outlineBeginDate);
        Date endDate = this.getFormatEndDate(new Date()).getTime();
        int endday = 0;
        String isAdjustPeriod = "0";
        DynamicObject group = (DynamicObject)model.getValue("group");
        int times = group.getInt("times");
        int truetimes = "3".equals(adjusttype) ? times * 2 : times;
        ArrayList<Integer> adjustPeriodNums = new ArrayList<Integer>(truetimes);
        for (int i = 1; i <= truetimes; ++i) {
            int index;
            int n = index = "2".equals(adjusttype) ? period - truetimes + i : period / truetimes * i;
            if (i == truetimes) {
                index = period;
            }
            adjustPeriodNums.add(index);
        }
        int totaldays = (int)((outlineEndDate.getTime() - outlineBeginDate.getTime()) / 86400000L) + 1;
        int dayOfPerPeriod = totaldays / (period - truetimes);
        int periodindex = 1;
        int indexOfQuarter = 0;
        int indexOfUnAdjustPeriod = 0;
        int countOfUnAdjustPeriod = period - truetimes;
        for (int i = 0; i < period; ++i) {
            if (adjustPeriodNums.contains(i + 1)) {
                isAdjustPeriod = "1";
                if (indexOfQuarter == 4 || adjustPeriodNums.indexOf(i + 1) + 1 < countOfUnAdjustPeriod) {
                    // empty if block
                }
                int n = --periodindex;
                ++periodindex;
                map = this.convertToMap(n, endDate, endDate, indexOfQuarter, isAdjustPeriod);
                list.add(map);
                continue;
            }
            ++indexOfUnAdjustPeriod;
            isAdjustPeriod = "0";
            if (!"3".equals(generatetype) && !"4".equals(generatetype)) {
                int curDate = c.get(5);
                int lastdayofcurmonth = c.getActualMaximum(5);
                c.add(2, 1);
                int lastdayofnextmonth = c.getActualMaximum(5);
                endday = curDate == lastdayofcurmonth ? lastdayofnextmonth - 1 : (curDate > lastdayofnextmonth ? lastdayofnextmonth : curDate - 1);
                c.set(5, endday);
                endDate = c.getTime();
            } else {
                if ("3".equals(generatetype)) {
                    c.add(5, 6);
                } else {
                    c.add(5, dayOfPerPeriod - 1);
                }
                endDate = c.getTime();
            }
            if (indexOfUnAdjustPeriod > countOfUnAdjustPeriod / 4 * indexOfQuarter && ++indexOfQuarter > 4) {
                indexOfQuarter = 4;
            }
            if (indexOfUnAdjustPeriod == period - truetimes) {
                endDate = outlineEndDate;
            }
            map = this.convertToMap(periodindex++, outlineBeginDate, endDate, indexOfQuarter, isAdjustPeriod);
            list.add(map);
            c.add(5, 1);
            outlineBeginDate = c.getTime();
        }
        return list;
    }

    private Map<String, Object> convertToMap(int i, Date beginDate, Date endDate, int quarter, String isAdjustPeriod) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar todayStart = this.getFormatBeginDate(beginDate);
        Calendar todayEnd = this.getFormatEndDate(endDate);
        map.put("periodNumber", i);
        map.put("beginDate", todayStart.getTime());
        map.put("endDate", todayEnd.getTime());
        map.put("quarter", quarter);
        map.put("isAdjustPeriod", isAdjustPeriod);
        return map;
    }

    private Calendar getFormatBeginDate(Date beginDate) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(beginDate);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart;
    }

    private Calendar getFormatEndDate(Date endDate) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(endDate);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 0);
        return todayEnd;
    }

    private int getYear(long periodTypeId) {
        QFilter periodTypeF = new QFilter("group", "=", (Object)periodTypeId);
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_periodoutline_tree", (String)"periodyear", (QFilter[])new QFilter[]{periodTypeF}, (String)"periodyear desc", (int)1);
        int periodYear = 0;
        if (period == null || period.isEmpty()) {
            periodYear = Calendar.getInstance().getWeekYear();
            this.setYearComs(1950L, 2049L);
        } else {
            periodYear = ((DynamicObject)period.get(0)).getInt("periodyear") + 1;
            this.setYearComs(periodYear, periodYear);
        }
        return periodYear;
    }

    private void setYearComs(long start, long end) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        ComboEdit com = (ComboEdit)this.getControl("periodyear1");
        for (long i = start; i <= end; ++i) {
            ComboItem citem = new ComboItem();
            LocaleString caption = new LocaleString(String.valueOf(i));
            citem.setCaption(caption);
            citem.setValue(String.valueOf(i));
            list.add(citem);
        }
        com.setComboItems(list);
    }

    private Map<Object, DynamicObject> getPeriodListByOutlineId(long outlineId) {
        QFilter[] qfArr = new QFilter[]{new QFilter("periodoutline", "=", (Object)outlineId)};
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id,name,number,periodnumber,begindate,enddate,periodquarter,isadjustperiod", (QFilter[])qfArr, (String)"id");
        return result;
    }

    private boolean checkData() {
        int entryCount;
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Date outlineBeginDate = (Date)model.getDataEntity().get("outlinebegindate");
        int outLineBeginDateIntVal = Integer.parseInt(sdf1.format(outlineBeginDate));
        Date outlineEndDate = (Date)model.getDataEntity().get("outlineenddate");
        int outlineEndDateIntVal = Integer.parseInt(sdf1.format(outlineEndDate));
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(outlineBeginDate);
        int periodYear = this.getModel().getDataEntity().getInt("periodyear1");
        DynamicObjectCollection list = model.getEntryEntity("period_entry");
        if (list.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u4f1a\u8ba1\u671f\u95f4\u751f\u6210\u64cd\u4f5c\u3002", (String)"PeriodEdit_13", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        int periodcount = (Integer)model.getValue("period");
        if (periodcount != (entryCount = model.getEntryRowCount("period_entry"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u6570\u4e0d\u7b49\u4e8e\u671f\u95f4\u660e\u7ec6\u5206\u5f55\u6570\u91cf\u3002", (String)"PeriodEdit_14", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date firstEntryDate = ((DynamicObject)list.get(0)).getDate("begindate");
        int firstEntryDateIntVal = Integer.parseInt(sdf1.format(firstEntryDate));
        if (firstEntryDateIntVal != outLineBeginDateIntVal) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u660e\u7ec6\u91cc\u7684\u5f00\u59cb\u65e5\u671f\u548c\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u5f00\u59cb\u65e5\u671f\u4e0d\u4e00\u81f4\u3002", (String)"PeriodEdit_15", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        int dayOfMonth = beginCal.get(5);
        String generatetype = (String)model.getValue("generatetype");
        if (dayOfMonth != 1 && !"4".equals(generatetype)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u751f\u6210\u65b9\u5f0f\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u5f00\u59cb\u65e5\u671f\u624d\u53ef\u4ee5\u5b9a\u4e49\u5230\u975e1\u53f7\u65e5\u671f", (String)"PeriodEdit_16", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("4".equals(generatetype)) {
            DynamicObjectCollection periodentry = model.getEntryEntity("period_entry");
            Date lastEndDate = null;
            int lastEndDateIntVal = 0;
            for (int i = 0; i < periodentry.size(); ++i) {
                String lastEndDateStr;
                DynamicObject period = (DynamicObject)periodentry.get(i);
                Date beginDate = period.getDate("begindate");
                Date endDate = period.getDate("enddate");
                String beginDateStr = sdf1.format(beginDate);
                String endDateStr = sdf1.format(endDate);
                int beginDateIntVal = Integer.parseInt(beginDateStr);
                int endDateIntVal = Integer.parseInt(endDateStr);
                boolean isAdjust = period.getBoolean("isadjustperiod");
                if (beginDateIntVal > endDateIntVal) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6bcf\u4e00\u671f\u660e\u7ec6\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"PeriodEdit_17", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (lastEndDate != null) {
                    lastEndDateStr = sdf1.format(lastEndDate);
                    lastEndDateIntVal = Integer.parseInt(lastEndDateStr);
                    if (isAdjust && (beginDateIntVal != endDateIntVal || lastEndDateIntVal != beginDateIntVal)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6bcf\u4e00\u671f\u8c03\u6574\u671f\u7684\u5f00\u59cb\u65e5\u671f\u5e94\u8be5\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u4e14\u4e0e\u4e0a\u4e00\u4e2a\u975e\u8c03\u6574\u7684\u7ed3\u675f\u65e5\u671f\u76f8\u540c\u3002", (String)"PeriodEdit_18", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                if (isAdjust) continue;
                lastEndDate = endDate;
                lastEndDateStr = sdf1.format(lastEndDate);
                lastEndDateIntVal = Integer.parseInt(lastEndDateStr);
            }
            if (lastEndDateIntVal != outlineEndDateIntVal) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u671f\u975e\u8c03\u6574\u671f\u7684\u7ed3\u675f\u65e5\u671f\u4e0e\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u7ed3\u675f\u65e5\u671f\u4e0d\u4e00\u81f4\u3002", (String)"PeriodEdit_19", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        DynamicObject type = (DynamicObject)model.getValue("group");
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select fperiodyear,fbegindate from t_bd_periodoutline where fgroupid = ?", new Object[]{type.getPkValue()});
        if (!OperationStatus.ADDNEW.equals((Object)view.getFormShowParameter().getStatus())) {
            long id = (Long)model.getValue("id");
            sql.append(" and fid <> ?", new Object[]{id});
        }
        try (DataSet periodoutline = DB.queryDataSet((String)"fi.bd.PeriodEdit", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            int maxYear = 0;
            int minYear = 3000;
            while (periodoutline.hasNext()) {
                Row row = periodoutline.next();
                Date fbegindate = row.getDate("fbegindate");
                int year = row.getInteger("fperiodyear");
                maxYear = maxYear > year ? maxYear : year;
                int n = minYear = minYear < year ? minYear : year;
                if (year != periodYear + 1) continue;
                Calendar c = Calendar.getInstance();
                c.setTime(outlineEndDate);
                c.add(5, 1);
                int curYear = c.get(1);
                int curMonth = c.get(2);
                int curDate = c.get(5);
                c.setTime(fbegindate);
                int nextYear = c.get(1);
                int nextMonth = c.get(2);
                int nextDate = c.get(5);
                if (curYear == nextYear && curMonth == nextMonth && curDate == nextDate) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\u5e94\u8be5\u4e0e\u4e0b\u4e00\u5e74\u5ea6\u7684\u5f00\u59cb\u65e5\u671f\u4fdd\u6301\u8fde\u7eed\u3002", (String)"PeriodEdit_20", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
            if (minYear != 3000 && maxYear != 0 && (periodYear < minYear - 1 || periodYear > maxYear + 1)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8de8\u5e74\u589e\u52a0\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodEdit_21", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                boolean row = false;
                return row;
            }
        }
        for (DynamicObject period : list) {
            String periodName = period.getString("periodname");
            if (periodName != null && !periodName.isEmpty()) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PeriodEdit_24", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isNameRepite = this.isNameRepite(model);
        if (isNameRepite) {
            view.showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u660e\u7ec6\u540d\u79f0\u4e0d\u552f\u4e00\u3002", (String)"PeriodEdit_22", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap<Long, Integer> periodIndexMap = new HashMap<Long, Integer>(8);
        for (int row = 0; row < list.size(); ++row) {
            periodIndexMap.put(this.getPeriodEntryIdByIndex(row, model), row);
        }
        Set<Long> periodIdFromAccountBook = this.getPeriodIdFromAccountBook(periodIndexMap.keySet());
        Set<Long> periodIdFromVoucher = this.getPeriodIdFromVoucher(periodIndexMap.keySet());
        HashSet<Long> usedPeriodIdSet = new HashSet<Long>(8);
        usedPeriodIdSet.addAll(periodIdFromAccountBook);
        usedPeriodIdSet.addAll(periodIdFromVoucher);
        String errorMsg = this.changeNameCheck(model, periodIndexMap, usedPeriodIdSet);
        if (!errorMsg.isEmpty()) {
            view.showTipNotification(errorMsg);
            return false;
        }
        return true;
    }

    private boolean isNameRepite(IDataModel model) {
        DynamicObject type = (DynamicObject)model.getValue("group");
        int periodyear = Integer.parseInt(String.valueOf(model.getValue("periodyear1")));
        HashSet<String> nameSet = new HashSet<String>();
        DynamicObjectCollection periodentry = model.getEntryEntity("period_entry");
        for (DynamicObject entry : periodentry) {
            String name = entry.getString("periodname");
            if (nameSet.contains(name)) {
                return true;
            }
            nameSet.add(name);
        }
        Long id = (Long)model.getValue("id");
        QFilter qid = id != null && id != 0L ? new QFilter("periodoutline", "!=", (Object)id) : new QFilter("periodyear", "!=", (Object)periodyear);
        boolean isRepite = QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", (Object)Long.parseLong(String.valueOf(type.getPkValue()))), qid, new QFilter("name", "in", nameSet)});
        return isRepite;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    private String changeNameCheck(IDataModel model, Map<Long, Integer> periodIndexMap, Set<Long> usedPeriodIdSet) {
        StringBuilder errorMsg = new StringBuilder();
        HashMap<Long, String> periodNameMap = new HashMap<Long, String>(8);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"bd_period", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", usedPeriodIdSet)});
        for (DynamicObject dyo : dyos) {
            periodNameMap.put(dyo.getLong("id"), dyo.getString("name"));
        }
        for (Map.Entry entry : periodNameMap.entrySet()) {
            int index = periodIndexMap.get(entry.getKey());
            String oldName = (String)entry.getValue();
            String newName = String.valueOf(model.getValue("periodname", index));
            if (oldName == null || oldName.equals(newName)) continue;
            errorMsg.append(oldName).append("\u3001");
        }
        if (errorMsg.length() != 0) {
            errorMsg.deleteCharAt(errorMsg.length() - 1);
            return String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u540d\u79f0\u3002", (String)"PeriodEdit_9", (String)"fi-bd-formplugin", (Object[])new Object[0]), errorMsg.toString());
        }
        return errorMsg.toString();
    }

    private Set<Long> getPeriodIdFromAccountBook(Set<Long> periodIdSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("select p.fid id from t_bd_period p inner join t_bd_period_l pl on p.fid = pl.fid where p.fid in (");
        sql.append(this.appendPlaceholder(periodIdSet.size()));
        sql.append(") and exists (select b.fid from t_bd_accountbooks b where b.fcurperiodid = p.fid or b.fstartperiodid = p.fid)");
        DataSet dataSet = DB.queryDataSet((String)"fi.bd.PeriodEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql.toString(), (Object[])periodIdSet.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(8);
        for (Row row : dataSet) {
            periodIds.add(row.getLong("id"));
        }
        return periodIds;
    }

    private Set<Long> getPeriodIdFromVoucher(Set<Long> periodIdSet) {
        HashSet<Long> usedPeriodIdSet = new HashSet<Long>(8);
        HashSet<Long> periodIds = new HashSet<Long>(8);
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct t.fperiodid from (select distinct faccountid, forgid, fperiodid from t_gl_balance) t ");
        DataSet dataSet = DB.queryDataSet((String)"fi.bd.PeriodEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql.toString());
        sql.delete(0, sql.length());
        for (Row row : dataSet) {
            usedPeriodIdSet.add(row.getLong(0));
        }
        sql.append("select distinct fperiodid from t_gl_tempvoucher_index t where fperiodid in (");
        sql.append(this.appendPlaceholder(periodIdSet.size()));
        sql.append(")");
        dataSet = DB.queryDataSet((String)"fi.bd.PeriodEdit", (DBRoute)DBRoute.of((String)"fi"), (String)sql.toString(), (Object[])periodIdSet.toArray());
        for (Row row : dataSet) {
            usedPeriodIdSet.add(row.getLong(0));
        }
        periodIdSet.forEach(periodId -> {
            if (usedPeriodIdSet.contains(periodId)) {
                periodIds.add((Long)periodId);
            }
        });
        return periodIds;
    }

    private String appendPlaceholder(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("?");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

