/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.formplugin.account.AccountQueryOptimizer;
import kd.fi.bd.util.DebugTrace;

public class AccListDataProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(AccListDataProvider.class);
    private IFormView view;
    private static final String[] STRUCTFIELDS = new String[]{"currencyhelp", "checkitemhelp"};
    private static final String KEY_CACHE_ACCOUNT_LIST_COUNT = "account-list-max-count";

    public AccListDataProvider(IFormView view) {
        this.view = view;
    }

    public void setListFields(List<ListField> listFields) {
        super.setListFields(listFields);
        HashSet<String> fields = new HashSet<String>(listFields.size());
        for (ListField listField : listFields) {
            fields.add(listField.getFieldName());
        }
        for (String sfield : STRUCTFIELDS) {
            if (fields.contains(sfield)) continue;
            ListField listField = new ListField(sfield);
            listField.setFieldName(sfield);
            listFields.add(listField);
        }
        if (!fields.contains("acitemhelp")) {
            ListField listField = new ListField("acitemhelp");
            listField.setFieldName("acitemhelp");
            listFields.add(listField);
        }
    }

    public DynamicObjectCollection getData(int start, int limit) {
        List assgrps;
        HashMap<Long, List> asstactyMap;
        DynamicObject acct;
        Map.Entry entry2;
        Row row3;
        Object dt;
        DynamicObjectCollection dyos;
        Throwable useRangeDataSet;
        QueryBuilder queryBuilder = this.getQueryBuilder();
        List qFilters = this.getQFilters();
        if (DebugTrace.enable()) {
            qFilters.forEach(x -> LOGGER.info("=====AccountTreeList_AccListDataProvier_qFilters:{}=====", (Object)x.toString()));
        }
        AccountQueryOptimizer accountQueryOptimizer = new AccountQueryOptimizer(qFilters);
        accountQueryOptimizer.check();
        if (accountQueryOptimizer.isMatched()) {
            String orgIdStr = accountQueryOptimizer.getOrgIdStr();
            if (DebugTrace.enable()) {
                LOGGER.info("=====AccountTreeList_AccListDataProvier_orgIdStr:{}=====", (Object)orgIdStr);
            }
            ArrayList<QFilter> globalShareFilters = new ArrayList<QFilter>(10);
            ArrayList<QFilter> useRangeFilters = new ArrayList<QFilter>(10);
            globalShareFilters.addAll(accountQueryOptimizer.getOtherQFilters());
            useRangeFilters.addAll(accountQueryOptimizer.getOtherQFilters());
            globalShareFilters.add(new QFilter("ctrlstrategy", "=", (Object)"5"));
            globalShareFilters.add(new QFilter("status", "=", (Object)"C"));
            useRangeFilters.add(QFilter.joinSQL((String)"bd_accountview", (String)("inner join t_bd_account_u u on u.fdataid=bd_accountview.fid and u.fuseorgid = " + orgIdStr), null));
            Iterator orm = ORM.create();
            DataSet ctrlstrategyDataSet = orm.queryDataSet("AccountTreeList#ctrlstrategyDataSet", "bd_accountview", queryBuilder.getSelectFields(), globalShareFilters.toArray(new QFilter[globalShareFilters.size()]));
            useRangeDataSet = orm.queryDataSet("AccountTreeList#idFilterDataSet", "bd_accountview", queryBuilder.getSelectFields(), useRangeFilters.toArray(new QFilter[useRangeFilters.size()]));
            DataSet idDataSet = ctrlstrategyDataSet.union((DataSet)useRangeDataSet).orderBy(queryBuilder.getOrderBys().split(","));
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>(8);
            ArrayList<Long> queryIds = new ArrayList<Long>(limit);
            int index = 0;
            for (Row row2 : idDataSet) {
                Long id = row2.getLong("id");
                if (!ids.add(id)) continue;
                if (index >= start && queryIds.size() < limit) {
                    queryIds.add(id);
                }
                ++index;
            }
            QFilter idFilter = new QFilter("id", "in", queryIds);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(idFilter);
            queryBuilder.setFilters(idFilter.toArray());
            this.setQFilters(filterList);
            dyos = super.getData(0, limit);
            this.getQueryResult().setBillDataCount(index);
            this.getQueryResult().setDataCount(index);
            this.view.getPageCache().put(KEY_CACHE_ACCOUNT_LIST_COUNT, String.valueOf(index));
        } else {
            if (DebugTrace.enable()) {
                LOGGER.info("=====AccountTreeList_AccListDataProvier_orgIdStr:{}=====", (Object)"orgIdStr is null");
            }
            dyos = super.getData(start, limit);
        }
        HashMap<Long, DynamicObject> accountsMap = new HashMap<Long, DynamicObject>();
        if (!dyos.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)dyos.get(0)).getDynamicObjectType().getProperties();
            boolean needAddacitemhelp = true;
            for (IDataEntityProperty property : properties) {
                if (!property.getName().equals("acitemhelp")) continue;
                needAddacitemhelp = false;
            }
            if (needAddacitemhelp) {
                properties.add((Object)new DynamicSimpleProperty("acitemhelp", String.class, null));
            }
        }
        MainEntityType dataEntityType = (MainEntityType)dyos.getDynamicCollectionItemPropertyType();
        for (DynamicObject dyo : dyos) {
            accountsMap.put(dyo.getLong("id"), dyo);
        }
        if (accountsMap.isEmpty()) {
            return dyos;
        }
        QFilter idf = new QFilter("id", "in", accountsMap.keySet());
        if (dataEntityType.findProperty(STRUCTFIELDS[0]) != null) {
            HashMap<Long, List> currencyMap = new HashMap<Long, List>();
            dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,acctcurrency,currencyentry.currency currencyid,currencyentry.currency.name currname", (QFilter[])new QFilter[]{idf}, (String)"currencyentry.seq");
            useRangeDataSet = null;
            try {
                while (dt.hasNext()) {
                    row3 = dt.next();
                    long id = row3.getLong("id");
                    String acctcurrency = row3.getString("acctcurrency");
                    List currs = currencyMap.computeIfAbsent(id, f -> new ArrayList());
                    if (acctcurrency == null) continue;
                    if ("descurrency".equals(acctcurrency)) {
                        String currname = row3.getString("currname");
                        if (StringUtils.isEmpty((CharSequence)currname)) {
                            currs.add(" ");
                            continue;
                        }
                        currs.add(currname);
                        continue;
                    }
                    if (!"allcurrency".equals(acctcurrency) || !currs.isEmpty()) continue;
                    currs.add(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"AccountTreeList_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable row3) {
                useRangeDataSet = row3;
                throw row3;
            }
            finally {
                if (dt != null) {
                    if (useRangeDataSet != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row3) {
                            useRangeDataSet.addSuppressed(row3);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            for (Map.Entry entry2 : accountsMap.entrySet()) {
                long id = (Long)entry2.getKey();
                acct = (DynamicObject)entry2.getValue();
                List currs = (List)currencyMap.get(id);
                if (currs == null) continue;
                this.structureField(currs, acct, STRUCTFIELDS[0]);
            }
        }
        if (dataEntityType.findProperty(STRUCTFIELDS[1]) != null) {
            asstactyMap = new HashMap<Long, List>();
            dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,checkitementry.asstactitem.name asstname", (QFilter[])new QFilter[]{idf}, (String)"checkitementry.seq");
            entry2 = null;
            try {
                while (dt.hasNext()) {
                    row3 = dt.next();
                    long id = row3.getLong("id");
                    String asstname = row3.getString("asstname");
                    assgrps = asstactyMap.computeIfAbsent(id, f -> new ArrayList());
                    if (asstname == null || asstname.isEmpty()) continue;
                    assgrps.add(asstname);
                }
            }
            catch (Throwable row4) {
                entry2 = row4;
                throw row4;
            }
            finally {
                if (dt != null) {
                    if (entry2 != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row4) {
                            ((Throwable)((Object)entry2)).addSuppressed(row4);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            for (Map.Entry entry2 : accountsMap.entrySet()) {
                long id = (Long)entry2.getKey();
                acct = (DynamicObject)entry2.getValue();
                List assgrps2 = (List)asstactyMap.get(id);
                if (assgrps2 == null) continue;
                this.structureField(assgrps2, acct, STRUCTFIELDS[1]);
            }
        }
        if (dataEntityType.findProperty("acitemhelp") != null) {
            asstactyMap = new HashMap();
            dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,checkitementry.asstactitem.name asstname", (QFilter[])new QFilter[]{idf, new QFilter("checkitementry.enaccheck", "=", (Object)true)}, (String)"checkitementry.seq");
            entry2 = null;
            try {
                while (dt.hasNext()) {
                    row3 = dt.next();
                    long id = row3.getLong("id");
                    String asstname = row3.getString("asstname");
                    assgrps = asstactyMap.computeIfAbsent(id, f -> new ArrayList());
                    if (asstname == null || asstname.isEmpty()) continue;
                    assgrps.add(asstname);
                }
            }
            catch (Throwable row5) {
                entry2 = row5;
                throw row5;
            }
            finally {
                if (dt != null) {
                    if (entry2 != null) {
                        try {
                            dt.close();
                        }
                        catch (Throwable row5) {
                            ((Throwable)((Object)entry2)).addSuppressed(row5);
                        }
                    } else {
                        dt.close();
                    }
                }
            }
            for (Map.Entry entry2 : accountsMap.entrySet()) {
                long id = (Long)entry2.getKey();
                acct = (DynamicObject)entry2.getValue();
                List assgrps3 = (List)asstactyMap.get(id);
                if (assgrps3 == null) continue;
                this.structureField(assgrps3, acct, "acitemhelp");
            }
        }
        return dyos;
    }

    private void structureField(List<String> assgrps, DynamicObject acct, String fieldName) {
        if (!assgrps.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String str : assgrps) {
                if (sb.length() != 0) {
                    sb.append('\\');
                }
                sb.append(str);
            }
            acct.set(fieldName, (Object)sb.toString());
        }
    }

    public int getMaxCount() {
        String count = this.view.getPageCache().get(KEY_CACHE_ACCOUNT_LIST_COUNT);
        if (StringUtils.isEmpty((CharSequence)count)) {
            return super.getMaxCount();
        }
        return Integer.parseInt(count);
    }
}

