/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.orm.query.QFilter;

public class AccountQueryOptimizer {
    private List<QFilter> qFilters;
    private boolean isMatched = false;
    private List<QFilter> otherQFilters;
    private String orgIdStr = null;
    private static Pattern pattern = Pattern.compile("\\s*\\(ctrlstrategy\\s*=\\s*'5'\\s*AND\\s*status\\s*=\\s*'C'\\s*OR\\s*id\\s*in\\s*\\(\\s*\\(\\s*select\\s*fdataid\\s*from\\s*T_BD_Account_U\\s*where\\s*fuseorgid\\s*=\\s*(\\d*)\\s*\\)\\s*\\)\\s*\\)");

    public AccountQueryOptimizer(List<QFilter> qFilters) {
        this.qFilters = qFilters;
    }

    public void check() {
        Optional<QFilter> patternFilter;
        if (this.qFilters != null && !this.qFilters.isEmpty() && (patternFilter = this.qFilters.stream().filter(filter -> Objects.nonNull(filter) && pattern.matcher(filter.toString()).find()).findFirst()).isPresent()) {
            Matcher matcher = pattern.matcher(patternFilter.get().toString());
            matcher.find();
            this.orgIdStr = matcher.group(1);
            this.otherQFilters = new ArrayList<QFilter>(this.qFilters.size());
            this.otherQFilters.addAll(this.qFilters);
            this.otherQFilters.remove(patternFilter.get());
            this.isMatched = true;
        }
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public List<QFilter> getOtherQFilters() {
        return this.otherQFilters;
    }

    public String getOrgIdStr() {
        return this.orgIdStr;
    }
}

