/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountCheckListDataProvider
extends ListDataProvider {
    private static final String CURRENCY_HELP = "currencyhelp";
    private static final String CHECKITEM_HELP = "checkitemhelp";

    public void setListFields(List<ListField> listFields) {
        super.setListFields(listFields);
        List keys = listFields.stream().map(ListField::getFieldName).collect(Collectors.toList());
        if (!keys.contains(CURRENCY_HELP)) {
            ListField listField = new ListField(CURRENCY_HELP);
            listField.setFieldName(CURRENCY_HELP);
            listFields.add(listField);
        } else if (!keys.contains(CHECKITEM_HELP)) {
            ListField listField = new ListField(CHECKITEM_HELP);
            listField.setFieldName(CHECKITEM_HELP);
            listFields.add(listField);
        }
    }

    public DynamicObjectCollection getData(int start, int limit) {
        long id;
        DynamicObjectCollection dyos = super.getData(start, limit);
        HashMap<Long, DynamicObject> accountsMap = new HashMap<Long, DynamicObject>(32);
        MainEntityType dataEntityType = (MainEntityType)dyos.getDynamicObjectType();
        if (!dyos.isEmpty()) {
            Iterator properties = ((DynamicObject)dyos.get(0)).getDynamicObjectType().getProperties();
            boolean needAddCurrencyhelp = true;
            boolean needAddCheckitemhelp = true;
            if (properties.stream().anyMatch(iDataEntityProperty -> CURRENCY_HELP.equals(iDataEntityProperty.getName()))) {
                needAddCurrencyhelp = false;
            }
            if (properties.stream().anyMatch(iDataEntityProperty -> CHECKITEM_HELP.equals(iDataEntityProperty.getName()))) {
                needAddCheckitemhelp = false;
            }
            if (needAddCurrencyhelp) {
                properties.add(new DynamicSimpleProperty(CURRENCY_HELP, String.class, null));
            }
            if (needAddCheckitemhelp) {
                properties.add(new DynamicSimpleProperty(CHECKITEM_HELP, String.class, null));
            }
        }
        for (DynamicObject dyo : dyos) {
            accountsMap.put(dyo.getLong("accountid_Id"), dyo);
        }
        if (accountsMap.isEmpty()) {
            return dyos;
        }
        QFilter idf = new QFilter("id", "in", accountsMap.keySet());
        if (dataEntityType.findProperty(CURRENCY_HELP) != null) {
            HashMap<Long, List> currencyMap = new HashMap<Long, List>(8);
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,acctcurrency,currencyentry.currency currencyid,currencyentry.currency.name currname", (QFilter[])new QFilter[]{idf}, (String)"currencyentry.seq");){
                while (dt.hasNext()) {
                    Row row = dt.next();
                    id = row.getLong("id");
                    String acctcurrency = row.getString("acctcurrency");
                    List currs = currencyMap.computeIfAbsent(id, f -> new ArrayList());
                    if (acctcurrency == null) continue;
                    if ("descurrency".equals(acctcurrency)) {
                        String currname = row.getString("currname");
                        if (StringUtils.isEmpty((CharSequence)currname)) {
                            currs.add(" ");
                            continue;
                        }
                        currs.add(currname);
                        continue;
                    }
                    if (!"allcurrency".equals(acctcurrency) || !currs.isEmpty()) continue;
                    currs.add(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"AccountTreeList_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                }
            }
            for (Throwable dyo2 : dyos) {
                long id2 = dyo2.getLong("accountid_Id");
                List currs = (List)currencyMap.get(id2);
                if (currs == null) continue;
                this.structureField(currs, (DynamicObject)dyo2, CURRENCY_HELP);
            }
        }
        if (dataEntityType.findProperty(CHECKITEM_HELP) != null) {
            Throwable dyo2;
            HashMap<Long, List> asstactyMap = new HashMap<Long, List>(8);
            dyo2 = null;
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id,checkitementry.asstactitem.name asstname", (QFilter[])new QFilter[]{idf}, (String)"checkitementry.seq");){
                while (dt.hasNext()) {
                    Row row = dt.next();
                    id = row.getLong("id");
                    String asstname = row.getString("asstname");
                    List assgrps = asstactyMap.computeIfAbsent(id, f -> new ArrayList());
                    if (asstname == null || asstname.isEmpty()) continue;
                    assgrps.add(asstname);
                }
            }
            catch (Throwable row) {
                dyo2 = row;
                throw row;
            }
            for (Throwable dyo2 : dyos) {
                long id3 = dyo2.getLong("accountid_Id");
                List assgrps = (List)asstactyMap.get(id3);
                if (assgrps == null) continue;
                this.structureField(assgrps, (DynamicObject)dyo2, CHECKITEM_HELP);
            }
        }
        return dyos;
    }

    protected void structureField(List<String> assgrps, DynamicObject acct, String fieldName) {
        if (!assgrps.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String str : assgrps) {
                if (sb.length() != 0) {
                    sb.append('\\');
                }
                sb.append(str);
            }
            acct.set(fieldName, (Object)sb.toString());
        }
    }
}

