/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class AccountCheckProcessFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String LIST_NAME = "listname";
    private boolean canClose = false;
    private static final String CLOSE_CONFIRMED = "close_confirmed";
    private static final String PROGRESS_BARAP = "progressbarap";
    private JobFormInfo jobFormInfo;

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam("check_jobinfo");
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
            }
        }
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.putTaskId(taskId);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinish();
        this.setFinish(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            String errMsg = ResManager.loadKDString((String)"\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AccountCheckTask_1", (String)"fi-bd-formplugin", (Object[])new Object[0]);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            this.getView().showErrorNotification(errMsg);
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                this.returnResult(taskInfo);
            }
            e.setProgress(100);
            this.stopBar();
            this.close();
        }
    }

    private void close() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            String msg = ResManager.loadKDString((String)"\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"AccountCheckTask_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().showLoading(new LocaleString(msg));
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkpanel"});
        } else if ("btnok".equals(controlKey)) {
            this.stopBar();
            this.toBackground();
        }
    }

    private void toBackground() {
        this.close();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
                ThreadService.execute((Runnable)subscriber, (TaskType)TaskType.GL_REPORT_EXPORT_ALL_BACKGROUND_MONITOR);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (!this.isStart()) {
            e.setCancel(true);
        } else if (!this.canClose && !this.isFinish() && StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u68c0\u67e5\uff1f", (String)"AccountCheckTask_4", (String)"fi-bd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_CONFIRMED, (IFormPlugin)this));
            this.stopBar();
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label title = (Label)this.getControl(LIST_NAME);
        String text = ResManager.loadKDString((String)"\u6b63\u5728\u5168\u91cf\u68c0\u67e5\u4e2d\uff0c\u5b8c\u6210\u540e\u82e5\u53d1\u73b0\u4e0d\u7b26\u7ba1\u63a7\u7684\u79d1\u76ee\u6570\u636e\uff0c\u5219\u5217\u8868\u4f1a\u5c55\u793a\u7ed3\u679c\u3002", (String)"AccountCheckTask_5", (String)"fi-bd-formplugin", (Object[])new Object[0]);
        title.setText(text);
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESS_BARAP);
            bar.setPercent(progress);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else {
            this.doStop();
        }
    }

    private void doStop() {
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"AccountCheckTask_6", (String)"bos-export", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.setStart(true);
            ScheduleServiceHelper.stopTask((String)taskId);
            TaskClientProxy.suspend((JobFormInfo)this.getJobFormInfo(), (String)taskId);
            this.close();
        }
    }

    private boolean isStart() {
        return this.getPageCache().get("isstart") == null ? false : Boolean.parseBoolean(this.getPageCache().get("isstart"));
    }

    private void setStart(boolean isStart) {
        this.getPageCache().put("isstart", String.valueOf(isStart));
    }

    private boolean isFinish() {
        return this.getPageCache().get("isfinish") == null ? false : Boolean.parseBoolean(this.getPageCache().get("isfinish"));
    }

    private void setFinish(boolean isFinish) {
        this.getPageCache().put("isfinish", String.valueOf(isFinish));
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("check_taskid", taskId);
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("check_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("check_taskid") : this.getPageCache().get("check_taskid");
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        bar.stop();
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = AccountCheckProcessFormPlugin.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }
}

