/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.bd.accounthealth.CheckContext;
import kd.fi.bd.accounthealth.accountrepair.repair.AccountRepairContext;
import kd.fi.bd.accounthealth.impl.AccountCheckServiceImpl;
import kd.fi.bd.accounthealth.util.SXSSFWorkbookUtils;
import kd.fi.bd.accounthealth.vo.AccountRepairResVO;
import kd.fi.bd.business.BDGLServiceFactory;
import kd.fi.bd.business.service.accountrepair.AccountRepairCommonService;
import kd.fi.bd.business.vo.AccountHealthLogEntryVO;
import kd.fi.bd.business.vo.AccountHealthLogVO;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.enums.AccountPropCategory;
import kd.fi.bd.enums.ExeState;
import kd.fi.bd.formplugin.consts.FormpluginResource;
import kd.fi.bd.interfaces.service.AccountHealthLogService;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.POIUtils;
import kd.fi.bd.vo.OrgVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AccountRepairConfirmPlugin
extends AbstractFormPlugin {
    private static final String DOWN_LOAD_DETAIL = "download_detail";
    private static final String CONTINUT_SAVE = "continue_save";
    private static final String KEY_LABELAP = "labelap";
    private List<AccountRepairResVO> workOuterToExcelInfoList = new ArrayList<AccountRepairResVO>(8);
    private static final String TYPE_REPAIR = "1";
    private AccountHealthLogService accountHealthLogService = (AccountHealthLogService)BDGLServiceFactory.getService(AccountHealthLogService.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{DOWN_LOAD_DETAIL, CONTINUT_SAVE, "btncancel"});
    }

    public void afterCreateNewData(EventObject evt) {
        Label labelap = (Label)this.getControl(KEY_LABELAP);
        String repairType = (String)this.getView().getFormShowParameter().getCustomParam("repair_type");
        if (StringUtils.isNotBlank((CharSequence)repairType) && repairType.equals(AccountPropCategory.ASST.getType())) {
            labelap.setText(ResManager.loadKDString((String)"\u7248\u672c\u5316\u4fee\u6539\u4f1a\u5168\u91cf\u4fee\u6539\u6240\u9009\u79d1\u76ee\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\u3001\u4e0b\u7ea7\u79d1\u76ee\u3002\u6b64\u64cd\u4f5c\u5f71\u54cd\u6781\u5927\u4e14\u4e0d\u53ef\u9006\uff0c\u8bf7\u5148\u4e0b\u8f7d\u660e\u7ec6\u67e5\u770b\u8be6\u60c5\uff0c\u518d\u8fdb\u884c\u786e\u8ba4\u3002", (String)"AccountRepairConfirmPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTINUT_SAVE});
            this.getView().getParentView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        boolean isRealRepair = key.equals(CONTINUT_SAVE);
        if (key.equals(DOWN_LOAD_DETAIL) || key.equals(CONTINUT_SAVE)) {
            Optional<String> url;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParam = formShowParameter.getCustomParams();
            if (CollectionUtils.isEmpty((Map)customParam)) {
                return;
            }
            Object selectRowIds = customParam.get("select_row_ids");
            Object repairType = customParam.get("repair_type");
            if (ObjectUtils.isEmpty(selectRowIds) || ObjectUtils.isEmpty(repairType)) {
                return;
            }
            boolean isRepairAssgrp = repairType.equals(AccountPropCategory.ASST.getType());
            Object version_date = customParam.get("version_date");
            List selectRowIdList = (List)selectRowIds;
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            AccountRepairContext ctx = new AccountRepairContext(selectRowIdList, repairType.toString(), Boolean.valueOf(isRealRepair), userID);
            if (Objects.nonNull(version_date)) {
                ctx.setVersionDate(DateUtils.stringToDate((String)version_date.toString(), (String)"yyyy-MM-dd"));
            }
            this.workOuterToExcelInfoList = AccountRepairCommonService.doRepair((AccountRepairContext)ctx);
            if (!CollectionUtils.isEmpty(this.workOuterToExcelInfoList) && isRealRepair) {
                Map<String, Tuple<Integer, Integer>> orgSummaryRes = this.calculateRes(this.workOuterToExcelInfoList);
                List<AccountHealthLogVO> healthLogVOList = this.generateLogList(ctx.getAccountTableId(), this.workOuterToExcelInfoList, orgSummaryRes);
                this.accountHealthLogService.saveLog(healthLogVOList);
            }
            if ((url = this.downloadDetail(ctx.getRealRepair(), repairType.toString())).isPresent()) {
                this.getPageCache().put("afterDownloadUrl", url.get());
                if (!isRealRepair) {
                    this.getView().download(url.get());
                    if (isRepairAssgrp) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{CONTINUT_SAVE});
                    }
                }
            } else if (!isRealRepair) {
                String notes = ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u79d1\u76ee\u6570\u636e\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u9700\u8fdb\u884c\u4fee\u6539\uff0c\u8bf7\u70b9\u51fb\u53d6\u6d88\u56de\u5230\u5217\u8868\uff0c\u91cd\u65b0\u8fdb\u884c\u5168\u91cf\u68c0\u67e5\u3002", (String)"AccountRepairConfirmPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(notes);
                return;
            }
            if (!isRealRepair) {
                return;
            }
            this.reCheck(ctx);
            List repairFailddAccs = this.workOuterToExcelInfoList.stream().filter(x -> BDCommonResource.getFailedText().equals(x.getResultStatus())).collect(Collectors.toList());
            int failedCount = CollectionUtils.isEmpty(repairFailddAccs) ? 0 : repairFailddAccs.size();
            List repairSuccessAccs = this.workOuterToExcelInfoList.stream().filter(x -> BDCommonResource.getSuccessText().equals(x.getResultStatus())).collect(Collectors.toList());
            int successCount = CollectionUtils.isEmpty(repairSuccessAccs) ? 0 : repairSuccessAccs.size();
            String resultSummary = AccountPropCategory.ASST.getType().equals(String.valueOf(repairType)) ? ResManager.loadKDString((String)"\u5df2\u7248\u672c\u5316\u4fee\u6539\u6210\u529f%1$s\u4e2a\u79d1\u76ee\uff0c\u5931\u8d25%2$s\u4e2a\u79d1\u76ee\u3002", (String)"AccountRepairConfirmPlugin_7", (String)"fi-bd-formplugin", (Object[])new Object[]{successCount, failedCount}) : ResManager.loadKDString((String)"\u5df2\u7ecf\u4fee\u6539\u6210\u529f%1$s\u4e2a\u79d1\u76ee\uff0c\u5931\u8d25%2$s\u4e2a\u79d1\u76ee\u3002", (String)"AccountRepairConfirmPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[]{successCount, failedCount});
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            ConfirmTypes confirmTypes = ConfirmTypes.Default;
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("after_repair_save_confirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
            btnNameMaps.put(6, FormpluginResource.getQueryLog());
            btnNameMaps.put(7, FormpluginResource.getCancelText());
            this.getView().showConfirm(resultSummary, "", options, confirmTypes, callBackListener, btnNameMaps);
            this.getPageCache().put("repair_type", String.valueOf(repairType));
            this.workOuterToExcelInfoList.clear();
            this.writeOpLog(ctx);
        }
    }

    protected Map<String, Tuple<Integer, Integer>> calculateRes(List<AccountRepairResVO> workOuterToExcelInfoList) {
        Map<String, List<AccountRepairResVO>> workInfoMapGroupByOrg = workOuterToExcelInfoList.stream().collect(Collectors.groupingBy(AccountRepairResVO::getUseOrgInfo));
        HashMap<String, Tuple<Integer, Integer>> orgResCountMap = new HashMap<String, Tuple<Integer, Integer>>(8);
        for (Map.Entry<String, List<AccountRepairResVO>> entry : workInfoMapGroupByOrg.entrySet()) {
            Tuple<Integer, Integer> count = this.countNum(entry.getValue());
            orgResCountMap.put(entry.getKey(), count);
        }
        return orgResCountMap;
    }

    protected Tuple<Integer, Integer> countNum(List<AccountRepairResVO> workInfos) {
        int success = 0;
        int failed = 0;
        for (AccountRepairResVO workInfo : workInfos) {
            String state = workInfo.getResultStatus();
            if (BDCommonResource.getSuccessText().equals(state)) {
                ++success;
            }
            if (!BDCommonResource.getFailedText().equals(state)) continue;
            ++failed;
        }
        return new Tuple((Object)success, (Object)failed);
    }

    protected List<AccountHealthLogVO> generateLogList(long accountTableId, List<AccountRepairResVO> workOuterToExcelInfoList, Map<String, Tuple<Integer, Integer>> orgSummaryRes) {
        ArrayList<AccountHealthLogVO> logList = new ArrayList<AccountHealthLogVO>(8);
        long userId = ContextUtil.getUserId();
        String requestId = RequestContext.get().getRequestId();
        this.getPageCache().put("log_request_id", requestId);
        for (Map.Entry<String, Tuple<Integer, Integer>> entry : orgSummaryRes.entrySet()) {
            AccountHealthLogVO logVO = new AccountHealthLogVO();
            logVO.setOrgId(Long.valueOf(entry.getKey()));
            logVO.setAccountTableId(Long.valueOf(accountTableId));
            logVO.setCreateTime(new Date());
            logVO.setCreater(Long.valueOf(userId));
            logVO.setRequestId(requestId);
            logVO.setOpType(TYPE_REPAIR);
            logVO.setExeResult(ResManager.loadKDString((String)"\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", (String)"AccountRepairConfirmPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[]{entry.getValue().item1, entry.getValue().item2}));
            List currentOrgWorkList = workOuterToExcelInfoList.stream().filter(vo -> vo.getUseOrgInfo().equals(entry.getKey())).collect(Collectors.toList());
            int seq = 1;
            ArrayList<AccountHealthLogEntryVO> entryVOList = new ArrayList<AccountHealthLogEntryVO>(8);
            for (AccountRepairResVO repairResVO : currentOrgWorkList) {
                AccountHealthLogEntryVO entryVO = new AccountHealthLogEntryVO();
                entryVO.setSeq(seq++);
                entryVO.setAcctNumber(repairResVO.getAccNumber());
                entryVO.setCategories(this.dealCategories(repairResVO.getRepairAccInfo(), repairResVO.getQty()));
                entryVO.setDescription(repairResVO.getDesc());
                entryVO.setExeState(this.getStateValue(repairResVO.getResultStatus()));
                entryVO.setRepairAccId(repairResVO.getRepairAccId());
                entryVO.setVersionDate(repairResVO.getVersionDate());
                entryVOList.add(entryVO);
            }
            logVO.setHealthLogEntryVOList(entryVOList);
            logList.add(logVO);
        }
        return logList;
    }

    protected String dealCategories(String repairAccInfo, String qty) {
        if (StringUtils.isEmpty((CharSequence)qty)) {
            return repairAccInfo;
        }
        if (StringUtils.isEmpty((CharSequence)repairAccInfo)) {
            return ResManager.loadKDString((String)"\u6570\u91cf\u6838\u7b97\uff1a%s", (String)"AccountRepairConfirmPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[]{qty});
        }
        return repairAccInfo + "\r\n" + ResManager.loadKDString((String)"\u6570\u91cf\u6838\u7b97\uff1a%s", (String)"AccountRepairConfirmPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[]{qty});
    }

    protected String getStateValue(String status) {
        if (BDCommonResource.getFailedText().equals(status)) {
            return ExeState.FAIL.getValue();
        }
        if (BDCommonResource.getSuccessText().equals(status)) {
            return ExeState.SUCCESS.getValue();
        }
        return ExeState.SKIP.getValue();
    }

    private void writeOpLog(AccountRepairContext ctx) {
        String opKey = "accountHealthCheck";
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u79d1\u76ee\u5065\u5eb7\u5de1\u68c0", "AccountRepairConfirmPlugin_3", "fi-bd-formplugin");
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(8);
        String appNum = EntityMetadataCache.getDataEntityType((String)"bd_account_checkresult").getAppId();
        String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
        Map treeNodeMap = BiTreeNode.toMap((BiTreeNode)ctx.getTreeNode());
        Iterator iterator = ctx.getNeedRepairOrgIds().iterator();
        while (iterator.hasNext()) {
            long orgId = (Long)iterator.next();
            String descParam = ((OrgVO)((BiTreeNode)treeNodeMap.get(orgId)).getData()).getName();
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u63cf\u8ff0\uff1a\u5df2\u4fee\u6539\u7ec4\u7ec7\uff08%s\uff09\u6240\u9009\u79d1\u76ee\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u4e0b\u7ea7\u79d1\u76ee\u3002", "AccountRepairConfirmPlugin_4", "fi-bd-formplugin");
            AppLogInfo appLogInfo = this.buildLogInfo(opDescBridge, opKey, opNameBridge, orgId, "bd_account_checkresult", appId, descParam);
            appLogInfoList.add(appLogInfo);
        }
        LogServiceHelper.addBatchLog(appLogInfoList);
    }

    private void reCheck(AccountRepairContext ctx) {
        CheckContext context = new CheckContext(ctx.getAccountTableId().longValue(), ctx.getNeedRepairOrgIds());
        AccountCheckServiceImpl accountCheckService = new AccountCheckServiceImpl(context);
        accountCheckService.check();
    }

    private Optional<String> downloadDetail(boolean isRealRepair, String repairType) {
        if (isRealRepair) {
            return Optional.empty();
        }
        if (!CollectionUtils.isEmpty(this.workOuterToExcelInfoList)) {
            List repairFailddAccs = this.workOuterToExcelInfoList.stream().filter(x -> !x.getResultStatus().equals(BDCommonResource.getSuccessText())).collect(Collectors.toList());
            boolean isAllSuccess = CollectionUtils.isEmpty(repairFailddAccs);
            if (isRealRepair && isAllSuccess) {
                return Optional.empty();
            }
            String url = POIUtils.getDownloadUrl((SXSSFWorkbook)SXSSFWorkbookUtils.fillDetailResultWorkbook(this.workOuterToExcelInfoList, (boolean)isRealRepair, (String)repairType), (String)SXSSFWorkbookUtils.generateFileName());
            return Optional.of(url);
        }
        return Optional.empty();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("after_repair_save_confirm")) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                ListShowParameter param = new ListShowParameter();
                param.setBillFormId("bd_accounthealth_log");
                param.setFormId("bos_list");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                String requestId = this.getPageCache().get("log_request_id") == null ? "" : this.getPageCache().get("log_request_id");
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
                filterList.add(new QFilter("requestid", "=", (Object)requestId));
                filterList.add(new QFilter("optype", "=", (Object)TYPE_REPAIR));
                listFilterParameter.setQFilters(filterList);
                param.setListFilterParameter(listFilterParameter);
                if (this.getPageCache().get("repair_type").equals(AccountPropCategory.ASST.getType())) {
                    this.getView().getParentView().getParentView().showForm((FormShowParameter)param);
                    this.getView().getParentView().getParentView().invokeOperation("refresh");
                    this.getView().getParentView().close();
                } else {
                    this.getView().getParentView().showForm((FormShowParameter)param);
                    this.getView().getParentView().invokeOperation("refresh");
                }
                this.getView().close();
            } else {
                if (this.getPageCache().get("repair_type").equals(AccountPropCategory.ASST.getType())) {
                    this.getView().getParentView().getParentView().invokeOperation("refresh");
                    this.getView().getParentView().close();
                } else {
                    this.getView().getParentView().invokeOperation("refresh");
                }
                this.getView().close();
            }
            return;
        }
    }

    private AppLogInfo buildLogInfo(MultiLangEnumBridge opDescBridge, String opKey, MultiLangEnumBridge opNameBridge, long orgId, String entityId, String appId, String ... descParams) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(entityId);
        appLogInfo.setOpDesc(opDescBridge, descParams);
        appLogInfo.setOpName(opKey, opNameBridge);
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOrgID(Long.valueOf(orgId));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setModifyContentTag(opDescBridge.getDescription());
        return appLogInfo;
    }
}

