/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.formplugin.account.check.event.OrgChangeTypeEnum;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;

public class OrgEnableEventBDRecordServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(OrgEnableEventBDRecordServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        boolean isOpen;
        if (DebugTrace.enable()) {
            logger.info("OrgEnableEvent,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        }
        if (!(isOpen = BillParamUtil.getBooleanValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.healthcheck", (boolean)false))) {
            return null;
        }
        try {
            if (evt instanceof EntityEvent) {
                EntityEvent event = (EntityEvent)evt;
                List ids = event.getBusinesskeys();
                this.saveOrgRecords(ids);
            }
        }
        catch (Exception e) {
            logger.error("OrgEnableEvent error:", (Throwable)e);
        }
        return evt.getEventId();
    }

    protected void saveOrgRecords(List<String> ids) {
        ArrayList<DynamicObject> orgRecordList = new ArrayList<DynamicObject>(8);
        Date date = new Date();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                DynamicObject orgChangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_org_changeinfo");
                orgChangeInfo.set("org", (Object)Long.parseLong(id));
                orgChangeInfo.set("createtime", (Object)date);
                orgChangeInfo.set("type", (Object)OrgChangeTypeEnum.ENABLE.getType());
                orgRecordList.add(orgChangeInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])orgRecordList.toArray(new DynamicObject[0]));
    }
}

