/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.account.check.event;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.event.AbstractOrgEventServicePlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.formplugin.account.check.event.OrgChangeTypeEnum;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;

public class OrgUnfreezeEventBDRecordServicePlugin
extends AbstractOrgEventServicePlugin {
    private static final Log logger = LogFactory.getLog(OrgUnfreezeEventBDRecordServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        boolean isOpen;
        if (DebugTrace.enable()) {
            logger.info("OrgUnfreezeEvent,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        }
        if (!(isOpen = BillParamUtil.getBooleanValue((String)"P9H6JC5EVP1", (String)"fi.bd.account.healthcheck", (boolean)false))) {
            return null;
        }
        try {
            JSONObject params = this.getBecEventOperationParams(evt);
            if (params == null) {
                return null;
            }
            List<Long> ids = this.getChangedData(params, "update");
            this.saveOrgRecords(ids);
        }
        catch (Exception e) {
            logger.error("OrgUnfreezeEvent error:", (Throwable)e);
        }
        return evt.getEventId();
    }

    protected void saveOrgRecords(List<Long> ids) {
        ArrayList<DynamicObject> orgRecordList = new ArrayList<DynamicObject>(8);
        Date date = new Date();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                DynamicObject orgChangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_org_changeinfo");
                orgChangeInfo.set("org", (Object)id);
                orgChangeInfo.set("createtime", (Object)date);
                orgChangeInfo.set("type", (Object)OrgChangeTypeEnum.FUNCTION_UNFREEZE.getType());
                orgRecordList.add(orgChangeInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])orgRecordList.toArray(new DynamicObject[0]));
    }

    private List<Long> getChangedData(JSONObject params, String operation) {
        JSONObject opJson = params.getJSONObject(operation);
        ArrayList<Long> ids = new ArrayList<Long>(8);
        if (opJson == null) {
            return ids;
        }
        Set entries = opJson.entrySet();
        for (Map.Entry orgEntry : entries) {
            JSONObject idJson = (JSONObject)orgEntry.getValue();
            JSONObject entityJson = idJson.getJSONObject("structure");
            if (entityJson == null) continue;
            long id = Long.parseLong((String)orgEntry.getKey());
            this.getChangedProperty(id, entityJson, ids);
        }
        return ids;
    }

    private void getChangedProperty(long id, JSONObject entityJson, List<Long> ids) {
        JSONObject proJson = entityJson.getJSONObject("bizunfreeze");
        if (proJson == null || proJson.getJSONObject("10") == null) {
            return;
        }
        ids.add(id);
    }
}

