/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accountingsys;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.fi.bd.accsyscache.AccSysModelCacheService;
import kd.fi.bd.formplugin.model.OrgTreeSearchParam;
import kd.fi.bd.formplugin.utils.AccountingSysOrgTreeUtil;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.BatchProcessUtil;

public class AccountingSysAddViewEdit
extends AbstractFormPlugin
implements ClickListener,
TreeNodeCheckListener,
TreeNodeDragListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(AccountingSysAddViewEdit.class);
    private static final String BIZUNITTREE = "bizunittree";
    private static final String BIZVIEWTREE = "bizviewtree";
    private static final String ISCHECKUNITCHILD = "ischeckunitchild";
    private static final String ISCHECKORGCHILD = "ischeckorgchild";
    private static final String BTN_UNCHECKUNIT = "btn_uncheckunit";
    private static final String BTN_ADDNODE = "btn_addnode";
    private static final String BTN_DELETENODE = "btn_deletenode";
    private static final String CACHEKEY_UNIT_ROOT = "unittreenode";
    private static final String CACHEKEY_VIEW_ROOT = "viewtreenode";
    private static final String CACHEKEY_FILTER_VALUE = "filterValue";
    private static final String BD_ACCOUNTINGSYSVIEWSCH = "bd_accountingsysviewsch";
    private TreeView bizunittree;
    private TreeView bizviewtree;

    public void initialize() {
        super.initialize();
        this.bizunittree = (TreeView)this.getView().getControl(BIZUNITTREE);
        this.bizviewtree = (TreeView)this.getView().getControl(BIZVIEWTREE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ISCHECKUNITCHILD, BTN_UNCHECKUNIT, BTN_ADDNODE, BTN_DELETENODE});
        this.bizunittree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizviewtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizunittree.addTreeNodeDragListener((TreeNodeDragListener)this);
        this.bizviewtree.addTreeNodeDragListener((TreeNodeDragListener)this);
        this.bizviewtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.bizunittree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        orgsearchap.addEnterListener((SearchEnterListener)this);
        Search viewsearchap = (Search)this.getView().getControl("viewsearchap");
        viewsearchap.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "ischeckunitchild": {
                break;
            }
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_deletenode": {
                this.deleteNode();
                break;
            }
            case "clear": {
                TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(new TreeNode(bizTree.getParentid(), bizTree.getId(), bizTree.getText()));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        boolean islegal;
        super.afterBindData(e);
        if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap", "orgproperty", "patterntype", "labelpt"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ismainview"});
        }
        if (islegal = this.getIslegal()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap", "orgproperty"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"patterntype", "labelpt"});
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            Long id = this.getModel().getDataEntity().getLong("id");
            this.showTreeView(id, AccountingSysUtil.getDefaultViewSchemaInfoId(), true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        QFilter qf = null;
        String filterValue = "";
        if ("orgproperty".equals(name)) {
            changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue != null) {
                filterValue = newValue.getString("name");
                qf = new QFilter("org.orgpattern.name", "=", (Object)filterValue);
            }
            this.filterProperty(filterValue, qf);
        }
        if ("patterntype".equals(name)) {
            changeData = e.getChangeSet()[0];
            filterValue = (String)changeData.getNewValue();
            if (StringUtils.isNotBlank((CharSequence)filterValue)) {
                qf = new QFilter("org.orgpattern.patterntype", "=", (Object)filterValue);
            }
            this.filterProperty(filterValue, qf);
        }
    }

    private void filterProperty(String filterValue, QFilter qFilter) {
        this.bizunittree.deleteAllNodes();
        this.getPageCache().put(CACHEKEY_FILTER_VALUE, filterValue);
        String def = this.getPageCache().get("mainViewId");
        Map unitTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)Long.parseLong(def), (QFilter)qFilter, (boolean)false);
        Map allTreeMap = AccountingSysUtil.getAllOrgByViewIdIncludeDisable((Long)Long.parseLong(def));
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), allTreeMap.get(tree.getId()));
            }
            unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
            flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put(CACHEKEY_UNIT_ROOT, SerializationUtils.toJsonString((Object)unitRoot));
        AccountingSysOrgTreeUtil.removeAllSearchTreeNodeCache(this.getPageCache());
    }

    private void getInfo(Map<String, Map<String, String>> unitTreeMap, Map<String, Map<String, String>> allTreeMap) {
        for (Map.Entry<String, Map<String, String>> unitTree : unitTreeMap.entrySet()) {
            Map<String, String> map = allTreeMap.get(unitTree.getKey());
            unitTreeMap.get(unitTree.getKey()).put("parentid", this.getParent(map.get("id"), allTreeMap, unitTreeMap));
        }
    }

    private String getParent(String key, Map<String, Map<String, String>> allTreeMap, Map<String, Map<String, String>> unitTreeMap) {
        String parent = "";
        while (StringUtils.isBlank((CharSequence)parent)) {
            Map<String, String> map = allTreeMap.get(key);
            if (null == map) {
                TreeNode treeNode = AccountingSysUtil.createTreeNode(unitTreeMap);
                if (null == treeNode) {
                    parent = String.valueOf(OrgUnitServiceHelper.getRootOrgId());
                    continue;
                }
                parent = treeNode.getId();
                continue;
            }
            key = map.get("parentid");
            if (unitTreeMap.containsKey(key)) {
                parent = key;
                continue;
            }
            if (!"0".equals(key)) continue;
            parent = map.get("id");
        }
        return parent;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_save": {
                boolean islegal = (Boolean)this.getView().getParentView().getParentView().getModel().getValue("islegal");
                if (!islegal) break;
                TreeNode viewTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_VIEW_ROOT), TreeNode.class);
                HashMap<String, TreeNode> orgIdNodeMap = new HashMap<String, TreeNode>();
                HashSet leafOrgIdSet = new HashSet();
                AccountingSysOrgTreeUtil.preTravel(viewTreeNode, x -> {
                    if (CollectionUtils.isEmpty((Collection)x.getChildren())) {
                        leafOrgIdSet.add(Long.parseLong(x.getId()));
                    }
                    orgIdNodeMap.put(x.getId(), (TreeNode)x);
                });
                String viewId = this.getPageCache().get("mainViewId");
                Optional patternType = AccountingSysUtil.getNonlegalOrgName((Long)Long.parseLong(viewId), leafOrgIdSet);
                if (patternType.isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u4e0b\uff0c\u53f6\u5b50\u8282\u70b9\u7ec4\u7ec7\u7684\u4e1a\u52a1\u5355\u5143\u7c7b\u578b\u4e0d\u80fd\u4e3a\u975e\u6cd5\u4eba\u673a\u6784\u3002", (String)"AccountingSysAddViewEdit_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) break;
                if (leafOrgIdSet.size() > 20) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u89c6\u56fe\u7684\u53f6\u5b50\u8282\u70b9\u6700\u591a\u53ef\u5305\u542b20\u4e2a\u7ec4\u7ec7\u3002", (String)"AccountingSysAddViewEdit_10", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                ListMultimap<Integer, TreeNode> levelNodeMap = AccountingSysOrgTreeUtil.tagNodeWithLevel(viewTreeNode, orgIdNodeMap);
                if ((Integer)Collections.max(levelNodeMap.keySet()) <= 2) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u7684\u7edf\u8ba1\u89c6\u56fe\uff0c\u7ec4\u7ec7\u5c42\u7ea7\u6700\u591a\u4e3a2\u5c42\u3002", (String)"AccountingSysAddViewEdit_11", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            String errorMsg = this.checkBookRefer();
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
                return;
            }
            FormOperate source = (FormOperate)args.getSource();
            source.getOption().setVariableValue("viewschemanumber", this.getViewSchemaNumber());
            Map map = this.getView().getFormShowParameter().getCustomParams();
            if (StringUtils.isNotEmpty((CharSequence)((String)map.get("id")))) {
                source.getOption().setVariableValue("accountingsys_id", (String)map.get("id"));
            }
            ArrayList<String> rootnodeList = new ArrayList<String>(2);
            TreeNode viewTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_VIEW_ROOT), TreeNode.class);
            rootnodeList.add(viewTreeNode.getId());
            rootnodeList.add(viewTreeNode.getParentid());
            source.getOption().setVariableValue("rootnode", SerializationUtils.toJsonString(rootnodeList));
            LinkedHashMap<String, String> savenode = new LinkedHashMap<String, String>(16);
            List<OrgParam> orgParams = this.constructStruc(viewTreeNode);
            for (OrgParam orgParam : orgParams) {
                savenode.put(Long.toString(orgParam.getId()), Long.toString(orgParam.getParentId()));
            }
            if (savenode.size() > 0) {
                source.getOption().setVariableValue("savenode", SerializationUtils.toJsonString(savenode));
            }
            if (this.getPageCache().get("deletenode") != null) {
                source.getOption().setVariableValue("deletenode", this.getPageCache().get("deletenode"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.clearCahce();
    }

    private void clearCahce() {
        AccSysModelCacheService accSysModelCacheService = new AccSysModelCacheService();
        accSysModelCacheService.clear();
    }

    private String checkBookRefer() {
        DynamicObject oldModel;
        String result = "";
        IDataModel newModel = this.getModel();
        Long viewId = (Long)newModel.getValue("id");
        if (!viewId.equals(0L) && QueryServiceHelper.exists((String)BD_ACCOUNTINGSYSVIEWSCH, (QFilter[])new QFilter("id", "=", (Object)viewId).toArray()) && (oldModel = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)BD_ACCOUNTINGSYSVIEWSCH)).getBoolean("ismainview")) {
            if (!((Boolean)newModel.getValue("ismainview")).booleanValue()) {
                Set<String> referredOrgs = this.getReferredOrgs(this.getParamAccsysId(), viewId);
                if (!referredOrgs.isEmpty()) {
                    result = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u88ab\u8d26\u7c3f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\uff1a%s", (String)"AccountingSysAddViewEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), referredOrgs.toString());
                }
            } else {
                HashSet<Long> oldLeafOrgs = new HashSet<Long>(10);
                HashSet<Long> oldMiddleOrgs = new HashSet<Long>(10);
                Map<Long, Boolean> oldOrgs = this.getOrgInfoByViewId(viewId);
                Set<Long> oldOrgIds = oldOrgs.keySet();
                oldOrgs.forEach((k, v) -> {
                    if (v.booleanValue()) {
                        oldLeafOrgs.add((Long)k);
                    } else {
                        oldMiddleOrgs.add((Long)k);
                    }
                });
                HashSet newLeafOrgs = new HashSet(10);
                HashSet newMiddleOrgs = new HashSet(10);
                HashSet newOrgIds = new HashSet(10);
                TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
                List<TreeNode> viewAllNodes = this.getAllChildrenAndSelf(viewRoot);
                viewAllNodes.forEach(n -> {
                    Long orgId = Long.valueOf(n.getId());
                    newOrgIds.add(orgId);
                    if (n.getChildren() == null) {
                        newLeafOrgs.add(orgId);
                    } else {
                        newMiddleOrgs.add(orgId);
                    }
                });
                oldOrgIds.removeAll(newOrgIds);
                Set<String> referredOrgs = this.getReferredOrgs(this.getParamAccsysId(), oldOrgIds);
                if (!referredOrgs.isEmpty()) {
                    result = result + String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u88ab\u8d26\u7c3f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u79fb\u9664\uff1a%s", (String)"AccountingSysAddViewEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]), referredOrgs.toString());
                }
                oldLeafOrgs.removeAll(newLeafOrgs);
                oldLeafOrgs.removeAll(oldOrgIds);
                referredOrgs = this.getReferredOrgs(this.getParamAccsysId(), oldLeafOrgs);
                if (!referredOrgs.isEmpty()) {
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        result = result + "\n";
                    }
                    result = result + String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u88ab\u8d26\u7c3f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7531\u5b9e\u4f53\u7ec4\u7ec7\u53d8\u66f4\u4e3a\u865a\u4f53\u7ec4\u7ec7\uff1a%s", (String)"AccountingSysAddViewEdit_12", (String)"fi-bd-formplugin", (Object[])new Object[0]), referredOrgs.toString());
                }
                oldMiddleOrgs.removeAll(newMiddleOrgs);
                oldMiddleOrgs.removeAll(oldOrgIds);
                referredOrgs = this.getReferredOrgs(this.getParamAccsysId(), oldMiddleOrgs);
                if (!referredOrgs.isEmpty()) {
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        result = result + "\n";
                    }
                    result = result + String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u88ab\u8d26\u7c3f\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7531\u865a\u4f53\u7ec4\u7ec7\u53d8\u66f4\u4e3a\u5b9e\u4f53\u7ec4\u7ec7\uff1a%s", (String)"AccountingSysAddViewEdit_13", (String)"fi-bd-formplugin", (Object[])new Object[0]), referredOrgs.toString());
                }
            }
        }
        return result;
    }

    private Map<Long, Boolean> getOrgInfoByViewId(Long viewId) {
        DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,isleaf,org.enable", (QFilter[])new QFilter("view", "=", (Object)viewId).toArray());
        HashMap<Long, Boolean> orgInfos = new HashMap<Long, Boolean>(orgDyn.size());
        orgDyn.forEach(dyo -> {
            String enable = dyo.getString("org.enable");
            if ("1".equals(enable)) {
                Long orgId = dyo.getLong("org");
                Boolean isLeaf = dyo.getBoolean("isleaf");
                orgInfos.put(orgId, isLeaf);
            }
        });
        return orgInfos;
    }

    private Set<String> getReferredOrgs(Long accsysId, Long viewId) {
        Set<Long> orgs = this.getOrgByViewId(viewId);
        return this.getReferredOrgs(accsysId, orgs);
    }

    private Set<Long> getOrgByViewId(Long viewId) {
        DynamicObjectCollection orgDyn = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter("view", "=", (Object)viewId).toArray());
        return orgDyn.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
    }

    private Set<String> getReferredOrgs(Long accsysId, Set<Long> orgs) {
        DynamicObjectCollection bookDyns = BatchProcessUtil.batchQueryDynColl(orgs, batchOrg -> {
            QFilter orgFilter = new QFilter("org", "in", batchOrg);
            QFilter accsysFilter = new QFilter("accountingsys", "=", (Object)accsysId);
            return QueryServiceHelper.query((String)"gl_accountbook", (String)"org,org.name", (QFilter[])new QFilter[]{orgFilter, accsysFilter});
        });
        return bookDyns.stream().map(book -> book.getString("org.name")).collect(Collectors.toSet());
    }

    private List<OrgParam> constructStruc(TreeNode viewTreeNode) {
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>();
        this.getAllNodeInfo(orgParams, viewTreeNode);
        return orgParams;
    }

    private void getAllNodeInfo(List<OrgParam> orgParams, TreeNode viewTreeNode) {
        List childList;
        OrgParam param = new OrgParam();
        param.setId(Long.parseLong(viewTreeNode.getId()));
        String parentId = viewTreeNode.getParentid();
        param.setDuty(this.getViewSchemaNumber());
        param.setParentId(parentId.equals("") ? 0L : Long.parseLong(parentId));
        if (!parentId.equals("")) {
            orgParams.add(param);
        }
        if ((childList = viewTreeNode.getChildren()) != null && childList.size() > 0) {
            for (TreeNode childTreeNode : childList) {
                this.getAllNodeInfo(orgParams, childTreeNode);
            }
        }
    }

    private void deleteNode() {
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        HashSet deleteNode = new HashSet(10);
        for (String node : rightNodes) {
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)node, (TreeNode)viewRoot);
            if (checkNodeInfo == null) continue;
            String parentId = checkNodeInfo.getParentid();
            if (parentId.equals("")) {
                ArrayList deleteNodeId = new ArrayList();
                this.getAllChildrenAndSelf(checkNodeInfo).forEach(n -> deleteNodeId.add(n.getId()));
                deleteNodeId.remove(checkNodeInfo.getId());
                deleteNode.addAll(deleteNodeId);
                viewRoot.setChildren(null);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(viewRoot);
                continue;
            }
            viewRoot.deleteChildNode(checkNodeInfo.getId());
            this.bizviewtree.deleteNode(checkNodeInfo.getId());
            TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
            if (parentNode.getChildren() == null || parentNode.getChildren() != null && parentNode.getChildren().isEmpty()) {
                parentNode.setChildren(null);
            }
            this.bizviewtree.updateNode(parentNode);
            this.bizviewtree.expand(parentId);
            ArrayList deleteNodeId = new ArrayList();
            this.getAllChildrenAndSelf(checkNodeInfo).forEach(n -> deleteNodeId.add(n.getId()));
            deleteNode.addAll(deleteNodeId);
        }
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
        this.getPageCache().put("deletenode", SerializationUtils.toJsonString(deleteNode));
    }

    public void treeNodeDragged(TreeNodeDragEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        if (!BIZVIEWTREE.equalsIgnoreCase(source.getKey())) {
            return;
        }
        String sourceNodeId = (String)evt.getNodeId();
        if ("".equals(sourceNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6e90\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccountingSysAddViewEdit_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        String targetNodeId = (String)evt.getToParentId();
        TreeNode unitRoot = this.getCachedRoot(CACHEKEY_UNIT_ROOT);
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        TreeNode sourceNode = AccountingSysUtil.getTreeNodeById((String)sourceNodeId, (TreeNode)unitRoot);
        TreeNode targetNode = AccountingSysUtil.getTreeNodeById((String)targetNodeId, (TreeNode)viewRoot);
        List<TreeNode> allAppendNodes = this.getAllChildrenAndSelf(sourceNode);
        List allAppendNodeIds = allAppendNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        List allViewNodeIds = allViewNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<String> dumpIds = allAppendNodeIds.stream().filter(allViewNodeIds::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getParentExcludeIds(viewRoot, targetNode, dumpIds);
        String finalAppendNodeId = finalAppendNode.getId();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(targetNode);
        this.removeNodes(viewRoot, dumpIds);
        if ("".equals(sourceNode.getParentid())) {
            List children = sourceNode.getChildren();
            for (TreeNode child : children) {
                child.setParentid(finalAppendNodeId);
                finalAppendNode.addChild(child);
            }
        } else {
            sourceNode.setParentid(finalAppendNodeId);
            finalAppendNode.addChild(sourceNode);
        }
        this.bizviewtree.updateNodes(needUpdateNodes);
        this.expandUp(this.bizviewtree, viewRoot, finalAppendNode);
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private void addNode() {
        List<Map> leftNodes;
        List rightNodes = this.bizviewtree.getTreeState().getCheckedNodeIds();
        if (rightNodes.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s", (String)"AccountingSysAddViewEdit_4", (String)"fi-bd-formplugin", (Object[])new Object[]{rightNodes.size()}));
            return;
        }
        Map leftFocusNode = this.bizunittree.getTreeState().getFocusNode();
        List<Map> list = this.bizunittree.getTreeState().getCheckedNodes().size() == 0 ? (null == leftFocusNode ? Collections.EMPTY_LIST : Collections.singletonList(leftFocusNode)) : (leftNodes = this.bizunittree.getTreeState().getCheckedNodes());
        if (leftNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"AccountingSysAddViewEdit_5", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        String viewCheckedId = (String)rightNodes.get(0);
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        List<TreeNode> viewNodeAll = this.getAllChildrenAndSelf(viewRoot);
        List viewIdAll = viewNodeAll.stream().map(TreeNode::getId).collect(Collectors.toList());
        TreeNode viewCheckedNode = AccountingSysUtil.getTreeNodeById((String)viewCheckedId, (TreeNode)viewRoot);
        List unitCheckedNodes = AccountingSysUtil.buildTreeNodeByList((TreeNode)viewCheckedNode, leftNodes);
        unitCheckedNodes.removeIf(node -> node.getId().equals(viewRoot.getId()));
        List<String> dumpIds = unitCheckedNodes.stream().map(TreeNode::getId).filter(viewIdAll::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getAllNode();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(viewCheckedNode);
        this.removeNodes(viewRoot, dumpIds);
        this.bizviewtree.updateNodes(needUpdateNodes);
        if (finalAppendNode.getChildren() != null) {
            for (TreeNode tre : finalAppendNode.getChildren()) {
                this.clearSelectNode(tre);
                tre.setParentid(viewCheckedNode.getId());
                if (viewCheckedNode.getChildren() == null) {
                    viewCheckedNode.addChild(tre);
                    continue;
                }
                viewCheckedNode.getChildren().add(tre);
            }
        }
        AccountingSysUtil.sortTreeNode((List)viewCheckedNode.getChildren());
        this.bizviewtree.checkNode(viewCheckedNode);
        this.getPageCache().put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private void clearSelectNode(TreeNode viewCheckedNode) {
        this.bizunittree.uncheckNode(viewCheckedNode.getId());
    }

    private TreeNode getAllNode() {
        Map leftFocusNode = this.bizunittree.getTreeState().getFocusNode();
        List<Map<String, Object>> leftNodes = this.bizunittree.getTreeState().getCheckedNodes().size() == 0 ? (null == leftFocusNode ? Collections.EMPTY_LIST : Collections.singletonList(leftFocusNode)) : this.bizunittree.getTreeState().getCheckedNodes();
        Long mainViewId = Long.parseLong(this.getPageCache().get("mainViewId"));
        Map<String, Map<String, String>> unitTreeMap = this.getSelectInfo(AccountingSysUtil.getAllOrgByViewId((Long)mainViewId), leftNodes);
        this.removeRepetion(unitTreeMap);
        Map allTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)mainViewId);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap(unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode(unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), (Map<String, String>)allTreeMap.get(tree.getId()));
            }
            unitRoot = AccountingSysUtil.createTreeNode(unitTreeMap);
            flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap(unitTreeMap);
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        return unitRoot;
    }

    private void removeRepetion(Map<String, Map<String, String>> unitTreeMap) {
        TreeNode viewRoot = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        Set<String> nodeIds = unitTreeMap.keySet();
        Iterator<TreeNode> iterator = allViewNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!nodeIds.contains(node.getId())) continue;
            iterator.remove();
            if (node.getChildren() == null) continue;
            for (TreeNode n : node.getChildren()) {
                n.setParentid(node.getParentid());
            }
        }
    }

    private Map<String, Map<String, String>> getSelectInfo(Map<String, Map<String, String>> unitTreeMap, List<Map<String, Object>> leftNodes) {
        ArrayList<Object> list = new ArrayList<Object>(leftNodes.size());
        HashMap<String, String> idParentidMap = new HashMap<String, String>(leftNodes.size());
        for (Map<String, Object> leftNode : leftNodes) {
            list.add(leftNode.get("id"));
            idParentidMap.put((String)leftNode.get("id"), (String)leftNode.get("parentid"));
        }
        unitTreeMap.keySet().retainAll(list);
        unitTreeMap.keySet().forEach(x -> {
            if (!"0".equals(((Map)unitTreeMap.get(x)).get("parentid"))) {
                ((Map)unitTreeMap.get(x)).put("parentid", idParentidMap.get(x));
            }
        });
        return unitTreeMap;
    }

    private TreeNode getCachedRoot(String key) {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), TreeNode.class);
    }

    private Long getParamAccsysId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return Long.valueOf((String)map.get("accsysid"));
    }

    private Long getParamSelfId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return Long.valueOf((String)map.get("id"));
    }

    private String getViewSchemaNumber() {
        return this.getParamAccsysId() + ":" + this.getModel().getValue("number").toString();
    }

    public void afterCreateNewData(EventObject e) {
        Long orgViewSchemaId;
        IDataModel model = this.getModel();
        Long id = this.getParamSelfId();
        Long accsysid = this.getParamAccsysId();
        model.setValue("accountingsys_id", (Object)accsysid);
        boolean isEdit = !id.equals(0L);
        Long orgDefaultViewSchemaId = this.getSchemaId(accsysid, AccountingSysUtil.getDefaultViewSchemaInfoId(), id);
        if (isEdit) {
            orgViewSchemaId = id;
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)orgViewSchemaId, (String)BD_ACCOUNTINGSYSVIEWSCH);
            model.setValue("name", (Object)obj.getLocaleString("name"));
            model.setValue("number", (Object)obj.getString("number"));
            model.setValue("id", (Object)orgViewSchemaId);
            model.setValue("ismainview", (Object)obj.getBoolean("ismainview"));
            model.setValue("multilanguagetext", obj.get("multilanguagetext"));
        } else {
            orgViewSchemaId = orgDefaultViewSchemaId;
            QFilter mainQF = new QFilter("ismainview", "=", (Object)"1");
            QFilter accSysQF = new QFilter("accountingsys", "=", (Object)accsysid);
            if (!QueryServiceHelper.exists((String)BD_ACCOUNTINGSYSVIEWSCH, (QFilter[])new QFilter[]{mainQF, accSysQF})) {
                model.setValue("ismainview", (Object)true);
            }
            if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) {
                this.getModel().setValue("ismainview", (Object)false);
            }
        }
        this.showTreeView(orgViewSchemaId, orgDefaultViewSchemaId, isEdit);
    }

    private void showTreeView(Long orgViewSchemaId, Long orgDefaultViewSchemaId, boolean isEdit) {
        this.getPageCache().put("mainViewId", orgDefaultViewSchemaId + "");
        Map unitTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)orgDefaultViewSchemaId);
        Map flatOrgTreeMap = AccountingSysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            return;
        }
        AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put(BIZUNITTREE, SerializationUtils.toJsonString((Object)unitRoot));
        Map viewTreeMap = AccountingSysUtil.getAllOrgByViewId((Long)orgViewSchemaId);
        Map flatOrgTreeMap2 = AccountingSysUtil.getOrgTreeMap((Map)viewTreeMap);
        TreeNode viewRoot = AccountingSysUtil.createTreeNode((Map)viewTreeMap);
        if (isEdit) {
            if (viewRoot == null) {
                viewRoot = AccountingSysUtil.createTreeNode((Map)unitTreeMap);
            } else {
                AccountingSysUtil.createChildNodes((Map)flatOrgTreeMap2, (String)viewRoot.getId(), (TreeNode)viewRoot);
            }
        }
        this.bizviewtree.addNode(viewRoot);
        this.cacheTreeNode(unitRoot, viewRoot);
    }

    private void cacheTreeNode(TreeNode unitTreeNode, TreeNode viewTreeNode) {
        IPageCache cache = this.getPageCache();
        cache.put(CACHEKEY_UNIT_ROOT, SerializationUtils.toJsonString((Object)unitTreeNode));
        cache.put(CACHEKEY_VIEW_ROOT, SerializationUtils.toJsonString((Object)viewTreeNode));
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        Control treeView = (Control)e.getSource();
        boolean isCheckChild = (Boolean)this.getModel().getValue(ISCHECKUNITCHILD);
        boolean isCheckOrgChild = (Boolean)this.getModel().getValue(ISCHECKORGCHILD);
        if (treeView.getKey().equals(BIZUNITTREE) && isCheckChild) {
            boolean containsAll;
            String nodeId = (String)e.getNodeId();
            TreeNode unitTreeNode = this.getCachedRoot(CACHEKEY_UNIT_ROOT);
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)unitTreeNode);
            List checkedNodeIds = this.bizunittree.getTreeState().getCheckedNodeIds();
            boolean empty = this.bizviewtree.getTreeState().getSelectedNodeId().isEmpty();
            boolean bl = containsAll = empty ? false : checkedNodeIds.containsAll(this.bizviewtree.getTreeState().getSelectedNodeId());
            if (containsAll && StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADDNODE, BTN_DELETENODE});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (checkedNodeIds.contains(nodeId)) {
                this.bizunittree.checkNodes(allChildren);
            } else {
                List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                this.bizunittree.unCheckNodesWithoutChild(allChildrenIds);
            }
        } else if (treeView.getKey().equals(BIZVIEWTREE)) {
            TreeNode viewTreeNode = this.getCachedRoot(CACHEKEY_VIEW_ROOT);
            String nodeId = (String)e.getNodeId();
            TreeNode checkNodeInfo = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)viewTreeNode);
            List checkedNodeIds = this.bizviewtree.getTreeState().getCheckedNodeIds();
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (isCheckOrgChild) {
                if (checkedNodeIds.contains(nodeId)) {
                    this.bizviewtree.checkNodes(allChildren);
                } else {
                    List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                    this.bizviewtree.unCheckNodesWithoutChild(allChildrenIds);
                }
            }
        }
    }

    private boolean isHasBook(String nodeId, boolean isBizUnit) {
        QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(nodeId)), new QFilter("accountingsys", "=", this.getModel().getValue("accountingsys_id"))};
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("org", "=", (Object)Long.valueOf(nodeId)));
        qFilterList.add(new QFilter("accountingsys", "=", this.getModel().getValue("accountingsys_id")));
        if (isBizUnit) {
            qFilterList.add(new QFilter("isbizunit", "=", (Object)"1"));
        } else {
            qFilterList.add(new QFilter("isbizunit", "=", (Object)"0"));
        }
        return QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
        for (TreeNode child : children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(parentNode);
        return allChildren;
    }

    private List<TreeNode> getNeedUpdateNodes(TreeNode viewRoot, List<String> dumpIds) {
        ArrayList<TreeNode> needUpdateNodes = new ArrayList<TreeNode>(dumpIds.size());
        for (String dumpId : dumpIds) {
            needUpdateNodes.add(this.getParentExcludeIds(viewRoot, AccountingSysUtil.getTreeNodeById((String)dumpId, (TreeNode)viewRoot), dumpIds));
        }
        return needUpdateNodes;
    }

    private void expandUp(TreeView treeView, TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodesAndSelf(treeRoot, treeNode);
        parentNodes.forEach(x -> treeView.expand(x.getId()));
    }

    private List<TreeNode> getParentNodesAndSelf(TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodes(treeRoot, treeNode);
        parentNodes.add(treeNode);
        return parentNodes;
    }

    private List<TreeNode> getParentNodes(TreeNode treeRoot, TreeNode treeNode) {
        String parentId = treeNode.getParentid();
        if ("".equals(parentId)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)treeRoot);
        result.add(parentNode);
        result.addAll(this.getParentNodesAndSelf(treeRoot, parentNode));
        return result;
    }

    private TreeNode getParentExcludeIds(TreeNode viewRoot, TreeNode targetNode, List<String> dumpIds) {
        if (!dumpIds.contains(targetNode.getId())) {
            return targetNode;
        }
        String parentId = targetNode.getParentid();
        if ("".equals(parentId)) {
            return targetNode;
        }
        TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
        return this.getParentExcludeIds(viewRoot, parentNode, dumpIds);
    }

    private void removeNodes(TreeNode root, List<String> nodeIds) {
        for (String nodeId : nodeIds) {
            String parentId;
            TreeNode node = AccountingSysUtil.getTreeNodeById((String)nodeId, (TreeNode)root);
            if (node == null || "".equals(parentId = node.getParentid())) continue;
            List childNodes = node.getChildren();
            TreeNode parentNode = AccountingSysUtil.getTreeNodeById((String)parentId, (TreeNode)root);
            List parentChilds = parentNode.getChildren();
            parentChilds.removeIf(x -> x.getId().equals(nodeId));
            if (parentChilds.isEmpty()) {
                parentNode.setChildren(null);
            }
            if (childNodes == null) continue;
            for (TreeNode childNode : childNodes) {
                parentChilds.add(childNode);
                childNode.setParentid(parentId);
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String rootNodeCacheKey;
        String viewId;
        TreeView treeView;
        String searchText = e.getText();
        Search search = (Search)e.getSource();
        QFilter orgFilter = null;
        if ("orgsearchap".equals(search.getKey())) {
            treeView = (TreeView)this.getControl(BIZUNITTREE);
            viewId = this.getPageCache().get("mainViewId");
            rootNodeCacheKey = CACHEKEY_UNIT_ROOT;
            String filterValue = this.getPageCache().get(CACHEKEY_FILTER_VALUE);
            boolean islegal = this.getIslegal();
            if (StringUtils.isNotBlank((CharSequence)filterValue)) {
                orgFilter = islegal ? new QFilter("org.orgpattern.patterntype", "=", (Object)filterValue) : new QFilter("org.orgpattern.name", "=", (Object)filterValue);
            }
        } else {
            treeView = (TreeView)this.getControl(BIZVIEWTREE);
            viewId = this.getModel().getValue("id").toString();
            rootNodeCacheKey = CACHEKEY_VIEW_ROOT;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(searchText, this.getView(), treeView, rootNodeCacheKey, Long.parseLong(viewId), orgFilter);
        AccountingSysOrgTreeUtil.searchFromLazyOrgTree(searchParam);
    }

    private boolean getIslegal() {
        boolean islegal = false;
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            Long accountingsysid = this.getModel().getDataEntity().getLong("accountingsys_id");
            DynamicObject accountingsysObj = BusinessDataServiceHelper.loadSingle((Object)accountingsysid, (String)"bd_accountingsys");
            islegal = accountingsysObj.getBoolean("islegal");
        } else {
            islegal = (Boolean)this.getView().getParentView().getParentView().getModel().getValue("islegal");
        }
        return islegal;
    }

    private void unCheckNode(TreeView orgTree) {
        List selectedNodeId = orgTree.getTreeState().getSelectedNodeId();
        orgTree.uncheckNodes(selectedNodeId);
    }

    private void selectNode(TreeView orgTree, DynamicObject org, boolean containLeaf, long rootOrgId) {
        TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
        List childPathNodes = bizTree.getChildPathNodes(org.getString("id"));
        for (TreeNode child : childPathNodes) {
            if (!child.getText().equalsIgnoreCase(org.getString("name")) || String.valueOf(rootOrgId).equals(child.getId())) continue;
            orgTree.showNode(child.getId());
            orgTree.focusNode(child);
            orgTree.checkNode(child);
            if (containLeaf) {
                TreeNodeCheckEvent tnc = new TreeNodeCheckEvent((Object)orgTree, (Object)child.getParentid(), (Object)child.getId(), Boolean.valueOf(containLeaf));
                this.treeNodeCheck(tnc);
            }
            return;
        }
    }

    public Long getSchemaId(Object accsysid, Long orgDefaultViewSchemaId, Long id) {
        QFilter[] qf = new QFilter[]{new QFilter("accountingsys", "=", accsysid), new QFilter("ismainview", "=", (Object)"1")};
        DynamicObject mainView = QueryServiceHelper.queryOne((String)BD_ACCOUNTINGSYSVIEWSCH, (String)"id", (QFilter[])qf);
        if (mainView != null && mainView.getLong("id") != id.longValue()) {
            return mainView.getLong("id");
        }
        return orgDefaultViewSchemaId;
    }
}

