/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accountingsys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.enums.ConversionMethod;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.AccountingSysViewInfo;
import kd.fi.bd.util.ContextUtil;
import org.apache.commons.lang3.StringUtils;

public class AccountingSysEdit
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
SearchEnterListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final String BIZORGENTRY = "bizorgentry";
    private static final String ADD_BIZORG = "addbizorg";
    private static final String DEL_BIZORG = "delbizorg";
    private static final String ACCTVIEWSCHEMA = "acctviewschema";
    private static final String BOS_ORG = "bos_org";
    private static final String V_BIZORGENTRY = "vbizorgentry";
    private static final String V_BIZORG = "vbizorg";
    private static final String BIZORG = "bizorg";
    private static final String BD_ACCOUNTINGSYS_BASE = "bd_accountingsys_base";
    private static final String BASECURRRENCY = "basecurrrency";
    private static final String EXRATETABLE = "exratetable";
    private static final String BASEACCTORG = "baseacctorg";
    private static final String ISDEFAULT = "isdefault";
    private static final String BD_ACCOUNTINGSYS_DETAIL = "bd_accountingsys_detail";
    private static final String ENABLE_GROUP_LOCAL_CURRENCY = "enablegrplocalcur";
    private static final String CONVERSION_METHOD = "conversionmethod";
    private TreeView orgTree;
    private AccountingSysViewInfo info;
    private static final Log LOG = LogFactory.getLog(AccountingSysEdit.class);
    private boolean isQueryPermissionOrg = false;
    private Set<Long> permissionOrg = null;

    public void initialize() {
        super.initialize();
        this.orgTree = (TreeView)this.getView().getControl("orgtree");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_BIZORG, DEL_BIZORG});
        this.orgTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Tab detailTab = (Tab)this.getView().getControl("detailtabap");
        detailTab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit view = (BasedataEdit)this.getView().getControl(ACCTVIEWSCHEMA);
        view.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "addbizorg": {
                this.showBosOrgForm();
                break;
            }
            case "delbizorg": {
                this.delBizOrg();
                break;
            }
        }
    }

    private void delBizOrg() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(V_BIZORGENTRY);
        DynamicObject entryDb = model.getEntryRowEntity(V_BIZORGENTRY, rowIndex);
        String bizorgId = entryDb.getDynamicObject(V_BIZORG).getString("id");
        this.initInfo();
        boolean isRevl = this.isRelevance(bizorgId);
        if (!isRevl) {
            String currentOrgId = this.info.getCurrentOrgId();
            List bizorgIds = (List)this.info.getBizOrgIds().get(currentOrgId);
            if (bizorgIds != null) {
                bizorgIds.remove(bizorgId);
            }
            model.deleteEntryRow(V_BIZORGENTRY, rowIndex);
            this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8d26\u7c3f\u5df2\u5173\u8054\u8d26\u7c3f\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u8d26\u7c3f\u914d\u7f6e\u3002", (String)"AccountingSysEdit_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isRelevance(String bizorgId) {
        QFilter bizQf = new QFilter("org", "=", (Object)Long.valueOf(bizorgId));
        LOG.info("bizQf\u4e2d\u7684org\u503c= {}", (Object)bizorgId);
        QFilter qf = new QFilter("org", "=", (Object)Long.valueOf(this.info.getCurrentOrgId()));
        LOG.info("qf\u4e2d\u7684org\u503c= {}", (Object)this.info.getCurrentOrgId());
        DynamicObjectCollection assetBook = QueryServiceHelper.query((String)"fa_assetbook", (String)"id", (QFilter[])bizQf.toArray());
        HashSet<Long> bookId = new HashSet<Long>();
        for (DynamicObject asset : assetBook) {
            bookId.add(asset.getLong("id"));
        }
        QFilter[] q = new QFilter[]{new QFilter("b_entry.b_relatebook.fbasedataid", "in", bookId), new QFilter("accountingsys", "=", this.getModel().getValue("id")), qf};
        boolean isRel = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])q);
        if (isRel) {
            return isRel;
        }
        DynamicObjectCollection policyBook = QueryServiceHelper.query((String)"ar_policy", (String)"id", (QFilter[])bizQf.toArray());
        bookId.clear();
        for (DynamicObject policy : policyBook) {
            bookId.add(policy.getLong("id"));
        }
        QFilter[] policQF = new QFilter[]{new QFilter("b_entry.b_relatebook.fbasedataid", "in", bookId), qf};
        isRel = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])policQF);
        if (isRel) {
            return isRel;
        }
        DynamicObjectCollection costBook = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{new QFilter("calorg", "=", (Object)Long.valueOf(bizorgId))});
        bookId.clear();
        for (DynamicObject cost : costBook) {
            bookId.add(cost.getLong("id"));
        }
        QFilter[] costQF = new QFilter[]{new QFilter("b_entry.b_relatebook.fbasedataid", "in", bookId), qf};
        isRel = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])costQF);
        return isRel;
    }

    private void showBosOrgForm() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId(BOS_ORG);
        para.setFormId("bos_orgtreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("1068");
        css.setHeight("648");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setStatus(OperationStatus.ADDNEW);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BIZORG));
        para.setCustomParam("orgFuncId", (Object)"10");
        ListFilterParameter filterParam = para.getListFilterParameter();
        HashSet idSet = new HashSet();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qf2 = new QFilter("view", "=", (Object)AccountingSysUtil.getDefaultViewSchemaInfoId());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{qf2});
        coll.forEach(v -> idSet.add(v.getLong("org")));
        idSet.removeAll(this.getSelectOrg());
        Set<Long> permissionOrg = this.getPermissionOrg();
        if (permissionOrg != null) {
            idSet.retainAll(permissionOrg);
        }
        QFilter qf = new QFilter("id", "in", idSet);
        qFilters.add(qf);
        filterParam.setQFilters(qFilters);
        this.getView().showForm((FormShowParameter)para);
    }

    private Set<Long> getSelectOrg() {
        IDataModel model = this.getModel();
        DynamicObjectCollection orgentrys = model.getEntryEntity(V_BIZORGENTRY);
        HashSet<Long> selectOrg = new HashSet<Long>();
        for (DynamicObject orgentry : orgentrys) {
            DynamicObject org = orgentry.getDynamicObject(V_BIZORG);
            if (org == null) continue;
            selectOrg.add(org.getLong("id"));
        }
        return selectOrg;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        switch (key = e.getActionId()) {
            case "bizorg": {
                this.addBizOrgToModel(e);
                break;
            }
            case "acctviewschema": {
                Object newVals;
                if (e.getReturnData() == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getReturnData() + ""})) break;
                Long newViewId = 0L;
                newViewId = e.getReturnData() instanceof ListSelectedRowCollection ? Long.valueOf((newVals = (ListSelectedRowCollection)e.getReturnData()).isEmpty() ? 0L : Long.parseLong(newVals.get(0).getPrimaryKeyValue() + "")) : Long.valueOf((newVals = e.getReturnData()) == null ? 0L : Long.parseLong(String.valueOf(newVals)));
                this.getModel().setValue(ACCTVIEWSCHEMA, (Object)(newViewId == 0L ? null : newViewId));
                IPageCache cache = this.getPageCache();
                this.info = (AccountingSysViewInfo)SerializationUtils.fromJsonString((String)cache.get("info"), AccountingSysViewInfo.class);
                this.info.setCurrentOrgId(String.valueOf(this.getRootOrgIdByViewId(newViewId)));
                cache.put("info", SerializationUtils.toJsonString((Object)this.info));
                cache.saveChanges();
                this.changeTreeNode(newViewId);
                if (this.getPageCache().get("treenode") != null) {
                    TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treenode"), TreeNode.class);
                    this.initInfo();
                    this.addLeafOrgBiz(orgTreeNode);
                    this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
                }
                this.getView().updateView(ACCTVIEWSCHEMA);
                break;
            }
        }
    }

    private void setMustInput(boolean isMust) {
        BasedataEdit vbasecurrrency = (BasedataEdit)this.getControl("vbasecurrrency");
        vbasecurrrency.setMustInput(isMust);
        BasedataEdit vexratetable = (BasedataEdit)this.getControl("vexratetable");
        vexratetable.setMustInput(isMust);
    }

    private void addBizOrgToModel(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            IDataModel model = this.getModel();
            ListSelectedRowCollection coll = (ListSelectedRowCollection)e.getReturnData();
            for (ListSelectedRow row : coll) {
                int rowIndex = model.createNewEntryRow(V_BIZORGENTRY);
                model.setValue(V_BIZORG, row.getPrimaryKeyValue(), rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        Long priId = (Long)this.getModel().getValue("id");
        this.initInfo();
        String selectFields = "basecurrrency,exratetable,baseacctorg";
        DynamicObjectCollection baseColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS_BASE, (String)selectFields, null);
        this.putBaseInfo(baseColl);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap3", "flexpanelap4", "flexpanelap5"});
        if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"islegal"});
        }
        if (priId.equals(0L)) {
            this.initAcctOrgTree();
            DynamicObject db = BusinessDataServiceHelper.newDynamicObject((String)"bd_accountingsys");
            String tableName = db.getDynamicObjectType().getAlias();
            long genLongId = DBServiceHelper.genLongIds((String)tableName, (int)1)[0];
            this.getModel().setValue("id", (Object)genLongId);
            if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"accountingsys")) {
                this.getModel().setValue("islegal", (Object)true);
            }
        } else {
            DynamicObjectCollection bizorgColl = model.getEntryEntity(BIZORGENTRY);
            DynamicObjectCollection viewColl = QueryServiceHelper.query((String)"bd_accountingsysviewsch", (String)"id,ismainview", (QFilter[])new QFilter("accountingsys", "=", this.getModel().getValue("id")).toArray());
            List<Long> viewIds = viewColl.stream().mapToLong(view -> view.getLong("id")).boxed().collect(Collectors.toList());
            List mainViewIds = viewColl.stream().filter(view -> view.getBoolean("ismainview")).mapToLong(v -> v.getLong("id")).boxed().collect(Collectors.toList());
            Long defaultViewId = 0L;
            if (!viewIds.isEmpty()) {
                Long l = defaultViewId = !mainViewIds.isEmpty() ? (Long)mainViewIds.get(0) : (Long)viewIds.get(0);
            }
            if (defaultViewId != 0L) {
                this.putViewIds(viewIds);
                this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
                model.setValue(ACCTVIEWSCHEMA, (Object)defaultViewId);
                this.info.setCurrentOrgId(String.valueOf(this.getRootOrgIdByViewId(defaultViewId)));
                this.putBizOrgIds(bizorgColl);
                model.deleteEntryData(BIZORGENTRY);
            }
            if (AccountingSysUtil.isHaveBizByAccountBook((long)priId)) {
                ArrayList<String> mulCurFieldList = new ArrayList<String>(4);
                mulCurFieldList.addAll(this.getMulCurFields(true, true));
                mulCurFieldList.add(ENABLE_GROUP_LOCAL_CURRENCY);
                mulCurFieldList.add(CONVERSION_METHOD);
                this.getView().setEnable(Boolean.valueOf(false), mulCurFieldList.toArray(new String[0]));
            }
        }
        this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
        this.createBizEntry(this.info.getCurrentOrgId());
        model.setDataChanged(false);
        this.setEnableGroupCurrency();
        this.setGroupLocalCurrencyFields((Boolean)model.getValue(ENABLE_GROUP_LOCAL_CURRENCY));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_save": {
                boolean islegal = (Boolean)this.getView().getModel().getValue("islegal");
                if (!islegal) break;
                Long priId = (Long)this.getModel().getValue("id");
                QFilter filter = new QFilter("id", "!=", (Object)priId);
                filter.and(new QFilter("islegal", "=", (Object)true));
                if (!QueryServiceHelper.exists((String)"bd_accountingsys", (QFilter[])filter.toArray())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u6570\u636e\u4e2d\u5fc3\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u6cd5\u4eba\u6838\u7b97\u4f53\u7cfb\u3002", (String)"AccountingSysAddViewEdit_9", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    private Set<Long> getPermissionOrg() {
        if (!this.isQueryPermissionOrg) {
            this.permissionOrg = this.getPermissionOrgFunc();
            this.isQueryPermissionOrg = true;
        }
        return this.permissionOrg;
    }

    private Set<Long> getPermissionOrgFunc() {
        String appId = AppMetadataCache.getAppInfo((String)"fibd").getId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)"bd_accountingsys", (String)"47156aff000000ac");
        HashSet permissionOrg = null;
        if (!rs.hasAllOrgPerm()) {
            permissionOrg = new HashSet();
            permissionOrg.addAll(rs.getHasPermOrgs());
        }
        return permissionOrg;
    }

    private void putViewIds(List<Long> viewIds) {
        viewIds.forEach(v -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(v.toString(), "0");
            this.info.getViewIds().putAll(map);
        });
    }

    private void putBaseInfo(DynamicObjectCollection baseColl) {
        baseColl.forEach(v -> {
            HashMap<String, String> baseInfoMap = new HashMap<String, String>();
            String baseCurrencyId = v.getString(BASECURRRENCY) == null ? "0" : v.getString(BASECURRRENCY);
            String exratableId = v.getString(EXRATETABLE) == null ? "0" : v.getString(EXRATETABLE);
            String baseacctorg = v.getString(BASEACCTORG) == null ? "0" : v.getString(BASEACCTORG);
            baseInfoMap.put("vbasecurrrency", baseCurrencyId);
            baseInfoMap.put("vexratetable", exratableId);
            this.info.getBaseInfo().put(baseacctorg, baseInfoMap);
        });
    }

    private void putBizOrgIds(DynamicObjectCollection bizorgColl) {
        HashMap bizorgIdMap = new HashMap();
        for (DynamicObject bizOrg : bizorgColl) {
            if (bizOrg.getDynamicObject(BIZORG) == null) continue;
            String bizorgId = bizOrg.getDynamicObject(BIZORG).getString("id");
            String bizacctorgId = bizOrg.getDynamicObject("bizacctorg").getString("id");
            List bizOrgIds = bizorgIdMap.get(bizacctorgId) == null ? new ArrayList() : (List)bizorgIdMap.get(bizacctorgId);
            bizOrgIds.add(bizorgId);
            bizorgIdMap.put(bizacctorgId, bizOrgIds);
        }
        this.info.getBizOrgIds().putAll(bizorgIdMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        if (e.getSource() instanceof Save) {
            this.initInfo();
            this.cacheViewInfo();
            this.putViewIdInfo();
            this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
            model.deleteEntryData(BIZORGENTRY);
            this.setBizOrgInfoModelValue();
        }
    }

    private void setBizOrgInfoModelValue() {
        QFilter accountingsysFilter = new QFilter("accountingsys", "=", this.getModel().getValue("id"));
        QFilter ismainviewFilter = new QFilter("ismainview", "=", (Object)"1");
        DynamicObject mainViewSch = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{accountingsysFilter, ismainviewFilter});
        HashSet idSet = new HashSet(10);
        if (mainViewSch != null) {
            long mainViewId = mainViewSch.getLong("id");
            QFilter viewQf = new QFilter("view", "=", (Object)mainViewId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{viewQf});
            coll.forEach(v -> idSet.add(v.getLong("org")));
            IDataModel model = this.getModel();
            Map bizOrgIds = this.info.getBizOrgIds();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(BIZORG, new Object[0]);
            vs.addField("bizacctorg", new Object[0]);
            bizOrgIds.forEach((k, v) -> {
                if (!"0".equals(k) && idSet.contains(Long.valueOf(k))) {
                    v.forEach(v1 -> vs.addRow(new Object[]{Long.valueOf(v1), k}));
                }
            });
            AbstractFormDataModel model2 = (AbstractFormDataModel)model;
            model2.beginInit();
            model2.batchCreateNewEntryRow(BIZORGENTRY, vs);
            model2.endInit();
        }
    }

    private void cacheViewInfo() {
        String currentOrgId = this.info.getCurrentOrgId();
        this.putBaseInfo(currentOrgId);
        this.putBizOrgIds(currentOrgId);
    }

    private void putViewIdInfo() {
        if (this.getModel().getValue(ACCTVIEWSCHEMA) == null) {
            return;
        }
        String viewId = ((DynamicObject)this.getModel().getValue(ACCTVIEWSCHEMA)).getString("id");
        String isviewdefault = (Boolean)this.getModel().getValue(ISDEFAULT) != false ? "1" : "0";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(viewId, isviewdefault);
        this.info.getViewIds().putAll(map);
    }

    private void initInfo() {
        IPageCache cache = this.getPageCache();
        this.info = cache.get("info") != null ? (AccountingSysViewInfo)SerializationUtils.fromJsonString((String)cache.get("info"), AccountingSysViewInfo.class) : new AccountingSysViewInfo();
    }

    private void changeTreeNode(Long newViewId) {
        this.getModel().deleteEntryData(V_BIZORGENTRY);
        if (newViewId.equals(0L)) {
            this.orgTree.deleteAllNodes();
            this.setMustInput(false);
            this.initInfo();
            this.info.setCurrentOrgId("0");
            this.initBaseInfo();
            return;
        }
        this.setMustInput(true);
        this.initAcctOrgTree(newViewId);
        DynamicObject schemaDb = BusinessDataServiceHelper.loadSingle((Object)newViewId, (String)"bd_accountingsysviewsch");
        boolean isDefault = schemaDb.getBoolean("ismainview");
        this.getModel().setValue(ISDEFAULT, (Object)isDefault);
        if (isDefault) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"flexpanelap3", "flexpanelap5"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap3", "flexpanelap5"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (ACCTVIEWSCHEMA.equals(e.getProperty().getName())) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            Long oldViewId = oldValue == null ? 0L : ((DynamicObject)oldValue).getLong("id");
            Long newViewId = newValue == null ? 0L : ((DynamicObject)newValue).getLong("id");
            this.changeTreeNode(newViewId);
        }
        if (ENABLE_GROUP_LOCAL_CURRENCY.equals(e.getProperty().getName())) {
            boolean enableGrpLocalCur = (Boolean)e.getChangeSet()[0].getNewValue();
            this.setGroupLocalCurrencyFields(enableGrpLocalCur);
            if (!enableGrpLocalCur) {
                this.cleanGroupLocalCurrencyFieldsValue();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Long id = (Long)this.getModel().getValue("id");
        boolean isExist = QueryServiceHelper.exists((String)"bd_accountingsys", (Object)id);
        if (!isExist) {
            HashSet ids = new HashSet();
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter("accountingsys", "=", (Object)id).toArray());
            coll.forEach(v -> ids.add(v.getLong("id")));
            DeleteServiceHelper.delete((String)"bos_org_viewschema", (QFilter[])new QFilter("id", "in", ids).toArray());
            DeleteServiceHelper.delete((String)"bos_org_structure", (QFilter[])new QFilter("view", "in", ids).toArray());
            DeleteServiceHelper.delete((String)"bd_accountingsysviewsch", (QFilter[])new QFilter("accountingsys", "=", (Object)id).toArray());
        }
        e.setSkipNoField(true);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.initInfo();
        this.cacheViewInfo();
        String nodeId = (String)e.getNodeId();
        this.info.setCurrentOrgId(nodeId);
        this.getPageCache().put("info", SerializationUtils.toJsonString((Object)this.info));
        this.initBaseInfo();
        this.initBizOrgInfo();
        if (this.isHasPer(nodeId)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"flexpanelap4"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        }
        this.createBizEntry(nodeId);
        Tab detailTab = (Tab)this.getView().getControl("detailtabap");
        String defaultKey = "gltab";
        detailTab.selectTab(defaultKey);
        detailTab.activeTab(defaultKey);
        this.getModel().setDataChanged(false);
    }

    private boolean isCanAddEntry(String nodeId) {
        if (this.getPageCache().get("treenode") != null) {
            int i;
            TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treenode"), TreeNode.class);
            TreeNode treeNode = orgTreeNode.getTreeNode(nodeId, i = orgTreeNode.getNodeLevel(nodeId, 0));
            if (treeNode == null) {
                return false;
            }
            List childrenNode = treeNode.getChildren();
            boolean isDefault = (Boolean)this.getModel().getValue(ISDEFAULT);
            return isDefault && (childrenNode == null || childrenNode.size() == 0);
        }
        return false;
    }

    private void createBizEntry(String nodeId) {
        IDataModel model = this.getModel();
        if (this.isCanAddEntry(nodeId)) {
            Set<String> id = this.getBizOrgFromInfo(nodeId);
            if (id.isEmpty()) {
                id = this.getBizOrgFromData(nodeId, model);
            }
            if (id.size() == 0) {
                model.deleteEntryData(V_BIZORGENTRY);
                Long priId = (Long)model.getValue("id");
                if (priId.equals(0L)) {
                    int rowIndex = model.createNewEntryRow(V_BIZORGENTRY);
                    model.setValue(V_BIZORG, (Object)nodeId, rowIndex);
                }
            } else {
                model.deleteEntryData(V_BIZORGENTRY);
                for (String entry : id) {
                    int rowIndex = model.createNewEntryRow(V_BIZORGENTRY);
                    model.setValue(V_BIZORG, (Object)entry, rowIndex);
                }
            }
        }
        model.setDataChanged(false);
    }

    private Set<String> getBizOrgFromData(String nodeId, IDataModel model) {
        DynamicObject[] accSys = BusinessDataServiceHelper.load((Object[])new Object[]{model.getValue("id")}, (DynamicObjectType)model.getDataEntityType());
        DynamicObjectCollection entrys = null;
        entrys = accSys != null && accSys.length != 0 ? accSys[0].getDynamicObjectCollection(BIZORGENTRY) : model.getEntryEntity(BIZORGENTRY);
        HashSet<String> id = new HashSet<String>(entrys.size());
        for (DynamicObject entry : entrys) {
            if (!nodeId.equals(entry.getString("bizacctorg_id"))) continue;
            id.add(entry.getString("bizorg_id"));
        }
        return id;
    }

    private Set<String> getBizOrgFromInfo(String nodeId) {
        Map bizOrgIds = this.info.getBizOrgIds();
        List bizOrg = (List)bizOrgIds.get(this.info.getCurrentOrgId());
        if (bizOrg == null) {
            return new HashSet<String>();
        }
        HashSet<String> id = new HashSet<String>(bizOrg.size());
        for (String bizOrgId : bizOrg) {
            id.add(bizOrgId);
        }
        return id;
    }

    private boolean isHasPer(String nodeId) {
        Set<Long> permissionOrg = this.getPermissionOrg();
        return permissionOrg == null ? true : permissionOrg.contains(Long.parseLong(nodeId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.initInfo();
        this.createBizEntry(this.info.getCurrentOrgId());
    }

    private void initBizOrgInfo() {
        IDataModel model = this.getModel();
        model.deleteEntryData(V_BIZORGENTRY);
        Map bizOrgIds = this.info.getBizOrgIds();
        List bizOrg = (List)bizOrgIds.get(this.info.getCurrentOrgId());
        if (bizOrg == null) {
            return;
        }
        for (String bizOrgId : bizOrg) {
            int rowIndex = model.createNewEntryRow(V_BIZORGENTRY);
            model.setValue(V_BIZORG, (Object)Long.valueOf(bizOrgId), rowIndex);
        }
    }

    private void initBaseInfo() {
        IDataModel model = this.getModel();
        model.setValue("vperiodtype", null);
        model.setValue("vbasecurrrency", null);
        model.setValue("vexratetable", null);
        String currentOrgId = this.info.getCurrentOrgId();
        Map baseMap = BaseDataServiceHelper.getBaseAccountingInfo((Long)Long.parseLong(currentOrgId));
        model.setValue("vexratetable", baseMap.get("exchangeRateTableID"));
        model.setValue("vbasecurrrency", baseMap.get("baseCurrencyID"));
    }

    private void putBizOrgIds(String currentOrgId) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(V_BIZORGENTRY);
        ArrayList bizOrgIds = new ArrayList();
        coll.forEach(v -> {
            DynamicObject dynamicObject = v.getDynamicObject(V_BIZORG);
            if (dynamicObject != null) {
                String bizorgId = v.getDynamicObject(V_BIZORG).getString("id");
                bizOrgIds.add(bizorgId);
            }
        });
        HashSet setIds = new HashSet(bizOrgIds);
        bizOrgIds.clear();
        bizOrgIds.addAll(setIds);
        this.info.getBizOrgIds().put(currentOrgId, bizOrgIds);
    }

    private void putBaseInfo(String currentOrgId) {
        String exratableId;
        HashMap<String, String> baseInfoMap = new HashMap<String, String>();
        DynamicObject pertype = (DynamicObject)this.getModel().getValue("vperiodtype");
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("vbasecurrrency");
        DynamicObject exratable = (DynamicObject)this.getModel().getValue("vexratetable");
        String pertypeId = pertype == null ? "0" : pertype.getString("id");
        String baseCurrencyId = baseCurrency == null ? "0" : baseCurrency.getString("id");
        String string = exratableId = exratable == null ? "0" : exratable.getString("id");
        if (pertypeId.equals("0") && baseCurrencyId.equals("0") && exratableId.equals("0")) {
            return;
        }
        baseInfoMap.put("vperiodtype", pertypeId);
        baseInfoMap.put("vbasecurrrency", baseCurrencyId);
        baseInfoMap.put("vexratetable", exratableId);
        this.info.getBaseInfo().put(currentOrgId, baseInfoMap);
    }

    private void initAcctOrgTree() {
        this.initAcctOrgTree(0L);
    }

    private void initAcctOrgTree(Long orgViewSchemaId) {
        this.orgTree.deleteAllNodes();
        if (orgViewSchemaId.equals(0L)) {
            return;
        }
        TreeNode orgTreeNode = AccountingSysUtil.getTreeNode((Long)orgViewSchemaId);
        if (orgTreeNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c6\u56fe\u4fdd\u5b58/\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u6838\u7b97\u89c6\u56fe\u3002", (String)"AccountingSysEdit_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("treenode", SerializationUtils.toJsonString((Object)orgTreeNode));
        this.orgTree.addNode(orgTreeNode);
        this.orgTree.focusNode(orgTreeNode);
        this.orgTree.treeNodeClick("", orgTreeNode.getId());
        TreeNodeEvent tne = new TreeNodeEvent((Object)this.orgTree, (Object)orgTreeNode.getParentid(), (Object)orgTreeNode.getId());
        this.treeNodeClick(tne);
    }

    public void search(SearchEnterEvent e) {
        if (this.getModel().getValue(ACCTVIEWSCHEMA) == null) {
            return;
        }
        String text = e.getText();
        String focusNodeId = this.orgTree.getTreeState().getFocusNodeId();
        boolean isFocus = false;
        boolean matched = false;
        if (focusNodeId == null) {
            isFocus = true;
        }
        TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treenode"), TreeNode.class);
        List<TreeNode> allTreeNode = this.getAllChildrenAndSelf(orgTreeNode);
        TreeNode treeNode = null;
        for (TreeNode treenode : allTreeNode) {
            if (treenode.getId().equals(focusNodeId)) {
                isFocus = true;
                continue;
            }
            if (!this.patten(treenode.getText(), text) || !isFocus) continue;
            treeNode = treenode;
            treenode.setExpend(true);
            matched = true;
            break;
        }
        if (!matched) {
            for (TreeNode treenode : allTreeNode) {
                if (treenode.getId().equals(focusNodeId)) break;
                if (!this.patten(treenode.getText(), text)) continue;
                treeNode = treenode;
                treenode.setExpend(true);
                break;
            }
        }
        if (treeNode != null) {
            this.orgTree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            this.orgTree.showNode(treeNode.getId());
            this.orgTree.focusNode(treeNode);
            this.orgTree.getTreeState();
        }
    }

    private boolean patten(String name, String search) {
        return Pattern.matches(".*" + search + ".*", name);
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(0, parentNode);
        return allChildren;
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
        for (TreeNode child : children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    public void tabSelected(TabSelectEvent e) {
        this.initInfo();
        String currentOrgId = this.info.getCurrentOrgId();
        if (currentOrgId == null || currentOrgId.isEmpty() || currentOrgId.equals("0")) {
            return;
        }
        String tabKey = e.getTabKey();
        String key = tabKey.replace("tab", "");
        String mapKey = key + "-" + currentOrgId;
        String pageId = this.getCachePage(mapKey);
        this.showBizAppBook(key, pageId, mapKey);
    }

    private void showBizAppBook(String key, String pageId, String mapKey) {
        boolean isSameNode;
        boolean contains;
        DynamicObject bizDb = QueryServiceHelper.queryOne((String)BD_ACCOUNTINGSYS_DETAIL, (String)"bizform", (QFilter[])new QFilter("bizapp", "=", (Object)key).toArray());
        if (bizDb == null) {
            return;
        }
        String appId = "fibd";
        String currentOrgId = this.info.getCurrentOrgId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)"bd_accountingsys", (String)"47156aff000000ac");
        if (!rs.hasAllOrgPerm() && !(contains = rs.getHasPermOrgs().contains(Long.valueOf(currentOrgId)))) {
            return;
        }
        Object sysId = this.getModel().getValue("id");
        String billForm = bizDb.getString("bizform");
        ListShowParameter para = new ListShowParameter();
        StyleCss css = new StyleCss();
        css.setHeight("250");
        para.setBillFormId(billForm);
        para.setFormId("bd_accountsysshow");
        para.setShowTitle(false);
        para.setMultiSelect(false);
        para.setShowUsed(false);
        para.setShowQuickFilter(false);
        para.setIsolationOrg(false);
        para.setShowFilter(false);
        para.setShowQuickFilter(false);
        para.setShowApproved(false);
        para.getOpenStyle().setShowType(ShowType.InContainer);
        para.getOpenStyle().setTargetKey(key);
        TreeNode orgTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("treenode"), TreeNode.class);
        int i = orgTreeNode.getNodeLevel(currentOrgId, 0);
        TreeNode treeNode = orgTreeNode.getTreeNode(currentOrgId, i);
        List childrenNode = treeNode.getChildren();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (childrenNode == null || childrenNode.size() == 0) {
            dataMap.put("isleaf", "1");
        } else {
            dataMap.put("isleaf", "0");
        }
        ListFilterParameter filter = para.getListFilterParameter();
        filter.setFilter(this.getFilter(key, String.valueOf(sysId), this.info.getCurrentOrgId()));
        dataMap.put("id", String.valueOf(this.getModel().getValue("id")));
        dataMap.put("org", this.info.getCurrentOrgId());
        para.setCustomParams(dataMap);
        String selectNodeId = this.getPageCache().get("selectNodeId");
        boolean bl = isSameNode = selectNodeId != null && selectNodeId.equals(currentOrgId);
        if (pageId == null) {
            String pageIdNew = para.getPageId();
            String pageIdCache = this.getPageCache().get("pageid");
            Map<String, String> pageMap = pageIdCache != null && isSameNode ? (Map)SerializationUtils.fromJsonString((String)pageIdCache, HashMap.class) : new HashMap<String, String>();
            pageMap.put(mapKey, pageIdNew);
            this.getPageCache().put("pageid", SerializationUtils.toJsonString(pageMap));
            this.getView().showForm((FormShowParameter)para);
            this.getPageCache().put("selectNodeId", currentOrgId);
        }
    }

    private QFilter getFilter(String key, String sysId, String orgId) {
        QFilter qf = new QFilter("accountingsys", "=", (Object)Long.valueOf(sysId));
        qf.and(new QFilter("org", "=", (Object)Long.valueOf(orgId)));
        DynamicObjectCollection bookIds = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray());
        HashSet<Long> bookId = new HashSet<Long>();
        for (DynamicObject book : bookIds) {
            bookId.add(book.getLong("id"));
        }
        switch (key) {
            case "gl": {
                return new QFilter("id", "in", bookId);
            }
            case "fa": {
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])bookId.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"));
                Set<Long> assetbook = this.setBizEntryFilter(load, key);
                return new QFilter("id", "in", assetbook);
            }
            case "ar": {
                DynamicObject[] arload = BusinessDataServiceHelper.load((Object[])bookId.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"));
                Set<Long> policybook = this.setBizEntryFilter(arload, key);
                return new QFilter("id", "in", policybook);
            }
            case "cal": {
                DynamicObject[] calload = BusinessDataServiceHelper.load((Object[])bookId.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_accountbook"));
                Set<Long> costaccount = this.setBizEntryFilter(calload, key);
                return new QFilter("id", "in", costaccount);
            }
        }
        return null;
    }

    private String getCachePage(String key) {
        String pageIdCache = this.getPageCache().get("pageid");
        if (pageIdCache == null) {
            return null;
        }
        HashMap map = (HashMap)SerializationUtils.fromJsonString((String)pageIdCache, HashMap.class);
        return map.get(key) == null ? null : (String)map.get(key);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Long priId = (Long)this.getModel().getValue("id");
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("accountingsys", "=", (Object)priId));
        parameter.setCustomParam("accsysid", (Object)priId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACCTVIEWSCHEMA));
    }

    private void addLeafOrgBiz(TreeNode orgTreeNode) {
        boolean isDefault = (Boolean)this.getModel().getValue(ISDEFAULT);
        Object id = this.getModel().getValue("id");
        if (!isDefault && !QueryServiceHelper.exists((String)"bd_accountingsys", (QFilter[])new QFilter("id", "=", id).toArray())) {
            return;
        }
        List childrenNode = orgTreeNode.getChildren();
        if (childrenNode == null || childrenNode.isEmpty()) {
            List bizOrgIds = (List)this.info.getBizOrgIds().get(orgTreeNode.getId());
            if (null == bizOrgIds || bizOrgIds.size() == 0) {
                this.info.getBizOrgIds().put(orgTreeNode.getId(), Collections.singletonList(orgTreeNode.getId()));
            }
        } else {
            for (TreeNode child : childrenNode) {
                this.addLeafOrgBiz(child);
            }
        }
    }

    private Set<Long> setBizEntryFilter(DynamicObject[] calload, String key) {
        HashSet<Long> accountSet = new HashSet<Long>();
        for (DynamicObject book : calload) {
            DynamicObjectCollection bEntry = book.getDynamicObjectCollection("b_entry");
            for (DynamicObject row : bEntry) {
                String bizNum = Optional.ofNullable(row.getDynamicObject("b_app")).map(r -> r.getString("number")).orElse("");
                if (!key.equals(bizNum)) continue;
                DynamicObjectCollection relateBookCols = row.getDynamicObjectCollection("b_relatebook");
                relateBookCols.stream().forEach(r -> accountSet.add(r.getLong("fbasedataid_id")));
            }
        }
        return accountSet;
    }

    private void setEnableGroupCurrency() {
        IDataModel model = this.getModel();
        List<String> currencyFieldList = this.getMulCurFields(true, false);
        for (String currencyField : currencyFieldList) {
            if (!Objects.nonNull(model.getValue(currencyField))) continue;
            model.setValue(ENABLE_GROUP_LOCAL_CURRENCY, (Object)true);
        }
    }

    private void setGroupLocalCurrencyFields(boolean showGroupLocalCurrencyField) {
        IFormView view = this.getView();
        ArrayList<String> mulCurFieldList = new ArrayList<String>(8);
        mulCurFieldList.addAll(this.getMulCurFields(true, true));
        mulCurFieldList.add(CONVERSION_METHOD);
        ArrayList<Control> fieldEditList = new ArrayList<Control>(mulCurFieldList.size());
        for (String string : mulCurFieldList) {
            fieldEditList.add(view.getControl(string));
        }
        view.setVisible(Boolean.valueOf(showGroupLocalCurrencyField), mulCurFieldList.toArray(new String[0]));
        for (FieldEdit fieldEdit : fieldEditList) {
            fieldEdit.setMustInput(showGroupLocalCurrencyField);
        }
    }

    private void cleanGroupLocalCurrencyFieldsValue() {
        IDataModel model = this.getModel();
        List<String> curAndExRateTableFields = this.getMulCurFields(true, true);
        for (String field : curAndExRateTableFields) {
            model.setValue(field, null);
        }
        model.setValue(CONVERSION_METHOD, (Object)ConversionMethod.ORIGINAL.getValue());
    }

    private List<String> getMulCurFields(boolean currency, boolean exRateTable) {
        ArrayList<String> allMulCurFieldList = new ArrayList<String>(8);
        List configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId((String)"bd_accountingsys");
        for (LocalCurrencyConfigVO configVO : configVOList) {
            if (currency) {
                allMulCurFieldList.add(configVO.getCurrencyField());
            }
            if (!exRateTable) continue;
            allMulCurFieldList.add(configVO.getExRateField());
        }
        return allMulCurFieldList;
    }

    private Long getRootOrgIdByViewId(Long viewId) {
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        DynamicObject orgSt = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{viewFilter, parentFilter});
        return orgSt == null ? OrgUnitServiceHelper.getRootOrgId() : orgSt.getLong("org");
    }
}

