/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bd.formplugin.accounttableref;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.fi.bd.accounttableref.AccountTableRefTaskHelper;
import kd.fi.bd.util.ContextUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;

public class RefOpProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(RefOpProgressPlugin.class);
    private static final String CLOSE = "close";
    private static final String FINISH = "finish";
    private static final String START = "start";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String LABELAP = "labelap";
    private static final String TASK_ID = "taskId";
    private static final String TASK_CLASS = "kd.fi.bd.accounttableref.AccountTableRefTask";
    private static final String OP_KEY = "op_key";
    private static final String ACCOUNT_TABLE_REF_ID = "accountTableRefId";
    private static final String ORG = "org";
    private static final String DATE = "date";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startDoJob();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.isClose() && this.isStart() && !this.isFinish()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u672a\u6267\u884c\u7ed3\u675f\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"RefOpProgressPlugin_0", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            if (this.isFinish()) {
                e.setProgress(100);
                this.setProgressTip(ResManager.loadKDString((String)"\u672a\u6267\u884c\u3002", (String)"RefOpProgressPlugin_1", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                this.setClose();
            } else {
                e.setProgress(0);
                this.setProgressTip(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c...", (String)"RefOpProgressPlugin_2", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            }
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.setProgressTip(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u675f,\u8bf7\u67e5\u770b\u64cd\u4f5c\u62a5\u544a\u3002", (String)"RefOpProgressPlugin_3", (String)"fi-bd-formplugin", (Object[])new Object[0]));
                e.setProgress(100);
                this.closeAndReturnData(taskInfo, taskId);
            } else {
                this.setExcutedCount(e, taskId);
            }
        }
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(LABELAP);
        lblTip.setText(tip);
    }

    private void setExcutedCount(ProgressEvent e, String taskId) {
        int totalCount = AccountTableRefTaskHelper.getTotalCount((String)taskId);
        int excutedCount = AccountTableRefTaskHelper.getExcutedCount((String)taskId);
        if (totalCount == 0) {
            this.setProgressTip(ResManager.loadKDString((String)"\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"RefOpProgressPlugin_4", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            e.setProgress(1);
        } else {
            this.setProgressTip(String.format(ResManager.loadKDString((String)"\u5171\u6267\u884c%1$d\u4e2a\u6838\u7b97\u7ec4\u7ec7\uff0c\u5df2\u5b8c\u6210%2$d...", (String)"RefOpProgressPlugin_5", (String)"fi-bd-formplugin", (Object[])new Object[0]), totalCount, excutedCount));
            int progress = excutedCount * 100 / totalCount;
            if (progress >= 100) {
                progress = 99;
            }
            if (progress < 1) {
                progress = 1;
            }
            e.setProgress(progress);
        }
    }

    private void startDoJob() {
        this.setStart();
        this.startBar();
        this.dispatchTask();
    }

    private void dispatchTask() {
        JobInfo jobInfo = this.buildJobInfo();
        if (Objects.isNull(jobInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8fd4\u56de\u9009\u62e9\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RefOpProgressPlugin_6", (String)"fi-bd-formplugin", (Object[])new Object[0]));
            this.setFinish();
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        this.putTaskId(taskId);
    }

    private JobInfo buildJobInfo() {
        if (Objects.isNull(this.getDate())) {
            return null;
        }
        if (this.getOrgId() <= 0L) {
            return null;
        }
        if (this.getAccountTableRefId() <= 0L) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.getOpKey())) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u6267\u884c\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c", (String)"RefOpProgressPlugin_7", (String)"fi-bd-formplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(ContextUtil.getUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname(TASK_CLASS);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(ORG, this.getOrgId());
        params.put(DATE, this.getDate());
        params.put(ACCOUNT_TABLE_REF_ID, this.getAccountTableRefId());
        params.put(OP_KEY, this.getOpKey());
        jobInfo.setParams(params);
        if (DebugTrace.enable()) {
            logger.info("customparams_jobInfo :{}", (Object)DebugTraceHelper.toString((Object)jobInfo));
        }
        return jobInfo;
    }

    private void closeAndReturnData(TaskInfo info, String taskId) {
        this.stopBar();
        this.setFinish();
        this.setClose();
        AccountTableRefTaskHelper.clearCache((String)taskId);
        String strData = info.getData();
        if (StringUtils.isNotBlank((CharSequence)strData)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
            Object report = data.get("report");
            if (!Objects.isNull(report)) {
                this.getView().returnDataToParent(report);
            }
        } else if (info.isFailure()) {
            this.getView().getParentView().showErrMessage(ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002", (String)"RefOpProgressPlugin_8", (String)"fi-bd-formplugin", (Object[])new Object[0]), info.getFailureReason());
        }
        this.getView().close();
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private void setStart() {
        this.getPageCache().put(START, Boolean.TRUE.toString());
    }

    private boolean isStart() {
        return Objects.equals(Boolean.TRUE.toString(), this.getPageCache().get(START));
    }

    private void setFinish() {
        this.getPageCache().put(FINISH, Boolean.TRUE.toString());
    }

    private boolean isFinish() {
        return Objects.equals(Boolean.TRUE.toString(), this.getPageCache().get(FINISH));
    }

    private void setClose() {
        this.getPageCache().put(CLOSE, Boolean.TRUE.toString());
    }

    private boolean isClose() {
        return Objects.equals(Boolean.TRUE.toString(), this.getPageCache().get(CLOSE));
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(TASK_ID, taskId);
    }

    private String getTaskId() {
        return this.getPageCache().get(TASK_ID);
    }

    private Date getDate() {
        Object dateParam = this.getView().getFormShowParameter().getCustomParam(DATE);
        if (StringUtils.isNotBlank((Object)dateParam)) {
            return (Date)SerializationUtils.deSerializeFromBase64((String)dateParam.toString());
        }
        return null;
    }

    private long getOrgId() {
        return this.getLongParamValue(ORG);
    }

    private long getAccountTableRefId() {
        return this.getLongParamValue(ACCOUNT_TABLE_REF_ID);
    }

    private String getOpKey() {
        Object param = this.getView().getFormShowParameter().getCustomParam(OP_KEY);
        if (StringUtils.isNotBlank((Object)param)) {
            return param.toString();
        }
        return "";
    }

    private long getLongParamValue(String paramKey) {
        Object param = this.getView().getFormShowParameter().getCustomParam(paramKey);
        if (StringUtils.isNotBlank((Object)param)) {
            return Long.parseLong(param.toString());
        }
        return 0L;
    }
}

